/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime;

import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MetaData {
    private static final Class[] EMPTY_SYGNATURE = new Class[0];
    private static final Object[] EMPTY_ARGS = new Object[0];
    private String id;
    private String name;
    private Map compoundProperties;
    private Map propertyKeys;
    private Map tagMappings;

    public MetaData(String name, Map compoundProperties, Map propertyKeys, Map tagMappings) {
        this(null, name, compoundProperties, propertyKeys, tagMappings);
    }

    public MetaData(String id, String name, Map compoundProperties, Map propertyKeys, Map tagMappings) {
        this.id = id;
        this.name = name;
        this.compoundProperties = compoundProperties;
        this.propertyKeys = propertyKeys;
        this.tagMappings = tagMappings;
    }

    public Map getAttributesDescriptions() {
        return this.propertyKeys;
    }

    public Map getCompoundProperties() {
        return this.compoundProperties;
    }

    public AttributeDescription getAttributeDescription(Object attributeId) {
        if (this.propertyKeys == null) {
            return null;
        }
        return (AttributeDescription)this.propertyKeys.get(attributeId);
    }

    public Map getTagMappings() {
        return this.tagMappings;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static void createCompounds(DataSupport dataSupport, Element element) {
        MetaData meta = dataSupport.getMetaData();
        Map compoundProperties = meta.getCompoundProperties();
        if (compoundProperties == null) {
            return;
        }
        Map compounds = dataSupport.getCompounds();
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            Class clazz;
            if (child.getNodeType() != 1) continue;
            String name = child.getLocalName();
            if (name == null) {
                name = child.getLocalName();
            }
            if ((clazz = (Class)compoundProperties.get(name)) == null) continue;
            Object compound = MetaData.addCompound(clazz, compounds, name);
            DataSupport compDS = MetaData.asDataSupport(compound);
            MetaData.createCompounds(compDS, (Element)child);
        }
    }

    public static void createCompounds(DataSupport dataSupport) {
        MetaData meta = dataSupport.getMetaData();
        Map compoundProperties = meta.getCompoundProperties();
        if (compoundProperties == null) {
            return;
        }
        Map compounds = dataSupport.getCompounds();
        for (Map.Entry entry : compoundProperties.entrySet()) {
            String name = (String)entry.getKey();
            Class clazz = (Class)entry.getValue();
            Object compound = MetaData.addCompound(clazz, compounds, name);
            DataSupport compDS = MetaData.asDataSupport(compound);
            MetaData.createCompounds(compDS);
        }
    }

    public static Object addCompound(Class clazz, Map compounds, String name) {
        Object instance = MetaData.createCompound(clazz);
        if (instance != null) {
            compounds.put(name, instance);
        }
        return instance;
    }

    public static Object createCompound(Class clazz) {
        try {
            Method create = clazz.getMethod("create", EMPTY_SYGNATURE);
            return create.invoke(null, EMPTY_ARGS);
        }
        catch (InvocationTargetException e) {
            MetaData.compoundFailure(e);
        }
        catch (IllegalAccessException e) {
            MetaData.compoundFailure(e);
        }
        catch (NoSuchMethodException e) {
            MetaData.compoundFailure(e);
        }
        return null;
    }

    private static void compoundFailure(Exception e) {
        throw new RuntimeException("Failed to create instance of compound", e);
    }

    public static DataSupport asDataSupport(Object attrCollection) {
        if (!(attrCollection instanceof DataSupport)) {
            throw new IllegalArgumentException("Wrong message, data support is absent. Use generated sources only");
        }
        return (DataSupport)attrCollection;
    }
}

