/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime;

import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.commons.protocol.ProtocolDescriptionSupport;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.CodecLazyParser;
import com.genesyslab.platform.commons.protocol.runtime.CompoundValue;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.commons.protocol.runtime.LogHiddenAttributes;
import com.genesyslab.platform.commons.protocol.runtime.MetaData;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecUtil;
import com.genesyslab.platform.commons.protocol.runtime.codec.CustomTypeCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.EnumCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.LogIndentSupport;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class ToStringHelper {
    private static LogHiddenAttributes hiddenAttributes = null;

    private ToStringHelper() {
    }

    public static synchronized void hideAttribute(String protocolName, String attributeHolderName, String attributeName) throws NullPointerException {
        LogHiddenAttributes temp = hiddenAttributes;
        if (temp == null) {
            temp = new LogHiddenAttributes();
        }
        temp.hide(protocolName, attributeHolderName, attributeName);
        hiddenAttributes = temp;
    }

    public static synchronized void unhideAttribute(String protocolName, String attributeHolderName, String attributeName) throws NullPointerException {
        LogHiddenAttributes temp = hiddenAttributes;
        if (temp == null) {
            temp = new LogHiddenAttributes();
        }
        temp.unhide(protocolName, attributeHolderName, attributeName);
        hiddenAttributes = temp;
    }

    public static synchronized void setHiddenAttributes(LogHiddenAttributes config) {
        hiddenAttributes = config;
    }

    public static boolean isLogHidden(String protocolName, String attributeHolderName, String attributeName) {
        if (protocolName == null || attributeHolderName == null || attributeName == null) {
            return false;
        }
        LogHiddenAttributes config = hiddenAttributes;
        if (config == null) {
            return false;
        }
        return config.isLogHidden(protocolName, attributeHolderName, attributeName);
    }

    public static LogHiddenAttributes.AttributeSet getHiddenAttributes(String protocolName, String attributeHolderName) {
        if (protocolName == null || attributeHolderName == null) {
            return null;
        }
        LogHiddenAttributes config = hiddenAttributes;
        if (config == null) {
            return null;
        }
        return config.getHiddenSet(protocolName, attributeHolderName);
    }

    public static String toString(Message msg) {
        return ToStringHelper.toString(msg, true, true);
    }

    public static String toString(Message msg, boolean hideAllowed, boolean truncate) {
        StringBuffer buf = new StringBuffer();
        try {
            ToStringContext ctx = new ToStringContext(buf, truncate, hideAllowed);
            ctx.msg = msg;
            ctx.dataSupport = ToStringHelper.asDataSupport(msg);
            ToStringHelper.appendMessageHead(ctx);
            ToStringHelper.toStringBuf(ctx);
        }
        catch (Exception e) {
            Log.getLogger(ToStringHelper.class).warn((Object)"Exception in toString()", (Throwable)e);
            buf.append("!!!EXCEPTION PARSING MESSAGE!!! (WRONG PROTOCOL?): ").append(e.toString());
        }
        return buf.toString();
    }

    public static String toString(CompoundValue val) {
        return ToStringHelper.toString(val, true, true);
    }

    public static String toString(CompoundValue val, boolean truncate, boolean hideAllowed) {
        return ToStringHelper.toString(val, truncate, hideAllowed, 0);
    }

    public static String toString(CompoundValue val, boolean truncate, boolean hideAllowed, int indent) {
        ToStringContext ctx = new ToStringContext(new StringBuffer(), truncate, hideAllowed);
        ctx.dataSupport = ToStringHelper.asDataSupport(val);
        ctx.indent = indent;
        ToStringHelper.appendCompoundHeader(ctx);
        ctx.incIndent();
        ToStringHelper.toStringBuf(ctx);
        ctx.decIndent();
        return ctx.buf.toString();
    }

    private static void toStringBuf(ToStringContext ctx) {
        Collection values;
        DataSupport attrSet = ctx.dataSupport;
        String protocolName = ToStringHelper.getProtocolName(attrSet);
        MetaData meta = attrSet.getMetaData();
        String className = null;
        if (meta != null) {
            className = meta.getName();
        }
        LogHiddenAttributes.AttributeSet hiddenSet = null;
        if (protocolName != null && className != null) {
            hiddenSet = ToStringHelper.getHiddenAttributes(protocolName, className);
        }
        for (Map.Entry entry : attrSet.attributes().entrySet()) {
            AttributeDescription description;
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            AttributeDescription attributeDescription = description = meta != null ? meta.getAttributeDescription(key) : null;
            if (description != null && description.getName().equals(key)) {
                if (value instanceof CompoundValue) {
                    ctx.buf.append('\n');
                    ToStringHelper.appendIndent(ctx);
                    ctx.buf.append('\t').append(ToStringHelper.toString((CompoundValue)value, ctx.truncate, ctx.hideAllowed, ctx.indent + 1));
                    continue;
                }
                boolean logHidden = hiddenSet != null && hiddenSet.contains(key);
                ToStringHelper.appendSimpleAttr(ctx, description, value, logHidden);
                continue;
            }
            ToStringHelper.appendRawAttribute(ctx, key, value);
        }
        Map compMap = attrSet.getCompounds();
        Collection collection = values = compMap != null ? compMap.values() : null;
        if (values != null && !values.isEmpty()) {
            for (DataSupport ds : values) {
                if (ds == null) continue;
                ctx.dataSupport = ds;
                ctx.buf.append('\n');
                ToStringHelper.appendCompoundHeader(ctx);
                ctx.incIndent();
                ToStringHelper.toStringBuf(ctx);
                ctx.decIndent();
            }
        }
        CodecLazyParser lazyParser = attrSet.getLazyParser();
        String[] lazyAttrs = null;
        if (lazyParser != null) {
            lazyAttrs = lazyParser.getNotParsed();
        }
        if (lazyAttrs != null) {
            for (String sName : lazyAttrs) {
                AttributeDescription description = lazyParser.getAttributeDescription(sName);
                if (description == null) {
                    AttributeDescription attributeDescription = description = meta != null ? meta.getAttributeDescription(sName) : null;
                    if (description == null) continue;
                }
                if (ctx.hideAllowed && description.isHideable() && description.isHidden()) continue;
                ToStringHelper.appendLazyAttribute(ctx, description.getLogSignature());
            }
        }
    }

    private static void appendRawAttribute(ToStringContext ctx, String key, Object value) {
        ctx.buf.append('\n');
        ToStringHelper.appendIndent(ctx);
        ctx.buf.append('\t').append(key).append(" [").append(value.getClass().getSimpleName()).append("] <raw data attribute>");
    }

    private static void appendLazyAttribute(ToStringContext ctx, String key) {
        ctx.buf.append('\n');
        ToStringHelper.appendIndent(ctx);
        ctx.buf.append('\t').append(key).append(" <value is not yet parsed>");
    }

    private static void appendIndent(ToStringContext ctx) {
        if (ctx.indent > 0) {
            char[] indent = new char[ctx.indent];
            Arrays.fill(indent, '\t');
            ctx.buf.append(indent);
        }
    }

    private static void appendSimpleAttr(ToStringContext ctx, AttributeDescription key, Object value, boolean logHidden) {
        if (value == null || key.isHidden()) {
            return;
        }
        StringBuffer buf = ctx.buf;
        buf.append('\n');
        ToStringHelper.appendIndent(ctx);
        buf.append(key.getLogSignature()).append(" [");
        buf.append(ToStringHelper.getAttributeType(key)).append("] = ");
        try {
            ToStringHelper.appendAttributeValue(ctx, key, value, logHidden);
        }
        catch (CodecException e) {
            Log.getLogger(ToStringHelper.class).debug((Object)"Codec exception", (Throwable)((Object)e));
            buf.append("<invalid message: ").append(e.getMessage()).append('>');
        }
    }

    private static void appendAttributeValue(ToStringContext ctx, AttributeDescription key, Object value, boolean logHidden) throws CodecException {
        StringBuffer buf = ctx.buf;
        if (value == null) {
            buf.append("<null>");
        } else {
            boolean hide = ctx.hideAllowed && (key.isHideable() || logHidden);
            Class valueType = key.getValueType();
            CustomTypeCodec codec = key.createCodec(ctx.msg, null);
            if (hide) {
                buf.append("[output suppressed]");
            } else if (codec != null) {
                if (codec instanceof LogIndentSupport) {
                    ((LogIndentSupport)((Object)codec)).appendLogValue(buf, value, ctx.indent, ctx.truncate, ctx.hideAllowed);
                } else {
                    codec.appendLogValue(buf, value, ctx.truncate, ctx.hideAllowed);
                }
            } else if (valueType == String.class) {
                buf.append('\"').append((String)value).append('\"');
            } else if (valueType == Integer.TYPE || valueType == Integer.class || valueType == Long.TYPE || valueType == Long.class) {
                buf.append(value);
            } else if (valueType == byte[].class) {
                CodecUtil.appendBytesStr(buf, (byte[])value, ctx.truncate);
            } else if (key.isEnumProperty()) {
                new EnumCodec().appendLogValue(buf, value, ctx.truncate, hide);
            } else {
                throw new IllegalArgumentException("Unsupported attribute type");
            }
        }
    }

    private static String getAttributeType(AttributeDescription key) {
        CustomTypeCodec codec = key.createCodec(null, null);
        if (codec != null) {
            return codec.getLogType();
        }
        Class valueType = key.getValueType();
        if (valueType == String.class) {
            return "str";
        }
        if (valueType == Integer.TYPE || valueType == Integer.class) {
            return "int";
        }
        if (valueType == byte[].class) {
            return "bstr";
        }
        if (key.isEnumProperty()) {
            return new EnumCodec().getLogType();
        }
        if (valueType == Long.TYPE || valueType == Long.class) {
            return "long";
        }
        throw new IllegalArgumentException("Unsupported attribute type");
    }

    private static void appendMessageHead(ToStringContext ctx) {
        ctx.buf.append('\'').append(ctx.msg.messageName()).append("' ").append('(').append(ctx.msg.messageId()).append(") attributes:");
    }

    private static void appendCompoundHeader(ToStringContext ctx) {
        DataSupport attrSet = ctx.dataSupport;
        MetaData meta = attrSet.getMetaData();
        ToStringHelper.appendIndent(ctx);
        ctx.buf.append(meta.getName()).append(':');
    }

    private static DataSupport asDataSupport(Object attrCollection) {
        if (!(attrCollection instanceof DataSupport)) {
            throw new IllegalArgumentException("Wrong message, data support is absent. Use generated sources only");
        }
        return (DataSupport)attrCollection;
    }

    private static String getProtocolName(Object attrCollection) {
        if (!(attrCollection instanceof ProtocolDescriptionSupport)) {
            return null;
        }
        ProtocolDescription description = ((ProtocolDescriptionSupport)attrCollection).getProtocolDescription();
        return description != null ? description.getProtocolName() : null;
    }

    private static class ToStringContext {
        private StringBuffer buf;
        private boolean truncate;
        boolean hideAllowed;
        private Message msg;
        private DataSupport dataSupport;
        public int indent;

        private ToStringContext(StringBuffer buf, boolean truncate, boolean hideAllowed) {
            this.buf = buf;
            this.truncate = truncate;
            this.hideAllowed = hideAllowed;
        }

        public void incIndent() {
            ++this.indent;
        }

        public void decIndent() {
            if (--this.indent < 0) {
                this.indent = 0;
            }
        }
    }
}

