/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime.channel;

import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.EndpointSupport;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.OutputChannel;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.RequestContext;
import com.genesyslab.platform.commons.protocol.ServerChannel;
import com.genesyslab.platform.commons.protocol.runtime.UpdatableDescription;
import com.genesyslab.platform.commons.protocol.runtime.UpdatableProtocolId;
import java.util.Map;

public final class RequestContextImpl
implements RequestContext,
EndpointSupport,
UpdatableDescription,
UpdatableProtocolId {
    private OutputChannel outputChannel;
    private Message requestMessage;
    private Map clientContext;
    private ServerChannel serverChannel;
    private Endpoint endpoint;
    private ProtocolDescription protocolDescription;
    private int protocolId = 0;

    public RequestContextImpl(OutputChannel outputChannel, Message requestMessage, Map clientContext, ServerChannel serverChannel) {
        this.outputChannel = outputChannel;
        this.requestMessage = requestMessage;
        this.clientContext = clientContext;
        this.serverChannel = serverChannel;
    }

    public RequestContextImpl() {
    }

    @Override
    public Message getRequestMessage() {
        return this.requestMessage;
    }

    @Override
    public void respond(Message message) throws ProtocolException {
        if (message == null) {
            throw new IllegalArgumentException("message is null");
        }
        if (this.outputChannel == null) {
            return;
        }
        this.outputChannel.send(message);
    }

    @Override
    public void transmit(Message message) throws ProtocolException {
        if (this.serverChannel == null) {
            return;
        }
        this.serverChannel.sendToChannelsExcept(message, this.outputChannel);
    }

    @Override
    public OutputChannel getClientChannel() {
        return this.outputChannel;
    }

    @Override
    public Map getClientContext() {
        return this.clientContext;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public ProtocolDescription getProtocolDescription() {
        return this.protocolDescription;
    }

    @Override
    public void setProtocolDescription(ProtocolDescription description) {
        this.protocolDescription = description;
    }

    @Override
    public void setProtocolId(int protocolId) {
        this.protocolId = protocolId;
    }

    @Override
    public int getProtocolId() {
        return this.protocolId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RequestContext");
        if (this.protocolDescription != null) {
            sb.append("[").append(this.protocolDescription).append("]");
        }
        sb.append(": ").append(this.requestMessage);
        return sb.toString();
    }
}

