/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime.codec;

import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.codec.AttributeTypeCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecUtil;
import com.genesyslab.platform.commons.protocol.runtime.codec.NoDataCodec;
import com.genesyslab.platform.commons.xml.XmlUtil;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.w3c.dom.Element;

public class EnumCodec
extends NoDataCodec
implements AttributeTypeCodec {
    @Override
    public Object encodeForConnection(Object customTypeObject, String id, MessageTransport transport, Object transportState) throws PlatformException {
        int ordinal = ((GEnum)customTypeObject).ordinal();
        return transport.onAttribute(transportState, id, ordinal);
    }

    @Override
    public Object decodeFromConnection(Object value, AttributeDescription attributeDescription) throws PlatformException {
        Object val = value;
        if (value instanceof String) {
            try {
                val = new Integer((String)value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (!(val instanceof Integer)) {
            throw new CodecException("Int attribute expected. Found: " + value.getClass() + "; Attr: " + attributeDescription.getId());
        }
        Integer intAttr = (Integer)val;
        return GEnum.getValue((Class)attributeDescription.getValueType(), (Integer)intAttr);
    }

    @Override
    public void encodeToXml(Object customTypeObject, Result attributeElement) throws CodecException {
        String value = ((GEnum)customTypeObject).name();
        CodecUtil.appendText(value, attributeElement);
    }

    @Override
    public Object decodeFromXml(Source attributeElement, AttributeDescription attributeDescription) throws CodecException {
        return this.decodeFromXml(CodecUtil.asElement(attributeElement), attributeDescription);
    }

    private Object decodeFromXml(Element attributeElement, AttributeDescription attributeDescription) {
        String name = XmlUtil.getElementText((Element)attributeElement);
        if (name == null) {
            return null;
        }
        return GEnum.getValue((Class)attributeDescription.getValueType(), (String)name);
    }

    @Override
    public String getLogType() {
        return "int";
    }

    @Override
    public void appendLogValue(StringBuffer buf, Object customTypeObject, boolean truncate, boolean hide) {
        GEnum enumObj = (GEnum)customTypeObject;
        buf.append(enumObj.ordinal());
        buf.append(" [").append(enumObj.name()).append(']');
    }
}

