/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.protocol.runtime.codec;

import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import java.util.HashSet;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XmlToStringHelper {
    private static boolean supressEnabled = true;
    private static String outputSuppress = "[output suppressed]";
    private static String outputTruncate = "[output truncated]";
    private static HashSet<String> supressedFields = new HashSet();

    public static String toString(Node node) {
        return XmlToStringHelper.toString(node, 0);
    }

    public static String toString(Node node, int truncationLength) {
        if (node == null) {
            return "null";
        }
        try {
            StringBuilder sb = new StringBuilder();
            if (node instanceof Document) {
                XmlToStringHelper.document2String(sb, (Document)node, truncationLength);
            } else if (node instanceof Element) {
                XmlToStringHelper.element2String(sb, (Element)node, truncationLength);
            } else {
                throw new CodecException("Unexpected Node type: " + node);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "Exception while transforming DOM Node: " + e;
        }
    }

    public static boolean document2String(StringBuilder sb, Document doc, int truncationLength) {
        String xmlVersion = doc.getXmlVersion();
        String xmlEncoding = doc.getXmlEncoding();
        if (xmlVersion != null || xmlEncoding != null) {
            sb.append("<?xml");
            if (xmlVersion != null) {
                sb.append(" version=\"").append(xmlVersion).append('\"');
            }
            if (xmlEncoding != null) {
                sb.append(" encoding=\"").append(xmlEncoding).append('\"');
            }
            sb.append("?>");
        }
        return XmlToStringHelper.element2String(sb, doc.getDocumentElement(), truncationLength);
    }

    public static boolean element2String(StringBuilder sb, Element elem, int truncationLength) {
        Node child2out;
        NamedNodeMap attrs;
        sb.append("<").append(elem.getNodeName());
        String elemNs = elem.getNamespaceURI();
        if (elemNs != null && elemNs.length() == 0) {
            elemNs = null;
        }
        if ((attrs = elem.getAttributes()) != null && attrs.getLength() > 0) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                if (XmlToStringHelper.attr2String(sb, attr, truncationLength)) {
                    return true;
                }
                if (!attr.getName().equals("xmlns")) continue;
                elemNs = null;
            }
        }
        String parentNs = null;
        if (elem.getParentNode() != null) {
            parentNs = elem.getParentNode().getNamespaceURI();
        }
        if (!(elemNs == null || parentNs != null && parentNs.equals(elemNs))) {
            sb.append(" xmlns=\"").append(elemNs).append("\"");
        }
        if ((child2out = elem.getFirstChild()) != null) {
            sb.append(">");
            while (child2out != null) {
                if (child2out.getNodeType() == 1) {
                    if (XmlToStringHelper.element2String(sb, (Element)child2out, truncationLength)) {
                        return true;
                    }
                } else if (child2out.getNodeType() == 3) {
                    if (XmlToStringHelper.text2String(sb, (Text)child2out, truncationLength)) {
                        return true;
                    }
                } else {
                    sb.append(child2out.toString());
                }
                child2out = child2out.getNextSibling();
            }
            sb.append("</").append(elem.getNodeName()).append(">");
        } else {
            sb.append("/>");
        }
        return false;
    }

    public static boolean attr2String(StringBuilder sb, Attr attr, int truncationLength) {
        sb.append(' ').append(attr.getName()).append('=').append('\"');
        if (XmlToStringHelper.appendString(sb, XmlToStringHelper.getAttrValue(attr), truncationLength)) {
            return true;
        }
        sb.append('\"');
        return false;
    }

    public static boolean text2String(StringBuilder sb, Text text, int truncationLength) {
        return XmlToStringHelper.appendString(sb, text.getTextContent(), truncationLength);
    }

    private static boolean isSupressedField(String name) {
        if (!supressEnabled) {
            return false;
        }
        return supressedFields.contains(name.toLowerCase(Locale.ENGLISH));
    }

    private static String getAttrValue(Attr attribute) {
        if (supressEnabled && attribute.getName().equals("value")) {
            Element elm = attribute.getOwnerElement();
            if (XmlToStringHelper.isSupressedField(elm.getNodeName())) {
                return outputSuppress;
            }
            Node key = elm.getAttributes().getNamedItem("key");
            if (key != null && XmlToStringHelper.isSupressedField(key.getNodeValue())) {
                return outputSuppress;
            }
        }
        return attribute.getValue();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static boolean appendString(StringBuilder sb, String text, int truncationLength) {
        if (truncationLength <= 0) {
            sb.append(text);
            return false;
        }
        int subLen = truncationLength - sb.length();
        if (subLen > text.length()) {
            sb.append(text);
            return false;
        }
        if (subLen > 0) {
            sb.append(text.substring(0, Math.min(subLen, text.length())));
        }
        sb.append(outputTruncate);
        return true;
    }

    static {
        supressedFields.add("password");
    }
}

