/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl;

import com.genesyslab.platform.commons.connection.Connection;
import com.genesyslab.platform.commons.connection.ConnectionClosedEvent;
import com.genesyslab.platform.commons.connection.ConnectionHandler;
import com.genesyslab.platform.commons.connection.ConnectionState;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.configuration.ConnectionContext;
import com.genesyslab.platform.commons.connection.configuration.ManagedConfiguration;
import com.genesyslab.platform.commons.connection.impl.Command;
import com.genesyslab.platform.commons.connection.impl.EncodingSupport;
import com.genesyslab.platform.commons.connection.interceptor.AddpInterceptor;
import com.genesyslab.platform.commons.connection.interceptor.Interceptor;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractConnection
implements Connection {
    private static final ILogger log = Log.getLogger(AbstractConnection.class);
    private static final AtomicLong nextId = new AtomicLong();
    private final long Id;
    private volatile String uri;
    protected volatile String host;
    protected volatile int port;
    protected volatile ConnectionHandler connHandler;
    private volatile ConnectionState state = ConnectionState.CLOSED;
    private boolean closing = false;
    private boolean forceClosing = false;
    private volatile ConnectionContext ctx;
    protected volatile SocketAddress address;
    private volatile String stringAttributesEncoding = EncodingSupport.DEFAULT_ENCODING;
    private ManagedConfiguration configWithHandlers;
    protected final Object _syncConfig = new Object();
    private volatile boolean addpFlag;
    private volatile Executor executor;
    private volatile String localBindHost;
    private volatile Integer localBindPort;
    private final ManagedConfiguration.Handler onChangedEncodingProperty = new ManagedConfiguration.Handler(){

        @Override
        public void onPropertyChanged(Object sender, ManagedConfiguration.ChangeEvent event) {
            String encodingNew = event.getNewValue();
            if (encodingNew != null && encodingNew.length() > 0) {
                AbstractConnection.this.setStringAttributesEncoding(encodingNew);
            }
        }
    };
    private final ManagedConfiguration.Handler onChangedAddpProperty = new ManagedConfiguration.Handler(){

        @Override
        public void onPropertyChanged(Object sender, ManagedConfiguration.ChangeEvent event) {
            if (event == null) {
                return;
            }
            Interceptor interceptor = AbstractConnection.this.getInterceptor();
            if (interceptor != null) {
                if (event.getKey().equals("protocol")) {
                    AbstractConnection.this.updateAddpFlag(event.getNewValue());
                }
                interceptor.configure(AbstractConnection.this.configWithHandlers);
            }
        }
    };

    protected AbstractConnection() {
        this.Id = nextId.getAndIncrement();
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    protected void setExecutor(Executor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        AbstractConnection abstractConnection = this;
        synchronized (abstractConnection) {
            this.closing = false;
            this.forceClosing = false;
        }
    }

    public Connection getConnection() {
        return this;
    }

    @Override
    public void setConnectionHandler(ConnectionHandler connectionHandler) {
        this.connHandler = connectionHandler;
    }

    public ConnectionContext context() {
        return this.ctx;
    }

    @Override
    public void setContext(ConnectionContext ctx) {
        this.ctx = ctx;
    }

    protected void notifyEstablishedHandler() {
        final ConnectionHandler handler = this.connHandler;
        if (handler == null) {
            log.debug((Object)"ConnHandler is null, nobody to notify about established connection");
            return;
        }
        try {
            Executor executor = this.getExecutor();
            if (executor != null) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        handler.onConnectionEstablished();
                    }
                });
            } else {
                handler.onConnectionEstablished();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Exception in ConnectionHandler", (Throwable)e);
        }
    }

    protected void notifyCloseHandler(Throwable cause) {
        final ConnectionHandler handler = this.connHandler;
        if (handler == null) {
            log.debug((Object)"ConnHandler is null, nobody to notify about closed connection");
            return;
        }
        final ConnectionClosedEvent event = new ConnectionClosedEvent(this, cause);
        try {
            Executor executor = this.getExecutor();
            if (executor != null) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        handler.onConnectionClosed(event);
                    }
                });
            } else {
                handler.onConnectionClosed(event);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Exception in ConnectionHandler", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConnectionState(ConnectionState state) {
        AbstractConnection abstractConnection = this;
        synchronized (abstractConnection) {
            Interceptor interceptor;
            if (state == this.state) {
                return;
            }
            if (state == ConnectionState.OPENED) {
                interceptor = this.getInterceptor();
                if (interceptor instanceof AddpInterceptor && this.addpFlag) {
                    ((AddpInterceptor)interceptor).start();
                }
            } else if (state == ConnectionState.CLOSING && (interceptor = this.getInterceptor()) instanceof AddpInterceptor) {
                ((AddpInterceptor)interceptor).stop();
            }
            ConnectionState oldState = this.state;
            this.state = state;
            if (log.isInfo()) {
                log.info((Object)("ConnState transition. '" + oldState.toString() + "' -> '" + state.toString() + "' for '" + this));
            }
            if (state == ConnectionState.CLOSED) {
                this.unregisterConfigurationHandlers();
                Interceptor interceptor2 = this.getInterceptor();
                if (interceptor2 instanceof AddpInterceptor) {
                    ((AddpInterceptor)interceptor2).stop();
                }
            }
        }
        if (state == ConnectionState.OPENED) {
            this.notifyEstablishedHandler();
        }
    }

    @Override
    public ConnectionState getConnectionState() {
        return this.state;
    }

    public String getStringAttributesEncoding() {
        return this.stringAttributesEncoding;
    }

    public void setStringAttributesEncoding(String value) {
        this.stringAttributesEncoding = value == null || value.length() == 0 ? EncodingSupport.DEFAULT_ENCODING : value;
    }

    public void setUri(String host, int port) {
        this.host = host;
        this.port = port;
        this.address = InetSocketAddress.createUnresolved(host, port);
    }

    public void setUri(InetAddress address, int port) {
        this.host = address.getHostAddress();
        this.port = port;
        this.address = new InetSocketAddress(address, port);
    }

    @Override
    public String getUri() {
        if (this.uri == null && this.host != null) {
            this.uri = "tcp://" + this.host + ':' + this.port;
        }
        return this.uri;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        InetSocketAddress laddr = this.getLocalEndPoint();
        InetSocketAddress raddr = this.getRemoteEndPoint();
        if (laddr != null || raddr != null) {
            String ip;
            if (raddr != null) {
                ip = raddr.getAddress().getHostAddress();
                String h = this.host;
                if (h != null && h.equals(ip)) {
                    h = null;
                }
                if (h != null) {
                    sb.append(h);
                    sb.append('/');
                }
                sb.append(ip);
                sb.append(':');
                sb.append(raddr.getPort());
            }
            if (laddr != null) {
                sb.append('<');
                ip = laddr.getAddress().getHostAddress();
                sb.append(ip);
                sb.append(':');
                sb.append(laddr.getPort());
            }
        }
        sb.append('[');
        sb.append(this.state.toString());
        sb.append("]/");
        sb.append(this.Id);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Throwable e) {
        AbstractConnection abstractConnection = this;
        synchronized (abstractConnection) {
            ConnectionState connectionState = this.getConnectionState();
            if (connectionState == ConnectionState.CLOSED || connectionState == ConnectionState.CLOSING) {
                return;
            }
            if (this.closing) {
                return;
            }
            this.closing = true;
            this.setConnectionState(ConnectionState.CLOSING);
        }
        if (e != null) {
            log.debug((Object)"Emergency connection close", e);
        } else {
            log.debug((Object)"Closing connection");
        }
        this.startClose(e);
    }

    @Override
    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceClose(Throwable reason) {
        AbstractConnection abstractConnection = this;
        synchronized (abstractConnection) {
            if (this.getConnectionState() == ConnectionState.CLOSED) {
                return;
            }
            if (this.forceClosing) {
                return;
            }
            this.closing = true;
            this.forceClosing = true;
        }
        log.debugFormat("Forcing connection close. Connection: {0}", (Object)this);
        this.doClose(reason);
    }

    @Override
    public void forceClose() {
        this.forceClose(null);
    }

    protected abstract void startClose(Throwable var1);

    protected void doClose(Throwable closeReason) {
        this.setConnectionState(ConnectionState.CLOSED);
        this.notifyCloseHandler(closeReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterConfigurationHandlers() {
        Object object = this._syncConfig;
        synchronized (object) {
            ManagedConfiguration config = this.configWithHandlers;
            if (config == null) {
                return;
            }
            config.removeAfterPropertyChangeHandler("string-attributes-encoding", this.onChangedEncodingProperty);
            config.removeAfterPropertyChangeHandler("protocol", this.onChangedAddpProperty);
            config.removeAfterPropertyChangeHandler("x-addp-active", this.onChangedAddpProperty);
            config.removeAfterPropertyChangeHandler("addp-remote-timeout", this.onChangedAddpProperty);
            config.removeAfterPropertyChangeHandler("addp-trace", this.onChangedAddpProperty);
            config.removeAfterPropertyChangeHandler("addp-timeout", this.onChangedAddpProperty);
            this.configWithHandlers = null;
            if (log.isDebug()) {
                log.debug((Object)"Removed Attribute's handlers from connection configuration");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerConfigurationHandlers(ConnectionConfiguration config) {
        Object object = this._syncConfig;
        synchronized (object) {
            this.unregisterConfigurationHandlers();
            if (config == null) {
                return;
            }
            if (config instanceof ManagedConfiguration) {
                if (log.isDebug()) {
                    log.debug((Object)"Assigned Attribute's handlers for connection configuration");
                }
                ManagedConfiguration mcfg = (ManagedConfiguration)config;
                this.updateAddpFlag(mcfg.getOption("protocol"));
                mcfg.addAfterPropertyChangeHandler("string-attributes-encoding", this.onChangedEncodingProperty);
                mcfg.addAfterPropertyChangeHandler("protocol", this.onChangedAddpProperty);
                mcfg.addAfterPropertyChangeHandler("x-addp-active", this.onChangedAddpProperty);
                mcfg.addAfterPropertyChangeHandler("addp-remote-timeout", this.onChangedAddpProperty);
                mcfg.addAfterPropertyChangeHandler("addp-trace", this.onChangedAddpProperty);
                mcfg.addAfterPropertyChangeHandler("addp-timeout", this.onChangedAddpProperty);
                this.configWithHandlers = mcfg;
            }
        }
    }

    private void updateAddpFlag(String protocol) {
        this.addpFlag = "addp".equals(protocol);
    }

    @Override
    public boolean hasUnsetBytes() {
        return false;
    }

    @Override
    public long getUnsetBytes() {
        return 0L;
    }

    @Override
    public long getId() {
        return this.Id;
    }

    @Override
    public String getLocalBindHost() {
        return this.localBindHost;
    }

    @Override
    public void setLocalBindHost(String host) {
        this.localBindHost = host;
    }

    @Override
    public Integer getLocalBindPort() {
        return this.localBindPort;
    }

    @Override
    public void setLocalBindPort(Integer port) {
        this.localBindPort = port;
    }

    public class CloseCommand
    implements Command {
        private Throwable reason;

        public CloseCommand(Throwable reason) {
            this.reason = reason;
        }

        @Override
        public Object execute() {
            log.debug((Object)"Executing close command");
            AbstractConnection.this.doClose(this.reason);
            return null;
        }
    }
}

