/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl;

import com.genesyslab.platform.commons.collections.util.Hex;
import com.genesyslab.platform.commons.connection.ConnectionHandler;
import com.genesyslab.platform.commons.connection.MessagePackager;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.impl.AbstractConnection;
import com.genesyslab.platform.commons.connection.impl.CommonMessageTransportImpl;
import com.genesyslab.platform.commons.connection.impl.ConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.ConnectionMessagePackagerImpl;
import com.genesyslab.platform.commons.connection.interceptor.AddpInterceptor;
import com.genesyslab.platform.commons.connection.interceptor.Interceptor;
import com.genesyslab.platform.commons.connection.interceptor.InterceptorImpl;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.threading.AsyncInvoker;
import java.net.InetSocketAddress;

public abstract class AbstractConnectionImpl
extends AbstractConnection
implements ConnectionImpl {
    private static final ILogger log = Log.getLogger(AbstractConnectionImpl.class);
    private volatile InterceptorImpl interceptor;
    private MessagePackager packager;
    private MessageTransport transport;
    private AsyncInvoker invoker;
    protected ConnectionConfiguration config;
    private boolean serverConnection;

    @Override
    public ConnectionHandler getConnectionHandler() {
        return this.connHandler;
    }

    @Override
    public InterceptorImpl getProtocol() {
        return this.interceptor;
    }

    @Override
    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    @Override
    public MessagePackager getMessagePackager() {
        if (this.packager == null) {
            this.setMessagePackager(new ConnectionMessagePackagerImpl());
        }
        return this.packager;
    }

    @Override
    public void setMessagePackager(MessagePackager packager) {
        packager.setConnection(this);
        this.packager = packager;
    }

    @Override
    public MessageTransport getMessageTransport() {
        if (this.transport == null) {
            this.setMessageTransport(new CommonMessageTransportImpl());
        }
        return this.transport;
    }

    @Override
    public void setMessageTransport(MessageTransport transport) {
        transport.setConnection(this);
        this.transport = transport;
    }

    @Override
    public AsyncInvoker getInvoker() {
        return this.invoker;
    }

    @Override
    public void setInvoker(AsyncInvoker invoker) {
        this.invoker = invoker;
    }

    protected void initProtocol(ConnectionConfiguration config) {
        if (this.isServerConnection()) {
            String protocol = config.getOption("protocol");
            if (protocol != null && protocol.equals("addp")) {
                AddpInterceptor newInterceptor = new AddpInterceptor(this);
                newInterceptor.configure(config);
                this.interceptor = newInterceptor;
            }
        } else {
            AddpInterceptor newInterceptor = new AddpInterceptor(this);
            newInterceptor.configure(config);
            this.interceptor = newInterceptor;
        }
        String strAttrEncoding = config.getOption("string-attributes-encoding");
        if (strAttrEncoding != null && strAttrEncoding.length() > 0) {
            this.setStringAttributesEncoding(strAttrEncoding);
        }
    }

    protected void reconfigProtocol(ConnectionConfiguration config) {
        if (this.interceptor != null) {
            this.interceptor.configure(config);
        } else {
            log.debug((Object)"Interceptor is not initialized, call first configure() before open()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(ConnectionConfiguration config) {
        Object object = this._syncConfig;
        synchronized (object) {
            ConnectionConfiguration configOld = this.config;
            if (configOld != config) {
                this.unregisterConfigurationHandlers();
            }
            if (config == null) {
                return;
            }
            this.config = config;
            if (this.interceptor == null) {
                this.initProtocol(config);
            } else {
                this.reconfigProtocol(config);
            }
            if (this.packager != null) {
                this.packager.configure(config);
            }
            this.registerConfigurationHandlers(config);
        }
    }

    @Override
    public void setStringAttributesEncoding(String encodingNew) {
        String encodingOld = this.getStringAttributesEncoding();
        if (log.isDebug()) {
            log.debugFormat("setStringAttributesEncoding: {0} (previous value: {1})", (Object)new Object[]{encodingNew, encodingOld});
        }
        super.setStringAttributesEncoding(encodingNew);
    }

    public static int getConfigTimeout(ConnectionConfiguration config, String timeoutOptionName, int defaultTimeout) {
        block4: {
            String s;
            if (config != null && null != (s = config.getOption(timeoutOptionName))) {
                try {
                    int t = Integer.parseInt(s);
                    if (t > 0) {
                        return t;
                    }
                }
                catch (NumberFormatException e) {
                    if (!log.isWarn()) break block4;
                    log.warn((Object)(timeoutOptionName + " parsing was failed: " + s), (Throwable)e);
                }
            }
        }
        return defaultTimeout;
    }

    protected int getConfigTimeout(String timeoutOptionName, int defaultTimeout) {
        return AbstractConnectionImpl.getConfigTimeout(this.config, timeoutOptionName, defaultTimeout);
    }

    protected InetSocketAddress getConfigLocalEndpoint() {
        Integer portValue;
        if (null == this.config) {
            return null;
        }
        String host = this.getLocalBindHost();
        if (host == null) {
            host = this.config.getOption("transport-address");
        }
        if ((portValue = this.getLocalBindPort()) == null) {
            portValue = this.config.getInteger("transport-port");
        }
        if (null == host && null == portValue) {
            return null;
        }
        int port = 0;
        if (null != portValue) {
            port = portValue;
        }
        InetSocketAddress address = host == null ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
        return address;
    }

    protected static String bytesToHexDump(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        Hex.appendBytesStr((StringBuilder)result, (byte[])bytes, (boolean)true, (int)256);
        return result.toString();
    }

    public boolean isServerConnection() {
        return this.serverConnection;
    }

    protected void setServerConnection(boolean serverConnection) {
        this.serverConnection = serverConnection;
    }

    protected int getUsedLocalBindPort() {
        Integer port = this.getLocalBindPort();
        if (port != null) {
            return port;
        }
        port = this.config.getInteger("transport-port");
        if (port != null) {
            return port;
        }
        return 0;
    }
}

