/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl;

import com.genesyslab.platform.commons.connection.tls.ConfigUtils;
import com.genesyslab.platform.commons.connection.tls.PropertyReader;
import com.genesyslab.platform.commons.connection.tls.TLSConfiguration;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public final class InternalTLSConfigurationParser {
    private static final char[] DUMMY = new char[0];
    private static final ILogger log = Log.getLogger(InternalTLSConfigurationParser.class);
    private static final String TARGET_CHECK_HOST = "host";
    private static final String KEY_TARGET_SERVER_HOST = "psdk-internal-target-server-host";

    public static TLSConfiguration parseTlsConfiguration(PropertyReader prop, boolean clientMode, OptionDecoder decoder) {
        if (null == prop) {
            throw new IllegalArgumentException("prop must not be null");
        }
        TLSConfiguration config = new TLSConfiguration();
        config.setClientMode(clientMode);
        config.setTlsEnabled(ConfigUtils.isTrue(prop.getProperty("tls")));
        config.setProvider(prop.getProperty("provider"));
        config.setCertificate(prop.getProperty("certificate"));
        config.setCertificateKey(prop.getProperty("certificate-key"));
        config.setTrustedCaCertificate(prop.getProperty("trusted-ca"));
        config.setMutual(ConfigUtils.isTrue(prop.getProperty("tls-mutual")));
        config.setCrl(prop.getProperty("tls-crl"));
        config.setTargetNameCheckEnabled(TARGET_CHECK_HOST.equalsIgnoreCase(prop.getProperty("tls-target-name-check")));
        if (config.isTargetNameCheckEnabled()) {
            config.setExpectedHostname(prop.getProperty(KEY_TARGET_SERVER_HOST));
        }
        config.setFips140Enabled(ConfigUtils.isTrue(prop.getProperty("fips140-enabled")));
        config.setCipherList(prop.getProperty("cipher-list"));
        String secProtocol = prop.getProperty("sec-protocol");
        if (secProtocol != null) {
            config.setSecProtocol(secProtocol);
        }
        String protocolVersion = prop.getProperty("tls-version");
        String protocolList = prop.getProperty("protocol-list");
        if (secProtocol == null) {
            config.setEnabledProtocols(protocolList);
            config.setVersion(protocolVersion);
        } else {
            if (protocolVersion != null && !protocolVersion.equals(config.getVersion()) && log.isWarn()) {
                log.warnFormat("tls-version was ignored: {0}. sec-protocl was used: {1}.", (Object)new Object[]{protocolVersion, secProtocol});
            }
            if (protocolList != null && !secProtocol.equals(TLSConfiguration.enabledProtocols2sec(protocolList)) && log.isWarn()) {
                log.warnFormat("protocol-list was ignored: {0}. sec-protocl was used: {1}.", (Object)new Object[]{protocolList, secProtocol});
            }
        }
        if (decoder != null) {
            String trustStorePwd;
            String keyEntryPwd;
            String keyStorePwd = prop.getProperty("enc.keyStorePassword");
            if (keyStorePwd != null) {
                config.setKeyStoreCallbackHandler(new PwdCallbackHandler(keyStorePwd, decoder));
            }
            if ((keyEntryPwd = prop.getProperty("enc.keyEntryPassword")) != null) {
                config.setKeyStoreEntryCallbackHandler(new PwdCallbackHandler(keyEntryPwd, decoder));
            }
            if ((trustStorePwd = prop.getProperty("enc.trustStorePassword")) != null) {
                config.setTrustStoreCallbackHandler(new PwdCallbackHandler(trustStorePwd, decoder));
            }
        }
        return config;
    }

    private static class PwdCallbackHandler
    implements CallbackHandler {
        private final String encryptedValue;
        private final OptionDecoder decoder;

        public PwdCallbackHandler(String encryptedValue, OptionDecoder decoder) {
            this.encryptedValue = encryptedValue;
            this.decoder = decoder;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback c : callbacks) {
                if (!(c instanceof PasswordCallback)) continue;
                char[] tmp = this.decoder.decode(this.encryptedValue);
                if (tmp == null) {
                    tmp = DUMMY;
                }
                if (tmp == null) continue;
                ((PasswordCallback)c).setPassword(tmp);
                for (int i = tmp.length - 1; i >= 0; --i) {
                    tmp[i] = '\u0000';
                }
            }
        }
    }

    public static interface OptionDecoder {
        public char[] decode(String var1);
    }
}

