/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl.netty;

import com.genesyslab.platform.commons.connection.Connection;
import com.genesyslab.platform.commons.connection.ConnectionException;
import com.genesyslab.platform.commons.connection.ConnectionState;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.connection.PsdkConnectionException;
import com.genesyslab.platform.commons.connection.StartTLSSupport;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.impl.AbstractConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.BinaryStreamListening;
import com.genesyslab.platform.commons.connection.impl.ConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.ContextUtil;
import com.genesyslab.platform.commons.connection.impl.IncomingBinaryMessageListener;
import com.genesyslab.platform.commons.connection.impl.InvalidPacketException;
import com.genesyslab.platform.commons.connection.impl.InvalidPacketSizeException;
import com.genesyslab.platform.commons.connection.impl.OutcomingBinaryMessageListener;
import com.genesyslab.platform.commons.connection.impl.WritePipe;
import com.genesyslab.platform.commons.connection.impl.netty.NettyUtil;
import com.genesyslab.platform.commons.connection.impl.netty.NettyWritePipeImpl;
import com.genesyslab.platform.commons.connection.resolver.DefaultSocketAddressResolver;
import com.genesyslab.platform.commons.connection.resolver.SocketAddressResolver;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.io.Serializable;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.SucceededChannelFuture;
import org.jboss.netty.handler.ssl.SslHandler;

public class NettyConnectionImpl
extends AbstractConnectionImpl
implements Connection,
ConnectionImpl,
StartTLSSupport,
BinaryStreamListening {
    public static final String CHANNEL_FACTORY_CTX_KEY = "com.genesyslab.platform.commons.connection.impl.netty.ChannelFactory";
    private static final String SSL_HANDLER_NAME = "ssl-handler";
    private static final String INBOUND_HANDLER_NAME = "inbound-handler";
    private static final String CONNECTION_INBOUND_HANDLER_NAME = "connection-inbound-handler";
    private static final ILogger log = Log.getLogger(NettyConnectionImpl.class);
    private final NettyWritePipeImpl writePipe = new NettyWritePipeImpl(this);
    private int timeout;
    private final Object channelFactoryLock = new Object();
    private ChannelFactory channelFactory;
    private ChannelFactory serverChannelFactory;
    private volatile OpenConnectionTask openConnectionTask;
    private volatile ChannelFuture connectFuture;
    private volatile Channel channel;
    private final ChannelFutureListener closeListener = new CloseListener();
    private final AtomicBoolean closed = new AtomicBoolean();
    private volatile Throwable closeReason;
    private IncomingBinaryMessageListener incomingBinaryMessageListener;
    private OutcomingBinaryMessageListener outcomingBinaryMessageListener;

    public static NettyConnectionImpl createServerConnection() {
        NettyConnectionImpl n = new NettyConnectionImpl();
        n.setServerConnection(true);
        return n;
    }

    @Override
    public IncomingBinaryMessageListener getIncomingBinaryMessageListener() {
        return this.incomingBinaryMessageListener;
    }

    @Override
    public OutcomingBinaryMessageListener getOutcomingBinaryMessageListener() {
        return this.outcomingBinaryMessageListener;
    }

    @Override
    public void setIncomingBinaryMessageListener(IncomingBinaryMessageListener incomingBinaryMessageListener) {
        this.incomingBinaryMessageListener = incomingBinaryMessageListener;
    }

    @Override
    public void setOutcomingBinaryMessageListener(OutcomingBinaryMessageListener outcomingBinaryMessageListener) {
        this.outcomingBinaryMessageListener = outcomingBinaryMessageListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leaseChannelFactory() {
        Object object = this.channelFactoryLock;
        synchronized (object) {
            if (this.channelFactory == null) {
                this.channelFactory = NettyUtil.clientChannelFactory(this.context());
                this.setExecutor(NettyUtil.getFactoryExecutor(this.channelFactory));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leaseServerChannelFactory() {
        Object object = this.channelFactoryLock;
        synchronized (object) {
            ChannelFactory oldFactory = this.serverChannelFactory;
            this.serverChannelFactory = this.channel != null ? NettyUtil.useServerChannelFactory(this.channel.getFactory()) : null;
            if (oldFactory != null) {
                NettyUtil.releaseServerChannelFactory(oldFactory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseChannelFactory() {
        Object object = this.channelFactoryLock;
        synchronized (object) {
            if (this.serverChannelFactory != null) {
                NettyUtil.releaseServerChannelFactory(this.serverChannelFactory);
                this.serverChannelFactory = null;
            }
            if (this.channelFactory != null) {
                this.setExecutor(null);
                NettyUtil.releaseClientChannelFactory(this.channelFactory);
                this.channelFactory = null;
            }
        }
    }

    @Override
    public void open() {
        super.open();
        log.debugFormat("Opening Netty connection {0}", (Object)this);
        this.setConnectionState(ConnectionState.OPENING);
        this.timeout = this.getConfigTimeout("operation-timeout", 500);
        this.leaseChannelFactory();
        Executor executor = this.getExecutor();
        OpenConnectionTask openTask = new OpenConnectionTask();
        if (executor != null) {
            executor.execute(openTask);
        } else {
            this.getInvoker().invoke((Runnable)openTask);
        }
    }

    private ChannelPipeline initPipeline() {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast(CONNECTION_INBOUND_HANDLER_NAME, (ChannelHandler)new ConnectionTimeInboundHandler());
        return pipeline;
    }

    private void tryOpen(ClientBootstrap bootstrap, List<InetSocketAddress> ipAddresses, int ipAddressIndex) {
        InetSocketAddress ipAddress = ipAddresses.get(ipAddressIndex);
        int usedLocalPort = this.getUsedLocalBindPort();
        if (ipAddressIndex > 0 && usedLocalPort > 0 && log.isWarn()) {
            log.warn((Object)("Trying to use local port " + usedLocalPort + " binding for connection " + this.host + ":" + this.port + " to next resolved IP " + ipAddresses.get(ipAddressIndex).getAddress().getHostAddress()));
        }
        if (log.isDebug()) {
            log.debugFormat("Trying to open connection to {0}", (Object)ipAddress);
        }
        bootstrap.setOption("remoteAddress", (Object)ipAddress);
        this.connectFuture = bootstrap.connect();
        this.connectFuture.addListener((ChannelFutureListener)new ConnectionListener(bootstrap, ipAddresses, ipAddressIndex));
    }

    @Override
    public WritePipe getWritePipe() {
        return this.writePipe;
    }

    @Override
    public void startTLS() throws GeneralSecurityException {
        this.startTLS(this.isClientChannel());
    }

    @Override
    public void startTLS(Runnable notificationCllback) throws GeneralSecurityException {
        this.startTLS(this.isClientChannel(), notificationCllback);
    }

    protected void startTLS(boolean clientMode) throws GeneralSecurityException {
        this.startTLS(clientMode, null);
    }

    protected void startTLS(boolean clientMode, final Runnable notificationCllback) throws GeneralSecurityException {
        ChannelPipeline pipeline = this.channel.getPipeline();
        if (pipeline == null || this.getSSLHandler(pipeline) != null) {
            throw new PsdkConnectionException("can't start TLS");
        }
        SslHandler sslHandler = this.addSSLHandler(pipeline, clientMode);
        if (clientMode) {
            try {
                ChannelFuture chFuture = sslHandler.handshake();
                if (notificationCllback != null) {
                    chFuture.addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (future.isSuccess()) {
                                notificationCllback.run();
                            } else if (log.isError()) {
                                log.error((Object)"TLS handshake failed", future.getCause());
                            }
                        }
                    });
                } else {
                    this.awaitFuture(chFuture);
                }
            }
            catch (InterruptedException e) {
                throw new GeneralSecurityException("TLS handshake was interrupted", e);
            }
        }
    }

    @Override
    public void stopTLS() {
        ChannelPipeline pipeline = this.channel.getPipeline();
        SslHandler sslHandler = this.getSSLHandler(pipeline);
        if (null == sslHandler) {
            throw new PsdkConnectionException("can't stop TLS");
        }
        sslHandler.close();
        this.removeSSLHandler(pipeline);
    }

    @Override
    public boolean stopReading() {
        ChannelFuture cf = this.channel.setReadable(false);
        try {
            this.awaitFuture(cf);
            boolean success = cf.isSuccess();
            Throwable cause = cf.getCause();
            if (!success && null != cause) {
                log.error((Object)"Could not stop reading for channel", cause);
            }
            return success;
        }
        catch (InterruptedException e) {
            log.error((Object)"Could not stop reading for channel", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean resumeReading() {
        ChannelFuture cf = this.channel.setReadable(true);
        try {
            this.awaitFuture(cf);
            boolean success = cf.isSuccess();
            Throwable cause = cf.getCause();
            if (!success && null != cause) {
                log.error((Object)"Could not resume reading for channel", cause);
            }
            return success;
        }
        catch (InterruptedException e) {
            log.error((Object)"Could not resume reading for channel", (Throwable)e);
            return false;
        }
    }

    private void awaitFuture(ChannelFuture channelFuture) throws InterruptedException {
        if (this.timeout <= 0) {
            channelFuture.await();
        } else {
            channelFuture.await((long)this.timeout);
        }
    }

    private boolean isClientChannel() {
        return null != this.channelFactory;
    }

    @Override
    protected void startClose(final Throwable closeReason) {
        this.cancelConnection();
        final Channel channelLocal = this.channel;
        if (null == channelLocal) {
            return;
        }
        if (null != closeReason) {
            ExceptionEvent e = new ExceptionEvent(){

                public Throwable getCause() {
                    return closeReason;
                }

                public Channel getChannel() {
                    return channelLocal;
                }

                public ChannelFuture getFuture() {
                    return new SucceededChannelFuture(channelLocal);
                }
            };
            this.closeReason = closeReason;
            channelLocal.getPipeline().sendUpstream((ChannelEvent)e);
        } else {
            channelLocal.write((Object)ChannelBuffers.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
    }

    private boolean isCancelledState() {
        ConnectionState connectionState = this.getConnectionState();
        return ConnectionState.CLOSING == connectionState || ConnectionState.CLOSED == connectionState;
    }

    private void cancelConnection() {
        ChannelFuture future = this.connectFuture;
        if (null != future) {
            future.cancel();
        }
        this.interruptOpenTask();
    }

    private void interruptOpenTask() {
        OpenConnectionTask task = this.openConnectionTask;
        if (task != null) {
            task.interruptThread();
        }
    }

    @Override
    protected void doClose(Throwable closeReason) {
        Channel closingChannel = this.channel;
        this.doClose(closingChannel, closeReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose(Channel closingChannel, Throwable closeReason) {
        if (!this.closed.compareAndSet(false, true)) {
            if (log.isDebug()) {
                log.debug((Object)("doClose " + this));
            }
            return;
        }
        this.cancelConnection();
        if (closingChannel != null) {
            this.removeCloseListener(closingChannel);
            closingChannel.close();
        } else {
            log.debug((Object)("No channel assigned to close connection " + this));
        }
        try {
            super.doClose(closeReason);
        }
        finally {
            if (this.channelFactory != null || this.serverChannelFactory != null) {
                this.releaseChannelFactory();
            }
        }
    }

    protected Channel getChannel() {
        return this.channel;
    }

    private void assignChannel(Channel channel) {
        this.channel = channel;
        this.removeConnectionTimeInboundHandler(channel.getPipeline());
        this.addInboundHandler(channel.getPipeline());
        this.addCloseListener(channel);
    }

    @Override
    public InetSocketAddress getRemoteEndPoint() {
        SocketAddress sa = null;
        if (this.channel != null) {
            sa = this.channel.getRemoteAddress();
        }
        if (sa instanceof InetSocketAddress) {
            return (InetSocketAddress)sa;
        }
        return null;
    }

    @Override
    public InetSocketAddress getLocalEndPoint() {
        SocketAddress sa = null;
        if (this.channel != null) {
            if (this.channel instanceof SocketChannel) {
                SocketChannel sc = (SocketChannel)this.channel;
                Socket socket = sc.socket();
                if (socket != null) {
                    sa = socket.getLocalSocketAddress();
                }
            } else {
                sa = this.channel.getLocalAddress();
            }
        }
        if (sa instanceof InetSocketAddress) {
            return (InetSocketAddress)sa;
        }
        return null;
    }

    private void handleConnectionClose(Throwable cause) {
        if (cause == null) {
            if (ConnectionState.CLOSING != this.getConnectionState() && ConnectionState.CLOSED != this.getConnectionState() && this.isClientChannel()) {
                cause = new ConnectionException("Connection is closed by remote peer for " + this);
                log.error((Object)"connection closed", cause);
            } else {
                cause = this.closeReason;
            }
        }
        this.doClose((Throwable)cause);
    }

    private boolean isTLSEnabled() {
        ConnectionConfiguration conf = this.context().configuration();
        return null != conf && conf.getBoolean("tls");
    }

    private SslHandler createSSLHandler(boolean clientMode) {
        final SSLEngine engine = ContextUtil.sslEngine(this.context(), this.host, this.port, clientMode);
        return new SslHandler(engine){

            public void handleDownstream(ChannelHandlerContext context, ChannelEvent evt) throws Exception {
                try {
                    super.handleDownstream(context, evt);
                    NettyConnectionImpl.this.showSslHandshakeInfo(engine, null);
                }
                catch (Exception ex) {
                    NettyConnectionImpl.this.showSslHandshakeInfo(engine, ex);
                    throw ex;
                }
                catch (Error ex) {
                    NettyConnectionImpl.this.showSslHandshakeInfo(engine, ex);
                    throw ex;
                }
            }

            protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer in) throws Exception {
                try {
                    Object result = super.decode(ctx, channel, in);
                    NettyConnectionImpl.this.showSslHandshakeInfo(engine, null);
                    return result;
                }
                catch (Exception ex) {
                    NettyConnectionImpl.this.showSslHandshakeInfo(engine, ex);
                    throw ex;
                }
                catch (Error ex) {
                    NettyConnectionImpl.this.showSslHandshakeInfo(engine, ex);
                    throw ex;
                }
            }
        };
    }

    private void showSslHandshakeInfo(SSLEngine engine, Throwable ex) {
        if (ConnectionState.OPENING.equals((Object)this.getConnectionState()) && log.isDebug()) {
            SSLSession session = engine.getSession();
            if (session == null) {
                log.debugFormat("[TLSHandshake]: " + engine + " " + this.toString(), (Object)ex);
            } else {
                log.debugFormat("[TLSHandshake]: " + engine + " protocol:" + session.getProtocol() + " cipherSuite:" + session.getCipherSuite() + " " + this.toString(), (Object)ex);
            }
        }
    }

    private SslHandler getSSLHandler(ChannelPipeline pipeline) {
        SslHandler result = null;
        if (null != pipeline) {
            result = (SslHandler)pipeline.get(SSL_HANDLER_NAME);
        }
        return result;
    }

    private SslHandler addSSLHandler(ChannelPipeline pipeline, boolean clientMode) {
        SslHandler handler = this.getSSLHandler(pipeline);
        if (null == handler) {
            handler = this.createSSLHandler(clientMode);
            pipeline.addFirst(SSL_HANDLER_NAME, (ChannelHandler)handler);
        }
        return handler;
    }

    private SslHandler removeSSLHandler(ChannelPipeline pipeline) {
        SslHandler handler = this.getSSLHandler(pipeline);
        if (null != handler) {
            pipeline.remove((ChannelHandler)handler);
        }
        return handler;
    }

    private InboundHandler getInboundHandler(ChannelPipeline pipeline) {
        InboundHandler result = null;
        if (null != pipeline) {
            result = (InboundHandler)pipeline.get(INBOUND_HANDLER_NAME);
        }
        return result;
    }

    private ConnectionTimeInboundHandler getConnectionTimeInboundHandler(ChannelPipeline pipeline) {
        ConnectionTimeInboundHandler result = null;
        if (null != pipeline) {
            result = (ConnectionTimeInboundHandler)pipeline.get(CONNECTION_INBOUND_HANDLER_NAME);
        }
        return result;
    }

    private InboundHandler addInboundHandler(ChannelPipeline pipeline) {
        InboundHandler handler = this.getInboundHandler(pipeline);
        if (null == handler) {
            handler = new InboundHandler();
            pipeline.addLast(INBOUND_HANDLER_NAME, (ChannelHandler)handler);
        }
        return handler;
    }

    private InboundHandler removeInboundHandler(ChannelPipeline pipeline) {
        InboundHandler handler = this.getInboundHandler(pipeline);
        if (null != handler) {
            handler.removed = true;
        }
        return handler;
    }

    private ConnectionTimeInboundHandler removeConnectionTimeInboundHandler(ChannelPipeline pipeline) {
        ConnectionTimeInboundHandler handler = this.getConnectionTimeInboundHandler(pipeline);
        if (null != handler) {
            pipeline.remove((ChannelHandler)handler);
        }
        return handler;
    }

    private void addCloseListener(Channel channel) {
        channel.getCloseFuture().addListener(this.closeListener);
    }

    private void removeCloseListener(Channel channel) {
        channel.getCloseFuture().removeListener(this.closeListener);
    }

    private Map<String, Object> options() {
        int connectionTimeout;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("remoteAddress", this.address);
        InetSocketAddress localAddress = this.getConfigLocalEndpoint();
        if (null != localAddress) {
            result.put("localAddress", localAddress);
        }
        if ((connectionTimeout = this.getConfigTimeout("connection-timeout", -1)) > 0) {
            result.put("connectTimeoutMillis", connectionTimeout);
        }
        if (null != this.config) {
            if (null != this.config.getOption("reuse-address")) {
                result.put("reuseAddress", this.config.getBoolean("reuse-address"));
            }
            if (null != this.config.getOption("keep-alive")) {
                result.put("keepAlive", this.config.getBoolean("keep-alive"));
            }
        }
        return result;
    }

    public void attach(Channel channel) {
        this.setConnectionState(ConnectionState.OPENING);
        if (log.isDebug()) {
            log.debugFormat("Attaching to channel: {0} on connection ''{1}''", (Object)new Object[]{channel, this});
        }
        this.channel = channel;
        this.leaseServerChannelFactory();
        this.address = channel.getRemoteAddress();
        if (this.address instanceof InetSocketAddress) {
            InetSocketAddress socketAddress = (InetSocketAddress)this.address;
            this.host = socketAddress.getAddress().getHostAddress();
            this.port = socketAddress.getPort();
        }
        this.addInboundHandler(channel.getPipeline());
        this.addCloseListener(channel);
        this.setConnectionState(ConnectionState.OPENED);
    }

    @Override
    public boolean hasUnsetBytes() {
        return this.writePipe.hasUnsentBytes();
    }

    @Override
    public long getUnsetBytes() {
        return this.writePipe.getUnsentBytes();
    }

    private class CloseListener
    implements ChannelFutureListener {
        private CloseListener() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (NettyConnectionImpl.this.closed.get()) {
                if (log.isDebug()) {
                    log.debug((Object)("[CloseListener] operationComplete skipped " + NettyConnectionImpl.this));
                }
                return;
            }
            NettyConnectionImpl.this.handleConnectionClose(future.getCause());
        }
    }

    private class ConnectionTimeInboundHandler
    extends SimpleChannelUpstreamHandler {
        private volatile boolean nextTry;
        private String currentIpAddress;

        private ConnectionTimeInboundHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            if (NettyConnectionImpl.this.closed.get()) {
                if (log.isDebug()) {
                    log.debug((Object)("[ConnectionTimeInboundHandler] exceptionCaught skipped " + NettyConnectionImpl.this), e.getCause());
                }
                return;
            }
            if (log.isDebug()) {
                log.debug((Object)("[ConnectionTimeInboundHandler] exceptionCaught " + NettyConnectionImpl.this), e.getCause());
            }
            Throwable t = e.getCause();
            boolean forceClose = false;
            if (t instanceof BindException) {
                int usedLocalBindPort = NettyConnectionImpl.this.getUsedLocalBindPort();
                if (this.nextTry && usedLocalBindPort > 0) {
                    log.error((Object)("The local port " + usedLocalBindPort + " is busy. It can be happened if the server \"" + NettyConnectionImpl.this.host + ":" + NettyConnectionImpl.this.port + "\" is offline or it isn't accessible by the resolved IP " + this.currentIpAddress), t);
                } else {
                    log.error((Object)("Could not bind to local port " + usedLocalBindPort + " on connection " + NettyConnectionImpl.this.host + "/" + this.currentIpAddress + ":" + NettyConnectionImpl.this.port), t);
                }
                forceClose = true;
            } else if (t instanceof SocketException && t.getCause() instanceof UnresolvedAddressException) {
                log.error((Object)("Could not bind to local address on connection " + NettyConnectionImpl.this), t);
                forceClose = true;
            } else if (log.isError()) {
                log.error((Object)("[ConnectionTimeInboundHandler] Exception on connection \"" + NettyConnectionImpl.this + "\": "), t);
            }
            if (forceClose) {
                Channel ch = e.getChannel();
                NettyConnectionImpl.this.doClose(ch, e.getCause());
            }
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
            if (NettyConnectionImpl.this.closed.get()) {
                if (log.isDebug()) {
                    log.debug("[ConnectionTimeInboundHandler] messageReceived skipped " + NettyConnectionImpl.this + " " + e != null ? e.getMessage() : "null");
                }
                return;
            }
            Object message = e.getMessage();
            if (message instanceof ChannelBuffer) {
                ChannelBuffer buffer = (ChannelBuffer)message;
                int cnt = buffer.readableBytes();
                byte[] bytes = new byte[cnt];
                buffer.readBytes(bytes);
                String hexDump = NettyConnectionImpl.bytesToHexDump(bytes);
                log.debug((Object)("Unexpected inbound data encountered on \"" + NettyConnectionImpl.this + "\": " + hexDump));
            } else {
                log.debug((Object)("Unexpected message type encountered on \"" + NettyConnectionImpl.this + "\": " + message.getClass().getName()));
            }
        }
    }

    private class InboundHandler
    extends SimpleChannelUpstreamHandler {
        public boolean removed;

        private InboundHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            if (this.removed) {
                return;
            }
            if (NettyConnectionImpl.this.closed.get()) {
                if (log.isDebug()) {
                    log.debug((Object)("[InboundHandler] exceptionCaught skipped " + NettyConnectionImpl.this + "\": "), e.getCause());
                }
                return;
            }
            if (log.isError()) {
                log.error((Object)("[InboundHandler] Exception on connection \"" + NettyConnectionImpl.this + "\": "), e.getCause());
            }
            Channel ch = e.getChannel();
            NettyConnectionImpl.this.doClose(ch, e.getCause());
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws ConnectionException {
            block8: {
                if (this.removed) {
                    return;
                }
                if (NettyConnectionImpl.this.closed.get()) {
                    if (log.isDebug()) {
                        log.debug((Object)("[InboundHandler] messageReceived skipped " + NettyConnectionImpl.this + "\": " + (e != null ? e.getMessage() : "null")));
                    }
                    return;
                }
                Object message = e.getMessage();
                if (message instanceof ChannelBuffer) {
                    ChannelBuffer buffer = (ChannelBuffer)message;
                    int cnt = buffer.readableBytes();
                    byte[] bytes = new byte[cnt];
                    buffer.readBytes(bytes);
                    try {
                        MessageTransport mt = NettyConnectionImpl.this.getMessageTransport();
                        if (mt != null) {
                            mt.processData(bytes, 0, cnt);
                            break block8;
                        }
                        log.error((Object)"null transport");
                    }
                    catch (InvalidPacketException ex) {
                        String hexDump = NettyConnectionImpl.bytesToHexDump(bytes);
                        log.debug((Object)("Invalid packet encountered on \"" + NettyConnectionImpl.this + "\": " + hexDump), (Throwable)((Object)ex));
                        if (ex instanceof InvalidPacketSizeException) {
                            Channel ch = e.getChannel();
                            NettyConnectionImpl.this.doClose(ch, (Throwable)((Object)ex));
                        }
                        break block8;
                    }
                }
                log.error((Object)("Unexpected message type, simple buffer expected " + e));
                throw new ConnectionException("Unexpected message type, simple buffer expected");
            }
        }
    }

    private class TLSHandshakeListener
    extends ConnectionListener {
        private TLSHandshakeListener(ClientBootstrap bootstrap, List<InetSocketAddress> ipAddresses, int ipAddressIndex) {
            super(bootstrap, ipAddresses, ipAddressIndex);
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            if (NettyConnectionImpl.this.closed.get()) {
                if (log.isDebug()) {
                    log.debug((Object)("[TLSHandshakeListener] operationComplete skipped " + NettyConnectionImpl.this));
                }
                return;
            }
            NettyConnectionImpl.this.connectFuture = null;
            if (future.isCancelled() || NettyConnectionImpl.this.isCancelledState()) {
                this.handleCancellation(future, "TLS handshake was cancelled for " + NettyConnectionImpl.this);
            } else if (future.isSuccess()) {
                log.debug((Object)"TLS handshake succeeded");
                this.handleSuccess(future);
            } else {
                this.tryNextIP(future, "TLS handshake with remote host did not succeed, trying next IP address");
            }
        }
    }

    private class ConnectionListener
    implements ChannelFutureListener {
        protected final ClientBootstrap bootstrap;
        protected final List<InetSocketAddress> ipAddresses;
        protected final int ipAddressIndex;

        private ConnectionListener(ClientBootstrap bootstrap, List<InetSocketAddress> ipAddresses, int ipAddressIndex) {
            this.bootstrap = bootstrap;
            this.ipAddresses = ipAddresses;
            this.ipAddressIndex = ipAddressIndex;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (NettyConnectionImpl.this.closed.get()) {
                if (log.isDebug()) {
                    log.debug((Object)("[ConnectionListener] operationComplete skipped " + NettyConnectionImpl.this));
                }
                return;
            }
            NettyConnectionImpl.this.connectFuture = null;
            if (future.isCancelled() || NettyConnectionImpl.this.isCancelledState()) {
                this.handleCancellation(future, "Connection was cancelled for " + NettyConnectionImpl.this);
            } else if (future.isSuccess()) {
                log.debugFormat("Connection {0} is established", (Object)NettyConnectionImpl.this);
                NettyConnectionImpl.this.assignChannel(future.getChannel());
                if (NettyConnectionImpl.this.isTLSEnabled()) {
                    this.tryTLSHandshake(future);
                } else {
                    this.handleSuccess(future);
                }
            } else {
                this.tryNextIP(future, "Could not connect to remote host, trying next IP address for " + NettyConnectionImpl.this);
            }
        }

        protected void tryTLSHandshake(ChannelFuture future) {
            SslHandler sslHandler;
            if (log.isDebug()) {
                log.debugFormat("Registering TLS handshake handler ->{0}:{1}", (Object)new Object[]{this.getCurrentIpAddress(), Integer.toString(NettyConnectionImpl.this.port)});
            }
            if (null != (sslHandler = NettyConnectionImpl.this.addSSLHandler(future.getChannel().getPipeline(), true))) {
                if (log.isDebug()) {
                    log.debugFormat("Starting TLS handshake ->{0}:{1}", (Object)new Object[]{this.getCurrentIpAddress(), Integer.toString(NettyConnectionImpl.this.port)});
                }
                NettyConnectionImpl.this.connectFuture = sslHandler.handshake();
                NettyConnectionImpl.this.connectFuture.addListener((ChannelFutureListener)new TLSHandshakeListener(this.bootstrap, this.ipAddresses, this.ipAddressIndex));
            }
        }

        private Object getCurrentIpAddress() {
            return this.ipAddresses == null ? NettyConnectionImpl.this.host : (Serializable)this.ipAddresses.get(this.ipAddressIndex);
        }

        protected void tryNextIP(ChannelFuture future, String message) {
            ChannelPipeline pipeline = future.getChannel().getPipeline();
            NettyConnectionImpl.this.removeSSLHandler(pipeline);
            NettyConnectionImpl.this.removeInboundHandler(pipeline);
            Throwable th = future.getCause();
            if (this.ipAddresses != null && this.ipAddressIndex + 1 < this.ipAddresses.size()) {
                ConnectionTimeInboundHandler conHandler = NettyConnectionImpl.this.getConnectionTimeInboundHandler(pipeline);
                if (conHandler != null) {
                    conHandler.nextTry = true;
                    conHandler.currentIpAddress = this.ipAddresses.get(this.ipAddressIndex + 1).getAddress().getHostAddress();
                }
                log.debug((Object)message, th);
                NettyConnectionImpl.this.tryOpen(this.bootstrap, this.ipAddresses, this.ipAddressIndex + 1);
            } else {
                log.error((Object)"connection opening failed", th);
                NettyConnectionImpl.this.handleConnectionClose(th);
            }
        }

        protected void handleSuccess(ChannelFuture future) {
            if (NettyConnectionImpl.this.isCancelledState()) {
                NettyConnectionImpl.this.doClose(null);
                return;
            }
            NettyConnectionImpl.this.writePipe.writePendingData();
            NettyConnectionImpl.this.setConnectionState(ConnectionState.OPENED);
        }

        protected void handleCancellation(ChannelFuture future, String message) {
            log.debug((Object)message);
            Object th = future.getCause();
            if (null == th) {
                th = new ConnectionException(message);
            }
            NettyConnectionImpl.this.doClose((Throwable)th);
        }
    }

    class OpenConnectionTask
    implements Runnable {
        private Thread thread;
        private final Object threadGuard = new Object();
        private boolean interrupted;

        OpenConnectionTask() {
        }

        private void checkInterruption() throws InterruptedException {
            if (NettyConnectionImpl.this.isCancelledState()) {
                throw new InterruptedException("Connection opening is cancelled for " + NettyConnectionImpl.this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NettyConnectionImpl.this.openConnectionTask = this;
            Object object = this.threadGuard;
            synchronized (object) {
                this.thread = Thread.currentThread();
            }
            try {
                ClientBootstrap bootstrap;
                List<InetSocketAddress> ipAddresses;
                SocketAddressResolver resolver = null;
                Object res = NettyConnectionImpl.this.context().getAttribute("dns-resolver");
                if (res instanceof SocketAddressResolver) {
                    resolver = (SocketAddressResolver)res;
                } else if (res != null) {
                    log.warn((Object)("Invalid DNS resolver type in the context: " + res.getClass().getName()));
                }
                if (resolver == null) {
                    resolver = DefaultSocketAddressResolver.resolver();
                }
                if ((ipAddresses = resolver.resolve(DefaultSocketAddressResolver.createResolutionRequest(NettyConnectionImpl.this.host, NettyConnectionImpl.this.port, NettyConnectionImpl.this.context()))) == null || ipAddresses.isEmpty()) {
                    throw new UnknownHostException(NettyConnectionImpl.this.host);
                }
                this.checkInterruption();
                ChannelFactory channelFactory = NettyConnectionImpl.this.channelFactory;
                if (channelFactory == null) {
                    return;
                }
                try {
                    bootstrap = new ClientBootstrap(channelFactory);
                    bootstrap.setPipeline(NettyConnectionImpl.this.initPipeline());
                    bootstrap.setOptions(NettyConnectionImpl.this.options());
                    this.checkInterruption();
                }
                catch (Exception e) {
                    log.error((Object)"connection opening failed", (Throwable)e);
                    NettyConnectionImpl.super.doClose(e);
                    if (NettyConnectionImpl.this.channelFactory != null || NettyConnectionImpl.this.serverChannelFactory != null) {
                        NettyConnectionImpl.this.releaseChannelFactory();
                    }
                    return;
                }
                try {
                    NettyConnectionImpl.this.tryOpen(bootstrap, ipAddresses, 0);
                }
                catch (Exception e) {
                    NettyConnectionImpl.this.doClose(e);
                }
            }
            finally {
                Object object2 = this.threadGuard;
                synchronized (object2) {
                    this.thread = null;
                }
                NettyConnectionImpl.this.openConnectionTask = null;
                if (this.interrupted) {
                    Thread.interrupted();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void interruptThread() {
            Object object = this.threadGuard;
            synchronized (object) {
                if (this.thread != null) {
                    this.thread.interrupt();
                    this.interrupted = true;
                }
            }
        }
    }
}

