/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl.netty;

import com.genesyslab.platform.commons.PsdkCustomization;
import com.genesyslab.platform.commons.collections.util.Hex;
import com.genesyslab.platform.commons.connection.ConnectionState;
import com.genesyslab.platform.commons.connection.impl.WritePipe;
import com.genesyslab.platform.commons.connection.impl.WritePoint;
import com.genesyslab.platform.commons.connection.impl.netty.NettyConnectionImpl;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.Channels;

public class NettyWritePipeImpl
implements WritePipe,
WritePipe.TechnicalTrafficSupport {
    private static ILogger log = Log.getLogger(NettyWritePipeImpl.class);
    private NettyConnectionImpl connection;
    private final List<WritePointImpl> pendingWrites = new Vector<WritePointImpl>();
    private final AtomicInteger writingCounter = new AtomicInteger();
    private final AtomicLong writingBytes = new AtomicLong();
    private volatile long lastSendingTime;

    public NettyWritePipeImpl(NettyConnectionImpl connection) {
        this.connection = connection;
    }

    @Override
    public boolean hasUnsentBytes() {
        return this.writingBytes.get() > 0L;
    }

    @Override
    public long getUnsentBytes() {
        return this.writingBytes.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(WritePoint writePoint) {
        if (!(writePoint instanceof WritePointImpl)) {
            throw new IllegalArgumentException("Incompatible WritePoint, mixing connection implementation?");
        }
        WritePointImpl wp = (WritePointImpl)writePoint;
        List<WritePointImpl> list = this.pendingWrites;
        synchronized (list) {
            if (!wp.technicalTraffic) {
                if (wp.buffers != null) {
                    for (ChannelBuffer buffer : wp.buffers) {
                        int byteCount = buffer.writerIndex();
                        this.writingCounter.incrementAndGet();
                        this.writingBytes.addAndGet(byteCount);
                    }
                } else {
                    int byteCount = wp.bufferFirst.writerIndex();
                    this.writingCounter.incrementAndGet();
                    this.writingBytes.addAndGet(byteCount);
                }
            }
            if (this.connection.getConnectionState() == ConnectionState.OPENING) {
                log.debug((Object)"Attempt to write while connection is opening, request is queued");
                this.pendingWrites.add(wp);
            } else if (wp.buffers != null) {
                for (ChannelBuffer buffer : wp.buffers) {
                    this.writeChannelBuffer(buffer, wp.technicalTraffic, false);
                }
            } else {
                this.writeChannelBuffer(wp.bufferFirst, wp.technicalTraffic, false);
            }
        }
    }

    private static int hashCode(byte[] a, int offset, int length) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        int offset2 = offset + length;
        for (int i = offset; i < offset2; ++i) {
            byte element = a[i];
            result = 31 * result + element;
        }
        return result;
    }

    private void writeChannelBuffer(ChannelBuffer buffer, boolean technicalTraffic, boolean pendingBuffer) {
        int byteCount = buffer.writerIndex();
        Channel channel = this.connection.getChannel();
        if (this.connection.getConnectionState() != ConnectionState.OPENED) {
            log.debug((Object)"Can't write data to channel - its not opened ...");
            return;
        }
        if (!pendingBuffer && !this.pendingWrites.isEmpty()) {
            this.writePendingData();
        }
        this.logBuffer(buffer);
        ChannelFuture future = Channels.write((Channel)channel, (Object)buffer);
        if (!technicalTraffic) {
            future.addListener((ChannelFutureListener)new WriteListener(byteCount));
        }
    }

    private void logBuffer(ChannelBuffer buffer) {
        int cnt;
        String optionValue;
        if (log.isDebug() && ((optionValue = PsdkCustomization.getOption((PsdkCustomization.PsdkOption)PsdkCustomization.PsdkOption.LogConnectionTraffic, null, (String)"")).equals("all") || optionValue.equals("out")) && (cnt = buffer.readableBytes()) > 0) {
            byte[] bytes = buffer.array();
            int offset = buffer.arrayOffset();
            String s = Hex.appendHexAndAscTable(null, (byte[])bytes, (int)offset, (int)cnt, (String)"").toString();
            StringBuilder sb = new StringBuilder(200 + cnt * 5);
            sb.append("\n\nSEND ");
            sb.append(cnt);
            sb.append(" bytes @");
            sb.append(Integer.toHexString(NettyWritePipeImpl.hashCode(bytes, offset, cnt)));
            sb.append(" : ");
            sb.append(this.connection);
            sb.append(":\n");
            Hex.appendHexAndAscTable((StringBuilder)sb, (byte[])bytes, (int)offset, (int)cnt, (String)"");
            sb.append("\n");
            log.debug((Object)sb.toString());
        }
    }

    @Override
    public WritePoint createWritePoint() {
        return new WritePointImpl(false);
    }

    @Override
    public WritePoint createTechnicalTrafficWritePoint() {
        return new WritePointImpl(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePendingData() {
        Channel channel = this.connection.getChannel();
        if (channel == null) {
            return;
        }
        List<WritePointImpl> list = this.pendingWrites;
        synchronized (list) {
            if (this.pendingWrites.isEmpty()) {
                return;
            }
            if (this.connection.getConnectionState() != ConnectionState.OPENED) {
                log.debug((Object)"Can't write pending data to channel - its not opened ...");
                return;
            }
            log.debug((Object)"Writing queued requests...");
            for (WritePointImpl wp : this.pendingWrites) {
                if (wp.buffers != null) {
                    for (ChannelBuffer buffer : wp.buffers) {
                        this.writeChannelBuffer(buffer, wp.technicalTraffic, true);
                    }
                    continue;
                }
                this.writeChannelBuffer(wp.bufferFirst, wp.technicalTraffic, true);
            }
            this.pendingWrites.clear();
        }
    }

    @Override
    public void close(Throwable closeReason) {
    }

    @Override
    public long getLastSendingTime() {
        return this.lastSendingTime;
    }

    public static class PlainWritePointImpl
    implements WritePoint {
        private ChannelBuffer buffer = ChannelBuffers.dynamicBuffer((int)1024);

        @Override
        public void write(byte[] bytes) {
            this.write(bytes, 0, bytes.length);
        }

        @Override
        public void write(byte[] bytes, int offset, int len) {
            this.buffer.writeBytes(bytes, offset, len);
        }

        public ChannelBuffer getBuffer() {
            return this.buffer;
        }
    }

    public static class WritePointImpl
    implements WritePoint {
        private ChannelBuffer bufferFirst;
        private ArrayList<ChannelBuffer> buffers;
        private final boolean technicalTraffic;

        public WritePointImpl() {
            this(false);
        }

        public WritePointImpl(boolean technicalTraffic) {
            this.technicalTraffic = technicalTraffic;
        }

        @Override
        public void write(byte[] bytes) {
            this.write(bytes, 0, bytes.length);
        }

        @Override
        public void write(byte[] bytes, int offset, int len) {
            if (bytes == null) {
                throw (NullPointerException)new NullPointerException("bytes").initCause(null);
            }
            if (offset < 0 || offset >= bytes.length) {
                throw new IllegalArgumentException("offset=" + offset + " bytes.length=" + bytes.length);
            }
            if (len < 0 || len > offset + bytes.length) {
                throw new IllegalArgumentException(" offset=" + offset + " len: " + len + " bytes.length=" + bytes.length);
            }
            ChannelBuffer channelBuffer = ChannelBuffers.wrappedBuffer((byte[])bytes, (int)offset, (int)len);
            if (this.bufferFirst == null) {
                this.bufferFirst = channelBuffer;
            } else {
                if (this.buffers == null) {
                    this.buffers = new ArrayList(1024);
                    this.buffers.add(this.bufferFirst);
                }
                this.buffers.add(channelBuffer);
            }
        }

        public ChannelBuffer getBufferFirst() {
            return this.bufferFirst;
        }

        public Iterable<ChannelBuffer> getBuffers() {
            return this.buffers;
        }
    }

    private class WriteListener
    implements ChannelFutureListener {
        private volatile int remainedBytes;

        public WriteListener(int byteCount) {
            this.remainedBytes = byteCount;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                NettyWritePipeImpl.this.lastSendingTime = System.currentTimeMillis();
                NettyWritePipeImpl.this.writingCounter.decrementAndGet();
                NettyWritePipeImpl.this.writingBytes.addAndGet(-this.remainedBytes);
                this.remainedBytes = 0;
            }
        }
    }
}

