/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl.xml;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.MessagePackager;
import com.genesyslab.platform.commons.connection.PsdkConnectionException;
import com.genesyslab.platform.commons.connection.impl.InvalidPacketException;
import com.genesyslab.platform.commons.connection.impl.MessageProducer;
import com.genesyslab.platform.commons.connection.impl.xml.ProtocolDialect;
import com.genesyslab.platform.commons.connection.impl.xml.ProtocolDialectResolver;
import com.genesyslab.platform.commons.connection.impl.xml.XmlStructureHandler;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.xml.XmlUtil;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlMessageProducerImpl
implements MessageProducer {
    private static final String HEADER = "header";
    private static final String ENVELOPE = "envelope";
    private static final String BODY = "body";
    private static final String TEXT = "text";
    private static ILogger log = Log.getLogger(XmlMessageProducerImpl.class);
    private byte[] buf;
    private int pos;
    private int len;
    private MessagePackager packager;
    private ProtocolDialect dialect = null;
    private ProtocolDialectResolver dialectResolver = null;

    public XmlMessageProducerImpl(byte[] b, int pos, int len, MessagePackager packager) {
        this.buf = new byte[len];
        System.arraycopy(b, pos, this.buf, 0, len);
        this.pos = 0;
        this.len = len;
        this.packager = packager;
    }

    public void setDialect(ProtocolDialect dialect) {
        this.dialect = dialect;
    }

    public void setDialectResolver(ProtocolDialectResolver dialectResolver) {
        this.dialectResolver = dialectResolver;
    }

    @Override
    public void parse() throws InvalidPacketException {
        if (this.dialect == null && this.dialectResolver == null) {
            throw new PsdkConnectionException("MessageProducer is not initialized");
        }
        try {
            Document doc = this.parseData();
            if (doc != null) {
                Element envelope = doc.getDocumentElement();
                if (envelope != null) {
                    Element body = this.validateMessage(envelope);
                    if (body != null) {
                        this.parseMessage(XmlUtil.getFirstChild((Element)body), this.getMessageProtocolId(envelope));
                    } else {
                        log.warn((Object)"Got no proper xml message body element");
                    }
                } else {
                    log.warn((Object)"Got no proper xml message document element");
                }
            } else {
                log.warn((Object)"Got no proper xml message content");
            }
        }
        catch (PlatformException e) {
            log.warn((Object)"Problems packaging xml message", (Throwable)e);
        }
    }

    protected void parseMessage(Element messageElement) throws PlatformException {
        this.parseMessage(messageElement, null);
    }

    protected void parseMessage(Element messageElement, String protocolId) throws PlatformException {
        if (messageElement == null) {
            throw new PlatformException("empty body");
        }
        ProtocolDialect msgDialect = null;
        if (this.dialectResolver != null) {
            msgDialect = this.dialectResolver.resolveDialect(protocolId);
        }
        if (msgDialect == null) {
            msgDialect = this.dialect;
        }
        if (msgDialect == null) {
            throw new PlatformException("Unrecognized message protocol dialect");
        }
        String messageName = messageElement.getNodeName();
        int msgId = msgDialect.getMessageId(messageName);
        MessagePackager pkg = null;
        if (this.dialectResolver != null) {
            pkg = this.dialectResolver.resolvePackager(protocolId);
        }
        if (pkg == null) {
            pkg = this.packager;
        }
        Object state = pkg.onNewMessage(null, msgId);
        this.parseSimpleData(pkg, messageElement, state);
        this.parseComplexData(pkg, messageElement, state);
        pkg.onMessageEnd(state);
    }

    private void parseSimpleData(MessagePackager pkg, Element element, Object state) throws PlatformException {
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            pkg.onAttribute(state, attr.getName(), attr.getValue());
        }
        String text = XmlMessageProducerImpl.getTextWithoutFormatting(element);
        if (text != null && text.length() > 0) {
            pkg.onAttribute(state, TEXT, text);
        }
    }

    private void parseComplexData(MessagePackager pkg, Element complexData, Object packagerState) throws PlatformException {
        Element nestedData = XmlUtil.getFirstChild((Element)complexData);
        while (nestedData != null) {
            this.processComplexElement(pkg, nestedData, packagerState);
            nestedData = XmlUtil.getNextSibling((Element)nestedData);
        }
    }

    private static String getTextWithoutFormatting(Element elem) {
        StringBuilder buf = new StringBuilder();
        int index = 0;
        int nodeCount = 0;
        int textCount = 0;
        int skippedTextCount = 0;
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++nodeCount;
            if (node.getNodeType() == 3) {
                ++textCount;
                buf.append(node.getNodeValue());
                continue;
            }
            if (index >= buf.length() || !XmlMessageProducerImpl.detectFormatting(buf, index)) continue;
            buf.setLength(index);
            ++skippedTextCount;
        }
        if (textCount == 0) {
            return null;
        }
        if (textCount < nodeCount && index < buf.length() && XmlMessageProducerImpl.detectFormatting(buf, index)) {
            buf.setLength(index);
            ++skippedTextCount;
        }
        return buf.toString();
    }

    private static boolean detectFormatting(StringBuilder sb, int index) {
        int len = sb.length();
        int i = index;
        char c = sb.charAt(i);
        if (c == '\n') {
            ++i;
        } else if (c == '\r' && len > 1 && sb.charAt(i + 1) == '\n') {
            i += 2;
        } else {
            return false;
        }
        while (i < len) {
            c = sb.charAt(i);
            if (c != ' ' && c != '\t') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void processComplexElement(MessagePackager pkg, Element nestedData, Object packagerState) throws PlatformException {
        XmlStructureHandler xmlStructureHandler = null;
        boolean isXml = pkg instanceof XmlStructureHandler;
        boolean needsProcessing = false;
        String nodeName = nestedData.getNodeName();
        Object currentState = packagerState;
        if (isXml) {
            xmlStructureHandler = (XmlStructureHandler)((Object)pkg);
            currentState = xmlStructureHandler.onComplexAttribute(packagerState, nodeName, nestedData);
            needsProcessing = xmlStructureHandler.needsProcessing(packagerState, nodeName, nestedData);
        }
        if (needsProcessing) {
            this.parseSimpleData(pkg, nestedData, currentState);
            this.parseComplexData(pkg, nestedData, currentState);
        }
        if (isXml) {
            xmlStructureHandler.onComplexEnd(packagerState, nodeName);
        }
    }

    private Element validateMessage(Element envelope) throws PlatformException {
        Element body;
        if (envelope == null || !ENVELOPE.equals(envelope.getNodeName())) {
            throw new PlatformException("envelope element expected");
        }
        Element header = XmlUtil.getFirstChild((Element)envelope);
        if (header == null || !HEADER.equals(header.getNodeName())) {
            throw new PlatformException("header not found as the first child of envelope");
        }
        if (this.dialectResolver == null) {
            this.dialect.validateHeader(header);
        }
        if ((body = XmlUtil.getNextSibling((Element)header)) == null || !BODY.equals(body.getNodeName())) {
            throw new PlatformException("body not found as second child of envelope");
        }
        return body;
    }

    private String getMessageProtocolId(Element envelope) throws PlatformException {
        Element header = XmlUtil.getFirstChild((Element)envelope);
        if (header == null || !HEADER.equals(header.getNodeName())) {
            throw new PlatformException("header not found as the first child of envelope");
        }
        Element protoInfo = XmlUtil.getFirstChild((Element)header);
        if (protoInfo == null || !"protocol-info".equals(protoInfo.getNodeName())) {
            return null;
        }
        return protoInfo.getAttribute("protocol-id");
    }

    private Document parseData() throws PlatformException {
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.fixEncoding();
            if (log.isDebug()) {
                String encoding = "UTF-16";
                if (this.buf[this.pos] != 0) {
                    encoding = "UTF-16LE";
                }
                log.debug((Object)("Parsing: " + new String(this.buf, this.pos, this.len, encoding)));
            }
            return docBuilder.parse(new ByteArrayInputStream(this.buf, this.pos, this.len));
        }
        catch (Exception e) {
            throw new PlatformException("Failed to parse xml message", (Throwable)e);
        }
    }

    private void fixEncoding() {
        boolean badTail;
        int lastIndex = this.pos + this.len - 1;
        boolean bl = badTail = this.buf[lastIndex] == 0 && this.buf[lastIndex - 1] == 0;
        if (badTail) {
            this.len -= 2;
        }
    }
}

