/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl.xml;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.connection.PsdkConnectionException;
import com.genesyslab.platform.commons.connection.impl.AbstractConnection;
import com.genesyslab.platform.commons.connection.impl.ConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.InvalidPacketException;
import com.genesyslab.platform.commons.connection.impl.StreamParser;
import com.genesyslab.platform.commons.connection.impl.WritePipe;
import com.genesyslab.platform.commons.connection.impl.WritePoint;
import com.genesyslab.platform.commons.connection.impl.xml.ProtocolDialect;
import com.genesyslab.platform.commons.connection.impl.xml.ProtocolDialectResolver;
import com.genesyslab.platform.commons.connection.impl.xml.XmlMessage;
import com.genesyslab.platform.commons.connection.impl.xml.XmlMessageProducerFactory;
import com.genesyslab.platform.commons.connection.impl.xml.XmlStructureHandler;
import java.io.IOException;
import org.w3c.dom.Element;

public class XmlMessageTransportImpl
implements MessageTransport,
XmlStructureHandler {
    private static final String WRONG_ATTR_MESSAGE = "type of attribute is not supported in xml transport";
    private ConnectionImpl connection;
    private StreamParser streamParser;
    private String targetXmlVersion = null;
    private String stringAttributesEncoding;
    private ProtocolDialect dialect;
    private ProtocolDialectResolver dialectResolver;
    private boolean replaceIllegalUnicodeChars = false;
    private String illegalUnicodeCharsReplacement = null;
    private boolean messageFormattingDisabled;

    public XmlMessageTransportImpl(ProtocolDialect dialect) {
        this(dialect, null);
    }

    public XmlMessageTransportImpl(ProtocolDialectResolver dialectResolver) {
        this(null, null);
        this.dialectResolver = dialectResolver;
    }

    public XmlMessageTransportImpl(ProtocolDialect dialect, String stringAttributesEncoding) {
        this.dialect = dialect;
        this.stringAttributesEncoding = stringAttributesEncoding;
        if (this.stringAttributesEncoding == null) {
            this.stringAttributesEncoding = "UTF-16";
        }
    }

    public void setTargetXmlVersion(String xmlVersion) {
        this.targetXmlVersion = xmlVersion;
    }

    public void setReplaceIllegalUnicodeChars(boolean value) {
        this.replaceIllegalUnicodeChars = value;
    }

    public void setIllegalUnicodeCharsReplacement(String value) {
        this.illegalUnicodeCharsReplacement = value;
    }

    @Override
    public void processData(byte[] b, int offset, int len) throws InvalidPacketException {
        if (this.streamParser == null) {
            throw new PsdkConnectionException("No connection in message transport");
        }
        this.streamParser.processBytes(b, offset, len);
    }

    @Override
    public void setConnection(ConnectionImpl connection) {
        this.connection = connection;
        if (this.stringAttributesEncoding == null) {
            this.stringAttributesEncoding = "UTF-16";
        }
        if (this.connection instanceof AbstractConnection) {
            ((AbstractConnection)((Object)this.connection)).setStringAttributesEncoding(this.stringAttributesEncoding);
        }
        XmlMessageProducerFactory factory = this.dialectResolver != null ? new XmlMessageProducerFactory(this.dialectResolver) : new XmlMessageProducerFactory(this.dialect);
        this.streamParser = new StreamParser(connection, factory);
    }

    @Override
    public Object onNewMessage(Object state, int messageId) throws PlatformException {
        ProtocolDialect msgDialect = null;
        if (this.dialectResolver != null && state != null) {
            msgDialect = this.dialectResolver.resolveMessageDialect(state);
        }
        if (msgDialect == null) {
            msgDialect = this.dialect;
        }
        XmlMessage xmlMessage = new XmlMessage(msgDialect, messageId, this.targetXmlVersion, this.stringAttributesEncoding, this.replaceIllegalUnicodeChars, this.illegalUnicodeCharsReplacement);
        xmlMessage.setFormattingDisabled(this.messageFormattingDisabled);
        return xmlMessage;
    }

    @Override
    public Object onAttribute(Object state, String id, String value) throws PlatformException {
        XmlMessage msg = (XmlMessage)state;
        msg.appendAttribute(id, value);
        return msg;
    }

    @Override
    public Object onAttribute(Object state, String id, byte[] value) throws PlatformException {
        throw new PlatformException(WRONG_ATTR_MESSAGE);
    }

    @Override
    public Object onRawAttribute(Object state, String id, Object value) throws PlatformException {
        throw new PlatformException(WRONG_ATTR_MESSAGE);
    }

    @Override
    public Object onAttribute(Object state, String id, int value) throws PlatformException {
        return this.onAttribute(state, id, String.valueOf(value));
    }

    @Override
    public Object onAttribute(Object state, String id, long value) throws PlatformException {
        return this.onAttribute(state, id, String.valueOf(value));
    }

    @Override
    public Object onMessageEnd(Object state) throws PlatformException {
        XmlMessage message = (XmlMessage)state;
        try {
            WritePipe pipe = this.connection.getWritePipe();
            WritePoint writePoint = pipe.createWritePoint();
            if (writePoint == null) {
                throw new PsdkConnectionException("No WritePoint in connection");
            }
            message.writeTo(writePoint);
            pipe.write(writePoint);
        }
        catch (IOException e) {
            throw new PlatformException("io exception writing message", (Throwable)e);
        }
        return message;
    }

    @Override
    public boolean needsProcessing(Object state, String attributeId, Element complexElement) {
        return false;
    }

    @Override
    public Object onComplexAttribute(Object state, String attributeId, Element elem) {
        XmlMessage message = (XmlMessage)state;
        message.createComplex(attributeId);
        return state;
    }

    @Override
    public Object onComplexEnd(Object state, String attributeId) {
        XmlMessage message = (XmlMessage)state;
        message.closeComplex(attributeId);
        return message;
    }

    public boolean isMessageFormattingDisabled() {
        return this.messageFormattingDisabled;
    }

    public void setMessageFormattingDisabled(boolean messageFormattingDisabled) {
        this.messageFormattingDisabled = messageFormattingDisabled;
    }
}

