/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.resolver;

import com.genesyslab.platform.commons.PsdkCustomization;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.configuration.ConnectionContext;
import com.genesyslab.platform.commons.connection.resolver.SocketAddressResolver;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public class DefaultSocketAddressResolver
implements SocketAddressResolver {
    private static final boolean DEFAULT_ENABLE_IPV6 = false;
    private static final String DEFAULT_IP_VERSION = "4,6";
    private static final ILogger log = Log.getLogger(DefaultSocketAddressResolver.class);
    private static volatile SocketAddressResolver instance = null;

    public static synchronized SocketAddressResolver resolver() {
        if (instance == null) {
            instance = DefaultSocketAddressResolver.createDefaultResolver();
        }
        return instance;
    }

    public static synchronized void setResolver(SocketAddressResolver resolver) {
        if (resolver != null) {
            log.debugFormat("Setting SocketAddressResolver implementation to {0}", (Object)resolver.getClass().getName());
        } else {
            log.debug((Object)"Resetting SocketAddressResolver to the default implementation");
        }
        instance = resolver;
    }

    public static SocketAddressResolver createDefaultResolver() {
        String resClassName = PsdkCustomization.getOption((PsdkCustomization.PsdkOption)PsdkCustomization.PsdkOption.PsdkSocketAddressResolver);
        if (resClassName != null && !resClassName.isEmpty()) {
            try {
                Class<?> resClass = Class.forName(resClassName);
                if (resClass != null && SocketAddressResolver.class.isAssignableFrom(resClass)) {
                    return (SocketAddressResolver)resClass.newInstance();
                }
                if (resClass != null) {
                    log.errorFormat("Custom socket address resolver({0}) does not extend SocketAddressResolver", (Object)resClass.getName());
                }
            }
            catch (Exception ex) {
                log.error((Object)"Failed to instantiate custom SocketAddressResolver", (Throwable)ex);
            }
        }
        try {
            SocketAddressResolver resolver;
            ServiceLoader<SocketAddressResolver> srvLoader = ServiceLoader.load(SocketAddressResolver.class);
            Iterator<SocketAddressResolver> resolvers = srvLoader.iterator();
            if (resolvers != null && resolvers.hasNext() && (resolver = resolvers.next()) != null) {
                if (resolvers.hasNext()) {
                    log.warn((Object)("Got multiple implementations of SocketAddressResolver. Using " + resolver.getClass().getName()));
                } else {
                    log.debug((Object)("SocketAddressResolver implementation in use: " + resolver.getClass().getName()));
                }
                return resolver;
            }
        }
        catch (Exception ex) {
            log.error((Object)"Failed to create custom SocketAddressResolver", (Throwable)ex);
        }
        return new DefaultSocketAddressResolver();
    }

    public static SocketAddressResolver.AddressResolutionRequest createResolutionRequest(String host, int port, ConnectionContext<?> connectionContext) {
        Map resolverParams = null;
        HashMap<String, String> resolverArgs = null;
        if (connectionContext != null) {
            resolverParams = (Map)connectionContext.getAttribute("dns-resolver-params");
            ConnectionConfiguration connectionConfig = connectionContext.configuration();
            resolverArgs = new HashMap<String, String>();
            DefaultSocketAddressResolver.copyCfgArgument("enable-ipv6", connectionConfig, resolverArgs);
            DefaultSocketAddressResolver.copyCfgArgument("ip-version", connectionConfig, resolverArgs);
            DefaultSocketAddressResolver.copyCtxArgument("protocol-sdk", connectionContext, resolverArgs);
            DefaultSocketAddressResolver.copyCtxArgument("protocol-name", connectionContext, resolverArgs);
            DefaultSocketAddressResolver.copyCtxArgument("protocol-server-type", connectionContext, resolverArgs);
        }
        return new AddressResolutionRequestImpl(host, port, resolverParams, resolverArgs);
    }

    private static void copyCfgArgument(String name, ConnectionConfiguration conf, Map<String, String> resolverArgs) {
        String val = conf.getOption(name);
        if (val != null) {
            resolverArgs.put(name, val);
        }
    }

    private static void copyCtxArgument(String name, ConnectionContext<?> connectionContext, Map<String, String> resolverArgs) {
        Object val = connectionContext.getAttribute(name);
        if (val != null) {
            resolverArgs.put(name, val.toString());
        }
    }

    @Override
    public List<InetSocketAddress> resolve(SocketAddressResolver.AddressResolutionRequest request) throws UnknownHostException {
        ArrayList<InetSocketAddress> ret;
        if (request == null) {
            throw new IllegalArgumentException("Null AddressResolutionRequest");
        }
        String ipVersion = request.getArgument("ip-version");
        String enableIP6 = request.getArgument("enable-ipv6");
        boolean ip6Enabled = enableIP6 != null && !enableIP6.isEmpty() ? ("true".equalsIgnoreCase(enableIP6) || "yes".equalsIgnoreCase(enableIP6) || "on".equalsIgnoreCase(enableIP6) || "1".equalsIgnoreCase(enableIP6) ? true : ("false".equalsIgnoreCase(enableIP6) || "no".equalsIgnoreCase(enableIP6) || "off".equalsIgnoreCase(enableIP6) || "0".equalsIgnoreCase(enableIP6) ? false : false)) : false;
        if (ipVersion == null || ipVersion.isEmpty()) {
            ipVersion = DEFAULT_IP_VERSION;
        } else if (!ip6Enabled) {
            log.warn((Object)"IPv6 is not enabled, ip-version value will be ignored");
        }
        boolean preferIPv6 = !DEFAULT_IP_VERSION.equals(ipVersion);
        ArrayList<InetSocketAddress> list1 = new ArrayList<InetSocketAddress>();
        ArrayList<InetSocketAddress> list2 = ip6Enabled ? new ArrayList<InetSocketAddress>() : null;
        this.doResolve(request, list1, list2);
        if (list2 != null && !list2.isEmpty()) {
            if (preferIPv6) {
                list2.addAll(list1);
                ret = list2;
            } else {
                list1.addAll(list2);
                ret = list1;
            }
        } else {
            ret = list1;
        }
        if (ret == null || ret.isEmpty()) {
            throw new UnknownHostException(request.getHost());
        }
        return ret;
    }

    protected void doResolve(SocketAddressResolver.AddressResolutionRequest request, List<InetSocketAddress> outV4, List<InetSocketAddress> outV6) throws UnknownHostException {
        if (outV4 == null && outV6 == null) {
            throw new IllegalArgumentException("Null references for DNS resolution lists");
        }
        InetAddress[] addrs = InetAddress.getAllByName(request.getHost());
        int numV4 = 0;
        int numV6 = 0;
        if (addrs != null) {
            for (InetAddress addr : addrs) {
                if (outV4 != null && addr instanceof Inet4Address) {
                    outV4.add(new InetSocketAddress(addr, request.getPort()));
                    ++numV4;
                }
                if (outV6 == null || !(addr instanceof Inet6Address)) continue;
                outV6.add(new InetSocketAddress(addr, request.getPort()));
                ++numV6;
            }
        }
        if (log.isDebug()) {
            if (numV4 == 0 && numV6 == 0) {
                log.debug((Object)("Got no IP addresses for the remote host \"" + request.getHost() + "\" that are compliant with connection configuration options"));
            } else {
                if (numV4 > 0) {
                    log.debug((Object)("Found " + numV4 + " IPv4 address(es) for host \"" + request.getHost() + "\""));
                }
                if (numV6 > 0) {
                    log.debug((Object)("Found " + numV6 + " IPv6 address(es) for host \"" + request.getHost() + "\""));
                }
            }
        }
    }

    protected static class AddressResolutionRequestImpl
    implements SocketAddressResolver.AddressResolutionRequest {
        private final String host;
        private final int port;
        private final Map<String, Object> resolverParams;
        private final Map<String, String> resolverArgs;

        protected AddressResolutionRequestImpl(String host, int port, Map<String, Object> resolverParams, Map<String, String> resolverArgs) {
            this.host = host;
            this.port = port;
            this.resolverArgs = resolverArgs;
            this.resolverParams = resolverParams;
        }

        @Override
        public String getHost() {
            return this.host;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public String getArgument(String name) {
            return this.resolverArgs != null ? this.resolverArgs.get(name) : null;
        }

        @Override
        public Map<String, Object> getParams() {
            return this.resolverParams;
        }
    }
}

