/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.tls;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;

@Deprecated
public class DNParser {
    public static final String ATTR_CN = "CN";
    public static final String ATTR_OU = "OU";
    public static final String ATTR_O = "O";
    public static final String ATTR_C = "C";
    public static final String ATTR_L = "L";
    public static final String ATTR_ST = "ST";
    public static final String ATTR_STREET = "STREET";
    public static final String ATTR_EMAIL = "EMAILADDRESS";
    public static final String ATTR_UID = "UID";
    private final String dn;
    private final int length;
    private int pos;
    private int beg;
    private int end;
    private int cur;
    private char[] chars;
    private List<AttrTypeAndValue> rdnList = Collections.emptyList();

    public DNParser(X500Principal principal) throws ParseException {
        this.dn = principal.getName("RFC2253");
        this.length = this.dn.length();
        this.parseDN();
    }

    public String findFirstAttrOccurence(String attrType) {
        for (AttrTypeAndValue atv : this.rdnList) {
            if (!atv.getAttrType().equalsIgnoreCase(attrType)) continue;
            return atv.getAttrValue();
        }
        return null;
    }

    public String findLastAttrOccurence(String attrType) {
        for (int i = this.rdnList.size() - 1; i >= 0; --i) {
            AttrTypeAndValue atv = this.rdnList.get(i);
            if (!atv.getAttrType().equalsIgnoreCase(attrType)) continue;
            return atv.getAttrValue();
        }
        return null;
    }

    private void parseDN() throws ParseException {
        this.pos = 0;
        this.beg = 0;
        this.end = 0;
        this.cur = 0;
        this.chars = this.dn.toCharArray();
        ArrayList<AttrTypeAndValue> result = new ArrayList<AttrTypeAndValue>();
        String attrType = this.nextAttrType();
        if (attrType == null) {
            return;
        }
        boolean endReached = false;
        while (!endReached) {
            String attrValue = "";
            if (this.pos == this.length) {
                throw new ParseException("Malformed DN", this.pos);
            }
            switch (this.chars[this.pos]) {
                case '\"': {
                    attrValue = this.quotedAttrValue();
                    break;
                }
                case '#': {
                    attrValue = this.hexAttrValue();
                    break;
                }
                case '+': 
                case ',': 
                case ';': {
                    break;
                }
                default: {
                    attrValue = this.escapedAttrValue();
                }
            }
            result.add(new AttrTypeAndValue(attrType, attrValue));
            if (this.pos >= this.length) {
                endReached = true;
                continue;
            }
            if (this.chars[this.pos] != ',' && this.chars[this.pos] != ';' && this.chars[this.pos] != '+') {
                throw new ParseException("Malformed DN", this.pos);
            }
            ++this.pos;
            attrType = this.nextAttrType();
            if (attrType != null) continue;
            endReached = true;
        }
        this.rdnList = result;
    }

    private String nextAttrType() throws ParseException {
        while (this.pos < this.length && this.chars[this.pos] == ' ') {
            ++this.pos;
        }
        if (this.pos == this.length) {
            return null;
        }
        this.beg = this.pos++;
        while (this.pos < this.length && this.chars[this.pos] != '=' && this.chars[this.pos] != ' ') {
            ++this.pos;
        }
        if (this.pos >= this.length) {
            throw new ParseException("Unexpected end of DN", this.pos);
        }
        this.end = this.pos;
        if (this.chars[this.pos] == ' ') {
            while (this.pos < this.length && this.chars[this.pos] != '=' && this.chars[this.pos] == ' ') {
                ++this.pos;
            }
            if (this.chars[this.pos] != '=' || this.pos == this.length) {
                throw new ParseException("Unexpected end of DN", this.pos);
            }
        }
        ++this.pos;
        while (this.pos < this.length && this.chars[this.pos] == ' ') {
            ++this.pos;
        }
        if (!(this.end - this.beg <= 4 || this.chars[this.beg + 3] != '.' || this.chars[this.beg] != 'O' && this.chars[this.beg] != 'o' || this.chars[this.beg + 1] != 'I' && this.chars[this.beg + 1] != 'i' || this.chars[this.beg + 2] != 'D' && this.chars[this.beg + 2] != 'd')) {
            this.beg += 4;
        }
        return new String(this.chars, this.beg, this.end - this.beg);
    }

    private String quotedAttrValue() throws ParseException {
        ++this.pos;
        this.end = this.beg = this.pos;
        while (true) {
            if (this.pos == this.length) {
                throw new ParseException("Unexpected end of DN", this.pos);
            }
            if (this.chars[this.pos] == '\"') {
                ++this.pos;
                break;
            }
            this.chars[this.end] = this.chars[this.pos] == '\\' ? this.getEscaped() : this.chars[this.pos];
            ++this.pos;
            ++this.end;
        }
        while (this.pos < this.length && this.chars[this.pos] == ' ') {
            ++this.pos;
        }
        return new String(this.chars, this.beg, this.end - this.beg);
    }

    private String hexAttrValue() throws ParseException {
        if (this.pos + 4 >= this.length) {
            throw new ParseException("Encoded byte array must be not less then 4 bytes", this.pos);
        }
        this.beg = this.pos++;
        while (true) {
            if (this.pos == this.length || this.chars[this.pos] == '+' || this.chars[this.pos] == ',' || this.chars[this.pos] == ';') {
                this.end = this.pos;
                break;
            }
            if (this.chars[this.pos] == ' ') {
                this.end = this.pos++;
                while (this.pos < this.length && this.chars[this.pos] == ' ') {
                    ++this.pos;
                }
                break;
            }
            if (this.chars[this.pos] >= 'A' && this.chars[this.pos] <= 'F') {
                int n = this.pos;
                this.chars[n] = (char)(this.chars[n] + 32);
            }
            ++this.pos;
        }
        int hexLen = this.end - this.beg;
        if (hexLen < 5 || (hexLen & 1) == 0) {
            throw new ParseException("Encoded byte array must be not less then 4 bytes and must be even number", this.pos);
        }
        byte[] encoded = new byte[hexLen / 2];
        int p = this.beg + 1;
        for (int i = 0; i < encoded.length; ++i) {
            encoded[i] = (byte)this.getByte(p);
            p += 2;
        }
        return new String(this.chars, this.beg, hexLen);
    }

    private String escapedAttrValue() throws ParseException {
        this.beg = this.pos;
        this.end = this.pos;
        block5: while (this.pos < this.length) {
            switch (this.chars[this.pos]) {
                case '+': 
                case ',': 
                case ';': {
                    return new String(this.chars, this.beg, this.end - this.beg);
                }
                case '\\': {
                    this.chars[this.end++] = this.getEscaped();
                    ++this.pos;
                    continue block5;
                }
                case ' ': {
                    this.cur = this.end;
                    ++this.pos;
                    this.chars[this.end++] = 32;
                    while (this.pos < this.length && this.chars[this.pos] == ' ') {
                        this.chars[this.end++] = 32;
                        ++this.pos;
                    }
                    if (this.pos != this.length && this.chars[this.pos] != ',' && this.chars[this.pos] != '+' && this.chars[this.pos] != ';') continue block5;
                    return new String(this.chars, this.beg, this.cur - this.beg);
                }
            }
            this.chars[this.end++] = this.chars[this.pos];
            ++this.pos;
        }
        return new String(this.chars, this.beg, this.end - this.beg);
    }

    private char getEscaped() throws ParseException {
        ++this.pos;
        if (this.pos == this.length) {
            throw new ParseException("Unexpected end of DN", this.pos);
        }
        switch (this.chars[this.pos]) {
            case ' ': 
            case '\"': 
            case '#': 
            case '%': 
            case '*': 
            case '+': 
            case ',': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '\\': 
            case '_': {
                return this.chars[this.pos];
            }
        }
        return this.getUTF8();
    }

    private char getUTF8() throws ParseException {
        int res = this.getByte(this.pos);
        ++this.pos;
        if (res < 128) {
            return (char)res;
        }
        if (res >= 192 && res <= 247) {
            int count;
            if (res <= 223) {
                count = 1;
                res &= 0x1F;
            } else if (res <= 239) {
                count = 2;
                res &= 0xF;
            } else {
                count = 3;
                res &= 7;
            }
            for (int i = 0; i < count; ++i) {
                ++this.pos;
                if (this.pos == this.length || this.chars[this.pos] != '\\') {
                    return '?';
                }
                ++this.pos;
                int b = this.getByte(this.pos);
                ++this.pos;
                if ((b & 0xC0) != 128) {
                    return '?';
                }
                res = (res << 6) + (b & 0x3F);
            }
            return (char)res;
        }
        return '?';
    }

    private int getByte(int position) throws ParseException {
        if (position + 1 >= this.length) {
            throw new ParseException("Unexpected end of DN", position);
        }
        int b1 = this.chars[position];
        if (b1 >= 48 && b1 <= 57) {
            b1 -= 48;
        } else if (b1 >= 97 && b1 <= 102) {
            b1 -= 87;
        } else if (b1 >= 65 && b1 <= 70) {
            b1 -= 55;
        } else {
            throw new ParseException("Invalid hex value", position);
        }
        int b2 = this.chars[position + 1];
        if (b2 >= 48 && b2 <= 57) {
            b2 -= 48;
        } else if (b2 >= 97 && b2 <= 102) {
            b2 -= 87;
        } else if (b2 >= 65 && b2 <= 70) {
            b2 -= 55;
        } else {
            throw new ParseException("Invalid hex value", position);
        }
        return (b1 << 4) + b2;
    }

    private class AttrTypeAndValue {
        private String attrType;
        private String attrValue;

        private AttrTypeAndValue(String attrType, String attrValue) {
            this.attrType = attrType;
            this.attrValue = attrValue;
        }

        public String getAttrType() {
            return this.attrType;
        }

        public void setAttrType(String attrType) {
            this.attrType = attrType;
        }

        public String getAttrValue() {
            return this.attrValue;
        }

        public void setAttrValue(String attrValue) {
            this.attrValue = attrValue;
        }
    }
}

