/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.tls;

import com.genesyslab.platform.commons.PsdkCustomization;
import com.genesyslab.platform.commons.connection.tls.SSLExtendedOptions;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class SSLContextHelper {
    private static final ILogger log = Log.getLogger(SSLContextHelper.class);
    private static final String DEFAULT_VERSION = PsdkCustomization.getOption((PsdkCustomization.PsdkOption)PsdkCustomization.PsdkOption.PsdkTlsDefaultVersion, null, (String)"TLS");

    public static SSLContext createSSLContext(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom, String tlsVersion) throws GeneralSecurityException {
        if (tlsVersion == null) {
            tlsVersion = DEFAULT_VERSION;
        }
        SSLContext sslContext = SSLContext.getInstance(tlsVersion);
        if (log.isDebug()) {
            log.debug((Object)(sslContext.getProtocol() + "  is used"));
        }
        sslContext.init(keyManagers, trustManagers, secureRandom);
        return sslContext;
    }

    public static SSLContext createSSLContext(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom) throws GeneralSecurityException {
        return SSLContextHelper.createSSLContext(keyManagers, trustManagers, secureRandom, null);
    }

    public static SSLContext createSSLContext(KeyManager keyManager, TrustManager trustManager) throws GeneralSecurityException {
        return SSLContextHelper.createSSLContext(new KeyManager[]{keyManager}, new TrustManager[]{trustManager}, null, null);
    }

    public static SSLExtendedOptions createSSLExtendedOptions(boolean mutualTLS, String[] enabledCipherSuites) {
        return new SSLExtendedOptions(mutualTLS, enabledCipherSuites);
    }

    public static SSLExtendedOptions createSSLExtendedOptions(boolean mutualTLS, String[] enabledCipherSuites, String[] enabledProtocols) {
        return new SSLExtendedOptions(mutualTLS, enabledCipherSuites, enabledProtocols);
    }

    public static SSLExtendedOptions createSSLExtendedOptions(boolean mutualTLS, String enabledCipherSuites) {
        return new SSLExtendedOptions(mutualTLS, enabledCipherSuites);
    }

    public static SSLExtendedOptions createSSLExtendedOptions(boolean mutualTLS, String enabledCipherSuites, String enabledProtocols) {
        return new SSLExtendedOptions(mutualTLS, enabledCipherSuites, enabledProtocols);
    }
}

