/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.tls;

import com.genesyslab.platform.commons.connection.tls.SSLExtendedOptions;
import com.genesyslab.platform.commons.connection.tls.TLSConfigurationHelper;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;

public class TLSConfiguration
implements Cloneable {
    private static final Map<String, String> SecProtocol2ProtocolVersion = new HashMap<String, String>(){
        {
            this.put("SSLv23", TLSConfiguration.SSL_VERSION_3);
            this.put(TLSConfiguration.SSL_VERSION_3, TLSConfiguration.SSL_VERSION_3);
            this.put(TLSConfiguration.TLS_VERSION_1, TLSConfiguration.TLS_VERSION_1);
            this.put("TLSv11", TLSConfiguration.TLS_VERSION_1_1);
            this.put("TLSv12", TLSConfiguration.TLS_VERSION_1_2);
        }
    };
    private static final Map<String, String> SecProtocol2EnabledProtocols = new HashMap<String, String>(){
        {
            this.put("SSLv23", "SSLv3 SSLv2Hello");
            this.put(TLSConfiguration.SSL_VERSION_3, TLSConfiguration.SSL_VERSION_3);
            this.put(TLSConfiguration.TLS_VERSION_1, TLSConfiguration.TLS_VERSION_1);
            this.put("TLSv11", TLSConfiguration.TLS_VERSION_1_1);
            this.put("TLSv12", TLSConfiguration.TLS_VERSION_1_2);
        }
    };
    private static final Map<String, String> EnabledProtocols2SecProtocol = new HashMap<String, String>(){
        {
            for (Map.Entry e : SecProtocol2EnabledProtocols.entrySet()) {
                this.put(e.getValue(), e.getKey());
            }
            this.put("SSLv2Hello SSLv3", "SSLv23");
        }
    };
    public static final String TLS_VERSION_DEFAULT = "TLS";
    public static final String TLS_VERSION_1 = "TLSv1";
    public static final String TLS_VERSION_1_1 = "TLSv1.1";
    public static final String TLS_VERSION_1_2 = "TLSv1.2";
    public static final String SSL_VERSION_3 = "SSLv3";
    public static final String SSL_VERSION_2_HELLO = "SSLv2Hello";
    public static final String SSL_VERSION_DEFAULT = "SSL";
    public static final String TLS_PROVIDER_PEM_FILE = "PEM";
    public static final String TLS_PROVIDER_PKCS11 = "PKCS11";
    public static final String TLS_PROVIDER_MSCAPI = "MSCAPI";
    public static final String TLS_PROVIDER_JKS = "JKS";
    private boolean tlsEnabled;
    private String provider;
    private String certificate;
    private String certificateKey;
    private String trustedCaCertificate;
    private boolean mutual;
    private String crl;
    private boolean targetNameCheckEnabled;
    private String cipherList;
    private String enabledProtocolList;
    private boolean fips140Enabled;
    private CallbackHandler keyStoreCallbackHandler;
    private CallbackHandler trustStoreCallbackHandler;
    private String expectedHostname;
    private boolean clientMode;
    private String protocol;
    private CallbackHandler keyStoreEntryCallbackHandler;

    public static String sec2EnabledProtocols(String secProtocol) {
        return SecProtocol2EnabledProtocols.get(secProtocol);
    }

    public static String sec2Version(String secProtocol) {
        return SecProtocol2ProtocolVersion.get(secProtocol);
    }

    public static String enabledProtocols2sec(String enabledProtocols) {
        return EnabledProtocols2SecProtocol.get(enabledProtocols);
    }

    public SSLContext createSslContext() {
        return TLSConfigurationHelper.createSslContext(this);
    }

    public SSLExtendedOptions createSslExtendedOptions() {
        return TLSConfigurationHelper.createSslExtendedOptions(this);
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public void setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public String getCertificateKey() {
        return this.certificateKey;
    }

    public void setCertificateKey(String certificateKey) {
        this.certificateKey = certificateKey;
    }

    public String getTrustedCaCertificate() {
        return this.trustedCaCertificate;
    }

    public void setTrustedCaCertificate(String trustedCaCertificate) {
        this.trustedCaCertificate = trustedCaCertificate;
    }

    public boolean isMutual() {
        return this.mutual;
    }

    public void setMutual(boolean mutual) {
        this.mutual = mutual;
    }

    public String getCrl() {
        return this.crl;
    }

    public void setCrl(String crl) {
        this.crl = crl;
    }

    public boolean isTargetNameCheckEnabled() {
        return this.targetNameCheckEnabled;
    }

    public void setTargetNameCheckEnabled(boolean targetNameCheckEnabled) {
        this.targetNameCheckEnabled = targetNameCheckEnabled;
    }

    public String getCipherList() {
        return this.cipherList;
    }

    public void setCipherList(String cipherList) {
        this.cipherList = cipherList;
    }

    public boolean isFips140Enabled() {
        return this.fips140Enabled;
    }

    public void setFips140Enabled(boolean fips140Enabled) {
        this.fips140Enabled = fips140Enabled;
    }

    public CallbackHandler getKeyStoreCallbackHandler() {
        return this.keyStoreCallbackHandler;
    }

    public void setKeyStoreCallbackHandler(CallbackHandler keyStoreCallbackHandler) {
        this.keyStoreCallbackHandler = keyStoreCallbackHandler;
    }

    public CallbackHandler getTrustStoreCallbackHandler() {
        return this.trustStoreCallbackHandler;
    }

    public void setTrustStoreCallbackHandler(CallbackHandler trustStoreCallbackHandler) {
        this.trustStoreCallbackHandler = trustStoreCallbackHandler;
    }

    public String getExpectedHostname() {
        return this.expectedHostname;
    }

    public void setExpectedHostname(String expectedHostname) {
        this.expectedHostname = expectedHostname;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public void setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public String getVersion() {
        return this.protocol;
    }

    public void setVersion(String protocol) {
        this.protocol = protocol;
    }

    public String getEnabledProtocols() {
        return this.enabledProtocolList;
    }

    public void setEnabledProtocols(String enabledProtocolList) {
        this.enabledProtocolList = enabledProtocolList;
    }

    public void setEnabledProtocols(String ... enabledProtocolList) {
        if (enabledProtocolList == null || enabledProtocolList.length == 0) {
            this.setEnabledProtocols((String)null);
        } else {
            StringBuilder sb = new StringBuilder(1024);
            for (String s : enabledProtocolList) {
                sb.append(s);
                sb.append(' ');
            }
            sb.setLength(sb.length() - 1);
            this.setEnabledProtocols(sb.toString());
        }
    }

    public String getSecProtocol() {
        String version;
        String secProtocol = EnabledProtocols2SecProtocol.get(this.getEnabledProtocols());
        if (secProtocol != null && (version = this.getVersion()) != null && version.equals(SecProtocol2ProtocolVersion.get(secProtocol))) {
            return secProtocol;
        }
        return null;
    }

    public void setSecProtocol(String value) {
        if (TLS_VERSION_1_2.equals(value)) {
            value = "TLSv12";
        } else if (TLS_VERSION_1_1.equals(value)) {
            value = "TLSv11";
        }
        String ver = null;
        String protocols = null;
        if (value != null) {
            ver = SecProtocol2ProtocolVersion.get(value);
            protocols = SecProtocol2EnabledProtocols.get(value);
        }
        if (value != null && (ver == null || protocols == null)) {
            throw new IllegalArgumentException("Invalid sec-protocol value: " + value, null);
        }
        this.setVersion(ver);
        this.setEnabledProtocols(protocols);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public CallbackHandler getKeyStoreEntryCallbackHandler() {
        return this.keyStoreEntryCallbackHandler;
    }

    public void setKeyStoreEntryCallbackHandler(CallbackHandler keyStoreEntryCallbackHandler) {
        this.keyStoreEntryCallbackHandler = keyStoreEntryCallbackHandler;
    }
}

