/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.tls;

import com.genesyslab.platform.commons.connection.tls.DummyPasswordCallbackHandler;
import com.genesyslab.platform.commons.connection.tls.HostnameCheckingTrustManager;
import com.genesyslab.platform.commons.connection.tls.KeyManagerHelper;
import com.genesyslab.platform.commons.connection.tls.SSLContextHelper;
import com.genesyslab.platform.commons.connection.tls.SSLExtendedOptions;
import com.genesyslab.platform.commons.connection.tls.TLSConfiguration;
import com.genesyslab.platform.commons.connection.tls.ThumbprintUtils;
import com.genesyslab.platform.commons.connection.tls.TrustManagerHelper;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.io.File;
import java.security.GeneralSecurityException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;

public class TLSConfigurationHelper {
    public static final char[] DEFAULT_PASSWORD = new char[0];
    private static final ILogger log = Log.getLogger(TLSConfigurationHelper.class);
    private static final String WARN_ONLY_ENCRYPTION_BANNER = "\n***\nSSL CONTEXT HAS BEEN CREATED ONLY FOR ENCRYPTION; NO TLS AUTHENTICATION OR CERTIFICATE VALIDATION WILL BE PERFORMED.\n***";
    private static final String WARN_NO_TRUST_CA = "\n***\nSSL CONTEXT HAS BEEN CREATED WITHOUT TRUSTED CA; NO CERTIFICATE VALIDATION WILL BE PERFORMED.\n***";
    private static final String WARN_NO_CRL = "\n***\nSSL CONTEXT HAS BEEN CREATED WITHOUT CERTIFICATE REVOCATION LIST (CRL) FILE PATH CONFIGURING. THUS CERTIFICATE REVOCATION WILL NOT BE PERFORMED.\n***";
    private static final String WARN_NO_TARGET_NAME_CHECK = "\n***\nSSL CONTEXT HAS BEEN CREATED WITHOUT TARGET NAME CHECK CONFIGURING. THUS CERTIFICATE SUBJECT VALIDATION WILL NOT BE PERFORMED.\n***";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static SSLContext createSslContext(TLSConfiguration config) throws SecurityException {
        if (null == config) {
            throw new SecurityException("config must not be null");
        }
        prov = TLSConfigurationHelper.detectProvider(config);
        if (null == prov) {
            throw new SecurityException("Could not detect security provider type: TLS parameters are inconclusive or ambiguous");
        }
        TLSConfigurationHelper.validateTlsConfiguration(config, prov);
        isClient = config.isClientMode();
        noCertificate = true;
        km = null;
        try {
            cert = config.getCertificate();
            noCertificate = cert == null || cert.length() == 0;
            switch (1.$SwitchMap$com$genesyslab$platform$commons$connection$tls$TLSConfigurationHelper$ProviderType[prov.ordinal()]) {
                case 1: {
                    if (noCertificate) {
                        km = KeyManagerHelper.createEmptyKeyManager();
                        break;
                    }
                    km = KeyManagerHelper.createPEMKeyManager(cert, config.getCertificateKey());
                    break;
                }
                case 2: {
                    if (isClient && noCertificate) {
                        km = KeyManagerHelper.createEmptyKeyManager();
                        break;
                    }
                    km = KeyManagerHelper.createMSCAPIKeyManager(config.getKeyStoreCallbackHandler(), cert);
                    break;
                }
                case 3: {
                    km = KeyManagerHelper.createPKCS11KeyManager(config.getKeyStoreCallbackHandler());
                    break;
                }
                case 4: {
                    km = KeyManagerHelper.createEmptyKeyManager();
                    break;
                }
                case 5: {
                    if (noCertificate) {
                        km = KeyManagerHelper.createEmptyKeyManager();
                        break;
                    }
                    pwKeyStore = null;
                    pwKeyStoreEntry = null;
                    try {
                        keyStoreCallbackHandler = config.getKeyStoreCallbackHandler();
                        pwKeyStore = TLSConfigurationHelper.pickPw(keyStoreCallbackHandler, "KeyStore password");
                        keyStoreEntryCallbackHandler = config.getKeyStoreEntryCallbackHandler();
                        pwKeyStoreEntry = keyStoreEntryCallbackHandler != null ? TLSConfigurationHelper.pickPw(keyStoreEntryCallbackHandler, "KeyStoreEntry password") : TLSConfigurationHelper.pickPw(keyStoreCallbackHandler, "KeyStoreEntry password");
                        km = KeyManagerHelper.createJKSKeyManager(cert, pwKeyStore, pwKeyStoreEntry);
                        if (pwKeyStore == null) ** GOTO lbl48
                    }
                    catch (Throwable var10_16) {
                        if (pwKeyStore != null) {
                            for (i = pwKeyStore.length - 1; i >= 0; --i) {
                                pwKeyStore[i] = '\u0000';
                            }
                        }
                        if (pwKeyStoreEntry != null) {
                            for (i = pwKeyStoreEntry.length - 1; i >= 0; --i) {
                                pwKeyStoreEntry[i] = '\u0000';
                            }
                        }
                        throw var10_16;
                    }
                    for (i = pwKeyStore.length - 1; i >= 0; --i) {
                        pwKeyStore[i] = '\u0000';
                    }
lbl48:
                    // 2 sources

                    if (pwKeyStoreEntry == null) break;
                    for (i = pwKeyStoreEntry.length - 1; i >= 0; --i) {
                        pwKeyStoreEntry[i] = '\u0000';
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new SecurityException("Could not create key manager based on TLS parameters", e);
        }
        tm = null;
        try {
            hostName = config.isTargetNameCheckEnabled() != false ? config.getExpectedHostname() : null;
            trustCA = config.getTrustedCaCertificate();
            noTrustCA = trustCA == null || trustCA.length() == 0;
            switch (1.$SwitchMap$com$genesyslab$platform$commons$connection$tls$TLSConfigurationHelper$ProviderType[prov.ordinal()]) {
                case 1: {
                    if (noTrustCA) {
                        tm = TrustManagerHelper.createTrustEveryoneTrustManager();
                        if (hostName == null || hostName.length() <= 0) break;
                        tm = new HostnameCheckingTrustManager(hostName, tm);
                        break;
                    }
                    tm = TrustManagerHelper.createPEMTrustManager(trustCA, config.getCrl(), hostName);
                    break;
                }
                case 2: {
                    tm = TrustManagerHelper.createMSCAPITrustManager(config.getTrustStoreCallbackHandler(), config.getCrl(), hostName);
                    break;
                }
                case 3: {
                    tm = TrustManagerHelper.createPKCS11TrustManager(config.getTrustStoreCallbackHandler(), config.getCrl());
                    break;
                }
                case 4: {
                    tm = TrustManagerHelper.createTrustEveryoneTrustManager();
                    if (hostName == null || hostName.length() <= 0) break;
                    tm = new HostnameCheckingTrustManager(hostName, tm);
                    break;
                }
                case 5: {
                    if (noTrustCA) {
                        tm = TrustManagerHelper.createTrustEveryoneTrustManager();
                        if (hostName == null || hostName.length() <= 0) break;
                        tm = new HostnameCheckingTrustManager(hostName, tm);
                        break;
                    }
                    pw = null;
                    try {
                        pw = TLSConfigurationHelper.pickPw(config.getTrustStoreCallbackHandler(), "TrustStore password");
                        tm = TrustManagerHelper.createJKSTrustManager(trustCA, pw, config.getCrl(), hostName);
                        if (pw == null) break;
                    }
                    catch (Throwable var12_19) {
                        if (pw != null) {
                            for (i = pw.length - 1; i >= 0; --i) {
                                pw[i] = '\u0000';
                            }
                        }
                        throw var12_19;
                    }
                    for (i = pw.length - 1; i >= 0; --i) {
                        pw[i] = '\u0000';
                    }
                    break;
                }
            }
            if (TLSConfigurationHelper.log.isWarn()) {
                switch (1.$SwitchMap$com$genesyslab$platform$commons$connection$tls$TLSConfigurationHelper$ProviderType[prov.ordinal()]) {
                    case 4: {
                        TLSConfigurationHelper.log.warn((Object)"\n***\nSSL CONTEXT HAS BEEN CREATED ONLY FOR ENCRYPTION; NO TLS AUTHENTICATION OR CERTIFICATE VALIDATION WILL BE PERFORMED.\n***");
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 5: {
                        if (!noTrustCA || !noCertificate) break;
                        TLSConfigurationHelper.log.warn((Object)"\n***\nSSL CONTEXT HAS BEEN CREATED ONLY FOR ENCRYPTION; NO TLS AUTHENTICATION OR CERTIFICATE VALIDATION WILL BE PERFORMED.\n***");
                    }
                }
                switch (1.$SwitchMap$com$genesyslab$platform$commons$connection$tls$TLSConfigurationHelper$ProviderType[prov.ordinal()]) {
                    case 1: 
                    case 5: {
                        if (!noTrustCA || noCertificate || !config.isClientMode() && !config.isMutual()) break;
                        TLSConfigurationHelper.log.warn((Object)"\n***\nSSL CONTEXT HAS BEEN CREATED WITHOUT TRUSTED CA; NO CERTIFICATE VALIDATION WILL BE PERFORMED.\n***");
                    }
                }
                switch (1.$SwitchMap$com$genesyslab$platform$commons$connection$tls$TLSConfigurationHelper$ProviderType[prov.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 5: {
                        if (config.getCrl() != null && config.getCrl().length() != 0 || !config.isClientMode() && !config.isMutual()) break;
                        TLSConfigurationHelper.log.warn((Object)"\n***\nSSL CONTEXT HAS BEEN CREATED WITHOUT CERTIFICATE REVOCATION LIST (CRL) FILE PATH CONFIGURING. THUS CERTIFICATE REVOCATION WILL NOT BE PERFORMED.\n***");
                    }
                }
                if (config.isClientMode() && (!config.isTargetNameCheckEnabled() || config.getExpectedHostname() == null || config.getExpectedHostname().length() == 0)) {
                    TLSConfigurationHelper.log.warn((Object)"\n***\nSSL CONTEXT HAS BEEN CREATED WITHOUT TARGET NAME CHECK CONFIGURING. THUS CERTIFICATE SUBJECT VALIDATION WILL NOT BE PERFORMED.\n***");
                }
            }
        }
        catch (Exception e) {
            throw new SecurityException("Could not create trust manager based on TLS parameters", e);
        }
        try {
            sslContext = SSLContextHelper.createSSLContext(new KeyManager[]{km}, new TrustManager[]{tm}, null, config.getVersion());
        }
        catch (GeneralSecurityException e) {
            throw new SecurityException("Could not create SSLContext based on TLS parameters", e);
        }
        return sslContext;
    }

    private static char[] pickPw(CallbackHandler callbackHandler, String title) {
        block4: {
            if (callbackHandler != null) {
                try {
                    PasswordCallback p = new PasswordCallback(title, false);
                    callbackHandler.handle(new Callback[]{p});
                    char[] password = p.getPassword();
                    if (password != null) {
                        password = (char[])password.clone();
                        p.clearPassword();
                        return password;
                    }
                }
                catch (Exception e) {
                    if (!log.isError()) break block4;
                    log.error((Object)e);
                }
            }
        }
        return null;
    }

    public static SSLExtendedOptions createSslExtendedOptions(TLSConfiguration config) {
        return new SSLExtendedOptions(config.isMutual(), config.getCipherList(), config.getEnabledProtocols());
    }

    static ProviderType detectProvider(TLSConfiguration config) {
        boolean hasTrustedCaCertificate;
        boolean hasCertificate;
        log.debug((Object)"Detecting TLS security provider type...");
        if (null == config) {
            throw new IllegalArgumentException("config must not be null");
        }
        if (null != config.getProvider()) {
            if ("PEM".equalsIgnoreCase(config.getProvider())) {
                log.debug((Object)"Security provider is explicitly set to PEM.");
                return ProviderType.PEM_FILE;
            }
            if ("MSCAPI".equalsIgnoreCase(config.getProvider())) {
                log.debug((Object)"Security provider is explicitly set to MSCAPI.");
                return ProviderType.MSCAPI;
            }
            if ("PKCS11".equalsIgnoreCase(config.getProvider())) {
                log.debug((Object)"Security provider is explicitly set to PKCS11.");
                return ProviderType.PKCS11;
            }
            if ("JKS".equalsIgnoreCase(config.getProvider())) {
                log.debug((Object)"Security provider is explicitly set to JKS.");
                return ProviderType.JKS_FILE;
            }
            log.error((Object)("Security provider is set explicitly to " + config.getProvider() + ", but this type is not supported."));
            return null;
        }
        if (config.isFips140Enabled()) {
            log.debug((Object)"FIPS140 is enabled, implying PKCS11 provider.");
            return ProviderType.PKCS11;
        }
        String cert = config.getCertificate();
        boolean bl = hasCertificate = null != cert;
        if (hasCertificate) {
            if (ThumbprintUtils.isThumbprint(cert)) {
                log.debug((Object)"Certificate value is a valid thumbprint, implying MSCAPI provider.");
                return ProviderType.MSCAPI;
            }
            log.debug((Object)"Certificate value is not a valid thumbprint.");
            if (TLSConfigurationHelper.isExistingFile(cert)) {
                String certLo = cert.toLowerCase();
                if (certLo.endsWith(".jks")) {
                    log.debug((Object)"Certificate value is a valid file path, implying JKS provider.");
                    return ProviderType.JKS_FILE;
                }
                log.debug((Object)"Certificate value is a valid file path, implying PEM provider.");
                return ProviderType.PEM_FILE;
            }
            log.debug((Object)"Certificate value is not a path to an existing file.");
        } else {
            log.debug((Object)"Certificate value is null.");
        }
        String trustCA = config.getTrustedCaCertificate();
        boolean bl2 = hasTrustedCaCertificate = null != trustCA;
        if (hasTrustedCaCertificate) {
            if (ThumbprintUtils.isThumbprint(trustCA)) {
                log.debug((Object)"Trusted CA value is a valid thumbprint, implying MSCAPI provider.");
                return ProviderType.MSCAPI;
            }
            log.debug((Object)"Trusted CA value value is not a valid thumbprint.");
            if (TLSConfigurationHelper.isExistingFile(trustCA)) {
                String trustCALo = trustCA.toLowerCase();
                if (trustCALo.endsWith(".jks")) {
                    log.debug((Object)"Trusted CA value is a valid file path, implying JKS provider.");
                    return ProviderType.JKS_FILE;
                }
                log.debug((Object)"Trusted CA value is a valid file path, implying PEM provider.");
                return ProviderType.PEM_FILE;
            }
            log.debug((Object)"Trusted CA value is not a path to an existing file.");
        } else {
            log.debug((Object)"Trusted CA value is null.");
        }
        log.debug((Object)"Could not detect security provider.");
        return config.isTlsEnabled() && !hasCertificate && !hasTrustedCaCertificate ? ProviderType.ENCRYPTION_ONLY : null;
    }

    private static void validateTlsConfiguration(TLSConfiguration config, ProviderType providerType) throws SecurityException {
        if (null == config) {
            throw new IllegalArgumentException("config must not be null");
        }
        if (null == providerType) {
            throw new IllegalArgumentException("providerType must not be null");
        }
        switch (providerType) {
            case PEM_FILE: {
                TLSConfigurationHelper.validatePemConfiguration(config);
                break;
            }
            case MSCAPI: {
                TLSConfigurationHelper.validateMscapiConfiguration(config);
                break;
            }
            case PKCS11: {
                TLSConfigurationHelper.validatePkcs11Configuration(config);
                break;
            }
            case JKS_FILE: {
                TLSConfigurationHelper.validateJksConfiguration(config);
            }
        }
    }

    private static void validatePemConfiguration(TLSConfiguration config) throws SecurityException {
        boolean hasCertificate;
        log.debug((Object)"Validating PEM provider parameters...");
        String certificate = config.getCertificate();
        boolean bl = hasCertificate = certificate != null && certificate.length() > 0;
        if (config.isClientMode()) {
            if (!TLSConfigurationHelper.isExistingFile(config.getTrustedCaCertificate())) {
                throw new SecurityException("Could not find trusted CA certificate file by specified path. It is required for client application.");
            }
            if (hasCertificate) {
                if (!TLSConfigurationHelper.isExistingFile(certificate)) {
                    throw new SecurityException("Could not find certificate file by specified path. It is required for client application in TLS mutual mode.");
                }
                if (!TLSConfigurationHelper.isExistingFile(config.getCertificateKey())) {
                    throw new SecurityException("Could not find private key file by specified path. It is required for client application in TLS mutual mode.");
                }
            }
        } else {
            if (!TLSConfigurationHelper.isExistingFile(certificate)) {
                throw new SecurityException("Could not find certificate file by specified path. It is required for server application.");
            }
            if (!TLSConfigurationHelper.isExistingFile(config.getCertificateKey())) {
                throw new SecurityException("Could not find private key file by specified path. It is required for server application.");
            }
        }
        if (null != config.getCrl() && config.getCrl().length() > 0 && !TLSConfigurationHelper.isExistingFile(config.getCrl())) {
            throw new SecurityException("Could not find CRL file by specified path.");
        }
        if (config.isFips140Enabled()) {
            throw new SecurityException("fips140 configuration flag must be disabled for PEM file-based security provider");
        }
        log.debug((Object)"PEM provider parameters seem to be valid.");
    }

    private static void validateMscapiConfiguration(TLSConfiguration config) throws SecurityException {
        boolean hasCertificate;
        log.debug((Object)"Validating MSCAPI provider parameters...");
        if (null == config.getKeyStoreCallbackHandler()) {
            log.debug((Object)"Key store callback handler is null, using dummy instead...");
            config.setKeyStoreCallbackHandler(new DummyPasswordCallbackHandler());
        }
        if (null == config.getTrustStoreCallbackHandler()) {
            log.debug((Object)"Trust store callback handler is null, using dummy instead...");
            config.setTrustStoreCallbackHandler(new DummyPasswordCallbackHandler());
        }
        boolean bl = hasCertificate = config.getCertificate() != null && config.getCertificate().length() > 0;
        if (hasCertificate) {
            if (!ThumbprintUtils.isThumbprint(config.getCertificate())) {
                log.debug((Object)"Certificate value is not a valid thumbprint.");
                throw new SecurityException("Certificate value is not a valid thumbprint.");
            }
        } else if (!config.isClientMode()) {
            log.debug((Object)"Certificate thumbprint isn't assigned in server configuration.");
            throw new SecurityException("Certificate thumbprint isn't assigned in server configuration.");
        }
        if (null != config.getCrl() && !TLSConfigurationHelper.isExistingFile(config.getCrl())) {
            throw new SecurityException("Could not find CRL file by specified path.");
        }
        if (config.isFips140Enabled()) {
            throw new SecurityException("fips140 configuration flag must be disabled for MSCAPI security provider");
        }
        log.debug((Object)"MSCAPI provider parameters seem to be valid.");
    }

    private static void validatePkcs11Configuration(TLSConfiguration config) throws SecurityException {
        log.debug((Object)"Validating PKCS11 provider parameters...");
        if (null == config.getKeyStoreCallbackHandler()) {
            throw new SecurityException("Key store callback handler must be set for PKCS11 security provider.");
        }
        if (null == config.getTrustStoreCallbackHandler()) {
            throw new SecurityException("Trust store callback handler must be set for PKCS11 security provider.");
        }
        if (null != config.getCrl() && !TLSConfigurationHelper.isExistingFile(config.getCrl())) {
            throw new SecurityException("Could not find CRL file by specified path.");
        }
        if (!config.isFips140Enabled()) {
            throw new SecurityException("fips140 configuration flag must be enabled for PKCS11 security provider.");
        }
        if (config.isTargetNameCheckEnabled()) {
            throw new SecurityException("Target name check flag is not supported for PKCS11 security provider.");
        }
        log.debug((Object)"PKCS11 provider parameters seem to be valid.");
    }

    private static void validateJksConfiguration(TLSConfiguration config) throws SecurityException {
        boolean hasTrustedCaCertificate;
        boolean hasCertificateKey;
        log.debug((Object)"Validating JKS provider parameters...");
        String certificate = config.getCertificate();
        boolean hasCertificate = certificate != null && certificate.trim().length() > 0;
        String certificateKey = config.getCertificateKey();
        boolean bl = hasCertificateKey = certificateKey != null && certificateKey.trim().length() > 0;
        if (hasCertificateKey) {
            throw new SecurityException("Certificate key option is not supported for JKS security provider.");
        }
        String trustedCaCertificate = config.getTrustedCaCertificate();
        boolean bl2 = hasTrustedCaCertificate = trustedCaCertificate != null && trustedCaCertificate.trim().length() > 0;
        if (config.isClientMode()) {
            if (!TLSConfigurationHelper.isExistingFile(trustedCaCertificate)) {
                throw new SecurityException("Could not find trusted CA certificate file by specified path. It is required for client application.");
            }
            if (hasCertificate && !TLSConfigurationHelper.isExistingFile(config.getCertificate())) {
                throw new SecurityException("Could not find JKS file by specified path. It is required for client application in TLS mutual mode.");
            }
        } else {
            if (config.isMutual() && !TLSConfigurationHelper.isExistingFile(trustedCaCertificate)) {
                throw new SecurityException("Could not find trusted CA certificate file by specified path. It is required for server application in mutual mode.");
            }
            if (!TLSConfigurationHelper.isExistingFile(certificate)) {
                throw new SecurityException("Could not find JKS file by specified path. It is required for server application.");
            }
        }
        if (null != config.getCrl() && !TLSConfigurationHelper.isExistingFile(config.getCrl())) {
            throw new SecurityException("Could not find CRL file by specified path.");
        }
        if (config.isFips140Enabled()) {
            throw new SecurityException("fips140 configuration flag must be disabled for JKS security provider");
        }
        log.debug((Object)"JKS provider parameters seem to be valid.");
    }

    static boolean isExistingFile(String s) {
        if (null == s || s.length() == 0) {
            log.debug((Object)"File path is null or empty");
            return false;
        }
        File target = new File(s);
        log.debug((Object)("Resolving file \"" + s + "\", absolute path: " + target.getAbsolutePath()));
        if (target.exists()) {
            log.debug((Object)("File \"" + s + "\" is found."));
            return true;
        }
        log.debug((Object)("Could not find file \"" + target.getAbsolutePath() + "\"."));
        return false;
    }

    private static enum ProviderType {
        PEM_FILE,
        MSCAPI,
        PKCS11,
        ENCRYPTION_ONLY,
        JKS_FILE;

    }
}

