/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.tls;

import com.genesyslab.platform.commons.collections.KVList;
import com.genesyslab.platform.commons.connection.tls.ConfigUtils;
import com.genesyslab.platform.commons.connection.tls.KVListPropertyReader;
import com.genesyslab.platform.commons.connection.tls.MapPropertyReader;
import com.genesyslab.platform.commons.connection.tls.PropertiesReader;
import com.genesyslab.platform.commons.connection.tls.PropertyReader;
import com.genesyslab.platform.commons.connection.tls.TLSConfiguration;
import com.genesyslab.platform.commons.connection.tls.TransportParamsPropertyReader;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.util.Map;
import java.util.Properties;

public class TLSConfigurationParser {
    private static final ILogger log = Log.getLogger(TLSConfigurationParser.class);
    private static final String TARGET_CHECK_HOST = "host";
    private static final String KEY_TARGET_SERVER_HOST = "psdk-internal-target-server-host";

    public static TLSConfiguration parseServerTlsConfiguration(KVList kvl) {
        return TLSConfigurationParser.parseTlsConfiguration(new KVListPropertyReader(kvl), false);
    }

    public static TLSConfiguration parseClientTlsConfiguration(KVList kvl) {
        return TLSConfigurationParser.parseTlsConfiguration(new KVListPropertyReader(kvl), true);
    }

    public static TLSConfiguration parseServerTlsConfiguration(Map<String, String> map) {
        return TLSConfigurationParser.parseTlsConfiguration(new MapPropertyReader(map), false);
    }

    public static TLSConfiguration parseClientTlsConfiguration(Map<String, String> map) {
        return TLSConfigurationParser.parseTlsConfiguration(new MapPropertyReader(map), true);
    }

    public static TLSConfiguration parseServerTlsConfiguration(Properties prop) {
        return TLSConfigurationParser.parseTlsConfiguration(new PropertiesReader(prop), false);
    }

    public static TLSConfiguration parseClientTlsConfiguration(Properties prop) {
        return TLSConfigurationParser.parseTlsConfiguration(new PropertiesReader(prop), true);
    }

    public static TLSConfiguration parseServerTlsConfiguration(String transportParams) {
        return TLSConfigurationParser.parseTlsConfiguration(new TransportParamsPropertyReader(transportParams), false);
    }

    public static TLSConfiguration parseClientTlsConfiguration(String transportParams) {
        return TLSConfigurationParser.parseTlsConfiguration(new TransportParamsPropertyReader(transportParams), true);
    }

    public static TLSConfiguration parseTlsConfiguration(PropertyReader prop, boolean clientMode) {
        if (null == prop) {
            throw new IllegalArgumentException("prop must not be null");
        }
        TLSConfiguration config = new TLSConfiguration();
        config.setClientMode(clientMode);
        config.setTlsEnabled(ConfigUtils.isTrue(prop.getProperty("tls")));
        config.setProvider(prop.getProperty("provider"));
        config.setCertificate(prop.getProperty("certificate"));
        config.setCertificateKey(prop.getProperty("certificate-key"));
        config.setTrustedCaCertificate(prop.getProperty("trusted-ca"));
        config.setMutual(ConfigUtils.isTrue(prop.getProperty("tls-mutual")));
        config.setCrl(prop.getProperty("tls-crl"));
        config.setTargetNameCheckEnabled(TARGET_CHECK_HOST.equalsIgnoreCase(prop.getProperty("tls-target-name-check")));
        if (config.isTargetNameCheckEnabled()) {
            config.setExpectedHostname(prop.getProperty(KEY_TARGET_SERVER_HOST));
        }
        config.setFips140Enabled(ConfigUtils.isTrue(prop.getProperty("fips140-enabled")));
        config.setCipherList(prop.getProperty("cipher-list"));
        String secProtocol = prop.getProperty("sec-protocol");
        if (secProtocol != null) {
            config.setSecProtocol(secProtocol);
        }
        String protocolVersion = prop.getProperty("tls-version");
        String protocolList = prop.getProperty("protocol-list");
        if (secProtocol == null) {
            config.setEnabledProtocols(protocolList);
            config.setVersion(protocolVersion);
        } else {
            if (protocolVersion != null && !protocolVersion.equals(config.getVersion()) && log.isWarn()) {
                log.warnFormat("tls-version was ignored: {0}. sec-protocl was used: {1}.", (Object)new Object[]{protocolVersion, secProtocol});
            }
            if (protocolList != null && !secProtocol.equals(TLSConfiguration.enabledProtocols2sec(protocolList)) && log.isWarn()) {
                log.warnFormat("protocol-list was ignored: {0}. sec-protocl was used: {1}.", (Object)new Object[]{protocolList, secProtocol});
            }
        }
        return config;
    }
}

