/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.tls;

import com.genesyslab.platform.commons.connection.tls.CertificateLoader;
import com.genesyslab.platform.commons.connection.tls.HostnameCheckingTrustManager;
import com.genesyslab.platform.commons.connection.tls.KeyStoreFactory;
import com.genesyslab.platform.commons.connection.tls.TrustEveryoneX509TrustManager;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.CallbackHandler;

public class TrustManagerHelper {
    private static final ILogger log = Log.getLogger(TrustManagerHelper.class);
    private static final String CERT_STORE_COLLECTION = "Collection";

    public static X509TrustManager createPEMTrustManager(InputStream caCertStream, InputStream crlStream, String expectedHostName) throws IOException, GeneralSecurityException {
        if (null == caCertStream) {
            throw new IllegalArgumentException("caCertStream must not be null");
        }
        Certificate caCert = CertificateLoader.loadCertificateFromX509PEM(caCertStream);
        KeyStore trustKeyStore = KeyStoreFactory.createPEMTrustKeyStore(caCert);
        TrustManagerFactory trustManagerFactory = TrustManagerHelper.createTrustManagerFactory(trustKeyStore, crlStream);
        X509TrustManager trustManager = TrustManagerHelper.getX509TrustManager(trustManagerFactory);
        if (null == expectedHostName) {
            return trustManager;
        }
        return new HostnameCheckingTrustManager(expectedHostName, trustManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509TrustManager createPEMTrustManager(String caCertFilePath, String crlFilePath, String expectedHostName) throws IOException, GeneralSecurityException {
        if (null == caCertFilePath || caCertFilePath.length() == 0) {
            throw new IllegalArgumentException("caCertFilePath must not be empty");
        }
        FileInputStream crlStream = null;
        if (null != crlFilePath && crlFilePath.length() > 0) {
            crlStream = new FileInputStream(crlFilePath);
        }
        try {
            X509TrustManager x509TrustManager;
            FileInputStream pemStream = new FileInputStream(caCertFilePath);
            try {
                x509TrustManager = TrustManagerHelper.createPEMTrustManager(pemStream, crlStream, expectedHostName);
            }
            catch (Throwable throwable) {
                ((InputStream)pemStream).close();
                throw throwable;
            }
            ((InputStream)pemStream).close();
            return x509TrustManager;
        }
        finally {
            if (null != crlStream) {
                ((InputStream)crlStream).close();
            }
        }
    }

    public static X509TrustManager createMSCAPITrustManager(CallbackHandler callbackHandler, InputStream crlStream, String expectedHostName) throws IOException, GeneralSecurityException {
        if (null == callbackHandler) {
            throw new IllegalArgumentException("callbackHandler must not be null");
        }
        KeyStore trustKeyStore = KeyStoreFactory.createMSCAPIRootStore(callbackHandler);
        TrustManagerFactory trustManagerFactory = TrustManagerHelper.createTrustManagerFactory(trustKeyStore, crlStream);
        X509TrustManager trustManager = TrustManagerHelper.getX509TrustManager(trustManagerFactory);
        if (null == expectedHostName) {
            return trustManager;
        }
        return new HostnameCheckingTrustManager(expectedHostName, trustManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509TrustManager createMSCAPITrustManager(CallbackHandler callbackHandler, String crlFilePath, String expectedHostName) throws IOException, GeneralSecurityException {
        if (null == callbackHandler) {
            throw new IllegalArgumentException("callbackHandler must not be null");
        }
        FileInputStream crlStream = null;
        if (null != crlFilePath && crlFilePath.length() > 0) {
            crlStream = new FileInputStream(crlFilePath);
        }
        try {
            X509TrustManager x509TrustManager = TrustManagerHelper.createMSCAPITrustManager(callbackHandler, crlStream, expectedHostName);
            return x509TrustManager;
        }
        finally {
            if (null != crlStream) {
                ((InputStream)crlStream).close();
            }
        }
    }

    public static X509TrustManager createPKCS11TrustManager(CallbackHandler callbackHandler, InputStream crlStream) throws IOException, GeneralSecurityException {
        if (null == callbackHandler) {
            throw new IllegalArgumentException("callbackHandler must not be null");
        }
        KeyStore trustKeyStore = KeyStoreFactory.createPKCS11KeyStore(callbackHandler);
        TrustManagerFactory trustManagerFactory = TrustManagerHelper.createTrustManagerFactory(trustKeyStore, crlStream);
        return TrustManagerHelper.getX509TrustManager(trustManagerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509TrustManager createPKCS11TrustManager(CallbackHandler callbackHandler, String crlFilePath) throws IOException, GeneralSecurityException {
        if (null == callbackHandler) {
            throw new IllegalArgumentException("callbackHandler must not be null");
        }
        FileInputStream crlStream = null;
        if (null != crlFilePath && crlFilePath.length() > 0) {
            crlStream = new FileInputStream(crlFilePath);
        }
        try {
            X509TrustManager x509TrustManager = TrustManagerHelper.createPKCS11TrustManager(callbackHandler, crlStream);
            return x509TrustManager;
        }
        finally {
            if (null != crlStream) {
                ((InputStream)crlStream).close();
            }
        }
    }

    public static X509TrustManager createDefaultTrustManager() throws IOException, GeneralSecurityException {
        TrustManagerFactory defaultTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        defaultTrustManagerFactory.init((KeyStore)null);
        return TrustManagerHelper.getX509TrustManager(defaultTrustManagerFactory);
    }

    public static X509TrustManager createJKSTrustManager(InputStream jksStream, char[] keyStorePassword, InputStream crlStream, String expectedHostName) throws IOException, GeneralSecurityException {
        if (null == jksStream) {
            throw new IllegalArgumentException("jksStream must not be empty");
        }
        KeyStore trustKeyStore = KeyStoreFactory.createJKSKeyStore(jksStream, keyStorePassword);
        TrustManagerFactory trustManagerFactory = TrustManagerHelper.createTrustManagerFactory(trustKeyStore, crlStream);
        X509TrustManager trustManager = TrustManagerHelper.getX509TrustManager(trustManagerFactory);
        if (null == expectedHostName) {
            return trustManager;
        }
        return new HostnameCheckingTrustManager(expectedHostName, trustManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509TrustManager createJKSTrustManager(String jksFilePath, char[] keyStorePassword, String crlFilePath, String expectedHostName) throws IOException, GeneralSecurityException {
        if (null == jksFilePath || jksFilePath.length() == 0) {
            throw new IllegalArgumentException("jksFilePath must not be empty");
        }
        FileInputStream crlStream = null;
        if (null != crlFilePath && crlFilePath.length() > 0) {
            crlStream = new FileInputStream(crlFilePath);
        }
        try {
            X509TrustManager x509TrustManager;
            FileInputStream jksStream = new FileInputStream(jksFilePath);
            try {
                x509TrustManager = TrustManagerHelper.createJKSTrustManager(jksStream, keyStorePassword, crlStream, expectedHostName);
            }
            catch (Throwable throwable) {
                ((InputStream)jksStream).close();
                throw throwable;
            }
            ((InputStream)jksStream).close();
            return x509TrustManager;
        }
        finally {
            if (null != crlStream) {
                ((InputStream)crlStream).close();
            }
        }
    }

    public static X509TrustManager createTrustEveryoneTrustManager() {
        return new TrustEveryoneX509TrustManager();
    }

    private static TrustManagerFactory createTrustManagerFactory(KeyStore trustKeyStore, InputStream crlStream) throws IOException, GeneralSecurityException {
        CertStore certStore = null;
        if (null != crlStream) {
            Collection<? extends CRL> crls = CertificateLoader.loadCRLFromPEM(crlStream);
            CollectionCertStoreParameters certStoreParams = new CollectionCertStoreParameters(crls);
            certStore = CertStore.getInstance(CERT_STORE_COLLECTION, certStoreParams);
        }
        Set<TrustAnchor> trustAnchors = TrustManagerHelper.createTrustAnchors(trustKeyStore);
        PKIXBuilderParameters pkixParameters = new PKIXBuilderParameters(trustAnchors, null);
        if (null != certStore) {
            pkixParameters.setRevocationEnabled(true);
            pkixParameters.addCertStore(certStore);
        } else {
            pkixParameters.setRevocationEnabled(false);
        }
        CertPathTrustManagerParameters trustManagerParameters = new CertPathTrustManagerParameters(pkixParameters);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustManagerParameters);
        return trustManagerFactory;
    }

    private static Set<TrustAnchor> createTrustAnchors(KeyStore trustKeyStore) throws GeneralSecurityException {
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        Enumeration<String> aliases = trustKeyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate cert = null;
            try {
                cert = trustKeyStore.getCertificate(alias);
            }
            catch (Exception e) {
                log.warn((Object)("Could not get certificate from entry alias \"" + alias + "\", skipping entry..."), (Throwable)e);
            }
            if (!(cert instanceof X509Certificate)) continue;
            trustAnchors.add(new TrustAnchor((X509Certificate)cert, null));
        }
        return trustAnchors;
    }

    private static X509TrustManager getX509TrustManager(TrustManagerFactory factory) {
        for (TrustManager tm : factory.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        return null;
    }
}

