/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.openmedia.protocol.openmediaattributes;

import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.commons.collections.UTFValue;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.openmedia.protocol.openmediaattributes.Converter;
import com.genesyslab.platform.openmedia.protocol.openmediaattributes.InteractionAttributes;
import com.genesyslab.platform.openmedia.protocol.openmediaattributes.WorkbinStatisticDetails;
import com.genesyslab.platform.openmedia.protocol.openmediaattributes.WorkbinType;
import com.genesyslab.platform.openmedia.protocol.openmediaattributes.WorkbinTypeDetails;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class OpenMediaAttributesBinding {
    private static final ILogger log = Log.getLogger(OpenMediaAttributesBinding.class);
    private static final HashMap<String, String> _resolveMap = new HashMap(256);
    private static final Map<String, Integer> classNameIndex;
    private static final Map<String, Integer> keysIndex_WorkbinTypeDetails;
    private static final Map<String, Integer> keysIndex_WorkbinStatisticDetails;
    private static final Map<String, Integer> keysIndex_InteractionAttributes;

    private OpenMediaAttributesBinding() {
    }

    public static KeyValueCollection marshal(Object obj) throws KVBindingException {
        if (obj == null) {
            return null;
        }
        Integer keyIndex = classNameIndex.get(obj.getClass().getSimpleName());
        if (keyIndex != null) {
            KeyValueCollection kvlist = new KeyValueCollection();
            switch (keyIndex) {
                case 0: {
                    return OpenMediaAttributesBinding.marshal((WorkbinTypeDetails)obj, kvlist);
                }
                case 1: {
                    return OpenMediaAttributesBinding.marshal((WorkbinStatisticDetails)obj, kvlist);
                }
                case 2: {
                    return OpenMediaAttributesBinding.marshal((InteractionAttributes)obj, kvlist);
                }
            }
        }
        return null;
    }

    public static Object unmarshal(KeyValueCollection kvlist) throws KVBindingException {
        return OpenMediaAttributesBinding.unmarshal(OpenMediaAttributesBinding.resolve(kvlist), kvlist);
    }

    public static Object unmarshal(String className, KeyValueCollection kvlist) throws KVBindingException {
        Integer keyIndex;
        if (className == null) {
            className = OpenMediaAttributesBinding.resolve(kvlist);
        }
        if ((keyIndex = classNameIndex.get(className)) != null) {
            switch (keyIndex) {
                case 0: {
                    return OpenMediaAttributesBinding.unmarshal_WorkbinTypeDetails(kvlist);
                }
                case 1: {
                    return OpenMediaAttributesBinding.unmarshal_WorkbinStatisticDetails(kvlist);
                }
                case 2: {
                    return OpenMediaAttributesBinding.unmarshal_InteractionAttributes(kvlist);
                }
            }
        }
        return null;
    }

    public static String resolve(KeyValueCollection list) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String key = ((KeyValuePair)it.next()).getStringKey();
            String result = _resolveMap.get(key);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static KeyValueCollection marshal(WorkbinTypeDetails obj) throws KVBindingException {
        return OpenMediaAttributesBinding.marshal(obj, new KeyValueCollection());
    }

    static KeyValueCollection marshal(WorkbinTypeDetails obj, KeyValueCollection kvlist) throws KVBindingException {
        if (obj == null) {
            return null;
        }
        OpenMediaAttributesBinding.addNotNull(kvlist, "WorkbinType", OpenMediaAttributesBinding.enumOrdinal(obj.getWorkbinType()), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "View", obj.getView(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "Active", Converter.toInteger(obj.getActive()), null, null);
        return kvlist;
    }

    private static WorkbinTypeDetails unmarshal_WorkbinTypeDetails(KeyValueCollection kvlist) throws KVBindingException {
        if (kvlist == null) {
            return null;
        }
        WorkbinTypeDetails obj = new WorkbinTypeDetails();
        for (KeyValuePair pair : kvlist) {
            if (!OpenMediaAttributesBinding.unmarshalPairOf(obj, pair, kvlist)) continue;
        }
        return obj;
    }

    public static boolean setProperty(WorkbinTypeDetails obj, String name, Object value) throws ClassCastException {
        Integer keyIndex = keysIndex_WorkbinTypeDetails.get(name);
        if (keyIndex != null) {
            switch (keyIndex) {
                case 0: {
                    obj.setWorkbinType((WorkbinType)((Object)value));
                    return true;
                }
                case 1: {
                    obj.setView((String)value);
                    return true;
                }
                case 2: {
                    obj.setActive((Boolean)value);
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean unmarshalPairOf(WorkbinTypeDetails obj, KeyValuePair pair, KeyValueCollection kvlist) throws KVBindingException {
        Integer keyIndex = keysIndex_WorkbinTypeDetails.get(pair.getStringKey());
        if (keyIndex != null) {
            switch (keyIndex) {
                case 0: {
                    obj.setWorkbinType(WorkbinType.toEnum((Integer)pair.getValue()));
                    return true;
                }
                case 1: {
                    obj.setView(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 2: {
                    obj.setActive(Converter.toBoolean(OpenMediaAttributesBinding.asInteger(pair.getValue())));
                    return true;
                }
            }
        }
        return false;
    }

    public static KeyValueCollection marshal(WorkbinStatisticDetails obj) throws KVBindingException {
        return OpenMediaAttributesBinding.marshal(obj, new KeyValueCollection());
    }

    static KeyValueCollection marshal(WorkbinStatisticDetails obj, KeyValueCollection kvlist) throws KVBindingException {
        if (obj == null) {
            return null;
        }
        OpenMediaAttributesBinding.addNotNull(kvlist, "NumberOfInteractions", obj.getNumberOfInteractions(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "MinMovedToQueueAt", Converter.toString(obj.getMinMovedToQueueAt()), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "MaxMovedToQueueAt", Converter.toString(obj.getMaxMovedToQueueAt()), null, null);
        return kvlist;
    }

    private static WorkbinStatisticDetails unmarshal_WorkbinStatisticDetails(KeyValueCollection kvlist) throws KVBindingException {
        if (kvlist == null) {
            return null;
        }
        WorkbinStatisticDetails obj = new WorkbinStatisticDetails();
        for (KeyValuePair pair : kvlist) {
            if (!OpenMediaAttributesBinding.unmarshalPairOf(obj, pair, kvlist)) continue;
        }
        return obj;
    }

    public static boolean setProperty(WorkbinStatisticDetails obj, String name, Object value) throws ClassCastException {
        Integer keyIndex = keysIndex_WorkbinStatisticDetails.get(name);
        if (keyIndex != null) {
            switch (keyIndex) {
                case 0: {
                    obj.setNumberOfInteractions((Integer)value);
                    return true;
                }
                case 1: {
                    obj.setMinMovedToQueueAt((Date)value);
                    return true;
                }
                case 2: {
                    obj.setMaxMovedToQueueAt((Date)value);
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean unmarshalPairOf(WorkbinStatisticDetails obj, KeyValuePair pair, KeyValueCollection kvlist) throws KVBindingException {
        Integer keyIndex = keysIndex_WorkbinStatisticDetails.get(pair.getStringKey());
        if (keyIndex != null) {
            switch (keyIndex) {
                case 0: {
                    obj.setNumberOfInteractions(OpenMediaAttributesBinding.asInteger(pair.getValue()));
                    return true;
                }
                case 1: {
                    obj.setMinMovedToQueueAt(Converter.toDate(OpenMediaAttributesBinding.asString(pair.getValue())));
                    return true;
                }
                case 2: {
                    obj.setMaxMovedToQueueAt(Converter.toDate(OpenMediaAttributesBinding.asString(pair.getValue())));
                    return true;
                }
            }
        }
        return false;
    }

    public static KeyValueCollection marshal(InteractionAttributes obj) throws KVBindingException {
        return OpenMediaAttributesBinding.marshal(obj, new KeyValueCollection());
    }

    static KeyValueCollection marshal(InteractionAttributes obj, KeyValueCollection kvlist) throws KVBindingException {
        if (obj == null) {
            return null;
        }
        OpenMediaAttributesBinding.addNotNull(kvlist, "InteractionId", obj.getInteractionId(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "ParentId", obj.getParentId(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "ExternalId", obj.getExternalId(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "TenantId", obj.getTenantId(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "MediaType", obj.getMediaType(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "InteractionType", obj.getInteractionType(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "InteractionSubtype", obj.getInteractionSubtype(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "IsOnline", Converter.toInteger(obj.getIsOnline()), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "InteractionState", obj.getInteractionState(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "IsLocked", Converter.toInteger(obj.getIsLocked()), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "IsLockOwner", obj.getIsLockOwner(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "Queue", obj.getQueue(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "Workbin", obj.getWorkbin(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "WorkbinAgentId", obj.getWorkbinAgentId(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "WorkbinAgentGroupId", obj.getWorkbinAgentGroupId(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "WorkbinPlaceId", obj.getWorkbinPlaceId(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "WorkbinPlaceGroupId", obj.getWorkbinPlaceGroupId(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "SubmittedBy", obj.getSubmittedBy(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "Priority", obj.getPriority(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "ReceivedAt", Converter.toString(obj.getReceivedAt()), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "SubmittedAt", Converter.toString(obj.getSubmittedAt()), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "DeliveredAt", Converter.toString(obj.getDeliveredAt()), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "SubmittedToRouterAt", Converter.toString(obj.getSubmittedToRouterAt()), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "PlacedInQueueAt", Converter.toString(obj.getPlacedInQueueAt()), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "MovedToQueueAt", Converter.toString(obj.getMovedToQueueAt()), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "AbandonedAt", Converter.toString(obj.getAbandonedAt()), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "CustomerSegment", obj.getCustomerSegment(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "ContactId", obj.getContactId(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "ServiceType", obj.getServiceType(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "ServiceObjective", obj.getServiceObjective(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "CategoryId", obj.getCategoryId(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "CaseId", obj.getCaseId(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "ReasonCode", obj.getReasonCode(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "DispositionCode", obj.getDispositionCode(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "FlexibleProperties", obj.getFlexibleProperties(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "Subject", obj.getSubject(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "FromPersonal", obj.getFromPersonal(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "Mailbox", obj.getMailbox(), null, null);
        OpenMediaAttributesBinding.addNotNull(kvlist, "FromAddress", obj.getFromAddress(), null, null);
        KeyValueCollection list = obj.getInQueues();
        if (list != null) {
            kvlist.addAll((Collection)OpenMediaAttributesBinding.cloneKVList(list));
        }
        if ((list = obj.getOutQueues()) != null) {
            kvlist.addAll((Collection)OpenMediaAttributesBinding.cloneKVList(list));
        }
        OpenMediaAttributesBinding.addNotNull(kvlist, "Inviting", obj.getInviting(), null, null);
        KeyValueCollection items = obj.getOtherFields();
        if (items != null && items.size() > 0) {
            kvlist.addAll((Collection)OpenMediaAttributesBinding.cloneKVList(items));
        }
        return kvlist;
    }

    private static InteractionAttributes unmarshal_InteractionAttributes(KeyValueCollection kvlist) throws KVBindingException {
        if (kvlist == null) {
            return null;
        }
        InteractionAttributes obj = new InteractionAttributes();
        for (KeyValuePair pair : kvlist) {
            if (OpenMediaAttributesBinding.unmarshalPairOf(obj, pair, kvlist) || pair.getStringKey().equals("tkv.multibytes")) continue;
            KeyValueCollection items = obj.getOtherFields();
            if (items == null) {
                items = new KeyValueCollection();
                obj.setOtherFields(items);
            }
            items.addObject(pair.getStringKey(), pair.getValue());
        }
        return obj;
    }

    public static boolean setProperty(InteractionAttributes obj, String name, Object value) throws ClassCastException {
        Integer keyIndex = keysIndex_InteractionAttributes.get(name);
        if (keyIndex != null) {
            switch (keyIndex) {
                case 0: {
                    obj.setInteractionId((String)value);
                    return true;
                }
                case 1: {
                    obj.setParentId((String)value);
                    return true;
                }
                case 2: {
                    obj.setExternalId((String)value);
                    return true;
                }
                case 3: {
                    obj.setTenantId((Integer)value);
                    return true;
                }
                case 4: {
                    obj.setMediaType((String)value);
                    return true;
                }
                case 5: {
                    obj.setInteractionType((String)value);
                    return true;
                }
                case 6: {
                    obj.setInteractionSubtype((String)value);
                    return true;
                }
                case 7: {
                    obj.setIsOnline((Boolean)value);
                    return true;
                }
                case 8: {
                    obj.setInteractionState((Integer)value);
                    return true;
                }
                case 9: {
                    obj.setIsLocked((Boolean)value);
                    return true;
                }
                case 10: {
                    obj.setIsLockOwner((String)value);
                    return true;
                }
                case 11: {
                    obj.setQueue((String)value);
                    return true;
                }
                case 12: {
                    obj.setWorkbin((String)value);
                    return true;
                }
                case 13: {
                    obj.setWorkbinAgentId((String)value);
                    return true;
                }
                case 14: {
                    obj.setWorkbinAgentGroupId((String)value);
                    return true;
                }
                case 15: {
                    obj.setWorkbinPlaceId((String)value);
                    return true;
                }
                case 16: {
                    obj.setWorkbinPlaceGroupId((String)value);
                    return true;
                }
                case 17: {
                    obj.setSubmittedBy((String)value);
                    return true;
                }
                case 18: {
                    obj.setPriority((Integer)value);
                    return true;
                }
                case 19: {
                    obj.setReceivedAt((Date)value);
                    return true;
                }
                case 20: {
                    obj.setSubmittedAt((Date)value);
                    return true;
                }
                case 21: {
                    obj.setDeliveredAt((Date)value);
                    return true;
                }
                case 22: {
                    obj.setSubmittedToRouterAt((Date)value);
                    return true;
                }
                case 23: {
                    obj.setPlacedInQueueAt((Date)value);
                    return true;
                }
                case 24: {
                    obj.setMovedToQueueAt((Date)value);
                    return true;
                }
                case 25: {
                    obj.setAbandonedAt((Date)value);
                    return true;
                }
                case 26: {
                    obj.setCustomerSegment((String)value);
                    return true;
                }
                case 27: {
                    obj.setContactId((String)value);
                    return true;
                }
                case 28: {
                    obj.setServiceType((String)value);
                    return true;
                }
                case 29: {
                    obj.setServiceObjective((String)value);
                    return true;
                }
                case 30: {
                    obj.setCategoryId((String)value);
                    return true;
                }
                case 31: {
                    obj.setCaseId((String)value);
                    return true;
                }
                case 32: {
                    obj.setReasonCode((String)value);
                    return true;
                }
                case 33: {
                    obj.setDispositionCode((String)value);
                    return true;
                }
                case 34: {
                    obj.setFlexibleProperties((byte[])value);
                    return true;
                }
                case 35: {
                    obj.setSubject((String)value);
                    return true;
                }
                case 36: {
                    obj.setFromPersonal((String)value);
                    return true;
                }
                case 37: {
                    obj.setMailbox((String)value);
                    return true;
                }
                case 38: {
                    obj.setFromAddress((String)value);
                    return true;
                }
                case 39: {
                    return false;
                }
                case 40: {
                    return false;
                }
                case 41: {
                    obj.setInviting((Integer)value);
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean unmarshalPairOf(InteractionAttributes obj, KeyValuePair pair, KeyValueCollection kvlist) throws KVBindingException {
        Integer keyIndex = keysIndex_InteractionAttributes.get(pair.getStringKey());
        if (keyIndex != null) {
            switch (keyIndex) {
                case 0: {
                    obj.setInteractionId(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 1: {
                    obj.setParentId(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 2: {
                    obj.setExternalId(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 3: {
                    obj.setTenantId(OpenMediaAttributesBinding.asInteger(pair.getValue()));
                    return true;
                }
                case 4: {
                    obj.setMediaType(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 5: {
                    obj.setInteractionType(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 6: {
                    obj.setInteractionSubtype(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 7: {
                    obj.setIsOnline(Converter.toBoolean(OpenMediaAttributesBinding.asInteger(pair.getValue())));
                    return true;
                }
                case 8: {
                    obj.setInteractionState(OpenMediaAttributesBinding.asInteger(pair.getValue()));
                    return true;
                }
                case 9: {
                    obj.setIsLocked(Converter.toBoolean(OpenMediaAttributesBinding.asInteger(pair.getValue())));
                    return true;
                }
                case 10: {
                    obj.setIsLockOwner(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 11: {
                    obj.setQueue(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 12: {
                    obj.setWorkbin(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 13: {
                    obj.setWorkbinAgentId(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 14: {
                    obj.setWorkbinAgentGroupId(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 15: {
                    obj.setWorkbinPlaceId(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 16: {
                    obj.setWorkbinPlaceGroupId(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 17: {
                    obj.setSubmittedBy(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 18: {
                    obj.setPriority(OpenMediaAttributesBinding.asInteger(pair.getValue()));
                    return true;
                }
                case 19: {
                    obj.setReceivedAt(Converter.toDate(OpenMediaAttributesBinding.asString(pair.getValue())));
                    return true;
                }
                case 20: {
                    obj.setSubmittedAt(Converter.toDate(OpenMediaAttributesBinding.asString(pair.getValue())));
                    return true;
                }
                case 21: {
                    obj.setDeliveredAt(Converter.toDate(OpenMediaAttributesBinding.asString(pair.getValue())));
                    return true;
                }
                case 22: {
                    obj.setSubmittedToRouterAt(Converter.toDate(OpenMediaAttributesBinding.asString(pair.getValue())));
                    return true;
                }
                case 23: {
                    obj.setPlacedInQueueAt(Converter.toDate(OpenMediaAttributesBinding.asString(pair.getValue())));
                    return true;
                }
                case 24: {
                    obj.setMovedToQueueAt(Converter.toDate(OpenMediaAttributesBinding.asString(pair.getValue())));
                    return true;
                }
                case 25: {
                    obj.setAbandonedAt(Converter.toDate(OpenMediaAttributesBinding.asString(pair.getValue())));
                    return true;
                }
                case 26: {
                    obj.setCustomerSegment(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 27: {
                    obj.setContactId(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 28: {
                    obj.setServiceType(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 29: {
                    obj.setServiceObjective(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 30: {
                    obj.setCategoryId(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 31: {
                    obj.setCaseId(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 32: {
                    obj.setReasonCode(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 33: {
                    obj.setDispositionCode(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 34: {
                    obj.setFlexibleProperties((byte[])pair.getValue());
                    return true;
                }
                case 35: {
                    obj.setSubject(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 36: {
                    obj.setFromPersonal(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 37: {
                    obj.setMailbox(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 38: {
                    obj.setFromAddress(OpenMediaAttributesBinding.asString(pair.getValue()));
                    return true;
                }
                case 39: {
                    KeyValueCollection list = obj.getInQueues();
                    if (list == null) {
                        list = new KeyValueCollection();
                        obj.setInQueues(list);
                    }
                    OpenMediaAttributesBinding.addNotNull(list, pair.getStringKey(), pair.getValue(), null, null);
                    return true;
                }
                case 40: {
                    KeyValueCollection list = obj.getOutQueues();
                    if (list == null) {
                        list = new KeyValueCollection();
                        obj.setOutQueues(list);
                    }
                    OpenMediaAttributesBinding.addNotNull(list, pair.getStringKey(), pair.getValue(), null, null);
                    return true;
                }
                case 41: {
                    obj.setInviting(OpenMediaAttributesBinding.asInteger(pair.getValue()));
                    return true;
                }
            }
        }
        return false;
    }

    private static Integer asInteger(Object value) {
        if (value != null) {
            block10: {
                Class<?> valueClass = value.getClass();
                if (valueClass == Integer.class) {
                    return (Integer)value;
                }
                if (valueClass == String.class) {
                    try {
                        return Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException ex) {
                        if (log.isDebug()) {
                            log.warnFormat("[KVBinding] Fail parse as integer value: {0}", (Object)("" + value));
                            return null;
                        }
                        break block10;
                    }
                }
                if (valueClass == UTFValue.class) {
                    try {
                        return Integer.parseInt(((UTFValue)value).getValue());
                    }
                    catch (NumberFormatException ex) {
                        if (!log.isDebug()) break block10;
                        log.warnFormat("[KVBinding] Fail parse as integer UTF value: {0}", (Object)("" + value));
                        return null;
                    }
                }
            }
            if (log.isDebug()) {
                log.warnFormat("[KVBinding] Fail parse as integer value: {0}", (Object)("" + value));
            }
        }
        return null;
    }

    private static String enumName(GEnum value) {
        if (value != null) {
            return value.name();
        }
        return null;
    }

    private static Integer enumOrdinal(GEnum value) {
        if (value != null) {
            return value.ordinal();
        }
        return null;
    }

    private static String asString(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> c = value.getClass();
        if (c == UTFValue.class) {
            return ((UTFValue)value).getValue();
        }
        if (c == Integer.class) {
            return value.toString();
        }
        if (c == String.class) {
            return (String)value;
        }
        if (log.isDebug()) {
            log.warnFormat("[KVBinding] Fail parse as string value: {0}", (Object)("" + value));
        }
        return null;
    }

    private static UTFValue toUTF(String value) {
        return value == null ? null : new UTFValue(value);
    }

    private static KeyValueCollection cloneKVList(Object kvlist) {
        try {
            if (kvlist == null) {
                return null;
            }
            Object o = ((KeyValueCollection)kvlist).clone();
            return (KeyValueCollection)o;
        }
        catch (Throwable e) {
            log.error((Object)("[KVBinding] error cloning kvlist: " + kvlist), e);
            return null;
        }
    }

    private static void logNullKeyValue(String key, String contextClass, String keyProperty) {
        if (key == null) {
            log.warnFormat("{0} marshaler: key property {1} is null", (Object)new Object[]{contextClass, keyProperty});
        }
    }

    private static void addNotNull(KeyValueCollection kvlist, String key, KeyValueCollection value, String contextClass, String keyProperty) {
        if (key == null) {
            OpenMediaAttributesBinding.logNullKeyValue(key, contextClass, keyProperty);
            return;
        }
        if (value != null) {
            kvlist.addList(key, value);
        }
    }

    private static void addNotEmpty(KeyValueCollection kvlist, String key, KeyValueCollection value, String contextClass, String keyProperty) {
        if (key == null) {
            OpenMediaAttributesBinding.logNullKeyValue(key, contextClass, keyProperty);
            return;
        }
        if (value != null && value.size() > 0) {
            kvlist.addList(key, value);
        }
    }

    private static void addNotNull(KeyValueCollection kvlist, String key, Integer value, String contextClass, String keyProperty) {
        if (key == null) {
            OpenMediaAttributesBinding.logNullKeyValue(key, contextClass, keyProperty);
            return;
        }
        if (value != null) {
            kvlist.addInt(key, value);
        }
    }

    private static void addNotNull(KeyValueCollection kvlist, String key, GEnum value, String contextClass, String keyProperty) {
        if (key == null) {
            OpenMediaAttributesBinding.logNullKeyValue(key, contextClass, keyProperty);
            return;
        }
        if (value != null) {
            kvlist.addString(key, value.name());
        }
    }

    private static void addNotNull(KeyValueCollection kvlist, String key, String value, String contextClass, String keyProperty) {
        if (key == null) {
            OpenMediaAttributesBinding.logNullKeyValue(key, contextClass, keyProperty);
            return;
        }
        if (value != null) {
            kvlist.addString(key, value);
        }
    }

    private static void addNotNullUTF(KeyValueCollection kvlist, String key, String value, String contextClass, String keyProperty) {
        if (key == null) {
            OpenMediaAttributesBinding.logNullKeyValue(key, contextClass, keyProperty);
            return;
        }
        if (value != null) {
            kvlist.addUTFString(key, value);
        }
    }

    private static void addNotNull(KeyValueCollection kvlist, String key, UTFValue value, String contextClass, String keyProperty) {
        if (key == null) {
            OpenMediaAttributesBinding.logNullKeyValue(key, contextClass, keyProperty);
            return;
        }
        if (value != null) {
            kvlist.addUTFString(key, value);
        }
    }

    private static void addNotNull(KeyValueCollection kvlist, String key, byte[] value, String contextClass, String keyProperty) {
        if (key == null) {
            OpenMediaAttributesBinding.logNullKeyValue(key, contextClass, keyProperty);
            return;
        }
        if (value != null) {
            kvlist.addBinary(key, value);
        }
    }

    private static void addNotNull(KeyValueCollection kvlist, String key, Object value, String contextClass, String keyProperty) {
        if (key == null) {
            OpenMediaAttributesBinding.logNullKeyValue(key, contextClass, keyProperty);
            return;
        }
        if (value != null) {
            kvlist.addObject(key, value);
        }
    }

    static {
        _resolveMap.put("NumberOfInteractions", "WorkbinStatisticDetails");
        _resolveMap.put("WorkbinType", "WorkbinTypeDetails");
        _resolveMap.put("InteractionId", "InteractionAttributes");
        classNameIndex = new HashMap<String, Integer>(4096);
        classNameIndex.put("WorkbinTypeDetails", 0);
        classNameIndex.put("WorkbinStatisticDetails", 1);
        classNameIndex.put("InteractionAttributes", 2);
        keysIndex_WorkbinTypeDetails = new HashMap<String, Integer>(256);
        keysIndex_WorkbinTypeDetails.put("WorkbinType", 0);
        keysIndex_WorkbinTypeDetails.put("View", 1);
        keysIndex_WorkbinTypeDetails.put("Active", 2);
        keysIndex_WorkbinStatisticDetails = new HashMap<String, Integer>(256);
        keysIndex_WorkbinStatisticDetails.put("NumberOfInteractions", 0);
        keysIndex_WorkbinStatisticDetails.put("MinMovedToQueueAt", 1);
        keysIndex_WorkbinStatisticDetails.put("MaxMovedToQueueAt", 2);
        keysIndex_InteractionAttributes = new HashMap<String, Integer>(256);
        keysIndex_InteractionAttributes.put("InteractionId", 0);
        keysIndex_InteractionAttributes.put("ParentId", 1);
        keysIndex_InteractionAttributes.put("ExternalId", 2);
        keysIndex_InteractionAttributes.put("TenantId", 3);
        keysIndex_InteractionAttributes.put("MediaType", 4);
        keysIndex_InteractionAttributes.put("InteractionType", 5);
        keysIndex_InteractionAttributes.put("InteractionSubtype", 6);
        keysIndex_InteractionAttributes.put("IsOnline", 7);
        keysIndex_InteractionAttributes.put("InteractionState", 8);
        keysIndex_InteractionAttributes.put("IsLocked", 9);
        keysIndex_InteractionAttributes.put("IsLockOwner", 10);
        keysIndex_InteractionAttributes.put("Queue", 11);
        keysIndex_InteractionAttributes.put("Workbin", 12);
        keysIndex_InteractionAttributes.put("WorkbinAgentId", 13);
        keysIndex_InteractionAttributes.put("WorkbinAgentGroupId", 14);
        keysIndex_InteractionAttributes.put("WorkbinPlaceId", 15);
        keysIndex_InteractionAttributes.put("WorkbinPlaceGroupId", 16);
        keysIndex_InteractionAttributes.put("SubmittedBy", 17);
        keysIndex_InteractionAttributes.put("Priority", 18);
        keysIndex_InteractionAttributes.put("ReceivedAt", 19);
        keysIndex_InteractionAttributes.put("SubmittedAt", 20);
        keysIndex_InteractionAttributes.put("DeliveredAt", 21);
        keysIndex_InteractionAttributes.put("SubmittedToRouterAt", 22);
        keysIndex_InteractionAttributes.put("PlacedInQueueAt", 23);
        keysIndex_InteractionAttributes.put("MovedToQueueAt", 24);
        keysIndex_InteractionAttributes.put("AbandonedAt", 25);
        keysIndex_InteractionAttributes.put("CustomerSegment", 26);
        keysIndex_InteractionAttributes.put("ContactId", 27);
        keysIndex_InteractionAttributes.put("ServiceType", 28);
        keysIndex_InteractionAttributes.put("ServiceObjective", 29);
        keysIndex_InteractionAttributes.put("CategoryId", 30);
        keysIndex_InteractionAttributes.put("CaseId", 31);
        keysIndex_InteractionAttributes.put("ReasonCode", 32);
        keysIndex_InteractionAttributes.put("DispositionCode", 33);
        keysIndex_InteractionAttributes.put("FlexibleProperties", 34);
        keysIndex_InteractionAttributes.put("Subject", 35);
        keysIndex_InteractionAttributes.put("FromPersonal", 36);
        keysIndex_InteractionAttributes.put("Mailbox", 37);
        keysIndex_InteractionAttributes.put("FromAddress", 38);
        keysIndex_InteractionAttributes.put("InQueues", 39);
        keysIndex_InteractionAttributes.put("OutQueues", 40);
        keysIndex_InteractionAttributes.put("Inviting", 41);
    }

    public static class KVBindingException
    extends PlatformException {
        public KVBindingException(String message, Throwable cause) {
            super(message, cause);
        }

        public KVBindingException(String message) {
            super(message);
        }

        public KVBindingException(Throwable cause) {
            super(cause);
        }
    }
}

