/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.collections;

import com.genesyslab.platform.commons.collections.DataFormatException;
import com.genesyslab.platform.commons.collections.KVList;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.commons.collections.Pair;
import com.genesyslab.platform.commons.collections.SerialUtil;
import com.genesyslab.platform.commons.collections.ValueType;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;

public class TKVSerializer {
    private static final int MAX_TKVLIST_ELEMENT_SIZE = 65535;
    private static final int MAX_TKVLIST_PACKED_SIZE = 65535;
    private static final int STRING_SIGNATURE = 0;
    private static final int INT_SIGNATURE = 1;
    private static final int BINARY_SIGNATURE = 2;
    private static final int LIST_SIGNATURE = 3;
    private static final int UTF_SIGNATURE = 4;
    private static final int LONG_SIGNATURE = 6;
    private static final int FLOAT_SIGNATURE = 7;
    private static final int HUGE_DATA_SIGNATURE = 128;

    public static KeyValueCollection deserialize(InputStream in) throws IOException, DataFormatException {
        return TKVSerializer.deserialize(in, null, false);
    }

    public static KeyValueCollection deserialize(InputStream in, String encoding, boolean readLen) throws IOException, DataFormatException {
        long skipped;
        KeyValueCollection list = new KeyValueCollection();
        if (in == null) {
            return list;
        }
        if (readLen && (skipped = in.skip(2L)) != 2L) {
            throw new EOFException("Skipped " + skipped + " instead of 2");
        }
        int pairCount = TKVSerializer.readShort(in);
        while (pairCount-- > 0) {
            KeyValuePair pair = (KeyValuePair)TKVSerializer.readPair(in, encoding);
            list.addPair(pair);
        }
        return list;
    }

    @Deprecated
    public static KeyValueCollection deserialize(byte[] bytes) throws DataFormatException {
        try {
            return TKVSerializer.deserialize(bytes, null, false);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e.getMessage());
        }
    }

    @Deprecated
    public static KeyValueCollection deserialize(byte[] bytes, boolean getLen) throws DataFormatException {
        try {
            return TKVSerializer.deserialize(bytes, null, getLen);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e.getMessage());
        }
    }

    public static KeyValueCollection deserialize(byte[] bytes, String encoding) throws DataFormatException, UnsupportedEncodingException {
        return TKVSerializer.deserialize(bytes, encoding, 0, bytes.length, false);
    }

    public static KeyValueCollection deserialize(byte[] bytes, String encoding, boolean getLen) throws DataFormatException, UnsupportedEncodingException {
        return TKVSerializer.deserialize(bytes, encoding, 0, bytes.length, getLen);
    }

    public static KeyValueCollection deserialize(byte[] bytes, String encoding, int offset, int length, boolean readLen) throws DataFormatException, UnsupportedEncodingException {
        if (bytes == null) {
            return new KeyValueCollection();
        }
        try {
            return TKVSerializer.deserialize(new ByteArrayInputStream(bytes, offset, length), encoding, readLen);
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new Error(e.getMessage());
        }
    }

    public static void serialize(KVList list, OutputStream out) throws IOException {
        TKVSerializer.serialize(list, out, null, false);
    }

    public static void serialize(KVList list, OutputStream out, String encoding, boolean writeLen) throws IOException {
        byte[] bytes = TKVSerializer.getBytes(list, encoding);
        if (writeLen) {
            int length = bytes.length + 2;
            byte[] len = new byte[]{(byte)(length >> 8), (byte)length};
            out.write(len);
        }
        out.write(bytes);
    }

    public static byte[] getBytes(KeyValueCollection list) {
        try {
            return TKVSerializer.getBytes(list, null);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e.getMessage());
        }
    }

    @Deprecated
    public static byte[] getBytes(KVList list, String encoding) throws UnsupportedEncodingException {
        return TKVSerializer.getBytes(list, false, encoding, false);
    }

    @Deprecated
    public static byte[] getBytes(KVList list, String encoding, boolean useLen) throws UnsupportedEncodingException {
        return TKVSerializer.getBytes(list, false, encoding, useLen);
    }

    public static byte[] getBytes(KVList list, boolean useUtfString, String encoding, boolean useLen) throws UnsupportedEncodingException {
        byte[] b = useLen ? new byte[TKVSerializer.getListSize(list, useUtfString, encoding)] : new byte[TKVSerializer.getListSize(list, useUtfString, encoding) - 2];
        TKVSerializer.pack(list, b, 0, useUtfString, encoding, useLen);
        return b;
    }

    public static byte[] getBytes(KVList list, boolean useUtfString, String encoding) throws UnsupportedEncodingException {
        return TKVSerializer.getBytes(list, useUtfString, encoding, false);
    }

    private static int pack(KVList list, byte[] buf, int start, boolean useUtfString, String encoding, boolean writeLen) throws UnsupportedEncodingException {
        int p = start + 2;
        if (writeLen) {
            p = start + 4;
        }
        int npairs = 0;
        Enumeration e = list.getEnumeration();
        while (e.hasMoreElements()) {
            Pair kvp = (Pair)e.nextElement();
            int valueSize = TKVSerializer.getValueSize(kvp, useUtfString, encoding);
            if (valueSize < 0) continue;
            ++npairs;
            TKVSerializer.writePairHead(kvp, valueSize, buf, p, useUtfString);
            ++p;
            p += TKVSerializer.writeKey(kvp, buf, p, encoding);
            p += TKVSerializer.writeValue(kvp, valueSize, buf, p, useUtfString, encoding);
        }
        int len = p - start;
        if (writeLen) {
            if (len > 65535) {
                buf[start] = 0;
                buf[start + 1] = 0;
            } else {
                buf[start] = (byte)(len >> 8);
                buf[start + 1] = (byte)len;
            }
            buf[start + 2] = (byte)(npairs >> 8);
            buf[start + 3] = (byte)npairs;
        } else {
            buf[start] = (byte)(npairs >> 8);
            buf[start + 1] = (byte)npairs;
        }
        return len;
    }

    private static int writeValue(Pair kvp, int valueSize, byte[] buf, int pos, boolean useUtfString, String enc) throws UnsupportedEncodingException {
        if (kvp == null) {
            throw new IllegalArgumentException("argument kvp is null");
        }
        int p = pos;
        if (valueSize > 65535) {
            buf[p++] = (byte)(valueSize >> 24);
            buf[p++] = (byte)(valueSize >> 16);
        }
        buf[p++] = (byte)(valueSize >> 8);
        buf[p++] = (byte)valueSize;
        ValueType valueType = kvp.getValueType();
        if (ValueType.BINARY.equals(valueType)) {
            System.arraycopy(kvp.getBinaryValue(), 0, buf, p, valueSize);
        } else if (ValueType.INT.equals(valueType)) {
            Integer integerValue = kvp.getIntValue();
            if (integerValue != null) {
                int val = integerValue;
                buf[p] = (byte)(val >> 24);
                buf[p + 1] = (byte)(val >> 16);
                buf[p + 2] = (byte)(val >> 8);
                buf[p + 3] = (byte)val;
            }
        } else if (ValueType.STRING.equals(valueType)) {
            String stringValue = kvp.getStringValue();
            if (stringValue == null) {
                throw new NullPointerException("pair value isn't string. " + kvp.getStringKey() + " + : " + kvp.getValue());
            }
            byte[] bytes = useUtfString ? SerialUtil.getBytes(stringValue, "UTF-16BE") : SerialUtil.getBytes(stringValue, enc);
            System.arraycopy(bytes, 0, buf, p, valueSize);
        } else if (ValueType.TKV_LIST.equals(valueType)) {
            KeyValuePair pair = (KeyValuePair)kvp;
            TKVSerializer.pack(pair.getTKVValue(), buf, p, useUtfString, enc, true);
        } else if (ValueType.WIDE_STRING.equals(valueType)) {
            String stringValue = kvp.getStringValue();
            if (stringValue == null) {
                throw new NullPointerException("pair value isn't string. " + kvp.getStringKey() + " + : " + kvp.getValue());
            }
            byte[] bytes = SerialUtil.getBytes(stringValue, "UTF-16BE");
            System.arraycopy(bytes, 0, buf, p, valueSize);
        }
        if (valueSize > 65535) {
            return valueSize + 4;
        }
        return valueSize + 2;
    }

    private static int writeKey(Pair kvp, byte[] buf, int p, String enc) throws UnsupportedEncodingException {
        byte[] strBytes = SerialUtil.getBytes(kvp.getStringKey(), enc);
        int keylen = strBytes.length;
        buf[p++] = (byte)(keylen >> 8);
        buf[p++] = (byte)keylen;
        System.arraycopy(strBytes, 0, buf, p, keylen);
        return keylen + 2;
    }

    private static void writePairHead(Pair kvp, int valueSize, byte[] buf, int p, boolean useUtfString) {
        int pairTypeSignature = TKVSerializer.getPairTypeSignature(kvp, useUtfString);
        if (valueSize > 65535) {
            pairTypeSignature += 128;
        }
        buf[p] = (byte)pairTypeSignature;
    }

    private static int getPairTypeSignature(Pair kvp, boolean useUtfString) {
        if (kvp == null) {
            throw new IllegalArgumentException("argument kvp is null");
        }
        ValueType valueType = kvp.getValueType();
        if (ValueType.BINARY.equals(valueType)) {
            return 2;
        }
        if (ValueType.FLOAT.equals(valueType)) {
            return 7;
        }
        if (ValueType.INT.equals(valueType)) {
            return 1;
        }
        if (ValueType.LONG.equals(valueType)) {
            return 6;
        }
        if (ValueType.STRING.equals(valueType)) {
            return useUtfString ? 4 : 0;
        }
        if (ValueType.TKV_LIST.equals(valueType)) {
            return 3;
        }
        if (ValueType.WIDE_STRING.equals(valueType)) {
            return 4;
        }
        throw new Error("unexpected pair type");
    }

    private static int getListSize(KVList list, boolean useUtfString, String enc) throws UnsupportedEncodingException {
        int len = 4;
        Enumeration e = list.getEnumeration();
        while (e.hasMoreElements()) {
            byte[] bytes;
            String stringKey;
            Pair p = (Pair)e.nextElement();
            if (p == null || (stringKey = p.getStringKey()) == null || (bytes = SerialUtil.getBytes(stringKey, enc)) == null) continue;
            int keyLen = bytes.length;
            int valueLen = TKVSerializer.getValueSize(p, useUtfString, enc);
            if (valueLen != -1) {
                len += 5 + keyLen + valueLen;
            }
            if (valueLen <= 65535) continue;
            len += 2;
        }
        return len;
    }

    private static int getValueSize(Pair pair, boolean useUtfString, String enc) throws UnsupportedEncodingException {
        if (pair == null) {
            return -1;
        }
        ValueType valueType = pair.getValueType();
        if (valueType == null) {
            return -1;
        }
        if (ValueType.BINARY.equals(valueType)) {
            byte[] binaryValue = pair.getBinaryValue();
            return binaryValue != null ? binaryValue.length : 0;
        }
        if (ValueType.FLOAT.equals(valueType)) {
            return -1;
        }
        if (ValueType.INT.equals(valueType)) {
            return 4;
        }
        if (ValueType.LONG.equals(valueType)) {
            return -1;
        }
        if (ValueType.STRING.equals(valueType)) {
            String stringValue = pair.getStringValue();
            if (stringValue == null) {
                throw new NullPointerException("pair value isn't string. " + pair.getStringKey() + " + : " + pair.getValue());
            }
            if (useUtfString) {
                return SerialUtil.getBytes(stringValue, "UTF-16BE").length;
            }
            return SerialUtil.getBytes(stringValue, enc).length;
        }
        if (valueType.equals(ValueType.TKV_LIST)) {
            return TKVSerializer.getListSize(((KeyValuePair)pair).getTKVValue(), useUtfString, enc);
        }
        if (valueType.equals(ValueType.WIDE_STRING)) {
            String stringValue = pair.getStringValue();
            if (stringValue == null) {
                throw new NullPointerException("pair value isn't string. " + pair.getStringKey() + " + : " + pair.getValue());
            }
            return SerialUtil.getBytes(stringValue, "UTF-16BE").length;
        }
        throw new Error("unexpected pair type");
    }

    private static Pair readPair(InputStream in, String encoding) throws IOException, DataFormatException {
        byte type = SerialUtil.read(in);
        int len = TKVSerializer.readShort(in);
        String key = TKVSerializer.readString(in, len, encoding);
        KeyValuePair pair = new KeyValuePair(key);
        TKVSerializer.readValue(in, pair, type, encoding);
        return pair;
    }

    private static void readValue(InputStream in, Pair pair, int type, String encoding) throws IOException, DataFormatException {
        int len;
        if (type < 0) {
            type = 128 + type;
            len = TKVSerializer.readInt(in);
        } else {
            len = TKVSerializer.readShort(in);
        }
        switch (type) {
            case 0: {
                pair.setStringValue(TKVSerializer.readString(in, len, encoding));
                break;
            }
            case 1: {
                if (len != 4) {
                    throw new DataFormatException("corrupted data?");
                }
                pair.setIntValue(TKVSerializer.readInt(in));
                break;
            }
            case 2: {
                pair.setBinaryValue(SerialUtil.readBytes(in, len));
                break;
            }
            case 3: {
                ((KeyValuePair)pair).setTKVValue(TKVSerializer.deserialize(in, encoding, true));
                break;
            }
            case 4: {
                pair.setUTF16Value(TKVSerializer.readString(in, len, "UTF-16BE"));
                break;
            }
            default: {
                throw new DataFormatException("unknown type '" + type + "', corrupted data?");
            }
        }
    }

    private static int readInt(InputStream in) throws IOException, DataFormatException {
        int bt;
        int result = bt = in.read();
        bt = in.read();
        result = result << 8 | bt;
        bt = in.read();
        result = result << 8 | bt;
        bt = TKVSerializer.readByte(in);
        result = result << 8 | bt;
        return result;
    }

    private static int readShort(InputStream in) throws IOException, DataFormatException {
        int bt = TKVSerializer.readByte(in);
        int result = bt << 8;
        bt = TKVSerializer.readByte(in);
        return result | bt;
    }

    private static int readByte(InputStream in) throws IOException, DataFormatException {
        int bt = in.read();
        if (bt == -1) {
            throw new DataFormatException("unexpected end of stream");
        }
        return bt;
    }

    private static String readString(InputStream in, int len, String enc) throws IOException, DataFormatException {
        byte[] bytes = SerialUtil.readBytes(in, len);
        if (enc != null) {
            return new String(bytes, enc);
        }
        return new String(bytes);
    }
}

