/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.collections.processor;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.processor.KeyValueIndenter;
import com.genesyslab.platform.commons.collections.processor.KeyValueOutputFilter;
import com.genesyslab.platform.commons.collections.processor.KeyValuePrinterContext;
import com.genesyslab.platform.commons.collections.util.Hex;

public abstract class KeyValueAbstractOutputFilter
implements KeyValueOutputFilter {
    @Override
    public void configure(KeyValueCollection options) {
    }

    @Override
    public boolean isFilteredOut(String key, Object value, KeyValuePrinterContext context) {
        return false;
    }

    @Override
    public String appendKeyValuePair(StringBuffer buf, String key, Object value, KeyValuePrinterContext context) {
        KeyValueIndenter indenter = context.getIndenter();
        if (indenter != null) {
            indenter.appendIndent(buf);
        }
        return this.doAppendKeyValuePair(buf, key, value, context);
    }

    protected String doAppendKeyValuePair(StringBuffer buf, String key, Object value, KeyValuePrinterContext context) {
        this.doAppendPairKey(buf, key, value, context);
        if (value != null) {
            buf.append(" = ");
            return this.doAppendPairValue(buf, key, value, context);
        }
        return null;
    }

    protected void doAppendPairKey(StringBuffer buf, String key, Object value, KeyValuePrinterContext context) {
        buf.append('\'').append(key).append('\'');
        this.doAppendPairKeyType(buf, key, value, context);
    }

    protected void doAppendPairKeyType(StringBuffer buf, String key, Object value, KeyValuePrinterContext context) {
        if (value != null) {
            buf.append(" [");
            if (value instanceof String) {
                buf.append("str");
            } else if (value instanceof Integer) {
                buf.append("int");
            } else if (value instanceof byte[]) {
                buf.append("bstr");
            } else if (value instanceof KeyValueCollection) {
                buf.append("lst");
            } else {
                buf.append(value.getClass().getName());
            }
            buf.append(']');
        }
    }

    protected String doAppendPairValue(StringBuffer buf, String key, Object value, KeyValuePrinterContext context) {
        if (value instanceof String) {
            buf.append('\"').append(value).append('\"');
        } else if (value instanceof Integer) {
            buf.append(value);
        } else if (value instanceof byte[]) {
            Hex.appendBytesStr(buf, (byte[])value);
        } else if (value instanceof KeyValueCollection) {
            buf.append("KVList:");
        } else {
            buf.append(value);
        }
        return null;
    }
}

