/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.collections.runtime.processor;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.processor.KeyValueOutputFilter;
import com.genesyslab.platform.commons.collections.runtime.processor.CopyOutputFilter;
import com.genesyslab.platform.commons.collections.runtime.processor.HideFirstOutputFilter;
import com.genesyslab.platform.commons.collections.runtime.processor.HideLastOutputFilter;
import com.genesyslab.platform.commons.collections.runtime.processor.HideOutputFilter;
import com.genesyslab.platform.commons.collections.runtime.processor.PrefixPostfixFilter;
import com.genesyslab.platform.commons.collections.runtime.processor.SkipOutputFilter;
import com.genesyslab.platform.commons.collections.runtime.processor.TruncateOutputFilter;
import com.genesyslab.platform.commons.collections.runtime.processor.UnhideFirstOutputFilter;
import com.genesyslab.platform.commons.collections.runtime.processor.UnhideLastOutputFilter;
import java.util.ArrayList;
import java.util.List;

class FilterConfigurationHelper {
    private KeyValueOutputFilter copyFilter;
    private KeyValueOutputFilter skipFilter;
    private KeyValueOutputFilter hideFilter;
    private KeyValueOutputFilter truncateFilter;

    FilterConfigurationHelper() {
    }

    public KeyValueOutputFilter createCustomFilter(KeyValueCollection options) {
        Class<?> filterClass;
        if (options == null) {
            return null;
        }
        String filterType = options.getString("custom-filter-type");
        if (filterType == null || filterType.length() == 0) {
            throw new RuntimeException("No filter type specified for custom filter");
        }
        KeyValueOutputFilter customFilter = null;
        try {
            filterClass = Class.forName(this.getClass().getPackage().getName() + "." + filterType);
        }
        catch (ClassNotFoundException ex) {
            try {
                filterClass = Class.forName(filterType);
            }
            catch (ClassNotFoundException ex2) {
                throw new RuntimeException("Can't find class for custom filter type '" + filterType + "'");
            }
        }
        if (filterClass != null) {
            try {
                customFilter = (KeyValueOutputFilter)filterClass.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException("Exception on create custom filter from '" + filterClass.getName() + "'", ex);
            }
        }
        if (customFilter != null) {
            KeyValueCollection filterOptions = options.getList("custom-filter-options");
            customFilter.configure(filterOptions);
        }
        return customFilter;
    }

    public KeyValueOutputFilter createFilter(String filterName, KeyValueCollection config) {
        if (filterName == null) {
            return null;
        }
        if ("copy".equals(filterName)) {
            return this.getCopyFilter();
        }
        if ("truncate".equals(filterName)) {
            return this.getTruncateFilter();
        }
        if ("hide".equals(filterName)) {
            return this.getHideFilter();
        }
        if ("skip".equals(filterName)) {
            return this.getSkipFilter();
        }
        if (filterName.startsWith("hide-first")) {
            return this.getHideFirstFilter(filterName, config);
        }
        if (filterName.startsWith("hide-last")) {
            return this.getHideLastFilter(filterName, config);
        }
        if (filterName.startsWith("unhide-first")) {
            return this.getUnhideFirstFilter(filterName, config);
        }
        if (filterName.startsWith("unhide-last")) {
            return this.getUnhideLastFilter(filterName, config);
        }
        if (filterName.startsWith("tag")) {
            return this.getTagFilter(filterName, config);
        }
        return null;
    }

    private KeyValueOutputFilter getHideFirstFilter(String filterName, KeyValueCollection options) {
        Integer integerCnt;
        int cnt = -1;
        String[] str = filterName.split("\\s*,\\s*");
        if (str.length >= 2) {
            cnt = Integer.parseInt(str[1]);
        } else if (options != null && (integerCnt = options.getInt("hide-first-count")) != null) {
            cnt = integerCnt;
        }
        return new HideFirstOutputFilter(cnt);
    }

    private KeyValueOutputFilter getHideLastFilter(String filterName, KeyValueCollection options) {
        Integer integerCnt;
        int cnt = -1;
        String[] str = filterName.split("\\s*,\\s*");
        if (str.length >= 2) {
            cnt = Integer.parseInt(str[1]);
        } else if (options != null && (integerCnt = options.getInt("hide-last-count")) != null) {
            cnt = integerCnt;
        }
        return new HideLastOutputFilter(cnt);
    }

    private KeyValueOutputFilter getUnhideFirstFilter(String filterName, KeyValueCollection options) {
        Integer integerCnt;
        int cnt = -1;
        String[] str = filterName.split("\\s*,\\s*");
        if (str.length >= 2) {
            cnt = Integer.parseInt(str[1]);
        } else if (options != null && (integerCnt = options.getInt("unhide-first-count")) != null) {
            cnt = integerCnt;
        }
        return new UnhideFirstOutputFilter(cnt);
    }

    private KeyValueOutputFilter getUnhideLastFilter(String filterName, KeyValueCollection options) {
        Integer integerCnt;
        int cnt = -1;
        String[] str = filterName.split("\\s*,\\s*");
        if (str.length >= 2) {
            cnt = Integer.parseInt(str[1]);
        } else if (options != null && (integerCnt = options.getInt("unhide-last-count")) != null) {
            cnt = integerCnt;
        }
        return new UnhideLastOutputFilter(cnt);
    }

    private KeyValueOutputFilter getTagFilter(String filterName, KeyValueCollection options) {
        PrefixPostfixFilter filter = null;
        if (filterName == null) {
            return null;
        }
        List<String> argList = this.parseTagFilterOption(filterName);
        if (argList != null) {
            String pref = null;
            String post = null;
            if (argList.size() == 2) {
                pref = argList.get(0).trim();
                post = argList.get(1).trim();
                if (pref.length() > 16) {
                    pref = pref.substring(0, 16);
                }
                if (post.length() > 16) {
                    post = post.substring(0, 16);
                }
                if (pref.length() == 0 && post.length() == 0) {
                    pref = "<#";
                    post = "#>";
                }
            } else if (argList.size() == 1) {
                String val = argList.get(0).trim();
                if (val.length() == 0) {
                    pref = "<#";
                    post = "#>";
                }
            } else if (argList.size() == 0) {
                pref = "<#";
                post = "#>";
            }
            if (pref != null && post != null) {
                KeyValueCollection filterOpts = new KeyValueCollection();
                filterOpts.addString("key-prefix-string", "");
                filterOpts.addString("key-postfix-string", "");
                filterOpts.addString("value-prefix-string", pref);
                filterOpts.addString("value-postfix-string", post);
                filter = new PrefixPostfixFilter();
                filter.configure(filterOpts);
            }
        }
        return filter;
    }

    private List<String> parseTagFilterOption(String filterName) {
        if (!(filterName = filterName.trim()).startsWith("tag")) {
            return null;
        }
        boolean escaped = false;
        boolean bracketOpened = false;
        boolean wrongSymbol = false;
        ArrayList<String> argList = new ArrayList<String>();
        StringBuilder argument = null;
        for (int i = "tag".length(); i < filterName.length() && !wrongSymbol; ++i) {
            char c = filterName.charAt(i);
            if (escaped) {
                if (argument == null) {
                    argument = new StringBuilder();
                }
                argument.append(c);
                escaped = false;
                continue;
            }
            if (!bracketOpened) {
                if (c == '(') {
                    bracketOpened = true;
                    continue;
                }
                wrongSymbol = true;
                continue;
            }
            if (!bracketOpened) continue;
            if (c == '(') {
                wrongSymbol = true;
                continue;
            }
            if (c == ')') {
                bracketOpened = false;
                if (i == filterName.length() - 1) {
                    if (argument == null) continue;
                    argList.add(argument.toString());
                    continue;
                }
                wrongSymbol = true;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == ',') {
                if (argument == null) {
                    argList.add("");
                } else {
                    argList.add(argument.toString());
                }
                argument = new StringBuilder();
                continue;
            }
            if (argument == null) {
                argument = new StringBuilder();
            }
            argument.append(c);
        }
        if (bracketOpened || wrongSymbol) {
            argList = null;
        }
        return argList;
    }

    private KeyValueOutputFilter getCopyFilter() {
        if (this.copyFilter == null) {
            this.copyFilter = new CopyOutputFilter();
        }
        return this.copyFilter;
    }

    private KeyValueOutputFilter getTruncateFilter() {
        if (this.truncateFilter == null) {
            this.truncateFilter = new TruncateOutputFilter();
        }
        return this.truncateFilter;
    }

    private KeyValueOutputFilter getHideFilter() {
        if (this.hideFilter == null) {
            this.hideFilter = new HideOutputFilter();
        }
        return this.hideFilter;
    }

    private KeyValueOutputFilter getSkipFilter() {
        if (this.skipFilter == null) {
            this.skipFilter = new SkipOutputFilter();
        }
        return this.skipFilter;
    }
}

