/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.collections.runtime.processor;

import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.KeyValuePair;
import com.genesyslab.platform.commons.collections.ValueType;
import com.genesyslab.platform.commons.collections.processor.KeyValueIndenter;
import com.genesyslab.platform.commons.collections.processor.KeyValueOutputFilter;
import com.genesyslab.platform.commons.collections.runtime.processor.FilterConfigurationHelper;
import com.genesyslab.platform.commons.collections.runtime.processor.TKVPrinterContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class KeyValueFilterSet {
    public static KeyValueFilterSet DEFAULT_FILTERS = new KeyValueFilterSet();
    private Map<String, KeyValueOutputFilter> filters = new HashMap<String, KeyValueOutputFilter>();
    private final TKVPrinterContext context;
    private final FilterConfigurationHelper configHelper = new FilterConfigurationHelper();

    private KeyValueFilterSet() {
        this.context = new TKVPrinterContext(this);
    }

    public KeyValueFilterSet(KeyValueCollection options, KeyValueCollection data) {
        this.context = new TKVPrinterContext(this);
        this.parseOptions(options);
        this.parseData(data);
    }

    private void parseData(KeyValueCollection data) {
        if (data == null) {
            return;
        }
        for (KeyValuePair pair : data) {
            String key = pair.getStringKey();
            Object value = pair.getValue();
            KeyValueOutputFilter impl = null;
            if (value instanceof String) {
                impl = this.configHelper.createFilter(pair.getStringValue(), null);
            } else if (value instanceof KeyValueCollection) {
                KeyValueCollection kvData = (KeyValueCollection)value;
                impl = kvData.containsKey("filter-name") ? this.configHelper.createFilter(kvData.getString("filter-name"), kvData) : this.configHelper.createCustomFilter(kvData);
            }
            if (impl == null) continue;
            this.filters.put(key, impl);
        }
    }

    public void addCustomFilter(String key, KeyValueOutputFilter filter) {
        this.filters.put(key, filter);
    }

    private void parseOptions(KeyValueCollection options) {
        if (options == null) {
            return;
        }
        String defFilterName = options.getString("default-filter-type");
        KeyValueOutputFilter filter = "custom-filter".equals(defFilterName) ? this.configHelper.createCustomFilter(options) : this.configHelper.createFilter(defFilterName, null);
        if (filter != null) {
            this.context.setDefaultFilter(filter);
        }
        this.context.setTruncateThreshold(options.getInt("truncate-threshold"));
        Integer integerValue = options.getInt("hide-first-count");
        if (null != integerValue) {
            this.context.setHideFirstCharactersCount(integerValue);
        }
        if (null != (integerValue = options.getInt("hide-last-count"))) {
            this.context.setHideLastCharactersCount(integerValue);
        }
        if (null != (integerValue = options.getInt("unhide-first-count"))) {
            this.context.setUnhideFirstCharactersCount(integerValue);
        }
        if (null != (integerValue = options.getInt("unhide-last-count"))) {
            this.context.setUnhideLastCharactersCount(integerValue);
        }
    }

    public void filterPair(StringBuffer buf, KeyValuePair pair) {
        if (pair == null) {
            return;
        }
        if (ValueType.WIDE_STRING.equals(pair.getValueType())) {
            this.filterPair(buf, pair.getStringKey(), pair.getStringValue());
        } else {
            this.filterPair(buf, pair.getStringKey(), pair.getValue());
        }
    }

    private KeyValueOutputFilter getFilter(String key) {
        KeyValueOutputFilter filter = this.filters.get(key);
        if (filter == null) {
            filter = this.context.getDefaultFilter();
        }
        return filter;
    }

    public StringBuffer filterList(StringBuffer buff, KeyValueCollection list) {
        return this.filterList(buff, list, 1);
    }

    public StringBuffer filterList(StringBuffer buff, KeyValueCollection list, int indent) {
        StringBuffer buf = buff;
        if (buf == null) {
            buf = new StringBuffer();
        }
        buf.append("KVList: ");
        this.setIndent(indent);
        if (list == null) {
            buf.append("null");
        } else {
            this.processKeyValueTree(buf, list);
        }
        return buf;
    }

    public void filterPair(StringBuffer buf, String key, Object value) {
        this.checkValueType(value);
        KeyValueOutputFilter filter = this.getFilter(key);
        if (!filter.isFilteredOut(key, value, this.context)) {
            String rest = filter.appendKeyValuePair(buf, key, value, this.context);
            if (value instanceof KeyValueCollection) {
                if (this.context.getIndenter() != null) {
                    this.context.getIndenter().increaseIndent();
                }
                this.processKeyValueTree(buf, (KeyValueCollection)value);
                if (this.context.getIndenter() != null) {
                    this.context.getIndenter().decreaseIndent();
                }
            }
            if (rest != null) {
                buf.append(rest);
            }
        }
    }

    public void filterPair(StringBuffer buf, String key, Object value, int indent) {
        this.setIndent(indent);
        this.filterPair(buf, key, value);
    }

    private void processKeyValueTree(StringBuffer buf, KeyValueCollection list) {
        if (list != null) {
            Stack<KVTreeOutputState> stack = new Stack<KVTreeOutputState>();
            KVTreeOutputState currentState = new KVTreeOutputState(list.iterator(), null);
            while (currentState != null) {
                KeyValuePair pair = currentState.getNext();
                if (pair == null) {
                    if (currentState.strRest != null) {
                        buf.append(currentState.strRest);
                    }
                    if (stack.empty()) {
                        currentState = null;
                        continue;
                    }
                    currentState = (KVTreeOutputState)stack.pop();
                    if (this.context.getIndenter() == null) continue;
                    this.context.getIndenter().decreaseIndent();
                    continue;
                }
                if (pair.getValue() instanceof KeyValueCollection) {
                    if (pair.getValue() == list) {
                        KeyValueIndenter indenter = this.context.getIndenter();
                        if (indenter != null) {
                            indenter.appendIndent(buf);
                        }
                        buf.append("'");
                        buf.append(pair.getStringKey());
                        buf.append("' [lst] = KVList: (this KeyValueCollection)");
                        continue;
                    }
                    String key = pair.getStringKey();
                    KeyValueCollection value = (KeyValueCollection)pair.getValue();
                    KeyValueOutputFilter filter = this.getFilter(key);
                    if (filter.isFilteredOut(key, value, this.context)) continue;
                    String rest = filter.appendKeyValuePair(buf, key, value, this.context);
                    stack.push(currentState);
                    currentState = new KVTreeOutputState(value.iterator(), rest);
                    if (this.context.getIndenter() == null) continue;
                    this.context.getIndenter().increaseIndent();
                    continue;
                }
                this.filterPair(buf, pair);
            }
        }
    }

    private void checkValueType(Object value) {
        if (value == null || value instanceof String || value instanceof Integer || value instanceof byte[] || value instanceof KeyValueCollection) {
            return;
        }
        throw new IllegalArgumentException("Type " + value.getClass().getName() + " is not supported by KeyValuePrinter");
    }

    private void setIndent(int indent) {
        block3: {
            int currIndent;
            block2: {
                currIndent = this.context.getIndenter().increaseIndent();
                if (currIndent <= indent) break block2;
                while (currIndent != indent && currIndent > 0) {
                    currIndent = this.context.getIndenter().decreaseIndent();
                }
                break block3;
            }
            if (currIndent >= indent) break block3;
            while (currIndent != indent) {
                currIndent = this.context.getIndenter().increaseIndent();
            }
        }
    }

    private class KVTreeOutputState {
        Iterator<?> iterator;
        String strRest;

        KVTreeOutputState(Iterator<?> iterator, String rest) {
            this.iterator = iterator;
            this.strRest = rest;
        }

        KeyValuePair getNext() {
            if (this.iterator != null && this.iterator.hasNext()) {
                return (KeyValuePair)this.iterator.next();
            }
            return null;
        }
    }
}

