@echo off

:: User variables. Adapt to your environment
set HOST=[hostname]
set PORT=7500
set EXPORT_PATH=/tmp
set VERBOSE=false

:: Set env variables. Do not change them
set CLASSPATH=./gdpr-ucsdata-9.0.0.jar
set CLASSPATH=%CLASSPATH%;./lib/commons.jar
set CLASSPATH=%CLASSPATH%;./lib/connection.jar
set CLASSPATH=%CLASSPATH%;./lib/contactsprotocol.jar
set CLASSPATH=%CLASSPATH%;./lib/guava.jar
set CLASSPATH=%CLASSPATH%;./lib/jackson-annotations.jar
set CLASSPATH=%CLASSPATH%;./lib/jackson-core.jar
set CLASSPATH=%CLASSPATH%;./lib/jackson-databind.jar
set CLASSPATH=%CLASSPATH%;./lib/jackson2-module.jar
set CLASSPATH=%CLASSPATH%;./lib/kvlistbinding.jar
set CLASSPATH=%CLASSPATH%;./lib/kvlists.jar
set CLASSPATH=%CLASSPATH%;./lib/netty.jar
set CLASSPATH=%CLASSPATH%;./lib/openmediaprotocol.jar
set CLASSPATH=%CLASSPATH%;./lib/protocol.jar
set CLASSPATH=%CLASSPATH%;./lib/system.jar

if [%1]==[] GOTO :usage

java -classpath %CLASSPATH% com.genesyslab.eservices.gdpr.InteractionExportManager %*
GOTO :end

:usage
echo Usage:
echo     Search contact either by specifying a list of contacts Id in between double quotes and separated with a comma.
echo     Example:
echo          %0 "contactId1,contactId2"
echo     or use a json string to search by any other attributes, like email address.
echo.
echo     Example:
echo          %0 "{\"TenantId\":101,\"EmailAddress\":\"foo@bar.com\"}"
echo.
echo     Use -count option to estimate numbers of contacts and interactions/contact
echo     Example:
echo          %0 contactId1 -count
echo          %0 "{\"TenantId\":101,\"EmailAddress\":\"foo@bar.com\"}" -count
echo.

:end


