package com.genesyslab.gax.sampledb.entities;


import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import javax.validation.constraints.Size;
import com.genesyslab.gax.common.base.BaseEntity;

/*
 * persistence entity extends from @BaseEntity, which has tenantId, name implemented.
 * implements Comparable to be used in Collection
 */
@Entity
@Table(name="sample_test")
public class SampleTest extends BaseEntity implements Comparable<SampleTest> {

	@Id
	@GeneratedValue(strategy = GenerationType.TABLE, generator = "table_gen")
	@TableGenerator(name = "table_gen", table = "sequence_table", pkColumnName = "seq_name", valueColumnName = "seq_count", pkColumnValue = "sample_test_seq", allocationSize = 1, initialValue = 10000)
	private Long id;
	
	@Transient
	private String tenantName;
	
	public Long getId() {
		return this.id;
	}
	
	public void setId(Long id) {
		this.id = id;
	}
	
	@Size(max = 255)
	private String description;
	
	public String getDescription() {
		return this.description;
	}
	
	public void setDescription(String description) {
		this.description = description;
	}
	
	public String getTenantName() {
		return tenantName;
	}

	public void setTenantName(String tenantName) {
		this.tenantName = tenantName;
	}
	
	@Override
	public int compareTo(SampleTest st) {
		return this.getName().toLowerCase().compareTo(st.getName().toLowerCase());
	}

}
