package com.genesyslab.gax.sampledb.main;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.genesyslab.gax.api.base.BaseGaxPlugin;
import com.genesyslab.gax.api.communication.CommunicationService;
import com.genesyslab.gax.api.database.DefaultDatabaseInspectorImpl;
import com.genesyslab.gax.common.annotation.BaseURL;
import com.genesyslab.gax.common.database.DatabaseInspector;

@Service
@BaseURL("/sampledb")
/*
 * use the same bean name as gax-sample-plugin, but since we use our own name-generator, it is fine.
 */
public class SamplePlugin extends BaseGaxPlugin {
	private final static String PLUGIN_NAME = "gax-sample-db";
	//make sure that you use the same DB_MODULE_NAME in database.DB_SCHEMA_VERSION
	private final static String DB_MODULE_NAME = "sample";
	
	@PersistenceContext(unitName = "gax-sample-db")
	private EntityManager em;
	
	@Autowired
	private CommunicationService serviceLocator;
	
	@Autowired
	private SampleDBInformationProvider sampleDBInfoProvider;
	
	SamplePlugin() {
		super(PLUGIN_NAME);
	}

	@Override
	/*
	 * initialization logic should implemented here.
	 * If init() returns ‘true’, the plugin will be in the ‘Service’ state. 
	 * If it returns ‘false’, the plugin will be in the ‘Out of Service’ state, and no http request will be routed
	 * (non-Javadoc)
	 * @see com.genesyslab.gax.api.base.BaseGaxPlugin#init()
	 */
	/*
	 * register InformationProvider for other plugins to use
	 * (non-Javadoc)
	 * @see com.genesyslab.gax.api.base.BaseGaxPlugin#init()
	 */
	public boolean init() {
		serviceLocator.registerService("SampleDBResourceService", sampleDBInfoProvider);
		System.out.println("sample db plugin initialized");
		return true;
	}
 
	@Override
	/*
	 * If it returns ‘true’, the plugin will be in the ‘Service’ state. 
	 * If it returns ‘false’, the plugin will be in the ‘Out of Service’ state, and no http request will be routed
	 * (non-Javadoc)
	 * @see com.genesyslab.gax.api.base.BaseGaxPlugin#checkDatabase(java.lang.String)
	 */
	public boolean checkDatabase(String version) {
		DatabaseInspector verifier = new DefaultDatabaseInspectorImpl(em, PLUGIN_NAME,
				DB_MODULE_NAME);
		return verifier.checkSchemaVersion(version);
	}
}
