package com.genesyslab.gax.sampledb.service;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.genesyslab.gax.api.communication.CommunicationService;
import com.genesyslab.gax.common.cfg.dto.TenantDao;
import com.genesyslab.gax.common.cfg.dto.TenantDto;
import com.genesyslab.gax.sampledb.dao.SampleTestDao;
import com.genesyslab.gax.sampledb.entities.SampleTest;

/**
 * plugin service implementation using database DAO
 *
 */
@Service
public class SampleDBServiceImpl implements SampleService {

	private final Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private SampleTestDao sampleTestDao;
	
	@Autowired
	protected TenantDao tenantDao;
	

	
	@Override
	/*
	 * find all entities
	 * (non-Javadoc)
	 * @see com.genesyslab.gax.sampledb.service.SampleService#findAll()
	 */
	public List<SampleTest> findAll() {
		List<SampleTest> res = new ArrayList<SampleTest>();
		for(SampleTest st: sampleTestDao.findAll()) {
			res.add(st);
		}
		populate(res);
		return res;
	}
	
	/*
	 * add tenant name to the entity
	 */
	private void populate(List<SampleTest> params) {
		for (SampleTest param : params) {
			TenantDto tenant = tenantDao.load(param.getTenantId());
			if (tenant != null) {
				param.setTenantName(tenant.getName());
			}
		}
	}
	
	@Override
	/*
	 * find an entity by ID
	 * (non-Javadoc)
	 * @see com.genesyslab.gax.sampledb.service.SampleService#findById(long)
	 */
	public SampleTest findById(long id) {
		SampleTest st = sampleTestDao.findOne(id);
		if(st!=null) {
			TenantDto tenant = tenantDao.load(st.getTenantId());
			if (tenant != null) {
				st.setTenantName(tenant.getName());
			}
		}
		return st;
	}

	@Override
	/*
	 * create an entity
	 * (non-Javadoc)
	 * @see com.genesyslab.gax.sampledb.service.SampleService#create(com.genesyslab.gax.sampledb.entities.SampleTest)
	 */
	public SampleTest create(SampleTest input) {
		input = sampleTestDao.save(input);
		return input;
	}

	@Override
	/*
	 * update an entity
	 * (non-Javadoc)
	 * @see com.genesyslab.gax.sampledb.service.SampleService#update(com.genesyslab.gax.sampledb.entities.SampleTest)
	 */
	public SampleTest update(SampleTest input) {
		input = sampleTestDao.save(input);
		return input;
	}
}
