define([
    "underscore",
    "gax",
    "./model",
    "../nls/lk"
], function (_, gax, Model, lk) {
    "use strict";
    return gax.widgets.TenantTreePanel.extend({
        options: _.defaults({
            title: "Sample DB",
            itemRequest: "details:sampledb.detail",
            treeNodeName: lk.titles.SAMPLE_NAME,
            readItems: function () {
            	return Model.prototype.readAll();
            }
        }, gax.widgets.TenantTreePanel.prototype.options),
        _getColumns: function () {
            return [
                { id: "description", name: lk.titles.SAMPLE_DESCRIPTION, field: "description", width: 150 }
            ];
        }
    });
});
