package com.genesyslab.gax.sample.main;

import org.springframework.stereotype.Service;

import com.genesyslab.gax.api.base.BaseGaxPlugin;
import com.genesyslab.gax.common.annotation.BaseURL;

@Service
/*
 * @BaseURL is used as the namespace for plugin API.
 * you can access your API through
 * http://host:port/gax/api/{BaseURL}
 */
@BaseURL("/sample")
public class SamplePlugin extends BaseGaxPlugin {
	/* 
	 * plugin name
	 * used: http://host:port/gax/api/plugins/{PLUGIN_NAME}
	*/
	private final static String PLUGIN_NAME = "gax-sample";

	/*
	 * default constructor pass the plugin name
	 */
	SamplePlugin() {
		super(PLUGIN_NAME);
	}

}
