package com.genesyslab.gax.sample.web;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import com.genesyslab.gax.api.communication.CommunicationService;
import com.genesyslab.gax.api.communication.ObjectInformation;
import com.genesyslab.gax.api.communication.ObjectMap;
import com.genesyslab.gax.api.communication.SimpleInformation;
import com.genesyslab.gax.common.communication.Information;
import com.genesyslab.gax.sample.service.SampleService;

@Controller
@RequestMapping(value="/sample")
/**
 * 
 * spring MVC based controller
 */
public class SampleController {
	@Autowired
	SampleService sampleService ;
	
	@Autowired
	private CommunicationService serviceLocator;
	
	@RequestMapping(value ="sayhello/{name}", method=RequestMethod.GET)
	public @ResponseBody String getHello(@PathVariable String  name){
		return sampleService.sayHello(name);
	}

	/*
	 * cross plugin communication. 
	 */
	@RequestMapping(value ="crossplugin/itemCount", method=RequestMethod.GET)
	public @ResponseBody Integer itemCount(@RequestParam("tenantid") Integer[] tenantid){
		Information info = new ObjectInformation(tenantid);
		info.getHeader().put("RequestMethod", "readByTenantId");
		ObjectInformation response = (ObjectInformation) serviceLocator.requestService("gax-sample-db",
				"SampleDBResourceService", info);
		if (response != null) {
			List<ObjectMap> items = (List<ObjectMap>) response.getBody();
			return items.size();

		}
		return 0;
	}
}

