define([
    "module",
    "./panel",
    "text!./pluginhome.html",
    "../nls/lk"
], function (module, Panel, template, lk) {
    "use strict";
    return {
        name: "PluginHome",
        extensions: [{
            id: "panel:plugin.home",
            panel: Panel
        }, {
            id: "stylesheets",
            baseUrl: module.uri,
            stylesheets: [ "pluginhome.css" ]
        }, {
            id: "pluginhome:template",
            lang: "",
            template: template
        }, {
            id: "nav:category",
            extension: function () {
                return {
                    name: "pluginbutton",
                    title: lk.titles.HELLOWORLD_CATEGORY,
                    icon: "",
                    category: "operations"
                };
            }
        }, {
            id: "nav:item",
            extension: function () {
                return {
                    category: "pluginbutton",
                    target: "panel:plugin.home",
                    title: lk.titles.HELLOWORLD_ITEM,
                    icon: ""

                };
            }
        }]
    };
});
