define([
    "underscore",
    "gax",
    "../nls/lk"
], function (_, gax, lk) {
    "use strict";
    return gax.widgets.Panel.extend({
        options: _.defaults({
            width: 600,
            contentPadding: true
        }, gax.widgets.Panel.prototype.options),
        initialize: function () {
            this.options.title = lk.titles.PLUGIN_HOME;
            gax.widgets.Panel.prototype.initialize.call(this);
        },
        render: function () {
            gax.widgets.Panel.prototype.render.call(this);

            var lang = gax.preferences.get("locale/language");

            var template = gax.registry.getAll("pluginhome:template")
                // Filter by selected language
                .filter(function (template) {
                    return lang.indexOf(template.lang || "") === 0;
                })
                // Sort in order of decreasing specificity
                .sort(function (a, b) {
                    return b.lang.localeCompare(a.lang);
                })[0].template; // Pick first

            this.append({
                type: "Html",
                html: _.template(template, lk),
                padding: true
            });

            return this;
        }
    });
});
