<%@ page language="java" buffer="none" contentType="text/html; charset=utf-8" %>
<%@ page import="java.io.BufferedReader" %>
<%@ page import="java.io.IOException" %>
<%@ page import="java.io.StringReader" %>
<%@ page import="java.text.DateFormat" %>
<%@ page import="java.util.Date" %>
<%@ page import="java.util.Locale" %>
<%@ page import="java.util.Vector" %>
<%@ page import="com.genesyslab.ail.Agent" %>
<%@ page import="com.genesyslab.ail.AilFactory" %>
<%@ page import="com.genesyslab.ail.AilLoader" %>
<%@ page import="com.genesyslab.ail.Contact" %>
<%@ page import="com.genesyslab.ail.ContactManager" %>
<%@ page import="com.genesyslab.ail.InteractionOpenMedia" %>
<%@ page import="com.genesyslab.ail.Place" %>
<%@ page import="com.genesyslab.ail.WorkflowStatus" %>
<%@ page import="com.genesyslab.ail.exception.RequestFailedException" %>
<%@ include file="../../extension/common/util.jsp" %>
<%
    AilFactory factory = AilLoader.getAilFactory();
    InteractionOpenMedia openMedia = (InteractionOpenMedia) factory.getInteraction(request.getParameter("idInteraction"));

    String strContactFirstName = "";
    String strContactLastName = "";
    String idContact = openMedia.getContactId();
    ContactManager contactMgr = factory.getContactManager();
    if (contactMgr != null) {
        try {
            Vector contactAttributes = new Vector();
            contactAttributes.addElement(contactMgr.getFirstNameAttribute());
            contactAttributes.addElement(contactMgr.getLastNameAttribute());
            contactAttributes.addElement(contactMgr.getEmailAddressAttribute());
            contactAttributes.addElement(contactMgr.getPhoneNumberAttribute());

            Contact contact = contactMgr.getContact(idContact, contactAttributes);
            if (contact != null) {
                strContactFirstName = contact.getFirstName();
                strContactLastName = contact.getLastName();

                if ( (strContactFirstName.equals("")) && (strContactLastName.equals("")) ) {
                    strContactFirstName = contact.getPrimaryEmailAddress();
                    if (strContactFirstName.equals(""))
                        strContactFirstName = contact.getPrimaryPhoneNumber();

                }
            }

        } catch (RequestFailedException exp) {
        }
    }

    String strAgentName = openMedia.getUserName();
    String strMediaType = openMedia.getOpenMediaType();
    String strInteractionType = openMedia.getOpenInteractionType();
    String strInteractionSubType = openMedia.getOpenInteractionSubType();
    String strSubject = openMedia.getSubject();

    Date date = openMedia.getDateCreated();
    Locale locale = (Locale)session.getAttribute("regionalSettingsLocale");
    DateFormat df = DateFormat.getDateTimeInstance(DateFormat.LONG, DateFormat.LONG, locale);
    String strDate = null;
    if (date != null)
        strDate = df.format(date);
    else
        strDate = "";

    String workflowStatusLabel = "";
    String userName = (String)request.getParameter("userName");
    if ( (userName != null) && !(userName.equals("")) ) {
        Agent agent = (Agent) factory.getPerson(userName);
        if (agent != null) {
            Place place = agent.getPlace();
            if (place != null) {
                WorkflowStatus wStatus = place.getInteractionWorkflowStatus(openMedia);
                switch (wStatus.getStatus().toInt()) {
                     case WorkflowStatus.Status.HANDLING_:
                       workflowStatusLabel = "Handled by an agent";
                       break;
                     case WorkflowStatus.Status.QUEUED_:
                       workflowStatusLabel = "Queued";
                       break;
                     case WorkflowStatus.Status.QUEUED_IN_A_WORKBIN_:
                       workflowStatusLabel = "In a workbin";
                       break;
                     case WorkflowStatus.Status.ROUTING_:
                       workflowStatusLabel = "Routing";
                       break;
                     case WorkflowStatus.Status.STOPPED_:
                       workflowStatusLabel = "Stopped";
                       break;
                     case WorkflowStatus.Status.UNKNOWN_: 
                       workflowStatusLabel = "";
                       break;
                     default:
                       workflowStatusLabel = "";
                }
            }
        }
    }

    String strText = openMedia.getText();
    if ( (strText == null) || (strText.equals("")) )
        strText = "&nbsp;";

    /*String attachedFiles = "";
    Iterator attachments = SortCollection.sort(openMedia.getAttachments(),"getFilename").iterator();
    AttachedFileForm attach;
    String idxFile = null;
    String fileName;
    String contentType;
    String subStrContentType;
    int counter = 0;
    while(attachments.hasNext()) {
        attach = (AttachedFileForm)attachments.next();
        idxFile = attach.getIdAttachedFile();
        fileName = attach.getFilename();
        contentType = attach.getContentType();
        subStrContentType = "";
        if (9 <= contentType.length())
            subStrContentType = contentType.substring(0,9);
        if ( (idxFile == "-1") && (contentType != null) && ("text/html".equalsIgnoreCase(subStrContentType)) ) {
            fileName = Integer.toString(counter)+".html";
            counter++;
        } else if (idxFile == "-2") {
            int idxBegin = contentType.lastIndexOf("/");
            if (idxBegin != -1) {
                idxBegin += 1;
                int idxEnd = contentType.length();
                if (idxBegin < idxEnd) {
                    String fileExtension = contentType.substring(idxBegin, idxEnd);
                    fileName = fileName + "." + fileExtension;
                    counter++;
                }
            }
        }

        if ( (fileName != null) && !(fileName.equals("")) ) {
            if (attachedFiles.length() > 0)
                attachedFiles += "<br>";
            attachedFiles += "<a href='downloadAttachedFile.dow/" + URLEncoderEx.encode(fileName) + "?idFile="
                          + DownloadFileForm.createIdFile(DownloadFileForm.CONTAINER_TYPE_OPENMEDIA,openMedia.getIdInteraction(),attach.getIdAttachedFile())
                          + "' target='_blank' oncontextmenu='displayContextMenu=true;return true;'>" + fileName +"</a>";
        }
    }*/
%>
<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta http-equiv="imagetoolbar" content="no">
    <link rel="stylesheet" type="text/css" href="extension/generic/genericStyle.css"/>
    <script language="javascript">
      window.parent.includeGDFunctionalities(window);

      function custom_load() {
        activateGDFunctionalities();
      }

      function custom_unload() {
        unactivateGDFunctionalities();
      }
    </script>
  </head>
  <body class="extScrollBar extBackgroundRoundedPanel" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" onload="custom_load()" onunload="custom_unload()">
    <table width="100%" height="100%" border="0" cellpadding="0" cellspacing="0">
      <tr valign="top">
        <td class="extNotEditablePanelDarkShadow" width="1" align="left" rowspan="3"><img src="common/img/empty.gif"></td>
        <td class="extNotEditablePanelDarkShadow" height="1"><img src="common/img/empty.gif"></td>
        <td class="extNotEditablePanelLightShadow" width="1" align="right" rowspan="3"><img src="common/img/empty.gif"></td>
      </tr>
      <tr valign="top">
        <td class="extNotEditablePanelBackground" width="100%" align="left">
          <table class="extFontName" with="100%" border="0" cellpadding="0" cellspacing="0" vspace="0" hspace="0">
<%
    int nbRow = 12;
    if ( workflowStatusLabel != null && !"".equals(workflowStatusLabel) )
        nbRow = 13;
%>
            <tr height="5px"><td rowspan="<%= nbRow %>" width="5px"></td><td></td><td rowspan="12" width="5px"></td></tr>
            <tr height="18px"><td class="extNotEditablePanelText">Open Media Interaction</td></tr>
<%
    if ( workflowStatusLabel != null && !"".equals(workflowStatusLabel) ) {
%>
            <tr height="18px"><td class="extNotEditablePanelText">Workflow Status:&nbsp;<b><%=workflowStatusLabel%></b></td></tr>
<%
    }
%>
            <tr height="18px"><td class="extNotEditablePanelText">Subject:&nbsp;<b><%= stringToHtml(strSubject) %></b></td></tr>
            <tr height="18px"><td class="extNotEditablePanelText">Contact:&nbsp;<b><%= stringToHtml(strContactFirstName) %>&nbsp;<%= stringToHtml(strContactLastName) %></b></td></tr>
            <tr height="18px"><td class="extNotEditablePanelText">Agent:&nbsp;<b><%= stringToHtml(strAgentName) %></b></td></tr>
            <tr height="18px"><td class="extNotEditablePanelText">Open Media Type:&nbsp;<b><%= stringToHtml(strMediaType) %></b></td></tr>
            <tr height="18px"><td class="extNotEditablePanelText">Interaction Type:&nbsp;<b><%= stringToHtml(strInteractionType) %></b></td></tr>
            <tr height="18px"><td class="extNotEditablePanelText">Interaction Subtype:&nbsp;<b><%= stringToHtml(strInteractionSubType) %></b></td></tr>
            <tr height="18px"><td class="extNotEditablePanelText">Created Date:&nbsp;<b><%= stringToHtml(strDate) %></b></td></tr>
            <tr height="10px"><td></td></tr>
            <tr>
              <td>
                <table border="0" cellspacing="0" cellpadding="0" >
<%
    StringReader textReader = new StringReader(strText);
    BufferedReader textBufferedReader = new BufferedReader(textReader);
    try {
        String line = "";
        while (line != null) {
            line = textBufferedReader.readLine();
            if (line != null) {
                if (line.equals("")) {
%>
                  <tr><td class="extNotEditablePanelText" wrap>&nbsp;</td></tr>
<%
                } else {
%>
                  <tr><td class="extNotEditablePanelText" wrap><%= stringToHtml(line) %></td></tr>
<%
                }
            }
        }
    } catch (IOException ioexp) {
    }
%>
                </table>
              </td>
            </tr>
            <tr height="5px"><td></td></tr>
          </table>
        </td>
      </tr>
      <tr valign="bottom"><td class="extNotEditablePanelLightShadow" height="1"><img src="common/img/empty.gif"></td></tr>
    </table>
    <script language="javascript">
      var displayContextMenu = false;
      document.oncontextmenu = function(){
        var save = displayContextMenu;
        displayContextMenu = false;
        return save;
      }
    </script>
  </body>
</html>
