﻿profiles = new Array(
"Adding Terms| Home &gt; Managing Topics &gt; Defining a New Topic &gt; Adding Terms Adding Terms You can add terms to a Topic in one of the following ways: Manually typing terms, one at a time Pasting one or more terms from an external file, such as a Word or Excel file SMART allows you to check whether terms you have added also appear in other Topics, and lets you set custom Confidence requirements for terms. In addition, SMART notifies you if a term is too short to be accurately recognized. To manually add a term: In the Term field above the list of terms, type the term. Press Enter , or click the New button to the right of the text field. The term is added to the list. Term added to Topic To paste one or more terms: Copy one or more terms from an external file, such as a text file or a Word file. Each term should be in a separate paragraph in the original file. Right-click the Term field above the list of terms, and then click Paste . The last term in the list you pasted appears in the text field. Click the New button. All of the terms you pasted are added to the Topic list. Short Terms When you add a new term to a Topic, the system checks to see if the term is long enough to be accurately recognized in call audio. If it is not, a Too Short Terms warning message appears: Too Short Terms message The term is still added to the list, but a red icon ( ) identifies it as too short. Red icon identifying short term Although you can leave the short term in the list as it is, the system will not necessarily be able to recognize it in a call. If you can, add additional words to the term. You may even want to add a number of variations to the term. For example, if the term is can I refinance, you could modify it to can I refinance my loan, and also add in the variations can I refinance my mortgage and can I reschedule my payments. To modify a term that is too short: Click the term in the list. The term appears in the Term field above the list, and the New button to the right of the field become an Update button. In the Term field, modify the term by adding additional words to it. Click Update . The term is updated in the list. If you try to save a Topic that contains terms that are too short, the system notifies you of the existence of the short terms and asks you how to handle them. You can choose either to keep them as they are or to delete them. (You can restore deleted terms later if you wish; see Modifying a Topic .) Checking for Other Occurrences of Terms If you wish, you can include the same term in more than one Topic. If two Topics that contain the same term are linked to a single Program, the term is sought by SpeechMiner twice - once for each Topic - and, if it is found, it is marked twice. Nevertheless, you may wish to check whether an existing Topic already contains the same terms as those you have included in the Topic you are creating. If you find one, you may be able to use it, with or without modifications, instead of creating a new Topic. SMART can check to see if other Topics contain any of the terms that are in the current Topic, in one of the following ways: Checking each term as you enter it into the list Checking all of the terms whenever you choose to do so Checking the entire database of Topics for duplicate terms can require significant system resources. If you choose to check each term as you enter it, you may have to wait a while before you can enter the next term or perform other SMART actions. Checking all of the terms at once may therefore be more efficient. To check each term as you enter it: In the term-list controls, select the Check Similar checkbox. Any terms you add when this option is selected are checked before they are inserted into the list. Terms that are duplicated elsewhere are still inserted into the list, but a flag ( ) is inserted beside them and they are displayed in blue text until you perform another action. Duplicated term To check all of the terms that are currently in the list: In the term-list controls, click the Check Similar button. The terms in the list are checked one by one. A flag ( ) is inserted beside each duplicated term, and they are displayed in blue text until you perform another action. Regardless of which method you used to check for duplicate terms, you can see information about which Topics contain the duplicates. To see which other Topics contain a duplicate term: Place your mouse pointer on the flag beside the term. A screen tip displays the details. Information about a duplicate term Customizing the Strictness of a Term By default, each of the terms in a Topic are assigned the Strictness value that is assigned to the Topic (in the Topic's properties). You can change the Strictness values of individual terms if you wish. When the Strictness of a term has been customized, the custom level appears beside the term. Term with a custom Strictness value To set a custom Strictness value for a term: In the term list, select the term. The Set Strictness button ( ) becomes active. Click the Set Strictness button. The Term Strictness dialog box opens. Term Strictness dialog box Select Custom . A value field opens. Value field added to dialog box Specify the required Strictness value Click OK . The custom Strictness value is set for the term. See also Creating a Blank Topic Marking Keywords Saving the Topic ||adding_phrases.htm","Adding Topics| Home &gt; Managing Programs &gt; Defining a New Program &gt; Adding Topics Adding Topics A Program is essentially a list of recognition tasks that SpeechMiner must perform on calls that belong to the Program. The recognition tasks are lists of audio data that SpeechMiner should try to identify in the calls: Topics and non-linguistic data. When a Program is created, the Non Linguistics recognition task is automatically added to the Program and cannot be removed. This means SpeechMiner always tries to identify non-linguistic data in the calls it processes. When speech recognition is enabled for a Program, Topics can also be included in it as recognition tasks. The Topics included in the recognition tasks of a Program define the linguistic data that SpeechMiner should look for in calls that belong to the Program. You must add the Topics to the Program manually. You can add multiple Topics to a single Program. Note: The Topics must be defined before you can add them to a Program. However, you can change their contents after you add them to a Program. The Topic contents that are defined when the Program is applied are the ones that will be sought by SpeechMiner in calls belonging to the Program. For information about creating and modifying Topics, see Managing Topics . Adding Recognition Tasks to a Program You can add one or more Topics to every Program. To add Topics to a Program: Make sure the Program is open in SMART (i.e., a tab for it appears in the right panel of the SMART window) and is selected (i.e., it is displayed in the right panel - no. 5 in the illustration below). In the left panel, select the Topics tab (no. 1 below). An expandable list of the currently defined recognition tasks is displayed in the tree structure. Select the Topics you want to add to the Program. If you want to select multiple Topics, hold down the Ctrl key and click each of the Topics, or, to select a range of Topics, hold down the Shift key and click the first and last Topic in the range. You can also select a folder to include all of the Topics it contains (no. 4 below). The number of selected Topics is displayed in the tree-list controls above the tree structure (no. 2 below). In the tree-list controls, click the button (no. 3 below). The selected Topics are added to the Program. They appear in the right panel in the Content tab (no. 6 below) and in the structure diagram (no. 7 below). Adding Topics to a Program Removing Topics from a Program You can remove Topics from a Program as necessary. To remove Topics from a Program: In the right panel, in the Contents tab, select the Topics you want to remove. To select multiple recognition tasks, hold down the Ctrl key and click each of the Topics. Press Delete . The Topics are removed from the Program. See also Creating a Blank Program Managing the Program Structure Using Notes Saving and Activating the Program ||adding_topics_and_scripts.htm","Applying Changes| Home &gt; Applying Changes Applying Changes As you add and modify definitions in SMART, you save your changes within SMART, but the definitions in SpeechMiner are not changed. In order to implement your changes in SpeechMiner, you must apply them in SMART. Applying changes can be done in a number of ways: Apply All: Applies all changes to Programs, Topics, and Categories, and reprocesses the calls using the new definitions Apply Programs, Topics, and Scripts: Applies all changes to Programs and Topics (Scripts are not supported in this version of SpeechMiner), and reprocesses the calls using the new definitions Apply Categories: Applies all changes to Categories, and reprocesses the calls using the new definitions Recategorize calls only: Does not apply any changes from SMART to SpeechMiner, but reprocesses the calls in SpeechMiner using the latest set of Category definitions that was already applied. Note: Applying changes to Categories does not affect manual Categories; any items that SpeechMiner users assigned to a manual Category remain assigned to it even after changes to Categories are applied. When you choose to apply changes to SpeechMiner, SMART checks the SMART database for changes, and lists all of the changes that were made since the last time changes were applied. You can choose which of the changes you want to apply. In addition, SMART checks each of the changes in the list to ensure that it is ready to be applied, and marks all problematic items. For example, if it discovers Programs that contain locked Topics, it indicates which Programs they are and which Topics are locked. Some types of problems must be corrected before you can apply the problematic items, while others can be ignored if you choose. You cannot apply items that are locked by other users unless you have permissions to do so and explicitly choose to override the lock. (For additional information about locking items, see Locking and Unlocking Items .) In most systems, SMART allows you to save backup copies of the existing definition set in SpeechMiner before applying any changes. If you do this, you can later choose to roll back the definition set to an older set, if necessary. For additional information, see Managing Version History . To apply changes to SpeechMiner: Make sure no windows are open in the right panel. In the Quick Access Bar below the main menu, click ( Apply ). The Apply dialog box opens. SMART begins to review all of the changes that were made to the system since it was last applied. During this validation process, the message Loading definitions to apply. Please wait... appears at the bottom of the dialog box. The process may take a few minutes. When SMART has finished validating the definitions, it displays a list of all of the changes it found. Under Status , a marks items that are ready to be applied, a identifies problematic items that may require your attention but can be applied if you choose to apply them, and a identifies items that cannot be applied. If there are problems that require correction before you apply the changes, close the dialog box and correct the problems. Then, open the dialog box again, as described above. If you want to save a backup copy of the existing set of definitions in SpeechMiner before the new set is applied, select Backup apply, comment . (In some systems, this option is always implemented, or not available.) Modify the text field below the option as required, to specify the comment that will be attached to the backup. If you do not want to apply a particular item, in the Apply column, clear the checkbox. (The checkbox is not available for items that cannot be applied.) At the bottom of the dialog box, select the type of changes to apply: Apply All , Apply Programs, Topics, and Scripts , Apply Categories , or Recategorize Calls Only . (See above for information about these options.) Click Apply . You are prompted to confirm that you want to apply the changes. Click Yes . The process of applying the changes begins. The process may take a few minutes. When it is completed, a Done message appears, and the list of changes in the Apply dialog box is blank. See also Welcome Overview Managing Topics Managing Programs Managing Categories Managing Version History Exporting and Importing ||applying_changes.htm","Auditing a Topic| Home &gt; Managing Topics &gt; Auditing a Topic Auditing a Topic As SpeechMiner processes calls, you may want to check how well the the terms it contains represent the intent of the Topic and how accurately SMART identifies the terms in calls. You can use this information to fine-tune the terms in the Topic. You can do this in two ways: Run the Topic Analysis - Audits report to see information about the precision with which Topics, and the terms they contain, were identified by SpeechMiner View statistical data about each term in the Topic, including information about how often the term was recognized by SpeechMiner and summary data of term audits    See also Running the Topic Analysis - Audits Report Viewing Term Statistics Creating an Effective Topic Overview of the Topic-Manager Interface Defining a New Topic Modifying a Topic Managing Secured Topics Deleting Topics ||auditing_a_topic.htm","Call Classification: Categories| Home &gt; Overview &gt; Call Classification: Categories Call Classification: Categories Call classification takes place after call audio is analyzed and Events are identified. During call classification, Events and metadata are used to assign one or more Categories to calls. The Category classification enables SpeechMiner to find calls with specific characteristics when users request them and to perform statistical analysis on groups of calls based on their characteristics. Categories are defined and managed in SMART using a variety of criteria: Events: Information about the types of Events that were found in calls during call analysis Call content: Text that is found in the transcripts of calls that are generated by SpeechMiner during call processing Metadata: Information about calls that was received from the recording system, such as the name of the agent or call center Program information: The name and type of Program that was used to analyze the call Other Categories: Information about other Categories that are already assigned to the call Categories are defined globally for the entire SpeechMiner implementation and are automatically assigned to calls during processing. When changes are made to Category definitions, the entire database of calls is re-Categorized to ensure the Category assignments of all calls match the new definitions. SpeechMiner also supports manual Categories. Manual categories are created and named in SMART but they do not have any conditions assigned to them in SMART. Calls are assigned to these Categories manually by SpeechMiner users when they review them. For example, a manual category called For Review could be defined in SMART and then used by managers to create a group of calls that require additional handling. In order to make it easier to manage large numbers of Categories, they can be grouped hierarchically into parent Categories and sub-Categories. For example, a parent Category could be used to group a number of Categories that are relevant to a particular sales campaign. If a call is assigned to a sub-Category, it is automatically also assigned to its parent Category. See also Programs Events: Topics and Non-Linguistic Data Language Support Overview of the Interface Typical Workflows ||categories__events__and_metadata.htm","Configuring Category Conditions| Home &gt; Managing Categories &gt; Defining a New Category &gt; Configuring Category Conditions Configuring Category Conditions A call is assigned to a regular Category if it meets the conditions that are defined for inclusion in the Category. The conditions can include a wide variety of call characteristics, including the Program the call belongs to, Topics that were recognized in it, non-linguistic Events that were detected in it, its metadata properties, and even other Categories to which it belongs. Logical Expressions Configuring Category conditions is performed by defining a logical expression for SpeechMiner to evaluate. If the logical expression is evaluated as True for a particular call, the call is assigned to the Category. Logical expressions can consist of one or more elements. Each element is a statement, such as Date Of Call&gt;1/19/2010 or Found topic Reduction at least once with Low Strictness . If a logical expression contains one element, it is True whenever the condition defined in the element is true. For example, if a logical expression contains the element Date Of Call&gt;1/19/2010 , it is True for any call whose metadata indicates that it took place on or after 1/19/2010. Logical expressions can also contain multiple elements. When they do, the elements must be related to one another by logical operators, such as AND and OR. For example, Date Of Call&gt;1/19/2010 AND Found topic Reduction at least once with Low Strictness is a logical expression that indicates both conditions must be met - the Topic must be found and the call must have taken place in the specified time period - in order for the expression to be evaluated as True and the call to be assigned to the Category. The following operators can be used in logical expressions: Operator Description AND Both conditions must be met in order for the expression to be evaluated as True OR At least one of the conditions must be met in order for the expression to be evaluated as True NOT The expression should be evaluated as True only when the condition is not met. ( Opens a group of conditions that are evaluated as a unit ) Closes a group of conditions that are evaluated as a unit -&gt; Conditional AND: Both conditions must be met, but the second condition is dependent in some way on the first (e.g., the second must occur within 30 seconds of the end of the first); this operator is used in conjunction with the Secs Rel to Start of Prev or the Secs Rel to End of Prev position setting Logical expressions can be quite complex, containing a number of elements, various logical operators, and parentheses, if necessary. For example: (Date Of Call&gt;1/1/2011 AND Date Of Call&lt;1/30/2011 AND Found topic Payment Locations at least once with Low Strictness) OR (Date Of Call&gt;1/31/2011 AND ( Found topic Time Frame at least once with Low Strictness OR Found topic Payment Locations at least once with Medium Strictness )) means the call should be assigned to the Category if it took place between Jan. 1st and Jan. 30th and the Topic Reduction was found, or if the call took place Jan. 31st or later and either the Topic Time Frame or the Topic Payment Locations was found. Defining Logical Expressions The logical expressions that are used as Category conditions are configured by adding elements and logical operators to the expression. Inserting Elements into an Expression Elements of the following types can be included in the logical expression: Call metadata Non-linguistic Event information about the call The Program to which the call belongs Topics that were or were not found in the call Other Categories to which the call belongs Whether or not a speaker of a particular type (e.g., agent, supervisor) participated in the call (not available in all systems) To add an element to the logical expression: If you want to insert the element at the end of the expression, in the lower part of the right panel, click to clear all existing selections. Otherwise, select the element in the expression before which you want to insert the new element. Under Type , select the type of element you want to add to the expression. The fields required to select and configure the element are added to the right panel below the Type field. For information about the settings and options of each type of element, see: Configuring Metadata Elements Configuring Non-Linguistic Event Elements Configuring Program Elements Configuring Topic Elements Configuring Category Elements Configuring Speaker-Type Elements Configuring Text Elements Click Add . The element is inserted into the expression. Inserting Operators into an Expression You can add logical operators (see above ) to the expression as necessary to define the relationships between the elements of the expression. Note: There is no precedence among the logical operators in an expression. For example, NOT does not take precedence over AND, as it may in other environments. Thus, NOT A AND NOT B does not mean the same as (NOT A) AND (NOT B); rather it means the same as NOT (A AND NOT B) . For this reason, it is important to use parentheses to ensure that the operators define the condition as you intend them to. By contrast, the internal Not , which is an element property, always relates just to the element that follows it. Thus, Not A AND Not B does mean the same as (NOT A) AND (NOT B) . Inserting AND, OR, NOT, and Conditional AND Operators into an Expression AND, OR, NOT, and Conditional AND ( -&gt; ) define the relationship between two consecutive elements in an expression. You can add these operators to an expression as required. To insert AND, OR, NOT, or Conditional AND into an expression: Click the second of the two consecutive elements. The element is selected. At the top of the dialog box, click the required operator. The operator is inserted into the expression before the selected element. Inserting Parentheses into an Expression Parentheses can be inserted into an expression to group elements together for evaluation as a single unit. Complex expressions often require parentheses to break them into smaller expressions so that the relationships between the expressions are clear. For example, if a Topic must be found in calls handled by one of two agents, and you wrote Workgroup?Agent=workgroup 1/agent a OR Workgroup?Agent=workgroup 1/agent b AND Found topic Reduction at least once with Low Strictness it would not be clear whether the Topic must be found in calls handled by both agents or only in calls handled by agent b . If you add parentheses like this ( Workgroup?Agent=workgroup 1/agent a OR Workgroup?Agent=workgroup 1/agent b) AND Found topic Reduction at least once with Low Strictness the Topic would have to be found in calls handled by one of the agents. But if you write Workgroup?Agent=workgroup 1/agent a OR (Workgroup?Agent=workgroup 1/agent b AND Found topic Reduction at least once with Low Strictness) the Topic would only be required in calls handled by agent b. To insert parentheses into an expression: Click the first element that you want to include in the parentheses. The element is selected. At the top of the dialog box, click ( . A ( is inserted into the expression before the selected element. Click the element or operator after the last element you want to include in the parentheses. If the element you want to include is the last element in the expression, do not select any items in the expression. At the top of the dialog box, click ) . A ) is inserted into the expression after the last element of the expression. Defining a Negative Condition A negative condition is a condition that must not be met if an expression is to be evaluated as True. For example, a condition that states that a call must not have taken place in the month of January is a negative condition. Negative conditions can be specified for a single element of an expression or a group of elements that are contained in parentheses. Two methods are available for creating a negative condition for a single element: Insert a NOT operator before the element. Select the Not or Not found option in the element's conditions. In the following two illustrations, a negative condition is created in each of these ways. The meanings of the two conditions are identical: the condition is True as long as the date is not on or before January 1st, 2011. Negative condition created using the NOT operator Negative condition created using the Not option An expression containing multiple elements can only be marked as a negative condition using the NOT operator. For example, in the illustration below, the NOT operator is attached to a multi-element condition. The condition is True for all workgroups except workgroup 1 and workgroup 4. NOT operator used to create a negative condition with multiple elements To insert a NOT operator before an element or expression: If the condition is an expression that contains multiple elements, make sure it is contained in parentheses. In the expression area of the Category definition, select the element or expression. At the top of the expression area, click Not . A NOT operator is added to the condition before the selected item. To select the Not option for an element: If the properties of the element are not displayed, in the expression area of the Category definition, select the element. In the condition area below the expression area, select Not . Click Add or Update to add or update the negative element in the expression area. Copying an Expression from Another Category You can copy an expression from one Category and paste it into another Category. After you paste the expression, you can edit it as necessary, just as you would edit any other expression (see Modifying a Category ). To copy an expression from one Category to another: In the source Category, at the top-right of the dialog box, click Copy . In the target Category, at the top-right of the dialog box, click Paste . The condition expression from the source appears in the expression area of the target. See also Creating a Blank Category Saving and Activating the Category ||configuring_the_category.htm","Configuring Category Elements| Home &gt; Managing Categories &gt; Defining a New Category &gt; Configuring Category Conditions &gt; Configuring Category Elements Configuring Category Elements A Category element specifies that a call must (or must not) belong to another Category in order for the call to be assigned to the Category that is currently being configured. When you add a Category element to an expression (see  Inserting Elements into an Expression ), the fields required to select and configure the element are added to the right panel below the Type field. You can use these fields to select the Category and indicate if the call must belong to the Category or must not belong to the Category in order to meet the requirements of the current Category. Sub-Categories appear in the list of available Categories as separate Categories, and their parent Categories are indicated. For example, a Category called Adjustments that is a sub-Category of a Category called Bill Inquiry appears in the list of Categories as Bill Inquiry/Adjustments . Although you can create circular Category references, the Categories in which they appear cannot be applied to SpeechMiner. For example, if Category A is an element of the expression that defines Category B, Category B cannot also be an element of the expression that defines Category A. If they are, the circular references are indicated in the Apply dialog box, in the Message column of each Category. For additional information about applying changes to SpeechMiner, see Applying Changes .  Note: Including a Category element in the expression that defines a Category is not the same as making one a sub-Category of the other. For additional information about sub-Categories, see Managing Categories . To add a Category element: Under Category , select the Category. If you want the condition to include all calls except those that belong to the Category, select Not . (For additional information, see Configuring Category Conditions .)  See also Configuring Metadata Elements Configuring Non-Linguistic Event Elements Configuring Program Elements Configuring Topic Elements Configuring Speaker-Type Elements Configuring Text Elements ||configuring_category_elements.htm","Configuring Metadata Elements| Home &gt; Managing Categories &gt; Defining a New Category &gt; Configuring Category Conditions &gt; Configuring Metadata Elements Configuring Metadata Elements Metadata is information about calls that is gathered by the external recording system and relayed to SpeechMiner along with the call audio. Each system receives different sets of information about the calls that are passed to it for processing. For example, metadata could include the name of the agent for each call, the location of the customer, and the duration of the call. You can define metadata conditions based on any of the metadata values available in your system. The conditions you define can be as simple as one metadata value or complex expressions that specify the relationships among a number of types of metadata. Consider, for example, a sales campaign that is undertaken in Wyoming and in Texas. Certain agents in each location target senior citizens, while others target families with teenage children. To assign senior-citizen calls to a Category, you could define a condition that specifies either Agent1 or Agent2 if the customer is in Wyoming and Agent3 if the customer is in Texas. When you add a metadata element to an expression (see Inserting Elements into an Expression ), the fields required to select and configure the element are added to the right panel below the Type field. To configure a metadata element:   In the first field, specify the type of metadata. You can specify the type in one of two ways If the type appears in the dropdown list, select it. For example, select Workgroup?Agent if you want to define a condition based on the workgroup or agent that handled the call. Type the name of the type in the field. For example, if your system gathers data on call direction under the name calldirection , type calldirection if that is the name of that type of metadata. In the remaining fields, specify the condition. In some cases, you can select an operator ( , or =) in the second field and specify a value in the third; in other cases, you only specify a value (and the = operator is assumed). You can specify a value by selecting it from the list or by typing it manually into the third text field. Note: Some of the value options may be arranged hierarchically. For example, if you select Workgroup?Agent , a list of workgroups is displayed. You can select a workgroup, or click the + beside the name of a workgroup to expand the list and display the names of the agents in the workgroup. If you select a workgroup, all members of the workgroup are included in the condition; if you expand a workgroup and select an agent, only that agent is included. If you want the condition to include all calls except those that match the condition, select Not . (For additional information, see Configuring Category Conditions .)   See also Configuring Non-Linguistic Event Elements Configuring Program Elements Configuring Topic Elements Configuring Category Elements Configuring Speaker-Type Elements Configuring Text Elements ||configuring_metadata_elements.htm","Configuring Non-Linguistic Event Elements| Home &gt; Managing Categories &gt; Defining a New Category &gt; Configuring Category Conditions &gt; Configuring Non-Linguistic Event Elements Configuring Non-Linguistic Event Elements Non-linguistic Events include various sounds that SpeechMiner detects in a call, such as busy tones, key presses, and music or noise. Depending on the Program settings of the call, non-verbal indications of agitation may also be detected. In addition, the non-linguistic Event called Cross Talk is identified when two speakers are talking at the same time. This type of Event can only be identified in systems in which dual-channel recording is employed. In some cases, an element can include more than one type of related Event. For example, you can select Silence , Busy Tone , and Dial Tone together, but you cannot select Agitation along with other types of Events. When you select multiple types of non-linguistic Events, if any of those Events is found in the call, it meets the condition. When you add a non-linguistic Event element to an expression (see Inserting Elements into an Expression ), the fields required to select and configure the element are added to the right panel below the Type field. You can use these fields to select the type of non-linguistic Event and specify what proportion of the call must contain this type of Event and when it must be detected in the call. To configure a non-linguistic Event element: Under Non Linguistics , select the type of non-linguistic Event. Other types of non-linguistic Events, types that cannot be selected along with the selected type, become inactive. If it is possible to select additional types, they remain active. If you selected DTMF , a dropdown menu appears. If you selected Silence , Busy Tone , Music/Noise , Dial Tone , Ring Back Tone , or Cross Talk , the Amount area opens below the Position area. If additional types of Events are active, select any of the other active types, as required. If you selected DTMF , in the dropdown menu beside the option, select any to accept any key press, or select a key from the list. If you selected Silence , Busy Tone , Music/Noise , Dial Tone , Ring Back Tone , or Cross Talk , in the Amount area, define the amount of time that the selected types of non-linguistic Events must occupy in the total time of the call, as follows: Field Description From Define the minimum amount of time that the selected types of non-linguistic Events must occupy in the total time of the call in one of the following ways: Seconds: The minimum number of seconds in the call in which the types of Events must be found Percentage: The minimum proportion of the call in which the types of Events must be found, expressed as a percentage. (Insert the % character after the value to indicate it is a percentage.) To Define the maximum amount of time that the selected types of non-linguistic Events must occupy in the total time of the call, as explained above. Accumulated Amount / Continuous Select one of the following: Accumulated Amount: The values in the From and To fields refer to the total amount of time in the call audio in which the selected types of Events were found, even if the total consists of more than one distinct Event. Continuous: The values in the From and To fields refer to individual Events in the call audio. That is, an Event only meets the condition if it lasted at least as long as the value in the From field and not longer than the value in the To field. Modify the following settings as necessary: Setting Description Not found Select this option if you want the condition to include all calls except those in which the selected types of non-linguistic Events were found. (For additional information, see Configuring Category Conditions .) From Define the earliest position in the call audio at which the non-linguistic Event may be found, in seconds, and then select one of the following types of reference points: Secs Abs: The number of seconds is defined relative to the beginning of the call Secs Abs from End: The number of seconds is defined relative to the end of the call (i.e., the Event must be found no earlier in the call than this number of seconds from the end of the call) Secs Rel to Start of Prev: The number of seconds is defined relative to the beginning of the previous item in the expression; this option will only work if the operator connecting the two elements is Conditional AND ( -&gt; ). Otherwise, selecting this is the same as selecting Secs Abs . Secs Rel to End of Prev: The number of seconds is defined relative to the end of the parent item; this option will only work if the operator connecting the two elements is Conditional AND ( -&gt; ). Otherwise, selecting this is the same as selecting Secs Abs from End . To Define the latest position in the call audio at which the non-linguistic Event may be found, in seconds, and then select one of the types of reference points explained above. See also Configuring Metadata Elements Configuring Program Elements Configuring Topic Elements Configuring Category Elements Configuring Speaker-Type Elements Configuring Text Elements ||configuring_non-linguistic_event_elements.htm","Configuring Program Elements| Home &gt; Managing Categories &gt; Defining a New Category &gt; Configuring Category Conditions &gt; Configuring Program Elements Configuring Program Elements A Program element specifies that a call must (or must not) belong to a Program in order for the call to be assigned to the Category. When you add a Program element to an expression (see  Inserting Elements into an Expression ), the fields required to select and configure the element are added to the right panel below the Type field. You can use these fields to select the Program and indicate if the call must belong to the Program or must not belong to the Program in order to meet the requirements of the Category. To add a Program element: Under Program , select the Program. If you want the condition to include all calls except those that belong to the Program, select Not . (For additional information, see Configuring Category Conditions .)  See also Configuring Metadata Elements Configuring Non-Linguistic Event Elements Configuring Topic Elements Configuring Category Elements Configuring Speaker-Type Elements Configuring Text Elements ||configuring_program_elements.htm","Configuring Recognition Tasks| Home &gt; Managing Programs &gt; Defining a New Program &gt; Managing the Program Structure &gt; Configuring Recognition Tasks Configuring Recognition Tasks By default, the linguistic recognition tasks of the Program are performed by SpeechMiner throughout the call and for any speaker. In other words, SpeechMiner searches for each item throughout the entire audio record of the call. You can specify exactly when a particular linguistic item should be sought in a call. Defining the search time makes searching more efficient and minimizes false positive identifications. In some systems, you can also specify that an item should only be sought in a call if a particular speaker or type of speaker (caller, agent, etc.) took part in the call. Note: You can also specify other preconditions for linguistic items by defining and configuring triggers. See Configuring Trigger Properties . Non-linguistic recognition tasks are performed on all calls and on all parts of each call. Silence, busy tomes, music and noise, dial tones, DTMF key presses, and ring-back tones are always detected. By default, non-verbal agitation is not sought. However, you can choose to search for it if you wish. Configuring Linguistic Recognition Tasks You can specify when each linguistic recognition task should be sought in a call by defining a time range in which it can appear. Both the start time and the end time of the range can be defined relative to either the start or end time of the call. If the recognition task is the child of another item in the Program structure, you can also define the times relative to the start or end time of the parent item. In some systems, you can also specify that the recognition task should only be sought in the call if certain types of speakers took part in the call. For example, you could choose to perform the recognition task only if a supervisor participated in the call. To configure a linguistic recognition task: In the List pane, select the Content tab. The recognition tasks that are included in the Program are listed. Double-click the recognition task. The Recognition Task dialog box opens. Note: You can also open the dialog box by double-clicking the rectangle representing the task in the Program structure diagram. Recognition Task dialog box for linguistic tasks (Scripts) Under From , define the earliest time that the start of the task should be sought in the call audio, in seconds. For both options, select one of the following types of reference points: Secs Abs: The number of seconds is defined relative to the beginning of the call Secs Abs from End: The number of seconds is defined relative to the end of the call (i.e., the item must be found no earlier in the call than this number of seconds from the end of the call) Secs Rel to Start of Prev: The number of seconds is defined relative to the beginning of the parent item (for child items) Secs Rel to End of Prev: The number of seconds is defined relative to the end of the parent item (for child items) Under To , define the latest time that the start of the task should be sought in the call audio, in seconds, and select the reference point as explained above. In some systems, you can choose one or more types of speakers for the recognition task. If you can do so in your system, the Any checkbox is active. Clear the checkbox if you want to select one or more types of speakers from the list, and then select the speakers. Click OK . The setting is saved. Configuring Non-Linguistic Recognition Tasks You can choose whether SpeechMiner should search for evidence of agitation in calls that belong to the Program. To configure the non-linguistic recognition task: In the List pane, select the Content tab. The recognition tasks that are included in the Program are listed. Double-click the Non Linguistics task. The Recognition Task dialog box opens. Note: You can also open the dialog box by double-clicking the Non Linguistics rectangle in the Program structure diagram. Recognition Task dialog box for non-linguistic tasks If you want SpeechMiner to search for evidence of agitation in calls belonging to the Program, select Agitated . If you do not, clear the checkbox. Click OK . The setting is saved. See also Configuring Trigger Properties ||configuring_recognition_tasks_.htm","Configuring Speaker-Type Elements| Home &gt; Managing Categories &gt; Defining a New Category &gt; Configuring Category Conditions &gt; Configuring Speaker-Type Elements Configuring Speaker-Type Elements A Speaker-Type element specifies that a speaker of a particular type must have taken part (or must not have taken part) in a call in order for the call to be assigned to the Category. This information is gathered by the recording system and passed on to SpeechMiner along with the call data. The exact type of information available depends on the recording system that is employed in your company. Some recording systems also indicate the times in the call when each speaker was heard. In these cases, you can also specify the times in the call when the type of speaker must have taken part in the call in order for the call to meet the condition. For example, you could specify that a supervisor must have taken part in the last 120 seconds of the call.  When you add a Speaker-Type element to an expression (see  Inserting Elements into an Expression ), the fields required to select and configure the element are added to the right panel below the Type field. You can use these fields to select the Speaker-Type and specify its timing constraints.   To add a Speaker-Type element: Under  Speaker-Type , select the type of speaker. If you want the condition to include all calls except those that match the condition, select Not . (For additional information, see Configuring Category Conditions .) Modify the following settings as necessary: Setting Description   From Define the earliest position in the call audio at which the speaker may be found, in seconds, and then select one of the following types of reference points: Secs Abs: The number of seconds is defined relative to the beginning of the call Secs Abs from End: The number of seconds is defined relative to the end of the call (i.e., the Script must be found no earlier in the call than this number of seconds from the end of the call) Secs Rel to Start of Prev: The number of seconds is defined relative to the beginning of the previous item in the expression; this option will only work if the operator connecting the two elements is Conditional AND ( -> ). Otherwise, selecting this is the same as selecting Secs Abs . Secs Rel to End of Prev: The number of seconds is defined relative to the end of the parent item; this option will only work if the operator connecting the two elements is Conditional AND ( -> ). Otherwise, selecting this is the same as selecting Secs Abs from End .  To Define the latest position in the call audio at which the speaker may be found, in seconds, and then select one of the types of reference points explained above.   See also Configuring Metadata Elements Configuring Non-Linguistic Event Elements Configuring Program Elements Configuring Topic Elements Configuring Category Elements Configuring Text Elements ||configuring_speaker-type_elements.htm","Configuring Text Elements| Home &gt; Managing Categories &gt; Defining a New Category &gt; Configuring Category Conditions &gt; Configuring Text Elements Configuring Text Elements A Text element specifies that a phrase containing one or more words must be found (or must not be found) by SpeechMiner in the transcript of a call in order for the call to be assigned to the Category. The phrase must be found exactly as it is entered in the Text element definition to meet the condition, except that it is not case sensitive. For example, i want to repay my loan and I want to Repay My loan are treated as identical phrases, but I wanted to repay my loan and I want you to repay my loan are not identified as matching them. When you add a Text element to an expression (see Inserting Elements into an Expression ), the fields required to select and configure the element are added to the right panel below the Type field. You can use these fields to specify the phrase, its required number of occurrences in the call, its strictness level, and its timing constraints. To add a Text element: Under Text , enter the phrase. The phrase should consist of a sequence of one or more whole words. The words should be separated by single spaces, and no punctuation or other symbols should be included in the sequence. The text is not case-sensitive. Modify the following settings as necessary: Setting Description Not found Select this option if you want the condition to include all calls except those in which the phrase was found. (For additional information, see Configuring Category Conditions .) At least __ Occurrences Specify the minimum number of times the phrase must have been found in the call in order for the condition to be met. At least __ Confidence Select the minimum level of confidence for the recognition of the phrase; if the Confidence level does not meet this minimum, SpeechMiner proceeds as if the phrase was not found. From Define the earliest position in the call audio at which the phrase may be found, in seconds, and then select one of the following types of reference points: Secs Abs: The number of seconds is defined relative to the beginning of the call Secs Abs from End: The number of seconds is defined relative to the end of the call (i.e., the phrase must be found no earlier in the call than this number of seconds from the end of the call) Secs Rel to Start of Prev: The number of seconds is defined relative to the beginning of the previous item in the expression; this option will only work if the operator connecting the two elements is Conditional AND ( -&gt; ). Otherwise, selecting this is the same as selecting Secs Abs . Secs Rel to End of Prev: The number of seconds is defined relative to the end of the parent item; this option will only work if the operator connecting the two elements is Conditional AND ( -&gt; ). Otherwise, selecting this is the same as selecting Secs Abs from End . To Define the latest position in the call audio at which the phrase may be found, in seconds, and then select one of the types of reference points explained above. Speaker Type Select a speaker type if the phrase must be found when the selected type of speaker is speaking, or ANY to include all speaker types. See also Configuring Metadata Elements Configuring Non-Linguistic Event Elements Configuring Program Elements Configuring Topic Elements Configuring Category Elements Configuring Speaker-Type Elements ||configuring_text_elements.htm","Configuring Topic Elements| Home &gt; Managing Categories &gt; Defining a New Category &gt; Configuring Category Conditions &gt; Configuring Topic Elements Configuring Topic Elements A Topic element specifies that a Topic must be found (or must not be found) by SpeechMiner in a call in order for the call to be assigned to the Category. When you add a Topic element to an expression (see Inserting Elements into an Expression ), the fields required to select and configure the element are added to the right panel below the Type field. You can use these fields to select the Topic and specify its required number of occurrences in the call, its strictness level, and its timing constraints. To add a Topic element: Under Topic , select the Topic. Modify the following settings as necessary: Setting Description Not found Select this option if you want the condition to include all calls except those in which the Topic was found. (For additional information, see Configuring Category Conditions .) At least __ Occurrences Specify the minimum number of times the Topic must have been found in the call in order for the condition to be met. At least __ Strictness Select the minimum level of strictness for the recognition of the Topic; if the Topic recognition does not meet this minimum, SpeechMiner proceeds as if the Topic was not found. Note that this only limits strictness beyond the Topic's defined strictness. From Define the earliest position in the call audio at which the Topic may be found, in seconds, and then select one of the following types of reference points: Secs Abs: The number of seconds is defined relative to the beginning of the call Secs Abs from End: The number of seconds is defined relative to the end of the call (i.e., the Topic must be found no earlier in the call than this number of seconds from the end of the call) Secs Rel to Start of Prev: The number of seconds is defined relative to the beginning of the previous item in the expression; this option will only work if the operator connecting the two elements is Conditional AND ( -&gt; ). Otherwise, selecting this is the same as selecting Secs Abs . Secs Rel to End of Prev: The number of seconds is defined relative to the end of the parent item; this option will only work if the operator connecting the two elements is Conditional AND ( -&gt; ). Otherwise, selecting this is the same as selecting Secs Abs from End . To Define the latest position in the call audio at which the Topic may be found, in seconds, and then select one of the types of reference points explained above. Speaker Type Select a speaker type if the Topic must be found when the selected type of speaker is speaking, or ANY to include all speaker types. See also Configuring Metadata Elements Configuring Non-Linguistic Event Elements Configuring Program Elements Configuring Category Elements Configuring Speaker-Type Elements Configuring Text Elements ||configuring_topic_elements.htm","Configuring Trigger Properties| Home &gt; Managing Programs &gt; Defining a New Program &gt; Managing the Program Structure &gt; Configuring Trigger Properties Configuring Trigger Properties The conditions that define the circumstances under which SMART should search for a child item in a call are called triggers . The triggers of linguistic recognition tasks are defined in the Program's structure diagram (see Managing the Program Structure ), and are represented there by the arrows that connect recognition tasks. You can fine-tune the triggers in the following ways: Metadata: Specify that a particular child item should only be sought in a call if the call meets one or more metadata requirements. For example, you can specify that a particular Topic should only be sought if the customer is in the state of Nevada, or if a particular agent handled the call. Parent conditions: Configure the settings of the parent-child relationships that are defined in the structure diagram. For example, you can specify that the parent must be recognized with a particular level of strictness before the child should be sought, or that the parent must be found twice before the child is sought. Logical Expressions Configuring triggers is performed by defining a logical expression for SpeechMiner to evaluate. If the logical expression is evaluated as True, the trigger is activated and the child recognition task is run on the call; if it is false, the trigger is not activated, and the child recognition task is not run. Logical expressions can consist of one or more elements. Each element is a statement, such as Date Of Call&gt;1/19/2010 or Found topic Reduction at least once with Low Strictness . If a logical expression contains one element, it is True whenever the condition defined in the element is true. For example, if a logical expression contains the element Date Of Call&gt;1/19/2010 , it is True for any call whose metadata indicates that it took place on or after 1/20/2010. Logical expressions can also contain multiple elements. When they do, the elements must be related to one another by logical operators, such as AND or OR. For example, Date Of Call&gt;1/19/2010 AND Found topic Reduction at least once with Low Strictness is a logical expression that indicates both conditions must be met - the Topic must be found and the call must have taken place in the specified time period - in order for the expression to be evaluated as True and the recognition task to be implemented. The following operators can be used in logical expressions: Operator Description AND Both conditions must be met in order for the expression to be evaluated as True OR At least one of the conditions must be met in order for the expression to be evaluated as True NOT The expression should be evaluated as True only when the condition is not met. ( Opens a group of conditions that are evaluated as a unit ) Closes a group of conditions that are evaluated as a unit Logical expressions can be quite complex, containing a number of elements, various logical operators, and parentheses, if necessary. For example: (Date Of Call&gt;1/1/2011 AND Date Of Call&lt;1/30/2011 AND Found topic Reduction at least once with Low Strictness) OR (Date Of Call&gt;1/31/2011 AND ( Found topic Time Frame at least once with Low Strictness OR Found topic Payment Locations at least once with Medium Strictness )) means the recognition task should be performed if the call took place between Jan. 1st and Jan. 30th and the Topic Reduction was found, or if the call took place Jan. 31st or later and either the Topic Time Frame or the Topic Payment Locations was found. Configuring Trigger Conditions Trigger conditions are configured by defining logical expressions. Both metadata and parent conditions can be included in the logical expression. Metadata conditions are added to the logical expression manually, but parent conditions must be created in the structure diagram; once they are created, you can modify their properties manually. If conditions are defined for a particular trigger, they are displayed in the List pane in the Triggers tab, under Exp . Trigger conditions defined for the Fees and Services Charges -&gt; Payment Address trigger To configure the trigger conditions of a recognition task: In the List pane, select the Triggers tab. A list of all the triggers that are defined in the Program structure is displayed. Double-click the trigger for which you want to define the condition. The Trigger Properties dialog box opens. If any conditions are already defined for the trigger, they appear in the text area in the middle of the dialog box. Otherwise, the text area is blank. Note: You can also open the dialog box by double-clicking the trigger in the structure diagram. Trigger Properties dialog box Add metadata elements, modify existing elements, and add or change operators as explained below. Trigger Properties with logical expression defined Click OK . The condition appears in the Triggers tab under Exp . If the expression contains metadata elements, the trigger is displayed in the structure diagram in orange. Metadata trigger-condition displayed in orange Adding Metadata Conditions Metadata is information about calls that is gathered by the external recording system and relayed to SpeechMiner along with the call audio. Each system receives different sets of information about the calls that are passed to it for processing. For example, metadata could include the name of the agent for each call, the location of the customer, and the duration of the call. You can define metadata conditions based on any of the metadata values available in your system. In addition, you can define different metadata conditions for each linguistic task in a Program. The conditions you define can be as simple as one metadata value or complex expressions that specify the relationships among a number of types of metadata. Take, for example, a sales campaign that is undertaken in Wyoming and in Texas. Certain agents in each location target senior citizens, while others target families with teenage children. To process calls to senior citizens differently from other calls that belong to the Program, you could define a condition that specifies either Agent1 or Agent2 if the customer is in Wyoming, and Agent3 if the customer is in Texas, and apply the condition to the items that are specific to the senior-citizen campaign. To add a metadata element to an expression: In the lower part of the Trigger Properties dialog box, click to clear all existing selections. Under Type , select Metadata . The fields required to select the metadata values are added to the dialog box below the Type field. In the first field, specify the type of metadata. You can specify the type in one of two ways If the type appears in the dropdown list, select it. For example, select Workgroup?Agent if you want to define a condition based on the workgroup or agent that handled the call. Type the name of the type in the field. For example, if your system gathers data on call direction under the name calldirection , type calldirection if that is the name of that type of metadata. In the remaining fields, specify the condition. In some cases, you can select an operator (&lt;, &gt;, or =) in the second field and specify a value in the third; in other cases, you only specify a value (and the = operator is assumed). You can specify a value by selecting it from the list or by typing it manually into the third text field. Note: Some of the options may be arranged hierarchically. For example, if you select Workgroup?Agent , a list of workgroups is displayed. You can select a workgroup, or click the + beside the name of a workgroup to expand the list and display the names of the agents in the workgroup. If you select a workgroup, all members of the workgroup are included in the condition; if you expand a workgroup and select an agent, only that agent is included. If you want the trigger to include all calls except those that match the condition, select Not (or click the Not operator, as explained below ). Click Add . The element is inserted into the expression. If the element is not the first element in the expression, at the top of the dialog box, click the operator that should precede the element ( And , Or , or Not ). The operator is inserted into the expression before the element. Inserting Parentheses into an Expression Parentheses can be inserted into an expression to group elements together for evaluation as a single unit. Complex expressions often require parentheses to break them into smaller expressions so that the relationships between the expressions are clear. For example, if a Topic must be found in calls handled by one of two agents, and you wrote Workgroup?Agent=workgroup 1/agent a OR Workgroup?Agent=workgroup 1/agent b AND Found topic Reduction at least once with Low Strictness it would not be clear whether the Topic must be found in calls handled by both agents or only in calls handled by agent b . If you add parentheses like this ( Workgroup?Agent=workgroup 1/agent a OR Workgroup?Agent=workgroup 1/agent b) AND Found topic Reduction at least once with Low Strictness the Topic would have to be found in calls handled by one of the agents. But if you write Workgroup?Agent=workgroup 1/agent a OR (Workgroup?Agent=workgroup 1/agent b AND Found topic Reduction at least once with Low Strictness) the Topic would only be required in calls handled by agent b. To insert parentheses into an expression: Click the first element that you want to include in the parentheses. The element is selected. At the top of the dialog box, click ( . A ( is inserted into the expression before the selected element. Click the element or operator after the last element you want to include in the parentheses. If the element you want to include is the last element in the expression, do not select any items in the expression. At the top of the dialog box, click ) . A ) is inserted into the expression after the last element of the expression. Defining a Negative Condition A negative condition is a condition that must not be met if an expression is to be evaluated as True. For example, a condition that states that a call must not have taken place in the month of January is a negative condition. Negative conditions can be specified for a single element of an expression or a group of elements that are contained in parentheses. Two methods are available for creating a negative condition for a single element: Insert a NOT operator before the element. Select the Not option in the element's conditions. In the following two illustrations, a negative condition is created in each of these ways. The meanings of the two conditions are identical: the condition is True as long as the date is not on or before January 31st, 2011. Negative condition created using the NOT operator Negative condition created using the Not option An expression containing multiple elements can only be marked as a negative condition using the NOT operator. For example, in the illustration below, the NOT operator is attached to a multi-element condition. The condition is True for all workgroups except workgroup 1 and workgroup 4. NOT operator used to create a negative condition with multiple elements To insert a NOT operator before an element or expression: If the condition is an expression that contains multiple elements, make sure it is contained in parentheses. In the text area of the Trigger Properties dialog box, select the element or expression. At the top of the text area, click Not . A NOT operator is added to the condition before the selected item. To select the Not option for an element: If the properties of the element are not displayed, in the text area of the Trigger Properties dialog box, select the element. In the condition area below the text area, select Not . Click Add or Update to add or update the negative element in the text area. Modifying the Elements of an Expression You can modify the properties of elements that are already included in the expression. You can do this for metadata elements and for parent elements. Modifying Metadata Elements You can modify any of the properties of a metadata element. To modify an existing metadata element: In the text area, click the element. Its properties open below the text area. Modify the settings as required (see above ). Click Update . The settings are modified. Modifying Parent Elements You can change the properties of a parent element, including the required number of occurrences of the element, its strictness level, and its timing constraints, but you cannot change it to a different Topic and you cannot move it to a different position in the Program structure. (To do these latter two things, you have to change the structure diagram; see Managing the Program Structure . To modify a parent element: In the text area, click the element. The element is selected and its properties open below the text area. Modify the following settings as necessary: Setting Description Not found Select this option if you want the trigger to include all calls except those that match the condition; that is, the child should not be sought unless the parent is not found in the call At least __ Occurrences (Topics only) Specify the minimum number of times the parent Topic must be found in the call in order for the child to be sought; if the parent recognition does not meet this minimum, SpeechMiner proceeds as if the parent was not found At least __ Strictness (Topics only) Select the minimum level of strictness for the recognition of the parent Topic; if the parent recognition does not meet this minimum, SpeechMiner proceeds as if the parent was not found From Define the earliest position in the call audio at which the parent may be found, in seconds, and then select one of the following types of reference points: Secs Abs: The number of seconds is defined relative to the beginning of the call Secs Abs from End: The number of seconds is defined relative to the end of the call (i.e., the parent must be found no earlier in the call than this number of seconds from the end of the call) Secs Rel to Start of Prev: The number of seconds is defined relative to the beginning of the parent item Secs Rel to End of Prev: The number of seconds is defined relative to the end of the parent item To Define the latest position in the call audio at which the parent may be found, in seconds, and then select one of the types of reference points explained above. Speaker Type Select a speaker type if you want the trigger to only include locations in which the selected type of speaker is speaking, or ANY to include all speaker types. Click Update . The settings are modified. Copying an Expression from Another Trigger You can copy an expression from the Trigger Properties of one trigger and paste it into the Trigger Properties of another trigger. The triggers do not have to be part of the same Program. After you paste the expression, you can edit it as necessary, just as you would edit any other expression. To copy the trigger conditions from one trigger to another: In the Program containing the source trigger, double-click the trigger. The Trigger Properties dialog box of the source trigger opens. At the top-right of the dialog box, click Copy . Click OK . The dialog box. In the Program containing the target trigger, double-click the trigger. The Trigger Properties dialog box of the target trigger opens. At the top-right of the dialog box, click Paste . The condition expression from the source trigger appears in the expression area of the dialog box. Removing Elements and Operators from an Expression You can remove any element or operator from an expression except for a parent element (which must be removed in the structure diagram; see Managing the Program Structure ). To remove an element or operator from an expression: Click the element. The element is selected. At the top of the dialog box, click . The selected item is deleted from the expression. See also Configuring Recognition Tasks ||configuring_trigger_properties.htm","Creating a Blank Category| Home &gt; Managing Categories &gt; Defining a New Category &gt; Creating a Blank Category Creating a Blank Category A Category definition consists of a name, a description (optional), sharing properties, and, in some cases, a logical expression that defines the types of calls to which the Category can be assigned. Three types of Categories exist in SpeechMiner: Regular Categories: Categories that have conditions defined in the form of a logical expression. When SpeechMiner processes a call, the call is automatically assigned to this type of Category if it matches the requirements that are defined in the condition. These Categories can be independent (on the top level of the Category hierarchy) or they can be sub-Categories of other, parent Categories. Parent Categories: Categories that contain other Categories. These Categories have a name and description, but do not include a logical expression. Calls are assigned to them when they are assigned to any of their sub-Categories. Any Category can be converted into a parent Category by adding sub-Categories to it. (When a regular Category is converted into parent Category, the logical expression that defined the Category is deleted.) Manual Categories: Categories that have no conditions; SpeechMiner users manually assign calls to them as required. The sharing properties of a Category define which users will see it in the SpeechMiner interface. Users with whom a Category is shared will see the Category in the lists of Categories available for selection in the Call Explorer and in Category filters. Sharing settings are intended to remove clutter by hiding Categories that are not relevant to particular users. For example, if a particular workgroup only deals with calls that relate to maintenance issues, you can choose not to share sales Categories with that group. In this way, members of that workgroup will not have to encounter large numbers of Categories that do not concern them. In addition, if you are creating a new Category, you may not want to share it with anyone else until you have fully tested it. Once the testing process is complete, you can change the sharing settings and apply the change to SpeechMiner. By default, Categories are shared with all SpeechMiner users. You can specify groups, workgroups, roles, and/or specific users with whom a Category should be shared. Note: Category sharing does not affect which calls a user can see or play back. To create a blank Category: In the tree list, select All to create an independent Category, or select an existing Category to create the new Category as a sub-Category of the selected Category. Note: If you select an existing Category, the conditions defined for inclusion in the Category (its logical expression) are automatically erased. Note: You can also move the Category to a parent Category later. In the Categories menu, click ( New Category ) to create a regular Category or ( New Manual Category ) to create a manual Category. The blank Category opens in the right panel. Note: You can also create a new regular Category by selecting in the tree-list controls, but you must open the Categories menu to create a manual Category. The Categories menu can be opened either by clicking Categories above the tree-list controls or by right-clicking in the tree list. For additional information, see Overview of the Main Window . Under Name , enter a name for the Category. If you want to limit the types of SpeechMiner users with which the Category is shared, click Edit . The Category Sharing dialog box opens. Note: If you do not want to change the sharing settings, skip to step 8 below . Clear the Share with all checkbox. The sharing options become active. Select the groups, roles, and/or users with which the Category should be shared. Note: To filter the list of users, type a sequence of characters that appears in the user name you want to find. The list is filtered; only user names that contain the sequence you type are displayed. Click OK . The sharing settings are displayed in the Shared with field. Under Description , enter a description for the Category (optional). On the upper-left of the right panel, click ( Save ). The Category is saved. Note: If the Category is a regular Category, you can configure its conditions, as explained under Configuring Category Conditions , before you save it. If the Category is a parent Category or a manual Category, it does not require any additional configuration, and must be saved at this point. See also Configuring Category Conditions Saving and Activating the Category ||opening_a_blank_category.htm","Creating a Blank Program| Home &gt; Managing Programs &gt; Defining a New Program &gt; Creating a Blank Program Creating a Blank Program The first step in creating a new Program is opening a blank Program. To open a blank Program: In the tree list, select the folder in which you want to open the Program. Note: For information about opening folders, see Organizing Items Hierarchically . You can also move the Program to a folder later. In the tree-list controls, click ( New Program ). The Program Properties dialog box opens. Fill in the fields as follows: Field Description Folder Displays the folder in which the Program will be placed. If you want to save the Program in a different folder, click the ... button and select the required folder. Name Enter a name for the Program. External ID The ID of the Program in the external recording system. Each call that belongs to this Program is assigned this ID by the recording system. When SpeechMiner receives the call audio from the recording system, it checks this ID in order to find out which Program to use to analyze the call. For information about the correct External ID to assign to the Program, please consult your system administrator. Language Select the language of the Program. Note: In some systems, some or all calls do not undergo speech-recognition processing. In these systems, the option No Speech Recognition appears in the list of Languages. Select this value if calls in this Program should not undergo speech recognition processing. Topic recognition cannot be performed on calls that do not undergo speech-recognition processing. Active Select this option if you want the Program to be active when it is applied. (See Saving and Activating the Program .) Priority Specify the priority level of the Program. The priority level tells SpeechMiner in what order to process calls that are in the processing queue: Calls with higher priority are processed first. Five priority levels are defined: Very High , High , Medium , Low , and Very Low . The default priority level is Medium. If two calls in the queue have the same priority level, the processing order follows the process order set in SpeechMiner - either older calls first or newer calls first. Note: This level, and the process order setting, can be changed in SpeechMiner under Tools&gt;System Admin&gt;Manage Call Queue Description Enter a free-text description for the Program (optional). Note: The other fields in the dialog box are automatically updated by SMART each time the Program is saved. Click OK . The dialog box closes. The new Program appears in the tree list and is opened in the right panel of the SMART window. The Non Linguistics task is added to the Program automatically. This means SpeechMiner is instructed to try to identify non-linguistic Events in the call audio; this task is included in all Programs and cannot be removed. Blank Program See also Adding Topics Managing the Program Structure Using Notes Saving and Activating the Program ||opening_a_blank_program.htm","Creating a Blank Topic| Home &gt; Managing Topics &gt; Defining a New Topic &gt; Creating a Blank Topic Creating a Blank Topic The first step in creating a new Topic is opening a blank Topic and defining its properties. To open a blank Topic: In the tree list, select the folder in which you want to create the Topic. Note: For information about creating folders, see Organizing Items Hierarchically . You can also move the Topic to a folder later. In the tree-list controls, click ( New Topic ). The Topic Properties dialog box opens. Fill in the fields as follows: Field Description Folder Displays the folder in which the Topic will be placed. If you want to save the Topic in a different folder, click the ... button and select the folder. Name Enter a name for the Topic. (Do not include any special characters in the name.) Description Enter a free-text description for the Topic (optional). Strictness Select the required level of strictness for the Topic. This defines how confident SpeechMiner must be when recognizing one of the terms in the Topic in order for it to identify it as a linguistic Event of this Topic. The confidence level must be at least the value specified in parentheses. For example, if you select Medium (65) , the terms listed must be identified with confidence levels of at least 65 in order to be identified as Events of this Topic. SpeechMiner has a number of predefined confidence levels (Very Low, Low, Medium Low, Medium, Medium High, and High). You can select one of these, or, if you prefer, you can select Custom and then specify a custom confidence level (see below). Note: Confidence levels are assigned by SpeechMiner to each term it identifies during call processing. They indicate how closely the term defined in the Topic matches the term that was discovered in the audio segment. Confidence If, under Strictness , you selected Custom , specify the required level of strictness as a number in the range 1-100. Note: This field is only visible if Custom is selected under Strictness . Language Select the language of the Topic. Secured Topic Select this option if you want the Media Player to skip playback of this Topic for SMART users who do not have permission to hear confidential Topics. For example, if the Topic identifies the caller's credit card details, you can use this option to hide that information from users who are not authorized to hear it. Note: When you select this option, the two fields below it become active. Number of seconds to skip before the topic Specify how many seconds of playback before the Topic should be skipped when the Topic is not played back by the Media Player. Note: This field is only active when Secured Topic is selected. Number of seconds to skip after the topic Specify how many seconds of playback after the Topic should be skipped when the Topic is not played back by the Media Player. Note: This field is only active when Secured Topic is selected. Note: The other fields in the dialog box are automatically updated by SMART each time the Topic is saved. Click OK . The dialog box closes. The new Topic appears in the tree list and is opened in the right panel of the SMART window. See also Adding Terms Marking Keywords Saving the Topic ||opening_a_blank_topic.htm","Creating an Effective Topic| Home &gt; Managing Topics &gt; Creating an Effective Topic Creating an Effective Topic To be effective, a Topic must be well-defined. Since speakers use many different terms to express the same idea, you should try to include as wide a range of alternative terms as possible. To get ideas for what to include, listen to existing calls about the subject or similar subjects, and consult agents who handle calls.  In many cases, Topics can benefit from fine-tuning after they have been applied to calls and the call auditing process takes place. (For information about call auditing, see the SpeechMiner User Manual and Auditing a Topic below.) Here are a few suggestions to help you get started when defining a Topic: Business Problem : Before you begin listing terms, define the data you want to collect in 3-4 sentences. Think about the intent that the terms you are collecting should reflect, and be as specific as possible. Terms:   }}-->List as many common terms as you can that are frequently used to express the intent. }}--> Include as many variations of the term as you can. Term length: Longer terms are easier for SpeechMiner to identify than shorter terms, so try to use terms that include at least 4-6 words and at least 20 characters. Terms can contain up to 100 characters. As a rule, the longer the term, the more accurately it will be identified by SpeechMiner. However, fewer events are found for longer terms. Conversely, the shorter the term, the more events will be found, but the accuracy will be lower. Synonyms: Try to think of synonyms for words that appear in the terms, and list variations of the terms by using the synonyms in place of the original terms. For example, if you are looking for conversations in which closing an account  is discussed, list all terms with the verbs cancel and “close”: want to cancel my account want to close my account need to close my account “need to cancel my account” Short words: Remove short words from the beginnings of terms whenever possible. For example, instead of I want to reduce the rate, use want to reduce the rate. Keywords:   When you select a keyword in a term, you give it extra weight, so that SpeechMiner specifically looks for that word when screening calls.  It is not always necessary to specify a keyword. If no keyword is selected for a term, SMART automatically marks the longest word in the term as the keyword . For example, in the term  “I already called to cancel my account,” if you do not select a keyword, SMART automatically selects the word already as the keyword. However, it is best to choose the keyword for each term if you can, because this ensures that the correct keyword is selected. Thus, in the example above, you should select “cancel” as the keyword. Note that when a keyword is selected for a term, it is automatically applied to the entire Topic. Do not select the same keyword for another Topic. In general, only one keyword should be selected per term; if two words always appear together, like credit card ', you can select them both as the keyword.    See also Overview of the Topic-Manager Interface Defining a New Topic Modifying a Topic Auditing a Topic Managing Secured Topics Deleting Topics ||creating_an_effective_topic_definition.htm","Defining a New Category| Home &gt; Managing Categories &gt; Defining a New Category Defining a New Category Categories can be created in one of two ways: Manually by a SMART user, by creating a blank Category and constructing a logical expression to define which calls belong to it Automatically by SMART when a Topic is saved (see Saving the Topic ); in this case, the default definition of the Category is essentially calls in which the Topic was found In either case, the characteristics that define the Category can be edited to include all relevant conditions. This section explains how to create a blank Category and construct the logical expression that defines which calls belong to it. For information about modifying a Category that was created automatically, see Modifying a Category . See also Overview of the Category-Manager Interface Modifying a Category Deleting Categories ||defining_a_new_category.htm","Defining a New Program| Home &gt; Managing Programs &gt; Defining a New Program Defining a New Program You begin defining a new Program by creating a blank Program and specifying its properties. Once you have done this, you can  add Topics to the program. You can then fine-tune the Program as necessary, by doing some or all of the following: Defining the Program Structure Configuring Trigger Properties Configuring Recognition Tasks Finally, you complete the process of defining a new Program by  saving and activating it. See also Creating a Blank Program Adding Topics Managing the Program Structure Using Notes Saving and Activating the Program Overview of the Program-Manager Interface Modifying a Program Deleting Programs ||defining_a_new_program.htm","Defining a New Topic| Home &gt; Managing Topics &gt; Defining a New Topic Defining a New Topic You can define a new Topic by opening a blank Topic and adding terms to it. Once you have done this, you should select a keyword for each term. Finally, you should save the Topic in SMART. Creating a Blank Topic Adding Terms Marking Keywords Saving the Topic   See also Creating an Effective Topic Overview of the Topic-Manager Interface Modifying a Topic Auditing a Topic Managing Secured Topics Deleting Topics ||defining_a_new_topic.htm","Deleting Categories| Home &gt; Managing Categories &gt; Deleting Categories Deleting Categories You can delete Categories that are not required. When you apply the changes to SpeechMiner, the Categories you deleted from SMART are removed from SpeechMiner as well, and the Category assignments of all of the calls in the SpeechMiner database are redone (see Applying Changes ). To delete one or more Categories: Make sure the Categories you want to delete are closed. In the left panel, click the Category Manager tab. The list of existing Categories is displayed in the tree structure. In the tree structure, select the Categories you want to delete. To select multiple Categories, hold down the Ctrl key while you click them. In the tree controls above the tree structure, click ( Delete ). For each Category, a Category Deletion message appears. Category Deletion message Click Yes . The Category is deleted. If additional Categories were selected, a Category Deletion message appears for each one. Click Yes to confirm each deletion. Note: If you want to delete all of the selected Categories without confirming each one, select Apply to All before you select Yes . See also Overview of the Category-Manager Interface Defining a New Category Modifying a Category ||deleting_a_category.htm","Deleting Programs| Home &gt; Managing Programs &gt; Deleting Programs Deleting Programs You can delete Programs that are not required, as long as they are not linked to Categories. If you want to delete a Program that is linked to a Category, remove it from the Category definition first (see Modifying a Category ). To delete one or more Programs: Make sure the Programs you want to delete are closed. In the left panel, click the Program Manager tab. The list of existing Programs is displayed in the tree structure. In the tree structure, select the Programs you want to delete. To select multiple Programs, hold down the Ctrl key while you click them. In the tree controls above the tree structure, click ( Delete ). For each Program, a Program Deletion message appears. Program Deletion message Click Yes . The Program is deleted. If additional Programs were selected, a Program Deletion message appears for each one. Click Yes to confirm each deletion. Note: If you want to delete all of the selected Programs without confirming each one, select Apply to All before you select Yes . See also Overview of the Program-Manager Interface Defining a New Program Modifying a Program ||deleting_a_program.htm","Deleting Topics| Home &gt; Managing Topics &gt; Deleting Topics Deleting Topics You can delete Topics that are not required. Topics can be deleted even if they are linked to Programs, but they cannot be deleted if they are linked to Categories. If you want to delete a Topic that is linked to a Category, remove it from the Category definition first (see Modifying a Category ). To delete one or more Topics: Make sure the Topics you want to delete are closed. In the left panel, click the Topic Manager tab. The list of existing Topics is displayed in the tree structure. In the tree structure, select the Topics you want to delete. To select multiple Topics, hold down the Ctrl key while you click them. In the tree controls above the tree structure, click  ( Delete ). For each Topic, a Topic Deletion message appears. If the Topic is linked to any Programs, the Programs are listed in the message. Topic Deletion message Click Yes . The Topic is deleted. If additional Topics were selected, a Topic Deletion message appears for each one. Click Yes to confirm each deletion. Note: If you want to delete all of the selected Topics without confirming each one, select Apply to All before you select Yes .   See also Creating an Effective Topic Overview of the Topic-Manager Interface Defining a New Topic Modifying a Topic Auditing a Topic Managing Secured Topics ||deleting_a_topic.htm","Events: Topics and Non-Linguistic Data| Home &gt; Overview &gt; Events: Topics and Non-Linguistic Data Events: Topics and Non-Linguistic Data Events are specific types of call content that are identified by SpeechMiner in calls. SpeechMiner can identify linguistic Events - that is, Topics - and certain types of non-linguistic Events. Topics A Topic represents a specific business idea that you want to detect in analyzed calls. For example, if you want to identify calls in which the customer wishes to cancel an account, you could create a Topic named Cancelation . Once a Topic is defined, you populate it with terms - phrases that correlate with the idea the Topic was meant to capture. For example, you could add the following terms to the Cancelation Topic: Close out my account I need to cancel Topics can contain one or more terms, but at least 15 terms are usually necessary to define a useful Topic. A Topic can even contain hundreds of terms, if necessary. All of the terms should be concrete ways of identifying the idea represented by the Topic in a conversation. Topics are defined globally for your entire SpeechMiner system. In order to use them, they must be linked to Programs. When a Topic is linked to a Program, SpeechMiner searches for the terms of the Topic in calls that belong to the Program. If it finds one of the terms, it registers the Topic as found in that location in the call. Each Topic Event that is identified by SpeechMiner has a start time, an end time, a name, and a type. For example, if a Topic called Loan Offer is identified by the term can offer you a loan, the start time is when the agent began saying can, the end time is when the agent finished saying loan, the name is Loan Offer, and the type of Event is Topic. Non-Linguistic Events Non-Linguistic Events are sounds other than speech. SpeechMiner automatically identifies non-linguistic Events in calls, as follows:  Dial Tone: A dial tone   Ringbolt: A signal used in PSTN (Public Switched Telephone Networks - standard land lines) to indicate that the line is being called or an incoming call is present. Silence: Silence, usually indicating that the Mute button was held down on one of the handsets Busy Tone: A busy signal  Music and Noise: Music or noise, generally indicating the call was on hold  DTMF:  Key press on a touch-tone phone. 16 different keys can be identified using DTMF (Dual Tone Multi Frequency) In addition, when you configure a Program, you can choose whether SpeechMiner should also identify  agitation - non-verbal expressions of frustration and anger, such as deep sighs, grunts or rapid changes in pitch. Each non-linguistic Event that is identified by SpeechMiner has a start time, an end time, and a type. For example, if SpeechMiner identifies silence in a call, this is a non-linguistic Event whose start time is the beginning of the silent period, whose end time is the end of the silent period, and whose type is Silence.   See also Programs Call Classification: Categories Language Support Overview of the Interface Typical Workflows ||topics__scripts__and_non-linguistic_data.htm","Exporting and Importing| Home &gt; Exporting and Importing Exporting and Importing You can save selected parts of the definitions contained in SMART in a file by exporting them. Exported files can be imported into any SMART system. They can be used for a number of purposes: To back up your system To transfer the definitions from a test environment to the real system used by your company To transfer the definitions they contain to other SMART systems in your company. For example, you could export all of the definitions in your system and send the files to a company office in a different state. The SMART administrator in the other office could then import your system into the local SMART system. In this way, both offices can use the same definitions for their SpeechMiner systems. To send the file to UTOPY Inc. technical support if you are having problems with something you are defining in SMART SMART export files have the extension upf (UTOPY Inc. Program File). Exporting Definitions You can select one or more items of a single type for export in a single file - one or more Topics, Programs, or Categories. If you select a folder, all of the items in the folder are selected. If you select All in the tree list, all of the definitions of the selected type are selected. If you do not select any items, all items in the currently displayed Manager are included in the export file. For example, if the Topic tab is open, but no Topics are selected, all of the Topic definitions are included. When you export a Program, all Topics included in the Program are exported along with the Program. When you export a Parent Category, all of its sub-Categories are included in the export file. Note: When you export a Category, its sharing settings are not exported with it. Thus, if you later import it, its sharing setting will normally be All . For additional information, see below . To export some or all of your SMART definitions: Make sure none of the items you want to export are open or locked. (For information about unlocking locked items, see Locking and Unlocking Items .) If you want to select specific items for export, in the left panel, select the tab of the type of item you want to export. The tree list of the selected type of item is displayed. In the tree structure, select the items you want to export. To select multiple items, hold down Ctrl or Shift while you click. ( Ctrl causes causes individual items to be selected; Shift selects all items between the first and second items clicked.) If you want to export the entire SMART system, make sure no items are selected in the tree list. In the Quick Access Bar below the main menu, click ( Export ). The Export dialog box opens. If you selected specific items for export, they are listed in the dialog box. Selected Program items, and the Topics they contain, in the Export dialog box Under Target , modify the name and path of the export file as required, or click ... ( Browse ) to open a Windows Save as... dialog box in which to specify the target name and path. Click Export . The export file is created. When the process is completed, a confirmation message appears: Click OK to close the message. Both the message and the Export dialog box close. Importing Definitions from an Export File When you import a file, you can choose which items to import. In addition, you can choose whether to import the global definitions. Bear in mind that if you do import the global definitions, all existing global definitions will be erased and replaced by those that were imported. Note: When you import a Category, its sharing setting is normally set to All . However, if a Category with the same name already exists in SMART when the import process is initiated, the sharing settings of the existing Category are applied. To import the definitions from a upf export file: In the Quick Access Bar below the main menu, click ( Import ). The Import dialog box opens. Import dialog box Under Source file click ... ( Browse ) to open a Windows Open dialog box. Navigate to the file, and then click Open . The Import dialog box opens and displays a list of the items that are available for import from the file. Specific Program items, and the Topics they contain, in the Import dialog box If there are items in the list that you do not want to import, clear their checkboxes. Note: The Import Global Variables and Directives option is not in use in the version of SpeechMiner. Click Import . The import process begins. If you are importing items that already exist in SMART, you are prompted to confirm that you want to replace the existing items with the ones contained in the file. Select Yes to confirm or No skip the item and continue with the import process. When the process is completed, a confirmation message appears: Click OK to close the message. Both the message and the Import dialog box close. See also Welcome Overview Managing Topics Managing Programs Managing Categories Applying Changes Managing Version History ||exporting_and_importing.htm","Inserting Special Characters| Home &gt; Overview &gt; Overview of the Interface &gt; Inserting Special Characters Inserting Special Characters You can type the special characters listed below by using the specified key combinations. This is primarily necessary when you are typing a Topic in a supported language that uses accented characters. To enter a special character: Make sure Num Lock is on. Hold down the ALT key and type the specified number.  Press Enter . The character is inserted into the text.   Character  Key Combination  á ALT 160 or ALT 0225 é ALT 130 or ALT 0233 í ALT 161 or ALT 0237 ó ALT 162 or ALT 0243 ú ALT 163 or ALT 0250 Á ALT 0193 É ALT 0201 Í  ALT 0205 Ó ALT 0211 Ú ALT 0218 ü ALT 129 or ALT 0252 Ü ALT 154 or ALT 0220 ñ ALT 164 or ALT 0241 Ñ ALT 165 or ALT 0209 ¿ ALT 168 or ALT 0191 ¡ ALT 173 or ALT 0161 ¼ ALT 172 ½ ALT 171 º ALT 167   See also Logging In Overview of the Main Window Organizing Items Hierarchically Locking and Unlocking Items Saving and Applying Changes ||inserting_special_characters.htm","Item Tags| Home &gt; Managing Version History &gt; Item Tags Item Tags Item tags can be created in three ways: Manually: You can manually create a tag for an item at any time. On closing SMART: When you close SMART, the system automatically creates a tag for each item definition that has been changed and has not yet been applied . On applying changes: When you apply changes to SpeechMiner, if you choose to create a backup, SMART automatically creates a tag for every item in the system; this tag contains the definition as it appears in SMART when the changes are applied Each item tag includes the current definition of the item, the date and time the tag was created, your user name, and a comment. When you manually create a tag, you can enter the comment text you want to attach to it. When you apply changes, if you added a comment to the backup settings, the comment is attached to the tag of every item in the system. When SMART generates tags automatically before it closes, the tags have blank comment fields. Manually Creating Item Tags You can create item tags for one or more items at a time, as long as they are all of the same type. For example, you can tag one or more Topics. To create tags for one or more items: In the left panel, select the tab of the type of item for which you want to create tags (Categories, Topics, or Programs), so that the tree structure is displayed. In the tree structure, right-click the item you want to tag. To tag multiple items, hold down Ctrl or Shift while you click, and right-click after all the items are selected. ( Ctrl causes individual items to be selected; Shift selects all items between the first and second item clicked.) In the menu, select Tag [ item type ] . For example, if you are in the Topics tree structure, select Tag Topic . The Tag [ item type ] dialog box opens. Tag Topic dialog box In the text field, enter a comment to attach to the tag. If you selected multiple items, select Apply to all if you want to attach the comment to all of the items. If you do not select this option, the Tag [ item type ] dialog box will open again for each item you selected, so that you can enter a different comment for each one. Note: The Apply to all option does not appear if only one item was selected in the tree structure. Click OK . The tags are created. Restoring a Tagged Definition Any definition of an item that is stored in a tag can be restored to SMART by rolling back the definition to the selected tag. Note that this rollback process only restores the item definitions within SMART. If you want to restore the definitions to SpeechMiner, you must apply them after they are restored in SMART. To restore a tagged definition: Make sure the item whose definition you want to restore is not open or locked. In the tree structure, right-click the item, and then select History . The History dialog box opens and displays a list of available tags for the item. History dialog box for Balance Inquiry Topic In the list, select the tag you want to restore. Click Mark for Rollback . A rollback message appears at the bottom of the dialog box indicating that the item definition will be restored in accordance with the selected tag. Rollback message Click OK . The definition of the item in SMART is restored to match the tagged definition. Managing Tags You can change the comment text of any tag that you created or any tag you have permissions to change. You can also delete these tags as necessary. Note: Tags that were generated as a set during an apply process cannot be modified or deleted individually as described below. For information about modifying or deleting them, see Rolling Back the Definition Set . To change the comment of a tag: In the tree structure, right-click the item whose definition you want to restore, and then select History . The History dialog box opens. Click the comment text that you want to change. The text becomes an editable text field. Modify the text as necessary and then click outside the text field to close it. Click OK . The change is saved. To delete tags: In the tree structure, right-click the item whose tag you want to delete, and then select History . The History dialog box opens. Select the tags you want to delete. To select multiple tags, hold down Ctrl or Shift while you click. ( Ctrl causes individual tags to be selected; Shift selects all tags between the first and second tags clicked.) Press Delete . The selected tags are deleted from the list. Click OK . The tags are deleted from the database. See also Rolling Back the Definition Set ||item_tags.htm","Language Support| Home &gt; Overview &gt; Language Support Language Support SpeechMiner can process calls in a variety of languages. Support for particular languages varies from organization to organization. Topic text may be typed in any supported language, but the SMART interface (menus, buttons, and labels) are only available in English. Please contact UTOPY Client Solutions for information on available language packages. See also Programs Events: Topics and Non-Linguistic Data Call Classification: Categories Overview of the Interface Typical Workflows ||language_support.htm","Locking and Unlocking Items| Home &gt; Overview &gt; Overview of the Interface &gt; Locking and Unlocking Items Locking and Unlocking Items When a user opens an item in SMART, it is automatically locked to other users. This means other users can view it but cannot save changes to it. This prevents situations in which two users attempt to edit the same item simultaneously. Users with the required permissions can also lock items manually, without opening them, to ensure that no one changes them. In this case, the lock is not canceled until it is unlocked manually. Note: Changes to items cannot be applied in SpeechMiner if the items are locked. Although changes to Programs can be applied even if one or more of their component Topics are locked, it is highly recommended to avoid doing so. To manually lock one or more items: In the tree list, select the items. Right-click and then select Lock [item type] . To manually unlock one or more items: In the tree list, select the items. Right-click and then select  Unlock [item type] . For each selected item, if you are the user who locked the item, it is unlocked immediately. Otherwise, a confirmation prompt appears for each item: Select Yes to unlock the item. The item is unlocked. If additional locked items were selected, a prompt appears for the next item. Repeat the process until you have confirmed the unlocking of all the selected items. Note: If you want to unlock all of the selected items without confirming a prompt for each one, select Apply to All before you select Yes .   See also Logging In Overview of the Main Window Organizing Items Hierarchically Inserting Special Characters Saving and Applying Changes ||locking_and_unlocking_items.htm","Logging In| Home &gt; Overview &gt; Overview of the Interface &gt; Logging In Logging In SMART is a Windows application that must be installed on your computer in order for you to be able to work with it. In addition, you must log into SMART with a SpeechMiner user account, and the user account must have permissions for working in SMART. You may have permissions for all SMART functions or only for some of them. When you log in, SMART automatically checks the roles and groups that are assigned to your account. The roles tell the system what SMART functions and features you can access. Only those items you have permissions to view are displayed in the interface when you are logged in. For additional information about your SpeechMiner user account and permissions, see the SpeechMiner user manual or contact your SpeechMiner system administrator. SpeechMiner stores recorded calls and information about their contents in a database. The system can work with more than one database. For example, it may have one database for actual work and another for system-testing purposes. When you log into SMART, you can specify which database you want to use. In general, you will not need to switch databases often, if at all. SMART saves the information about the last database you worked with and automatically connects you to that database the next time you log in unless you choose to change the database settings. The connection between SMART and the database can be encrypted to ensure that confidential data cannot be intercepted and viewed by unauthorized people. This option is configured by the system administrator on the SQL database server. Three encryption settings can be defined there: Always use encryption Never use encryption Use encryption when the user requests it If the latter setting is implemented in your system, you can choose to use an encrypted connection when you log into SMART. If the database server is configured to always encrypt or not to encrypt at all, you cannot change this option when you log into SMART. To log into SMART: On the Desktop of the computer, double-click the SMART icon. The SMART Title screen opens, and then the SMART - Login dialog box appears. SMART icon SMART Title screen SMART - Login dialog box Select SpeechMiner Authentication if your username and password are managed by SpeechMiner. Select Windows Authentication if you log into SpeechMiner using the same username and password you use to log into Windows. Note: If you are not sure which option to choose, consult your system administrator. In the Username and Password fields, type your username and password. Note: If you are logging in using Windows Authentication, under username, enter the domain and user name in the form domain?username . If this is the first time you are opening SMART on this computer, or if you want to change the existing database settings, click the DB Settings arrow. The Login dialog box expands and displays the database settings. Expanded Login dialog box If you are setting or modifying the database settings, fill in the fields as follows: Field Description SQL Server Authentication / Windows Authentication Select SQL Server Authentication if the username and password for accessing the database are managed on the SQL server. Select Windows Authentication if you log into the database using the same username and password you used to log into Windows. Note: If you are not sure which option to choose, consult your system administrator. Server The name of the server on which the database is stored Port The port to use to connect to the database server Username The username to use to connect to the database Note: This field is not available when Windows Authentication is selected. In this case, the username is automatically taken from the username used to log into Windows. Password The password to use to connect to the database Note: This field is not available when Windows Authentication is selected. In this case, the password is automatically taken from the username used to log into Windows. Database The name of the database Encrypt connection If encrypting the connection to the database is optional in your system, select this option to activate encryption. Note: If encryption is always turned on in your system, selecting or clearing this option will have no effect. If encryption is always turned off in your system, selecting this option will prevent SMART from connecting to the database server and you will not be able to log in. In this case, an error message saying, Could not connect to database. Please check database settings, will appear when you click OK . Click OK . You are logged into the system, and the main SMART window is displayed. Main SMART window See also Overview of the Main Window Organizing Items Hierarchically Locking and Unlocking Items Inserting Special Characters Saving and Applying Changes ||logging_in.htm","Managing Categories| Home &gt; Managing Categories Managing Categories Categories are used to group calls with similar characteristics so that SpeechMiner users can find calls that require their attention for particular reasons. The call characteristics that define a Category can be as simple as calls in which the Topic of interest rates was found, but they can also be very complex, defining a very specific mix of characteristics. For example, a Category can be defined to group calls in which the Topic Payments was mentioned by the agent, the customer displayed signs of agitation, and the call-center supervisor was called in to deal with the customer during the last two minutes of the call. SpeechMiner assigns calls to Categories after it has finished processing them. All the Categories in the system are global Categories that can be applied to any call. When call processing is completed for a call, SpeechMiner goes one by one through the list of Categories in the system and checks whether the call meets the conditions of the Category. If it does, the call is assigned to the Category. A single call may not belong to any Categories, but it can also belong to many Categories. Category assignment is intended to help reviewers find calls with particular characteristics so that they can analyze them and compare them. For example, reviewers may wish to compare how different agents handled customer agitation during a particular sales campaign. It also enables SpeechMiner to perform statistical analysis on calls. For example, SpeechMiner can check the percentage of calls in September in which customers exhibited agitation. Categories can be nested; a parent-Category can contain sub-Categories, and there can even be multi-tiered Categories, in which a Category is a sub-Category of one Category and a parent-Category to other Categories. In this case, only the lowest-level Category in the hierarchy is defined by specifying the characteristics of the calls that belong to it; the parent-Categories are defined as containers for their sub-Categories. Thus, when SpeechMiner identifies a call as belonging to a sub-Category, it automatically identifies it as belonging to the parent-Category as well. For example, a Category called Sales Campaigns could contain the sub-Categories Spring Campaign and Summer Campaign , and each of these sub-Categories could contain a number of their own sub-Categories, such as Supervisor Required , Customer Agitated , and Customer Agreement . Any call that was included in the Supervisor Required Category of the Spring Campaign would automatically also belong to the Spring Campaign Category and to the Sales Campaigns Category. Call reviewers could use any of these Categories to find calls belonging to the Supervisor Required Category of the Spring Campaign. Another type of Category is a Manual Category. These Categories have no criteria at all; users of SpeechMiner can use them to group calls manually when they are reviewing them. For example, a manual Category could be Weekly Review , and a SpeechMiner user could use it to save a list of calls to review during routine weekly staff meetings. See also Welcome Overview Managing Topics Managing Programs Applying Changes Managing Version History Exporting and Importing ||managing_categories.htm","Managing Programs| Home &gt; Managing Programs Managing Programs A Program is a set of instructions for analyzing recorded conversations between call center agents and customers. It includes all of the detailed instructions required by SpeechMiner to recognize the content of a call and display the results. Each set of distinctive calls being processed (for example, calls from a particular sales campaign) should have a separate Program.  All Programs include an instruction to identify non-linguistic data, such as key presses and caller agitation. You define a Program by specifying how the speech in the calls should be processed by SpeechMiner: Whether SpeechMiner should perform speech recognition. When speech recognition is performed, all the speech that is recognized is also transcribed. Transcription enables users to search for terms and facilitates certain types of reports that analyze the speech that is recognized for trends. Whether SpeechMiner should look for specific Topics  in calls, and, if so, where in the calls it should look for them. This aspect of a Program definition is essentially a structured list of Topics. Before you can add Topics to a Program, you must define them in SMART using the relevant Manager. Topic data enables users to search for calls containing particular Topics, and facilitates reports that analyze the Topic data. (If speech recognition is not performed, Topic recognition cannot be performed either.) Calls are sent to SpeechMiner from the external recording system. When they are received, they are put into SpeechMiner's processing queue to await their turn for analysis by SpeechMiner. Because the processing of some calls may be more important than the processing of others, SpeechMiner does not automatically process calls in the order in which they were placed into the queue. When you create a Program, you assign a priority level to it. SpeechMiner chooses which call to process first based on its priority level. SpeechMiner processes the highest priority calls in the queue first, and then proceeds to calls with lower priorities, regardless of how long the calls have been in the queue. (If multiple calls have the same priority level, SpeechMiner processes them in the order in which they were put into the queue.)    See also Welcome Overview Managing Topics Managing Categories Applying Changes Managing Version History Exporting and Importing ||managing_programs.htm","Managing Secured Topics| Home &gt; Managing Topics &gt; Managing Secured Topics Managing Secured Topics You can view a list of all the secured Topics in the system and their settings, and remove the settings from the properties of one or more Topic. When you remove the security settings from selected Topics, the properties of the Topics are modified. Note: You can also manually delete the security settings from a Topic in the Topic Properties dialog box. To view the list of secured Topics: In the Main Menu, under Tools , select Secured Topics . The Secured Topics dialog box opens and lists all of the secured Topics in the system. Secured Topics dialog box To delete the security settings from selected Topics: In the Secured Topics dialog box, select the Topics whose security settings you want to delete. To select multiple Topics, hold down Ctrl or Shift while you click them. Ctrl is used to select multiple items individually; Shift is used to select all items between the first and last item that is clicked. In the upper-left corner of the dialog box, click . The security settings are removed from the properties of all of the selected Topics. See also Creating an Effective Topic Overview of the Topic-Manager Interface Defining a New Topic Modifying a Topic Auditing a Topic Deleting Topics ||managing_secured_topics.htm","Managing the Program Structure| Home &gt; Managing Programs &gt; Defining a New Program &gt; Managing the Program Structure Managing the Program Structure The Program structure defines the order in which the Program items should appear in the call audio. The structure is defined using a flow chart. Each recognition task in the Program is represented in the flow chart by a rectangle, and the order of the flow is represented by arrows that connect the rectangles. If the Program has alternative flows, the flow chart can be branched to show the alternatives. If an item is optional, one branch can include the optional item while another does not. You can also define conditions for an optional section. For example, if a particular item would only appear in calls made by a particular agent, you could indicate that the link to the item is only for that agent. Note: You cannot include loops in a Program structure. However, SpeechMiner can recognize the same item more than once in a call, as long as it meets the conditions in each case. The Program structure is defined in the right pane of the Program Manager. By default, the structure is defined such that all of the items in the Program are sought throughout each call. In the structure diagram, this is indicated by a Start item with separate branches to each of the recognition tasks of the Program. Note: Gray rectangles represent items that cannot be removed from the Program. Default Program structure You can fine tune the structure to increase the efficiency and accuracy of the recognition process using the following features: Modify the structure diagram: Specify the order in which the items must appear in the call, and indicate where branches may occur and which items are optional, by adding and removing arrows in the structure diagram Configure trigger properties: Set conditions for the links defined in the structure diagram, including conditions that the parent item must meet and metadata conditions that the call must meet (e.g, that the agent must be from a particular work group, or the call must have taken place after a certain date) Configure recognition tasks: Specify that the item must have taken place at a certain time in the call. This section explains how to modify the structure diagram. For information about configuring triggers and recognition tasks, see Configuring Trigger Properties and Configuring Recognition Tasks . Structure Diagram Display Options The structure diagram can be fairly large. It may not fit easily into the Structure pane. If it is too wide or long for the available space, scroll bars are added to the pane to enable you to see the entire structure. The SMART interface also includes some display options that can help you see and manage the structure diagram more easily: Close the List pane so that the diagram can fill the entire right panel of the SMART window Display the diagram vertically or horizontally Display or hide details about the items in the diagram Closing and Opening the List Pane You can hide the List pane to allow more space for the structure diagram. List pane displayed List pane hidden To hide or display the List pane: In the display-control area above the List pane, click one of the following: To hide the List pane when it is visible To show the List pane when it is hidden Changing the Direction of the Diagram Display The structure diagram can be displayed either horizontally (as in the illustrations above) or vertically. Vertical structure diagram To change the direction of the structure diagram: In the display-control area above the List pane, click . Displaying Item Details You can choose to display or hide item details in the structure diagram. By default, the details are hidden. Details displayed To display or hide item details in the structure diagram: In the display-control area above the List pane, click . Creating a Child Link A child link indicates that a particular item - the child item - should only be sought in a call after another item - the parent item - is found. That is, the parent item must always precede the child item. For example, you could specify that the Rate Discussion Topic can only appear after the Time Frame Topic. To create a child link in the structure: Place the mouse cursor on the first item rectangle, hold down the left-mouse button, and drag the cursor to the second item rectangle. A line connecting the two items is displayed as you drag the mouse. Dragging the cursor to create a child link When you release the mouse button, the link is created. If the item was previously a child of the Start item, it becomes a child of the new item instead. If the item was previously a child of another item, both child links are retained. Rate Discussion linked as a child to Time Frame Note: When you create a link, SMART may rearrange the way all of the item rectangles are laid out in the structure area. Creating a Branch You can create a branch in the Program structure by creating two child links from the item before the branch - one to each of the alternative branches of the Program. To create a branch: Create a link between the section that precedes the branch and one of the alternative sections of the branch. Repeat the process by creating a second link from the section that precedes the branch to another of the alternative branches. The branch is created. (The arrangement of the section rectangles is modified as necessary to display the branches correctly.) Repeat the process as necessary in order to create all of the required branches. Creating an Optional Link An optional link is essentially an extra branch that contains an optional section. For example, if the agent only has to discuss a particular Topic in certain cases, but must continue with the rest of the flow in either case, you can create two branches, one with the Topic and the other without it. To create an optional link: Create a link from the section that precedes the optional section to the optional section. A branch is created for the optional section. Create a link from the optional section to the next section of the Program. The branch rejoins the main flow of the Program. Optional branch containing Phone Service Topic Deleting a Link You can delete existing links between items as necessary. To delete an existing link: Click the link. The selected link is displayed in yellow. Press Del . The link is deleted. The arrangement of the item rectangles is modified as necessary to display the structure as it is currently defined. If you removed the only link from a parent item to a particular child item, the child item becomes a child of the Start item. See also Configuring Trigger Properties Configuring Recognition Tasks Creating a Blank Program Adding Topics Using Notes Saving and Activating the Program ||defining_the_program_structure.htm","Managing Topics| Home &gt; Managing Topics Managing Topics A Topic is a subject that you want SpeechMiner to find in a call. A Topic definition consists of a collection of phrases (terms) that may be used in a call when the subject is being discussed. For example, the Topic Cancelation can be defined to include a list of terms such as close out my account or I need to cancel. Topics are defined globally for the SpeechMiner system, and then included in one or more Programs as required. When you include a Topic in a Program, SpeechMiner searches for all of the terms included in the Topic's definition in all calls that belong to the Program. When one of the terms is found, SpeechMiner identifies it as a linguistic Event indicating that the Topic has been found. See also Welcome Overview Managing Programs Managing Categories Applying Changes Managing Version History Exporting and Importing ||managing_topics.htm","Managing Version History| Home &gt; Managing Version History Managing Version History The version-management system is used to back up and restore previous definitions of individual items or of the entire definition set. Two types of back ups are supported: Item tags: Backups of the definitions of individual items, such as a specific Program or Topic Definition sets: Backups of entire sets of definitions; the existing set of definitions can be backed up before an updated set is applied This section explains how to manually create item tags and how to work with item tags and definition sets. See also Welcome Overview Managing Topics Managing Programs Managing Categories Applying Changes Exporting and Importing ||managing_history.htm","Marking Keywords| Home &gt; Managing Topics &gt; Defining a New Topic &gt; Marking Keywords Marking Keywords SpeechMiner searches for terms by keyword. If it finds a keyword, it checks to see if the other words in the term also appear as specified. The keyword of a term should reflect the intent of the term. SMART automatically chooses the keywords of terms if you do not select one yourself. However, it is best if you choose the keyword yourself, because this ensures that the correct keyword is selected. In general, only one keyword should be selected for each term; if two words always appear together, like credit card ', you can select them as the keyword. When you select a keyword in one term, SMART automatically selects the word as the keyword in every term in the list in which it appears. For example, if you select discount, discount is selected in all the terms in the list (but discounted is not). If you add additional terms containing one of the selected keywords, those words are also marked. To select a keyword: In the term, click the keyword. To the right of the list, click the Mark Important button. Pointy brackets are inserted on either side of the word, and the word is displayed in green, in every term in which it appears. Terms with keywords marked See also Creating a Blank Topic Adding Terms Saving the Topic ||marking_keywords.htm","Modifying a Category| Home &gt; Managing Categories &gt; Modifying a Category Modifying a Category Modifying an existing Category includes the following tasks: Modifying the definition of the Category: Changing the logical expression that defines the conditions of the Category, by adding, modifying, or removing elements or operators Changing the sharing settings of the Category Changing the name or description of the Category Activating or deactivating the Category Moving the Category up or down in the tree list Modifying Category nesting Modifying the Definition of a Category You can modify all parts of the definition of a Category - its name, description, and the logical expression that defines the conditions for assigning a call to a Category. To modify any aspect of a Category, you must open the Category in the right panel. When you have finished making changes to the Category, you must save them in SMART. To open a Category: In the left panel, click the Category Manager tab. The list of existing Categories is displayed in the tree structure. Double-click the Category, or select the Category and then click ( Open Category ). The Category opens in a tab in the right panel. Changing the Sharing Settings of the Category You can change the sharing settings of the Category as necessary. To change the sharing settings of the Category: To the right of the Share with field, click Edit . The Category Sharing dialog box opens. Modify the settings as necessary. For additional information, see Opening a Blank Category . Click OK . The Share with field is updated. Changing the Name and Description of the Category You can change the name and description of the Category as necessary. To change the name or description of the Category: Modify the Name and Description fields as necessary. Adding Elements and Operators to the Expression For information about adding elements to the expression, see Inserting Elements into an Expression . For information about adding operators, see Inserting Operators into an Expression . Modifying the Properties of an Element You can change the properties of any of the elements that are already included in the expression. For additional information about logical expressions, see Configuring the Category . To modify the properties of an existing element: In the text area, click the element. Its properties open below the text area. Change the properties as required. For additional information about the properties of each type of element, see: Configuring Metadata Elements Configuring Non-Linguistic Event Elements Configuring Program Elements Configuring Topic Elements Configuring Speaker-Type Elements Configuring Text Elements Click Update . The properties are modified. Removing Elements and Operators from the Expression You can remove any element or operator from the expression. To remove an element or operator from an expression: Click the element. The element is selected. At the top of the right panel, click . The selected item is deleted from the expression. Saving Changes Whenever you modify a Category, you must save the changes in order for them to be implemented in SMART. For additional information about saving changes in SMART and implementing them in SpeechMiner, see Saving and Applying Changes . To save changes to the Category: To the upper-left of the right panel, click ( Save ). Activating or Deactivating a Category A saved Category can be active or inactive . When an active Category is applied to SpeechMiner, calls can be assigned to it. When an inactive Category is applied, it is saved in SpeechMiner but cannot be assigned to calls. This feature allows you to temporarily stop using a Category when it is not relevant. When SpeechMiner processes a call, it checks every active Category to see if it should be assigned to the call. Because of this, it is a good idea to deactivate Categories that are not needed because it makes call processing faster and more efficient. For example, if you only use a particular Program during certain sales campaigns, you can deactivate Categories that require the Program when no sales campaigns that use it are underway. Activating or deactivating a parent Category causes all of its sub-Categories to be activated or deactivated along with it. When you deactivate a Category that has been applied to SpeechMiner previously, you have to apply it to SpeechMiner in order to deactivate it in SpeechMiner. To deactivate a Category: In the left panel, in the Category Manager tab, select the Category. In the tree controls above the tree structure, click ( Deactivate ). The Category is deactivated in SMART. If you want to deactivate the Category in SpeechMiner, apply the Category. For additional information, see Applying Changes . After you modify a Category, make sure it is active before you apply it to SpeechMiner. Active Categories appear in the SMART tree list in bold type. To activate a Category: In the left panel, in the Category Manager tab, select the Category. In the tree controls above the tree structure, click ( Activate ). The Category is activated. Moving a Category Up or Down in the Tree List The list of Categories appears in SpeechMiner in the same order and with the same structure as it does in SMART. It is therefore a good idea to organize the list in a way that is convenient for SpeechMiner users. You can do this by moving Categories up or down in the tree list. To move a Category up or down in the tree list: In the tree list select the Category In the tree controls above the tree structure, click ( Move Up ) or ( Move Down ) as many times as necessary to move the Category to the desired location in the tree list. Modifying Category Nesting You can change any regular Category into a parent Category or a sub-Category, or move a sub-Category from one parent Category to another at any time (see Organizing Items Hierarchically ). To change a regular Category into a parent Category: In the tree list, drag a Category over the regular Category. The regular Category becomes the parent of the other Category. (Note that any conditions that were defined for the regular Category are deleted when it becomes a parent Category.) To change a regular Category into a sub-Category, or move a sub-Category from one parent Category to another: In the tree list, drag the Category over the desired parent Category. See also Overview of the Category-Manager Interface Defining a New Category Deleting Categories ||modifying_a_category.htm","Modifying a Program| Home &gt; Managing Programs &gt; Modifying a Program Modifying a Program Modifying an existing Program includes the following tasks: Managing the recognition tasks of the Program: Adding or removing recognition tasks Modifying the Program structure Modifying the configuration of the recognition tasks and triggers Managing Program notes Changing the priority level of the Program Activating or deactivating the Program Changing the properties of the Program Moving the Program to a different folder Managing the Recognition Tasks In order to manage the Program's recognition tasks, you must open the Program in the right panel. Once it is open, you can follow the instructions for defining a new Program to modify it as necessary. See Defining a New Program . To open a Program: In the left panel, click the Program Manager tab. The list of existing Programs is displayed in the tree structure. Double-click the Program, or select the Program and then click ( Open Program ). The Program opens in a tab in the right panel. Changing the Priority Level of the Program The priority level tells SpeechMiner in what order to process calls that are in the processing queue: Calls with higher priority are processed first. Five priority levels are defined: Very High , High , Medium , Low , and Very Low . The default priority level is Medium . For additional information about priority levels, see Managing Programs . Note: This level, and the process order setting, can be changed in SpeechMiner under Tools&gt;System Admin&gt;Manage Call Queue The priority level is one of the Program properties, and can be modified in the Program Properties dialog box, as explained below . However, you can also raise or lower the priority level without opening the dialog box, as follows: To change the priority level of the Program: In the left panel, in the tree list, right-click the Program, and then select Increase Program Priority to raise the priority one level, or Decrease Program Priority to lower the priority one level. The change is automatically saved. Saving Changes Whenever you make changes to the contents of a Program, you must save the changes in order for them to be implemented in SMART. For additional information about saving changes in SMART and implementing them in SpeechMiner, see Saving and Applying Changes . To save changes to the Program: To the upper-left of the right panel, click ( Save ). Activating or Deactivating a Program A saved Program can be active or inactive . When an active Program is applied to SpeechMiner, it can be used to process calls that belong to it. When an inactive Program is applied, it is saved in SpeechMiner but cannot be used to process calls. Calls that belong to it are not processed. This feature allows you to temporarily stop using a Program when you want to modify it. For example, if you want to modify a Program that is currently being used to process calls, the first thing you might want to do is deactivate the Program so that it will not process any more calls until the change you make is applied. When you deactivate a Program that has been applied to SpeechMiner previously, you have to apply the change in order to deactivate it in SpeechMiner. To deactivate a Program: In the left panel, in the Program Manager tab, select the Program. In the tree controls above the tree structure, click ( Deactivate ). The Program is deactivated in SMART. If you want to deactivate the Program in SpeechMiner, apply the Program. For additional information, see Applying Changes . After you modify a Program, make sure it is active before you apply it to SpeechMiner. Active Programs appear in the SMART tree list in bold type. To activate a Program: In the left panel, in the Program Manager tab, select the Program. In the tree controls above the tree structure, click ( Activate ). The Program is activated. Note: You can also activate or deactivate a Program in the Program Properties dialog box, as explained below. Modifying Program Properties Many of the Program properties are set automatically by the system and cannot be changed by users, but you can change all of the user-defined properties except for the language. To modify Program properties: In the left panel, click the Program Manager tab. The list of existing Programs is displayed in the tree structure. Right-click the Program, and then select Open Program Properties . The Program Properties dialog box opens. Program Properties dialog box Modify the properties as necessary. (For information about these properties, see Opening a Blank Program .) Click OK . The dialog box closes, and the properties are modified. Moving a Program to a Different Folder You can move a Program to a different folder at any time, either by changing its Folder in the Program Properties , as described above , or by dragging the Program to another folder in the tree list (see Organizing Items Hierarchically ). See also Overview of the Program-Manager Interface Defining a New Program Deleting Programs ||modifying_a_program.htm","Modifying a Topic| Home &gt; Managing Topics &gt; Modifying a Topic Modifying a Topic Modifying an existing Topic includes the following tasks: Managing the list of terms: Filtering the list Adding additional terms Modifying existing terms Deleting existing terms Viewing and restoring deleted terms Changing the keyword selection Changing the properties of the Topic Moving the Topic to a different folder Managing the List of Terms In order to manage the list of terms in a Topic, you must open the Topic in the right panel. To open a Topic: In the left panel, click the Topic Manager tab. The list of existing Topics is displayed in the tree structure. Double-click the Topic, or select the Topic and then click ( Open Topic ). If the Topic is linked to one or more Programs, a Topic Edit message appears, prompting you to confirm that you want to open the Topic. Topic Edit message In the Topic Edit message, click Yes . The Topic opens in a tab in the right panel, and the list of terms it contains is displayed. Open Topic Filtering the List of Terms You can filter the display of terms so that only terms that include a specified text string are visible in the list. For example, if you only want to see terms that include the word reduce in any of its forms, you can limit the display to terms that include the string reduc. Terms that include reduce, reduces, reduced, and reduction will be displayed; all other terms will be hidden from view. To specify a text string to use as a filter: To the right of the list, under Filter , type the text string. The list is filtered as you type. To clear the filter: To the right of the list, click Clear . Adding Terms Adding additional terms can be done as explained under Defining a New Topic . Modifying Existing Terms You can change the text of any term in the list. In addition, you can modify the Strictness of a term (see Customizing the Strictness of a Term ). To modify a term: In the term list, select the term. The term appears in the Term field above the list, and the New button to the right of the field becomes an Update button.. In the Term field, modify the term as required. Click Update . The term is updated in the list To modify the Strictness value of a term: In the term list, select the term, and then click the Set Strictness ( ) button. The Term Strictness dialog box opens. To use the default Strictness value for the Topic, select Topic Strictness . To set a custom value, select Custom , and then modify the value as required. Click OK . The Strictness value is modified. Deleting Terms You can delete any term from the list. Deleted terms are not sought in calls, but they are nevertheless stored in SMART's database. You can view and restore them later, if necessary (see below ). To delete terms: In the term list, select the terms. To delete multiple terms, hold down the Ctrl key and click each term. To the left of the list, click ( Delete) . The selected terms are deleted. Displaying and Restoring Deleted Terms You can include all the previously deleted terms in the list, and you can restore selected terms. To include deleted terms in the list: To the right of the list, select Show Deleted . All previously deleted terms are added to the display. A icon appears beside each deleted term. Select the deleted terms you want to restore. To select multiple terms, hold down the Ctrl key and click each term. List including deleted terms, with the first deleted term selected To the left of the list, click ( Restore ). The selected terms are restored. Changing the Keyword Selection You can cancel the selection of a keyword. When you do, the marking of every instance of the keyword is removed. (The words are not removed from the terms.) To cancel the selection of a keyword: Select the keyword in one of the terms. The Mark Important button becomes an Unmark Important button. Click the Unmark Important button. The Mark Important designation is removed from every instance of the selected word. Saving Changes Whenever you modify a Topic, you must save the changes in order for them to be implemented in SMART. For additional information about saving changes in SMART and implementing them in SpeechMiner, see Saving and Applying Changes . To save changes to the Topic: To the upper-left of the right panel, click ( Save ). Modifying Topic Properties Most of the Topic properties are set automatically by the system and cannot be changed by users, but you can change the folder, name, description, and Strictness of a Topic. To modify Topic properties: In the left panel, click the Topic Manager tab. The list of existing Topics is displayed in the tree structure. Right-click the Topic, and then select Open Topic Properties . If the Topic is linked to one or more Programs, a Topic Edit message appears, prompting you to confirm that you want to open the Topic properties. Topic Edit message In the Topic Edit message, click Yes . The Topic Properties dialog box opens. Topic Properties dialog box Modify the properties as necessary. (For information about these properties, see Opening a Blank Topic .) Click OK . The dialog box closes, and the properties are modified. Moving a Topic to a Different Folder You can move a Topic to a different folder at any time, either by changing its Folder in the Topic Properties , as described above , or by dragging the Topic to another folder in the tree list (see Organizing Items Hierarchically ). See also Creating an Effective Topic Overview of the Topic-Manager Interface Defining a New Topic Auditing a Topic Managing Secured Topics Deleting Topics ||modifying_a_topic.htm","Organizing Items Hierarchically| Home &gt; Overview &gt; Overview of the Interface &gt; Organizing Items Hierarchically Organizing Items Hierarchically Each of the Managers - Categories, Topics, and Programs - enables you to organize items in a hierarchic fashion. Topics and Programs can be contained in folders, and Categories can contain sub-Categories. The hierarchic organization is designed to help you manage large numbers of items. For example, if your call center is involved in sales campaigns and handles customer service calls from customers, you could create folders for each sales campaign and each type of customer-service issue. The hierarchic organization of Categories has an additional, functional purpose. When a sub-Category is assigned to a call by SpeechMiner, its parent Category is also automatically assigned to it. For example, if the Category Sales Campaigns has the sub-Categories Spring Campaign and Summer Campaign , whenever Spring Campaign is assigned to a call, Sales Campaigns is also assigned to it. Note: For simplicity, in this page, folders and parent Categories are called containers . You can create new items in containers or move existing items to new containers or from one container to another. To create a folder in the Topics or Programs Manager: In the tree list, select the folder in which you want to create the folder. To create a top-level folder, select the All folder. In the tree-list control bar, click . A new folder is added under the selected folder. It is initially called new folder. Type a name for the new folder, and then press Enter . The name is applied. Any existing Category can be used as a parent Category simply by creating or placing a sub-Category in it. The simplest way to create a parent Category is to create a new blank Category.   To create a parent Category: Place a sub-Category in an existing Category. The Category in which you placed the sub-Category becomes a parent Category. Note: Parent Categories cannot have any properties (i.e. they have a name but no definition). If you use an existing Category as a parent Category, any properties it has when the first sub-Category is added to it are automatically removed.  To create a new item in an existing container: Select the container. In the tree-list control bar, click the button that opens a new item of the current type. For example, if you are creating a new Program in the Program Manager, click . A dialog box or screen opens where you can define the properties of the new item. For detailed information about how to do this, see the relevant section in this manual. To move an item to a container or from one container to another: Drag the item to the target container.    See also Logging In Overview of the Main Window Locking and Unlocking Items Inserting Special Characters Saving and Applying Changes ||organizing_items_using_folders.htm","Overview of the Category-Manager Interface| Home &gt; Managing Categories &gt; Overview of the Category-Manager Interface Overview of the Category-Manager Interface The Category Manager contains the following elements: Element Number in Illustration Description Category Manager tab 1 Select this tab to display the Category Manager Categories menu 2 Click to open a menu for managing items in the tree list (also available by right-clicking anywhere in the tree list) Tree-list controls 3 Controls for managing the items in the tree list (i.e., shortcuts to some of the Categories menu items) and filtering the items Note: If the left pane is not wide enough to display all of the items in the menu bar, click the arrow ( ) on the right to access the hidden options. Tree structure 4 Expandable list of Categories Expression area 5 Box containing a logical expression that defines the conditions for inclusion in the Category that is open and selected in the right panel Child Categories list 6 Displays a list of the sub-Categories of the Categories that are selected in the Tree structure, with information about the status and definition of each one. All levels of sub-Categories are included in the list. For example, if you select a Category whose sub-Categories have sub-Categories, the sub-Categories of both levels are included. Note: To select multiple Categories in the Tree structure, hold down Ctrl or Shift and click the Categories. Ctrl selects each Category you click; Shift selects all of the Categories between the first Category and the second Category you click. Note: In the Child Categories list, use the bottom scroll bar to view hidden parts of the list. Place your mouse cursor over the definition column to see the complete definition. Element Properties area 7 Area in which each statement (condition) contained in the logical expression is defined or modified Save button 8 Click to save changes that were made to the displayed Category; changes are saved in SMART, but not applied in SpeechMiner Open Category tab 9 Tab of a Category that is open but not currently displayed Note: Click the tab to display the Category. Operator buttons 10 Click a button to insert the selected operator into the logical expression; the operator is inserted immediately before the selected statement or, if no statements are selected, at the end of the expression Displayed Category tab 11 Tab of the currently displayed Category Note: Multiple windows can be open at one time in SMART. Click a tab to view the desired window. Category definition pane 12 The right panel of the Category Manager, in which the properties of the Category, including the logical expression that defines the conditions for inclusion in the Category, are defined Sharing settings 13 Displays the current sharing settings of the Category Edit sharing-settings button 14 Click to open a dialog box in which you can edit the sharing settings of the Category See also Defining a New Category Modifying a Category Deleting Categories ||introduction3.htm","Overview of the Interface| Home &gt; Overview &gt; Overview of the Interface Overview of the Interface This section provides a general overview of the SMART interface: how to log in, the layout of the main window, and some standard features that are available whenever you are working with SMART. Later chapters provide details about working with the interface to create and manage Programs, Categories, and their components.   See also Programs Events: Topics and Non-Linguistic Data Call Classification: Categories Language Support Typical Workflows ||overview_of_the_interface.htm","Overview of the Main Window| Home &gt; Overview &gt; Overview of the Interface &gt; Overview of the Main Window Overview of the Main Window The main SMART window contains the following elements: Element Number in Illustration Description Main Menu 1 A menu bar providing access to some of the application options Quick Access Bar 2 Buttons providing quick access to selected options from the SMART menu: Refresh: Updates the display to include all of the latest changes made by SMART users working with the system Apply: Opens the Apply dialog box, which allows you to apply the latest definitions that are saved in SMART to SpeechMiner Import: Opens the Import dialog box, which allows you to import definitions that were previously exported from a SMART system Export: Opens the Export dialog box, which allows you to export definitions to a file; the definitions can be imported from the file to any SMART system Tabs 3 Tabs for selecting the type of manager to open: Categories, Topics, or Programs: Click a tab to open the required Manager. The tree list (no. 8) displays the items in the selected group, and the tab menu button and tree-list controls for the selected manager appear above the tree list. Tab menu button 4 Click to open a menu for managing items in the currently displayed tree list (also available by right-clicking anywhere in the tree list) Tree-list menu bar 5 Controls for managing the items in the tree list Note: If the left pane is not wide enough to display all of the items in the menu bar, a dropdown menu containing all of the hidden options is added on the right of the menu bar. Click the arrow ( ) to open the menu and access the hidden options. Filter text box 6 Enables you to hide items that are not of interest so that they are temporarily not included in the tree list: Type a sequence of one or more characters. Items that do not contain the sequence are not displayed in the tree list. Note: This option works in conjunction with the Filter button (no. 7); only those items that contain the specified character sequence and also belong to the selected filter group are displayed. Filter button 7 Enables you to hide items that are not of interest so that they are temporarily not included in the tree list: Click the arrow and select the desired filter. The tree list is updated in accordance with your choice. Note: This option works in conjunction with the Filter text box (no. 6); only those items that belong to the selected filter group and also contain the specified character sequence are displayed. Tree structure 8 Expandable list of items in the selected tab group Note: To change the width of the left pane, drag the right border left or right. Child Categories 9 Display of the child Categories of the Category selected in the tree list. Note: This area is only displayed when the Categpry Manager is open in the tree structure. Autohide button 10 Enables you to hide the left panel when it is not in use: When autohide is turned off, click to turn it on. The left panel is hidden whenever your mouse is not over it, and the tabs are moved to the left edge of the window. Click a tab to open the left panel and display the relevant Manager. When autohide is turned on, click to turn it off. The left panel remains open all the time. Window tabs 11 Multiple items of all types can be open in SMART at one time. A tab is displayed for each open window. Click the appropriate tab to view a particular window. Note: Alternatively, to view a window, select it in the main menu under Window . Selected tab 12 The tab of the window that is currently displayed Window-tab controls 13 Controls for the Window tabs: If many windows are open, some of the window tabs may not be visible. Click or to scroll the tab bar to the left or right. To close the selected window tab, click . See also Logging In Organizing Items Hierarchically Locking and Unlocking Items Inserting Special Characters Saving and Applying Changes ||elements_of_the_main_window.htm","Overview of the Program-Manager Interface| Home &gt; Managing Programs &gt; Overview of the Program-Manager Interface Overview of the Program-Manager Interface The Program Manager contains the following elements: Element Number in Illustration Description Program Manager tab 1 Select this tab to display the Program Manager Programs menu 2 Click to open a menu for managing items in the tree list (also available by right-clicking anywhere in the tree list) Tree-list controls 3 Controls for managing the items in the tree list (i.e., shortcuts to some of the Programs menu items) and filtering the items Note: If the left pane is not wide enough to display all of the items in the menu bar, click the arrow ( ) on the right to access the hidden options. Tree structure 4 Expandable list of Programs Save button 5 Click to save changes that were made to the displayed Program; changes are saved in SMART, but not applied in SpeechMiner Display-control buttons 6 Click a button to choose a display option: Changes the direction of the structure diagram from horizontal to vertical and vice versa Shows or hides details in the structure diagram Hides the List pane to make more room for the structure diagram; Shows the List pane when it is hidden List-pane tabs 7 Tabs for selecting what you want to display in the List pane - a list of the items in the Program (Topics and Non-linguistic data), notes, or a list of the links in the Program structure Displayed-Program tab 8 Tab of the currently displayed Program Note: Multiple windows can be open at one time in SMART. Click a tab to view the desired window. Open Program tab 9 Tab of a Program that is open but not currently displayed Note: Click the tab to display the Program. List pane 10 Area in which either a list of the items in the Program (Topics and Non-linguistic data), notes, or a list of the links in the Program structure are displayed Structure pane 11 Area in which the Program's structure is displayed See also Defining a New Program Modifying a Program Deleting Programs ||introduction2.htm","Overview of the Topic-Manager Interface| Home &gt; Managing Topics &gt; Overview of the Topic-Manager Interface Overview of the Topic-Manager Interface The standard version of the Topic Manager contains the elements in the illustration below. Element Number in Illustration Description Topic Manager tab 1 Select this tab to display the Topic Manager Topics menu 2 Click to open a menu for managing items in the tree list (also available by right-clicking anywhere in the tree list) Tree-list menu bar 3 Controls for managing the items in the tree list (i.e., shortcuts to some of the Topics menu items) and filtering them Note: If the left pane is not wide enough to display all of the items in the menu bar, click the arrow ( ) on the right to access the hidden options. Topic counter 4 Number indicating how many Topics are in the selected folder. If no folder is selected, the total number of Topics in the database appears. Term controls 5 Buttons for managing selected items in the list of terms Tree structure 6 Expandable list of Topics Save button 7 Click to save changes that were made to the displayed Topic; changes are saved in SMART, but not applied in SpeechMiner Audit Report button 8 Click to open the Topic Analysis - Audits report template in the SpeechMiner web interface. Note: Only available if you have auditing permissions. Displayed Topic tab 9 Tab of the currently displayed Topic Note: Multiple windows can be open at one time in SMART. Click a tab to view the desired window. Term field 10 Text field in which you can type new terms or edit existing terms; if an existing term is selected, it is displayed here Open Topic tab 11 Tab of a Topic that is open but not currently displayed Note: Click the tab to display the Topic. Topic Properties 12 Information about the strictness level required for the Topic, when the Topic was last saved, and by whom Term list 13 List of terms in the Topic Selected term 14 Term that is currently selected and displayed in the Term field (#10) Auditing information 15 Auditing information for each term in the Term list (see Auditing a Topic ). Note: If you do not have auditing permissions, this information is not displayed. Term-list controls 16 Buttons and options for working with the list of terms See also Creating an Effective Topic Defining a New Topic Modifying a Topic Auditing a Topic Managing Secured Topics Deleting Topics ||introduction.htm","Overview| Home &gt; Overview Overview SMART , the SpeechMiner Administration Tool, is a component of UTOPY SpeechMiner, UTOPY's award-winning, flagship product for Customer Intelligence. SpeechMiner analyzes recorded conversations between call-center agents and customers in accordance with a customizable set of instructions. SMART is used to define the set of instructions that is used by SpeechMiner in a particular organization. These instructions specify the way SpeechMiner performs recognition and analysis of customer data; SMART allows SpeechMiner users to create, edit, and update the recognition instructions so that SpeechMiner can identify the content of each call with maximum accuracy. The sets of instructions that are managed in SMART can be divided into two general parts: Call analysis: Programs tell SpeechMiner which specific linguistic and non-linguistic Events to search for in calls. Call classification: Categories are used to categorize calls after their content is analyzed, based on their content and other characteristics. The combination of call analysis and classification enables SpeechMiner users to find and play back important Events and to analyze groups of calls based on their characteristics. Typically, SpeechMiner implementations at our customer sites include development of the underlying SMART system by UTOPY's client solutions team. However, advanced SpeechMiner users who have SpeechMiner administrator privileges can choose to modify the SMART system themselves in order to further fine-tune call recognition and analysis in their company's implementation of SpeechMiner. See also Programs Events: Topics and Non-Linguistic Data Call Classification: Categories Language Support Overview of the Interface Typical Workflows ||overview.htm","Programs| Home &gt; Overview &gt; Programs Programs Programs are sets of instructions that tell SpeechMiner what content to try to identify in the audio of a particular type of call. Each type of call that SpeechMiner analyzes should have its own custom-designed Program. For example, each sales campaign should have a Program that defines how calls that are part of the campaign should be processed. Conversely, every call that is received by SpeechMiner is automatically assigned a Program before it is processed. }}-->  Programs can configure SpeechMiner to perform the following types of content processing: Speech: Transcribing all of the speech it recognizes in a call Topics:  Identifying speech that indicates a specific intent by searching for predefined terms in call audio Non-linguistic characteristics: Identifying non-verbal parts of a call, such as silence, a busy signal, a key press, or caller-agitation  A Topic is a list of alternative phrases (terms) that reflect a particular intent. Programs can include multiple Topics; SpeechMiner searches for all of the terms in all of the Topics when it processes calls in a Program. Each Program is organized as a structure diagram that links content types in a consecutive string to mimic the expected flow of the conversation. The diagram is used to tell SpeechMiner where in a call the content must be found in order to match the requirements. For example, a structure diagram could show a Loan Offer Topic at the beginning of a call, followed by a Disclaimer Topic, and, finally, a Contact Information Topic.    See also Events: Topics and Non-Linguistic Data Call Classification: Categories Language Support Overview of the Interface Typical Workflows ||using_programs.htm","Rolling Back the Definition Set| Home &gt; Managing Version History &gt; Rolling Back the Definition Set Rolling Back the Definition Set If you chose to save a backup when you applied changes to SpeechMiner (see Applying Changes ), the entire definition set can be restored to SpeechMiner later on as necessary. When the definitions are restored, they are automatically applied to SpeechMiner, and the calls in the database are reprocessed and re-Categorized. This process is called rollback . Note: It is highly recommended to create a backup whenever you apply changes. If you do so, you will be able to undo apply processes after they are implemented, by rolling back to the previous, saved definition set. To restore the definitions in SpeechMiner to a saved set: Make sure no items are open or locked. In SMART, in the  SMART menu, select Apply History . The  Apply History dialog box opens and displays a list of available definition sets. History dialog box In the list, select the definition set you want to restore. Click Mark for Rollback . A rollback message appears at the bottom of the dialog box indicating that the definition set will be restored in accordance with the selected set. Rollback message Click OK . The rollback process begins, and the Apply Rollback dialog box opens: Apply Rollback dialog box When the process is completed, a confirmation message appears: Confirmation message Click OK to close the message. Managing Stored Definition Sets You can change the comment text of any stored definition set, and delete definition, sets as necessary. To change the comment of a definition set: In SMART, in the  SMART menu, select Apply History . The  Apply History dialog box opens.  Click the comment text that you want to change. The text becomes an editable text field. Modify the text as necessary and then click outside the text field to close it. Click OK . The change is saved. To delete definition sets: In SMART, in the  SMART menu, select Apply History . The Apply History dialog box opens. Select the definition sets you want to delete. To select multiple sets, hold down Ctrl or Shift while you click. ( Ctrl causes causes individual sets to be selected; Shift selects all sets between the first and second sets clicked.) Press Delete . The selected sets are deleted from the list. Click OK . The sets are deleted from the database. See also Item Tags ||rolling_back_the_definition_set.htm","Running the Topic Analysis - Audits Report| Home &gt; Managing Topics &gt; Auditing a Topic &gt; Running the Topic Analysis - Audits Report Running the Topic Analysis - Audits Report The Topic Analysis - Audits report is one of the reports that can be generated from a template in the SpeechMiner web interface. The report shows the precision with which Topics were identified by SpeechMiner. Precision values are given for one or more confidence levels, as specified in the report parameters, and are determined by the TP/FP/SFP (True Positive/False Positive/Sense False Positive) selections made by the call auditor. You can drill down from any Topic included in the report to see detailed information about each term in the Topic. When you run the Topic Analysis - Audits report, you can choose which calls to include in the data set that will be used for the report. For example, you can choose to see information only about specific Topics from a specified time range and involving specific agents. This can help you interpret the auditing data. Topic Analysis - Audits report Drilling down to see data about the terms of a selected Topic For your convenience, you can run the Topic Analysis - Audits report directly from the SMART interface. Note: For complete information about SpeechMiner report templates in general and the Topic Analysis - Audits report in particular, please refer to the SpeechMiner User Manual. To run the Topic Analysis - Audits report from the SMART Topic Manager: Above the list of terms, click . The SpeechMiner web interface opens in a browser window. If you are already logged into SpeechMiner, the Topic Analysis - Audits report template opens immediately. If not, the SpeechMiner login screen opens. Enter your SpeechMiner username and password, and then the Topic Analysis - Audits report template will open. Topic Analysis - Audits report template Select the settings for the report. At the top of the template, click Run ( ). The report runs, and the results are displayed below the template. See also Viewing Term Statistics ||running_the_topic_analysis_-_audits_report.htm","Saving and Activating the Category| Home &gt; Managing Categories &gt; Defining a New Category &gt; Saving and Activating the Category Saving and Activating the Category When you create a blank Category, it is saved automatically. When you modify the name, description, or conditional expression, you should save the Category manually. For additional information about saving changes in SMART and applying them to SpeechMiner, see Saving and Applying Changes . To save a Category: To the upper-left of the right panel, click  ( Save ). A saved Category can be active or inactive . When an active Category is applied to SpeechMiner, calls can be assigned to it. When an inactive Category is applied, it is saved in SpeechMiner but calls cannot be assigned to it. This feature allows you to temporarily stop using a Category when you want to modify it.  Before you apply a new Category to SpeechMiner, make sure it is active. Active Categories appear in the tree list in bold type. To activate a Category: In the left panel, in the Category Manager tab, select the Category. In the tree controls above the tree structure, click  ( Activate ). The Category is activated.   See also Creating a Blank Category Configuring Category Conditions ||saving_the_category.htm","Saving and Activating the Program| Home &gt; Managing Programs &gt; Defining a New Program &gt; Saving and Activating the Program Saving and Activating the Program When you open a blank Program, it is saved automatically. When you add or modify recognition tasks or other items, you should save the Program manually. For additional information about saving changes in SMART and applying them to SpeechMiner, see Saving and Applying Changes . To save a Program: To the upper-left of the right panel, click ( Save ). A saved Program can be active or inactive . When an active Program is applied to SpeechMiner, it can be used to process calls that belong to it. When an inactive Program is applied, it is saved in SpeechMiner but cannot be used to process calls. Calls that belong to it are not processed. This feature allows you to temporarily stop using a Program when you want to modify it. Before you apply a new Program to SpeechMiner, make sure it is active. Active Programs appear in the tree list in bold type. To activate a Program: In the left panel, in the Program Manager tab, select the Program. In the tree controls above the tree structure, click ( Activate ). The Program is activated. See also Creating a Blank Program Adding Topics Managing the Program Structure Using Notes ||saving_and_activating_the_program.htm","Saving and Applying Changes| Home &gt; Overview &gt; Overview of the Interface &gt; Saving and Applying Changes Saving and Applying Changes Although SMART is a stand-alone application, it only exists in order to configure SpeechMiner. When you make changes in SMART - creating new items, or changing or deleing existing items, you save the changes in SMART as you proceed, but they do not affect the call-processing performed by SpeechMiner until they are applied . If you apply your changes, the instructions that are followed by SpeechMiner are updated to match your changes, and all the calls in the database are re-categorized. Note: Calls can also be reprocessed following changes to SMART using the SpeechMiner browser-based interface. For additional information, see the SpeechMiner manual. For additional information about applying changes, see Applying Changes . See also Logging In Overview of the Main Window Organizing Items Hierarchically Locking and Unlocking Items Inserting Special Characters ||saving_changes_in_smart.htm","Saving the Topic| Home &gt; Managing Topics &gt; Defining a New Topic &gt; Saving the Topic Saving the Topic Once you have added the required terms to the new Topic and marked their keywords, you can save the Topic in SMART. The first time you save a Topic, SMART offers the following options: Create a new Category for the Topic: If you choose this option, SMART automatically opens a new Category with the same name as the Topic, and configures the Category such that linguistic Events in which the Topic is recognized are included in the Category. (If you do not choose to do this at this point, you can manually open a Category for the Topic Defining a New Category or include the Topic in the properties of one or more existing Categories later; see Managing Categories .) Link the Topic to an existing Program: If you choose this option, SMART adds the Topic to the selected Program. (If you do not choose to do this at this point, you can manually link the Topic to one or more Programs later; see Managing Programs .) To save a new Topic: To the upper-left of the list of terms, click ( Save ). The Topic Express dialog box opens. Topic Express dialog box Note: If you try to save a Topic that contains terms that are too short to be effective, before the Topic Express dialog box opens you are prompted to choose how to handle them. Prompt about short terms If you want to create a Category for the Topic, select Build a default category for this topic. If you want to include the Topic in a Program, select Search this topic in program , and then, in the dropdown list, select the Program. Click OK . The Topic is saved in SMART and the options you selected are implemented. See also Creating a Blank Topic Adding Terms Marking Keywords ||saving_the_topic.htm","Typical Workflows| Home &gt; Overview &gt; Typical Workflows Typical Workflows In general, UTOPY Inc. technical staff performs the entire initial set up of customer implementations of SpeechMiner on site, including the initial configuration in SMART. UTOPY Inc. professional staff is also available to modify your company's implementation, including the instructions defined in SMART, as required. This means that users do not normally build the system of instructions that are defined in SMART from scratch. In fact, if you wish, you can leave all necessary updating to UTOPY. However, if you wish to do so, you can make moderate changes to SMART on your own, as explained in this manual. Typically, you will want to make slight modifications to Topics based on the accuracy of the results they are achieving, or define new Programs for new call campaigns or procedures based on existing ones. Therefore, typically, you will perform the following tasks when you work with SMART: Open existing items - Categories, Topics, Programs - in order to modify them. Create new items, either from scratch or by copying existing items, and define their properties. Add new Topics to a Program, and define the structure of the Program (by specifying when the items are expected to occur in the timeline of a call). Save changes to items as you modify them, by clicking a Save or OK button. Optionally, test the changes by applying them to a demo database. Apply changes to SpeechMiner when you have completed the modification process. Reprocess selected calls through the SpeechMiner browser-based interface. Other tasks that you may have occasion to perform are: Rolling back the current set of instructions to an earlier set, if parts of the newer set were only relevant for a limited time, or changes made were not useful  Importing an existing set of instructions to SMART Exporting the current set of instructions from SMART to a file. This is typically done for one of the following reasons: To send the output to another location within your company for importing into a different SMART implementation To send the output to UTOPY Inc. staff for testing or when you are having a problem with the system To create a backup copy of the set of instructions.  See also Programs Events: Topics and Non-Linguistic Data Call Classification: Categories Language Support Overview of the Interface ||getting_started.htm","Using Notes| Home &gt; Managing Programs &gt; Defining a New Program &gt; Using Notes Using Notes You can add notes to the entire Program as necessary. The notes can be seen by SpeechMiner users when they review calls that belong to the Program. To add new Program notes and modify existing notes: In the List pane, select the Notes tab. The existing notes are displayed. Modify the text as required. Notes in the Notes tab   See also Creating a Blank Program Adding Topics Managing the Program Structure Saving and Activating the Program ||using_notes.htm","Viewing Term Statistics| Home &gt; Managing Topics &gt; Auditing a Topic &gt; Viewing Term Statistics Viewing Term Statistics If you have Audit permissions in SpeechMiner (Audit Events in Calls Grid is allowed in the permissions of at least one of the Roles applied to your SpeechMiner account), the Topic Manager screen in SMART includes additional information about each term in the Topic that is not visible to other users. The illustration below shows what an open Topic looks like in this case. The table to the right of the list of terms contains the additional information for each term. Only Events that are recognized with at least the strictness specified for the Topic (indicated under Applied Strictness above the list of terms) are included in the data. Clicking links in this data opens Call Grids listing the calls in each category. You can use the grids to listen to the Topic Events in the calls and audit them for accuracy. This information can help you decide if certain terms should be modified or removed from the Topic, and if additional terms should be added. Topic Manager screen for users with Auditing permissions Overview of the Auditing Data The auditing data included in the Topic Manager provides information about how often terms in the Topic were found in calls and how accurately SpeechMiner identified them. The table contains the following data for each term: Column Description Percent The percentage of all the calls in the database in which the term was found Calls Count The number of calls in the database in which the term was found Events Count The number of times the term was found in the database Audits The number of times the term was audited for precision (was rated TP, FP, or SFP) TP Count The number of times the term was rated TP during auditing FP Count The number of times the term was rated FP during auditing SFP Count The number of times the term was rated SFP during auditing Audits Precision The percentage of TP ratings among all the audits Filtering the Events by Date You can filter the Event data set by selecting the earliest date to include in the data. To set the date filter: Above the list of terms, in the Show Calls Since field, select the start date of the data set. Click Refresh Audits . The data is refreshed; only data from calls that took place from the selected date on are included in it. Sorting the Terms You can sort the terms in the list alphabetically. To sort the terms: Click the Text button in the title bar of the list of terms. (Click it a second time to reverse the sort order.) Understanding the Term-Auditing Data Each linguistic Event that is recognized in a call can be audited . This means that a SpeechMiner user listens to the Event and then rates the precision of the identification. The rating can be one of the following: TP (True Positive): The Event was correctly identified by SpeechMiner. FP (False Positive): The Event was incorrectly identified by SpeechMiner. SFP (Sense False Positive): The words were correctly identified by SpeechMiner, but they were used in a sense that does not match the intent of the Topic. In order to audit an Event, the auditor must play the Event using an Event Grid. After listening to the Event, the auditor rates the accuracy of the Event recognition by selecting the rating in the TP/FP column of the Event Grid. Auditing can be performed in this way either in the SpeechMiner web interface or directly from SMART. Opening a Call Grid You can open a Call Grid directly from the Topic Manager screen. Once the list is open, you can use it to open the Media Player and play back calls. If the grid contains an Event list, you can audit the Event recognition and add or modify the precision ratings of the Events. Note: For information about working with Call Grids, playing calls in the Media Player, and auditing Events, please refer to the SpeechMiner User Manual. To open a Call Grid: In the table of term information, click the number in the relevant column, as follows: Column List Contents Calls Count A Call Grid containing calls in which the term was found Events Count An Event Grid listing locations in which the term was found Audits An Event Grid listing locations in which the term was audited TP Count An Event Grid listing locations in which the term was audited and rated TP FP Count An Event Grid listing locations in which the term was audited and rated FP SFP Count An Event Grid listing locations in which the term was audited and rated SFP Refreshing the Data While the Topic Manager is open, SpeechMiner continues to process calls. In addition, you or other users may audit Events that were already included in the data. You can refresh the data at any time to incorporate information about newly processed calls and newly audited Events. To refresh the term data: On the right side of the window, click Refresh Audits . Managing Terms Based on the information about the terms that were recognized by SpeechMiner in actual calls, you can modify the words of a term, add new terms, or delete existing terms, as necessary. For example, if a term is not recognized consistently (has a large number of FP ratings), you could add more words to the term to make it easier for SpeechMiner to identify. Similarly, if the auditing data show that the term frequently does not match the intent of the Topic (has a large number of SFP ratings), you could add more words to it in order to ensure it is only identified when it really does match the intent of the Topic. On the other hand, if you think a term with a large number of FPs or SFPs cannot be improved, you might choose to delete it. For information about how to modify the list of terms defined for a Topic, see Modifying a Topic . See also Running the Topic Analysis - Audits Report ||viewing_phrase_statistics.htm","Welcome| Welcome to the SMART online help system. Overview Managing Topics Managing Programs Managing Categories Applying Changes Managing Version History Exporting and Importing If you're unable to find what you're looking for in this help system, try these alternative resources: utopy.com Support site or contact our support team: Email: support@utopy.com Last Updated: February 14, 2011 &copy; 2012 UTOPY Inc. ||Welcome.htm");