//
//  GMSDMenu.m
//  GMSDMenu
//
/*
 Version: 1.0
 
 Disclaimer: IMPORTANT:  This software is supplied to you by Genesys
 Telecommunications Laboratories Inc ("Genesys") in consideration of your agreement
 to the following terms, and your use, installation, modification or redistribution
 of this Genesys software constitutes acceptance of these terms.  If you do not
 agree with these terms, please do not use, install, modify or redistribute this
 Genesys software.
 
 In consideration of your agreement to abide by the following terms, and subject
 to these terms, Genesys grants you a personal, non-exclusive license, under
 Genesys's copyrights in this original Genesys software (the "Genesys Software"), to
 use, reproduce, modify and redistribute the Genesys Software, with or without
 modifications, in source and/or binary forms; provided that if you redistribute
 the Genesys Software in its entirety and without modifications, you must retain
 this notice and the following text and disclaimers in all such redistributions
 of the Genesys Software.
 
 Neither the name, trademarks, service marks or logos of Genesys Inc. may be used
 to endorse or promote products derived from the Genesys Software without specific
 prior written permission from Genesys.  Except as expressly stated in this notice,
 no other rights or licenses, express or implied, are granted by Genesys herein,
 including but not limited to any patent rights that may be infringed by your
 derivative works or by other works in which the Genesys Software may be
 incorporated.
 
 The Genesys Software is provided by Genesys on an "AS IS" basis.  GENESYS MAKES NO
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
 WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, REGARDING THE GENESYS SOFTWARE OR ITS USE AND OPERATION ALONE OR IN
 COMBINATION WITH YOUR PRODUCTS.
 
 IN NO EVENT SHALL GENESYS BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, MODIFICATION AND/OR
 DISTRIBUTION OF THE GENESYS SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF
 CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF
 GENESYS HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
 Copyright (C) 2013 Genesys Inc. All Rights Reserved.
 */

#import "GMSDMenu.h"
#import "GMSDMenuTableViewController.h"
#import "GMSDMenuFormViewController.h"
#import "NSData+Base64.h"
#import "UIAlertViewBlock.h"


@implementation GMSDMenu
{
    NSDictionary *topLevelDictionary;
    UINavigationController *navigationController;       //Main navigation controller
}

+ (GMSDMenu *)initWithObject:(UINavigationController *)navController;
{
    GMSDMenu *dMenu = [[GMSDMenu alloc] init];
    dMenu->navigationController = navController;
    return dMenu;
}

- (void) submitRequest2GMS:(NSString *)URL              //URL
                    method:(NSString *)method           //POST or GET
                    params:(NSDictionary *)params       //parameters for POST request
                   headers:(NSDictionary *)headers      //custom HTTP headers for POST request
{
    if (!(URL && method)) {
        //both URL and method are empty => return
        return;
    }
    
    [[UIApplication sharedApplication] setNetworkActivityIndicatorVisible:YES];
    
    NSMutableURLRequest *request;
    
    if ([method isEqualToString:@"GET"]) {
        
        __block NSString *paramStr = [URL stringByAppendingFormat:@"?"];
        
        [params enumerateKeysAndObjectsUsingBlock:^(id key, id value, BOOL *stop){
            paramStr = [paramStr stringByAppendingFormat:@"%@=%@&", key, value];
        }];
        
        request = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:paramStr]
                                          cachePolicy:NSURLRequestUseProtocolCachePolicy
                                      timeoutInterval:30.0];
        [request setHTTPMethod:@"GET"];
        
        [self logRequest:[NSString stringWithFormat:@"Method: GET, URL: %@", paramStr] direction:toGMS];
    }
    
    if ([method isEqualToString:@"POST"]) {
        request = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:URL]
                                          cachePolicy:NSURLRequestUseProtocolCachePolicy
                                      timeoutInterval:30.0];
        [request setHTTPMethod:@"POST"];
        [request setValue:@"application/json" forHTTPHeaderField:@"Accept"];
        
        [headers enumerateKeysAndObjectsUsingBlock:^(id key, id value, BOOL *stop){
            [request setValue:value forHTTPHeaderField:key];
        }];
        
        //look if we can use application/x-www-form-urlencoded
        __block BOOL urlEncoding = YES;
        [params enumerateKeysAndObjectsUsingBlock:^(id key, id value, BOOL *stop){
            if ([value isKindOfClass:[NSData class]]) {
                urlEncoding = NO;
                *stop = YES;
            };
        }];
        
        if (urlEncoding) {
            
            [request setValue:@"application/x-www-form-urlencoded" forHTTPHeaderField:@"Content-Type"];
            
            __block NSString *paramStr = @"";
            
            [params enumerateKeysAndObjectsUsingBlock:^(id key, id value, BOOL *stop){
                paramStr = [paramStr stringByAppendingFormat:@"%@=%@&", key, value];
            }];
            
            [request setHTTPBody:[paramStr dataUsingEncoding:NSUTF8StringEncoding]];
            
            [self logRequest:[NSString stringWithFormat:@"Method: POST, URL: %@, Body: %@", URL, paramStr] direction:toGMS];
        }
        else { //Multi-part
            [request setValue:@"multipart/form-data; boundary=AaB03x" forHTTPHeaderField:@"Content-Type"];
            
            NSMutableData *requestBody = [[NSMutableData alloc] init];
            
            NSString *boundary = @"--AaB03x\r\nContent-Disposition: form-data; name=";
            
            [params enumerateKeysAndObjectsUsingBlock:^(id key, id value, BOOL *stop){
                if ([value isKindOfClass:[NSString class]]) {
                    NSString *part = [NSString stringWithFormat:@"%@\"%@\"\r\n\r\n%@\r\n", boundary, key, value];
                    [requestBody appendData:[part dataUsingEncoding:NSUTF8StringEncoding]];
                }
                if ([value isKindOfClass:[NSData class]]) {
                    NSString *part = [NSString stringWithFormat:@"%@\"%@\"; filename=\"GMS.png\"\r\nContent-Type:image/png\r\n\r\n", boundary, key];
                    [requestBody appendData:[part dataUsingEncoding:NSUTF8StringEncoding]];
                    [requestBody appendData:[[value base64Encoding] dataUsingEncoding:NSUTF8StringEncoding]];
                    [requestBody appendData:[@"\r\n" dataUsingEncoding:NSUTF8StringEncoding]];
                }
            }];
            
            [requestBody appendData:[@"--AaB03x--" dataUsingEncoding:NSUTF8StringEncoding]];
            [request setHTTPBody:requestBody];
            
            NSString *strBody = [[NSString alloc] initWithData:requestBody encoding:NSASCIIStringEncoding];
            NSString *trimmedBody;
            trimmedBody = ([strBody length] > 350) ? [NSString stringWithFormat:@"%@ ... %@", [strBody substringToIndex:150], [strBody substringFromIndex:[strBody length] - 150]] : strBody;
            
            [self logRequest:[NSString stringWithFormat:@"Method: POST, URL: %@,\nHeaders: %@\nBody: %@\n", URL, [request allHTTPHeaderFields], trimmedBody] direction:toGMS];
        }
    }
    
    [NSURLConnection sendAsynchronousRequest:request
                                       queue:[NSOperationQueue mainQueue]
                           completionHandler:^(NSURLResponse *response, NSData *data, NSError *error) {
                               
                               [[UIApplication sharedApplication] setNetworkActivityIndicatorVisible:NO];
                               
                               NSDictionary *responseDict = nil;
                               
                               if ([data length] > 0 && error == nil) {
                                   NSString *responseStr = [[NSString alloc] initWithData:data encoding:NSUTF8StringEncoding];
                                   [self logRequest:responseStr direction:fromGMS];
                                   // Parse the responseData, which we asked to be in JSON format for this request, into an NSDictionary using NSJSONSerialization.
                                   NSError *jsonParsingError = nil;
                                   responseDict = [NSJSONSerialization JSONObjectWithData:data options:0 error:&jsonParsingError];
//                                   if (responseDict[@"result"]) {
//                                       responseDict = responseDict[@"result"];
//                                   }
                                   
                                   if (jsonParsingError) {
                                       [self logRequest:[NSString stringWithFormat:@"JSON parsing error: %@", jsonParsingError] direction:fromGMS];
                                   }
                                   if ([responseDict isKindOfClass:[NSDictionary class]]) {
                                       [self processResponse:responseDict];
                                   }
                               }
                               else if (error != nil){
                                   UIAlertView *alert = [[UIAlertView alloc]
                                                         initWithTitle: @"Error accessing GMS Server"
                                                         message: [NSString stringWithFormat:@"URL: %@, Error: %@", URL, error]
                                                         delegate: nil
                                                         cancelButtonTitle:@"OK"
                                                         otherButtonTitles:nil];
                                   [alert show];
                               }

                               if (_completionBlock) {
                                   _completionBlock(responseDict);
                               }
                           }
     ];
}

- (void) logRequest:(NSString *)txt2Log direction:(int)dir {
    //Update Log View
    [[NSNotificationCenter defaultCenter] postNotificationName:kUpdateNotification
                                                        object:self
                                                      userInfo:@{@"direction":@(dir), @"text":txt2Log}];
}


//Finds child object with ID == IDToFind in dict2Search, returns found oject dictionary or nil

- (NSDictionary *) findID:(NSDictionary *)dict2Search IDToFind:(NSString *)IDToFind {
    
    __block NSDictionary *foundDict = nil;
    
    [dict2Search enumerateKeysAndObjectsUsingBlock:^(id key, id value, BOOL *stop){
        if ([value isKindOfClass:[NSString class]] && [value isEqualToString:IDToFind]) {
            *stop = YES;
            foundDict = dict2Search;
        }
        if ([value isKindOfClass:[NSDictionary class]]) {
            foundDict = [self findID:value IDToFind:IDToFind];
        }
        if ([value isKindOfClass:[NSArray class]]) {
            [value enumerateObjectsUsingBlock:^(id obj, NSUInteger idx, BOOL *stopInArray) {
                if ([obj isKindOfClass:[NSDictionary class]]) {
                    foundDict = [self findID:obj IDToFind:IDToFind];
                    if (foundDict) {
                        *stopInArray = YES;
                    }
                }
            }];
        }
    }];
    
    return foundDict;
}

- (void)openURL:(NSDictionary *)actionDict
{
    //TO DO: implement OpenURL POST method with PostParameters
    
    NSString *URL = actionDict[@"_display_url"];
    if (URL) {
        [self logRequest:[NSString stringWithFormat:@"Opening URL: %@", URL] direction:fromGMS];
        NSDictionary *cD = actionDict[@"_confirmation_dialog"];
        if (cD) {
            //"OkTitle" button is always present, otherButton is optional
            UIAlertViewBlock *alert = [[UIAlertViewBlock alloc] initWithTitle:@"Message from GMS"
                                                                      message:cD[@"_text"]
                                                                   completion:^(BOOL okPressed, NSInteger buttonIndex, NSDictionary *txtFieldParams) {
                                                                       if (okPressed) {
                                                                           [[UIApplication sharedApplication] openURL:[NSURL URLWithString:URL]];
                                                                       }
                                                                   }
                                                            cancelButtonTitle:cD[@"_ok_title"]
                                                            otherButtonTitles:cD[@"_cancel_title"], nil];
            [alert show];
        }
        else {
            [[UIApplication sharedApplication] openURL:[NSURL URLWithString:URL]];
        }
    }
}

- (void)dialNumber:(NSDictionary *)actionDict
{
    NSString *telURL = actionDict[@"_tel_url"];
    if (telURL) {
        [self logRequest:[NSString stringWithFormat:@"Dialing number: %@", telURL] direction:fromGMS];
        NSDictionary *cD = actionDict[@"_confirmation_dialog"];
        if (cD) {
            //"OkTitle" button is always present, otherButton is optional
            UIAlertViewBlock *alert = [[UIAlertViewBlock alloc] initWithTitle:@"Message from GMS"
                                                                      message:cD[@"_text"]
                                                                   completion:^(BOOL okPressed, NSInteger buttonIndex, NSDictionary *txtFieldParams) {
                                                                       if (okPressed) {
                                                                           [[UIApplication sharedApplication] openURL:[NSURL URLWithString:telURL]];
                                                                       }
                                                                   }
                                                            cancelButtonTitle:cD[@"_ok_title"]
                                                            otherButtonTitles:cD[@"_cancel_title"], nil];
            [alert show];
        }
        else {
            [[UIApplication sharedApplication] openURL:[NSURL URLWithString:telURL]];
        }
    }
}

- (void)startChat:(NSDictionary *)actionDict
{
    if (_startChatBlock) {
        _startChatBlock(actionDict);
    }
}

- (void)endChat
{
    if (_endChatBlock) {
        _endChatBlock();
    }
}

- (void)showAlert:(NSDictionary *)responseDict
       jumpBefore:(NSString *)jumpBefore
    userActionURL:(NSString *)userActionURL
           method:(NSString *)method
{
    void (^complBlock)(BOOL okPressed, NSInteger buttonIndex, NSDictionary *txtFieldParams) = ^(BOOL okPressed, NSInteger buttonIndex, NSDictionary *txtFieldParams) {
        if (okPressed) {
            //Jump before
            [self jumpBefore:jumpBefore];
            [self submitRequest2GMS:userActionURL method:method params:txtFieldParams headers:nil];
        }
    };
    
    if ([responseDict[@"_dialog_type"] isEqualToString:@"Notification"]){
        //No buttons - submit result to GMS after dismiss timeout
        complBlock = ^(BOOL okPressed, NSInteger buttonIndex, NSDictionary *txtFieldParams) {
            //Jump before
            [self jumpBefore:jumpBefore];
            [self submitRequest2GMS:userActionURL method:method params:txtFieldParams headers:nil];
        };
    }
    
    UIAlertViewBlock *alert;
    if ([responseDict[@"_dialog_type"] isEqualToString:@"Notification"]) {
        alert = [[UIAlertViewBlock alloc]
                 initWithTitle: @"Message from GMS"
                 message: responseDict[@"_text"]
                 completion:complBlock
                 cancelButtonTitle:nil
                 otherButtonTitles:nil];
        alert.dismissTimeout = [[responseDict objectForKey:@"_dismiss_timeout"] doubleValue];
        if (alert.dismissTimeout <= 0.) {
            alert.dismissTimeout = 60.; //default value
        }
    }
    else {
        alert = [[UIAlertViewBlock alloc]
                 initWithTitle: @"Message from GMS"
                 message: responseDict[@"_text"]
                 completion:complBlock
                 cancelButtonTitle:responseDict[@"_ok_title"]
                 otherButtonTitles:responseDict[@"_cancel_title"], nil];
        alert.txtFieldsParams = responseDict[@"_text_fields"];
    }
    
    
    if ([responseDict[@"_dialog_type"] isEqualToString:@"TextInput"]) {
        alert.alertViewStyle = UIAlertViewStylePlainTextInput;
    }
    else if ([responseDict[@"_dialog_type"] isEqualToString:@"SecureTextInput"]) {
        alert.alertViewStyle = UIAlertViewStyleSecureTextInput;
    }
    else if ([responseDict[@"_dialog_type"] isEqualToString:@"Login"]) {
        alert.alertViewStyle = UIAlertViewStyleLoginAndPasswordInput;
    }
    
    [alert show];
}

- (void) processResponse:(NSDictionary *)responseDict
{
    
    if ([responseDict[@"_action"] isEqualToString:@"DisplayMenu"]) {
        //DisplayMenu will become new top level object
        topLevelDictionary = responseDict;
        
        //Jump before
        [self jumpBefore:responseDict[@"_id_to_jump_top_level"]];
        
        
        GMSDMenuTableViewController *topMenu = [GMSDMenuTableViewController initWithObject:responseDict
                                                                              parentObject:nil
                                                                             dMenuDelegate:self];
        // Pass the selected vObject to the new view controller.
        [navigationController popToRootViewControllerAnimated:NO];
        [navigationController pushViewController:topMenu animated:NO];
    }
    
    else if ([responseDict[@"_action"] isEqualToString:@"DialNumber"]) {
        [self dialNumber:responseDict];
    }
    
    else if ([responseDict[@"_action"] isEqualToString:@"OpenURL"]) {
        [self openURL:responseDict];
    }
    
    else if ([responseDict[@"_action"] isEqualToString:@"Form"]) {
        //Form will become new top level object
        topLevelDictionary = responseDict;
        GMSDMenuFormViewController *formMenu = [GMSDMenuFormViewController initWithObject:responseDict parentObject:nil dMenuDelegate:self];
        // Pass the selected vObject to the new view controller.
        [navigationController popToRootViewControllerAnimated:NO];
        [navigationController pushViewController:formMenu animated:NO];
    }
    
    else if ([responseDict[@"_action"] isEqualToString:@"ConfirmationDialog"]) {
                
        [self showAlert:responseDict
             jumpBefore:responseDict[@"_id_to_jump_top_level"]
          userActionURL:responseDict[@"_user_action_url"]
                 method:responseDict[@"_method"]];
    }
    
    else if ([responseDict[@"_action"] isEqualToString:@"StartChat"]) {
        [self startChat:responseDict];
    }

    else if ([responseDict[@"_action"] isEqualToString:@"EndChat"]) {
        [self endChat];
    }

}

- (void) jumpBefore:(NSString *)id2Jump {
    if ([id2Jump hasPrefix:@"exit://"]) {
        [navigationController popToRootViewControllerAnimated:NO];
    }
    if ([id2Jump hasPrefix:@"menu://"]) {
        
        //Get ID of the object to jump to
        NSString *idN = [[id2Jump componentsSeparatedByString:@"menu://"] lastObject];
        if (idN) {
            NSDictionary *newD = [self findID:topLevelDictionary IDToFind:idN];
            //Prevent loop
            if (newD && ![newD[@"_dialog_id"] isEqualToString:id2Jump]) {
                [self processResponse:newD];
            }
        }
    }
}


@end
