/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.internal.ab;
import com.google.android.gms.internal.bb;
import com.google.android.gms.internal.bq;

public final class GameEntity
extends bq
implements Game {
    public static final GameEntityCreator CREATOR = new a();
    private final int W;
    private final String da;
    private final String ci;
    private final String db;
    private final String dc;
    private final String dd;
    private final String de;
    private final Uri df;
    private final Uri dg;
    private final Uri dh;
    private final boolean di;
    private final boolean dj;
    private final String dk;
    private final int dl;
    private final int dm;
    private final int dn;

    public GameEntity(Game game) {
        this.W = 1;
        this.da = game.getApplicationId();
        this.db = game.getPrimaryCategory();
        this.dc = game.getSecondaryCategory();
        this.dd = game.getDescription();
        this.de = game.getDeveloperName();
        this.ci = game.getDisplayName();
        this.df = game.getIconImageUri();
        this.dg = game.getHiResImageUri();
        this.dh = game.getFeaturedImageUri();
        this.di = game.isPlayEnabledGame();
        this.dj = game.isInstanceInstalled();
        this.dk = game.getInstancePackageName();
        this.dl = game.getGameplayAclStatus();
        this.dm = game.getAchievementTotalCount();
        this.dn = game.getLeaderboardCount();
    }

    GameEntity(int versionCode, String applicationId, String displayName, String primaryCategory, String secondaryCategory, String description, String developerName, Uri iconImageUri, Uri hiResImageUri, Uri featuredImageUri, boolean playEnabledGame, boolean instanceInstalled, String instancePackageName, int gameplayAclStatus, int achievementTotalCount, int leaderboardCount) {
        this.W = versionCode;
        this.da = applicationId;
        this.ci = displayName;
        this.db = primaryCategory;
        this.dc = secondaryCategory;
        this.dd = description;
        this.de = developerName;
        this.df = iconImageUri;
        this.dg = hiResImageUri;
        this.dh = featuredImageUri;
        this.di = playEnabledGame;
        this.dj = instanceInstalled;
        this.dk = instancePackageName;
        this.dl = gameplayAclStatus;
        this.dm = achievementTotalCount;
        this.dn = leaderboardCount;
    }

    public int F() {
        return this.W;
    }

    public String getApplicationId() {
        return this.da;
    }

    public String getDisplayName() {
        return this.ci;
    }

    public void getDisplayName(CharArrayBuffer dataOut) {
        bb.b(this.ci, dataOut);
    }

    public String getPrimaryCategory() {
        return this.db;
    }

    public String getSecondaryCategory() {
        return this.dc;
    }

    public String getDescription() {
        return this.dd;
    }

    public void getDescription(CharArrayBuffer dataOut) {
        bb.b(this.dd, dataOut);
    }

    public String getDeveloperName() {
        return this.de;
    }

    public void getDeveloperName(CharArrayBuffer dataOut) {
        bb.b(this.de, dataOut);
    }

    public Uri getIconImageUri() {
        return this.df;
    }

    public Uri getHiResImageUri() {
        return this.dg;
    }

    public Uri getFeaturedImageUri() {
        return this.dh;
    }

    public boolean isPlayEnabledGame() {
        return this.di;
    }

    public boolean isInstanceInstalled() {
        return this.dj;
    }

    public String getInstancePackageName() {
        return this.dk;
    }

    public int getGameplayAclStatus() {
        return this.dl;
    }

    public int getAchievementTotalCount() {
        return this.dm;
    }

    public int getLeaderboardCount() {
        return this.dn;
    }

    public Game freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.a(this);
    }

    public static int a(Game game) {
        return ab.hashCode(game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.isPlayEnabledGame(), game.isInstanceInstalled(), game.getInstancePackageName(), game.getGameplayAclStatus(), game.getAchievementTotalCount(), game.getLeaderboardCount());
    }

    public boolean equals(Object obj) {
        return GameEntity.a(this, obj);
    }

    public static boolean a(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return ab.equal(game2.getApplicationId(), game.getApplicationId()) && ab.equal(game2.getDisplayName(), game.getDisplayName()) && ab.equal(game2.getPrimaryCategory(), game.getPrimaryCategory()) && ab.equal(game2.getSecondaryCategory(), game.getSecondaryCategory()) && ab.equal(game2.getDescription(), game.getDescription()) && ab.equal(game2.getDeveloperName(), game.getDeveloperName()) && ab.equal(game2.getIconImageUri(), game.getIconImageUri()) && ab.equal(game2.getHiResImageUri(), game.getHiResImageUri()) && ab.equal(game2.getFeaturedImageUri(), game.getFeaturedImageUri()) && ab.equal(game2.isPlayEnabledGame(), game.isPlayEnabledGame()) && ab.equal(game2.isInstanceInstalled(), game.isInstanceInstalled()) && ab.equal(game2.getInstancePackageName(), game.getInstancePackageName()) && ab.equal(game2.getGameplayAclStatus(), game.getGameplayAclStatus()) && ab.equal(game2.getAchievementTotalCount(), game.getAchievementTotalCount()) && ab.equal(game2.getLeaderboardCount(), game.getLeaderboardCount());
    }

    public String toString() {
        return GameEntity.b(this);
    }

    public static String b(Game game) {
        return ab.c(game).a("ApplicationId", game.getApplicationId()).a("DisplayName", game.getDisplayName()).a("PrimaryCategory", game.getPrimaryCategory()).a("SecondaryCategory", game.getSecondaryCategory()).a("Description", game.getDescription()).a("DeveloperName", game.getDeveloperName()).a("IconImageUri", game.getIconImageUri()).a("HiResImageUri", game.getHiResImageUri()).a("FeaturedImageUri", game.getFeaturedImageUri()).a("PlayEnabledGame", game.isPlayEnabledGame()).a("InstanceInstalled", game.isInstanceInstalled()).a("InstancePackageName", game.getInstancePackageName()).a("GameplayAclStatus", game.getGameplayAclStatus()).a("AchievementTotalCount", game.getAchievementTotalCount()).a("LeaderboardCount", game.getLeaderboardCount()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.t()) {
            GameEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.da);
            dest.writeString(this.ci);
            dest.writeString(this.db);
            dest.writeString(this.dc);
            dest.writeString(this.dd);
            dest.writeString(this.de);
            dest.writeString(this.df == null ? null : this.df.toString());
            dest.writeString(this.dg == null ? null : this.dg.toString());
            dest.writeString(this.dh == null ? null : this.dh.toString());
            dest.writeInt(this.di ? 1 : 0);
            dest.writeInt(this.dj ? 1 : 0);
            dest.writeString(this.dk);
            dest.writeInt(this.dl);
            dest.writeInt(this.dm);
            dest.writeInt(this.dn);
        }
    }

    static final class a
    extends GameEntityCreator {
        a() {
        }

        public GameEntity createFromParcel(Parcel in) {
            boolean bl2 = GameEntity.c(GameEntity.s());
            if (bl2 || GameEntity.g(GameEntity.class.getCanonicalName())) {
                return super.createFromParcel(in);
            }
            String string2 = in.readString();
            String string3 = in.readString();
            String string4 = in.readString();
            String string5 = in.readString();
            String string6 = in.readString();
            String string7 = in.readString();
            String string8 = in.readString();
            Uri uri = string8 == null ? null : Uri.parse((String)string8);
            String string9 = in.readString();
            Uri uri2 = string9 == null ? null : Uri.parse((String)string9);
            String string10 = in.readString();
            Uri uri3 = string10 == null ? null : Uri.parse((String)string10);
            boolean bl3 = in.readInt() > 0;
            boolean bl4 = in.readInt() > 0;
            String string11 = in.readString();
            int n2 = in.readInt();
            int n3 = in.readInt();
            int n4 = in.readInt();
            return new GameEntity(1, string2, string3, string4, string5, string6, string7, uri, uri2, uri3, bl3, bl4, string11, n2, n3, n4);
        }
    }
}

