/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.internal.ab;
import com.google.android.gms.internal.bb;
import com.google.android.gms.internal.bq;
import com.google.android.gms.internal.r;

public final class PlayerEntity
extends bq
implements Player {
    public static final PlayerEntityCreator CREATOR = new a();
    private final int W;
    private final String ds;
    private final String ci;
    private final Uri df;
    private final Uri dg;
    private final long dt;

    public PlayerEntity(Player player) {
        this.W = 1;
        this.ds = player.getPlayerId();
        this.ci = player.getDisplayName();
        this.df = player.getIconImageUri();
        this.dg = player.getHiResImageUri();
        this.dt = player.getRetrievedTimestamp();
        r.b(this.ds);
        r.b(this.ci);
        r.a(this.dt > 0L);
    }

    PlayerEntity(int versionCode, String playerId, String displayName, Uri iconImageUri, Uri hiResImageUri, long retrievedTimestamp) {
        this.W = versionCode;
        this.ds = playerId;
        this.ci = displayName;
        this.df = iconImageUri;
        this.dg = hiResImageUri;
        this.dt = retrievedTimestamp;
    }

    public int F() {
        return this.W;
    }

    public String getPlayerId() {
        return this.ds;
    }

    public String getDisplayName() {
        return this.ci;
    }

    public void getDisplayName(CharArrayBuffer dataOut) {
        bb.b(this.ci, dataOut);
    }

    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    public Uri getIconImageUri() {
        return this.df;
    }

    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    public Uri getHiResImageUri() {
        return this.dg;
    }

    public long getRetrievedTimestamp() {
        return this.dt;
    }

    public Player freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.a(this);
    }

    public static int a(Player player) {
        return ab.hashCode(player.getPlayerId(), player.getDisplayName(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp());
    }

    public boolean equals(Object obj) {
        return PlayerEntity.a(this, obj);
    }

    public static boolean a(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return ab.equal(player2.getPlayerId(), player.getPlayerId()) && ab.equal(player2.getDisplayName(), player.getDisplayName()) && ab.equal(player2.getIconImageUri(), player.getIconImageUri()) && ab.equal(player2.getHiResImageUri(), player.getHiResImageUri()) && ab.equal(player2.getRetrievedTimestamp(), player.getRetrievedTimestamp());
    }

    public String toString() {
        return PlayerEntity.b(this);
    }

    public static String b(Player player) {
        return ab.c(player).a("PlayerId", player.getPlayerId()).a("DisplayName", player.getDisplayName()).a("IconImageUri", player.getIconImageUri()).a("HiResImageUri", player.getHiResImageUri()).a("RetrievedTimestamp", player.getRetrievedTimestamp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.t()) {
            PlayerEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.ds);
            dest.writeString(this.ci);
            dest.writeString(this.df == null ? null : this.df.toString());
            dest.writeString(this.dg == null ? null : this.dg.toString());
            dest.writeLong(this.dt);
        }
    }

    static final class a
    extends PlayerEntityCreator {
        a() {
        }

        public PlayerEntity createFromParcel(Parcel in) {
            boolean bl2 = PlayerEntity.c(PlayerEntity.s());
            if (bl2 || PlayerEntity.g(PlayerEntity.class.getCanonicalName())) {
                return super.createFromParcel(in);
            }
            String string2 = in.readString();
            String string3 = in.readString();
            String string4 = in.readString();
            String string5 = in.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            Uri uri2 = string5 == null ? null : Uri.parse((String)string5);
            long l2 = in.readLong();
            return new PlayerEntity(1, string2, string3, uri, uri2, l2);
        }
    }
}

