/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntityCreator;
import com.google.android.gms.internal.ab;
import com.google.android.gms.internal.bb;
import com.google.android.gms.internal.bq;

public final class ParticipantEntity
extends bq
implements Participant {
    public static final ParticipantEntityCreator CREATOR = new a();
    private final int W;
    private final String dS;
    private final String ci;
    private final Uri df;
    private final Uri dg;
    private final int eI;
    private final String eJ;
    private final boolean eK;
    private final PlayerEntity eL;
    private final int eM;

    public ParticipantEntity(Participant participant) {
        this.W = 1;
        this.dS = participant.getParticipantId();
        this.ci = participant.getDisplayName();
        this.df = participant.getIconImageUri();
        this.dg = participant.getHiResImageUri();
        this.eI = participant.getStatus();
        this.eJ = participant.aK();
        this.eK = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.eL = player == null ? null : new PlayerEntity(player);
        this.eM = participant.aL();
    }

    ParticipantEntity(int versionCode, String participantId, String displayName, Uri iconImageUri, Uri hiResImageUri, int status, String clientAddress, boolean connectedToRoom, PlayerEntity player, int capabilities) {
        this.W = versionCode;
        this.dS = participantId;
        this.ci = displayName;
        this.df = iconImageUri;
        this.dg = hiResImageUri;
        this.eI = status;
        this.eJ = clientAddress;
        this.eK = connectedToRoom;
        this.eL = player;
        this.eM = capabilities;
    }

    public int F() {
        return this.W;
    }

    public int getStatus() {
        return this.eI;
    }

    public String aK() {
        return this.eJ;
    }

    public boolean isConnectedToRoom() {
        return this.eK;
    }

    public String getDisplayName() {
        if (this.eL == null) {
            return this.ci;
        }
        return this.eL.getDisplayName();
    }

    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.eL == null) {
            bb.b(this.ci, dataOut);
            return;
        }
        this.eL.getDisplayName(dataOut);
    }

    public Uri getIconImageUri() {
        if (this.eL == null) {
            return this.df;
        }
        return this.eL.getIconImageUri();
    }

    public Uri getHiResImageUri() {
        if (this.eL == null) {
            return this.dg;
        }
        return this.eL.getHiResImageUri();
    }

    public String getParticipantId() {
        return this.dS;
    }

    public Player getPlayer() {
        return this.eL;
    }

    public int aL() {
        return this.eM;
    }

    public Participant freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.a(this);
    }

    public static int a(Participant participant) {
        return ab.hashCode(participant.getPlayer(), participant.getStatus(), participant.aK(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.aL());
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.a(this, obj);
    }

    public static boolean a(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return ab.equal(participant2.getPlayer(), participant.getPlayer()) && ab.equal(participant2.getStatus(), participant.getStatus()) && ab.equal(participant2.aK(), participant.aK()) && ab.equal(participant2.isConnectedToRoom(), participant.isConnectedToRoom()) && ab.equal(participant2.getDisplayName(), participant.getDisplayName()) && ab.equal(participant2.getIconImageUri(), participant.getIconImageUri()) && ab.equal(participant2.getHiResImageUri(), participant.getHiResImageUri()) && ab.equal(participant2.aL(), participant.aL());
    }

    public String toString() {
        return ParticipantEntity.b(this);
    }

    public static String b(Participant participant) {
        return ab.c(participant).a("Player", participant.getPlayer()).a("Status", participant.getStatus()).a("ClientAddress", participant.aK()).a("ConnectedToRoom", participant.isConnectedToRoom()).a("DisplayName", participant.getDisplayName()).a("IconImage", participant.getIconImageUri()).a("HiResImage", participant.getHiResImageUri()).a("Capabilities", participant.aL()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.t()) {
            ParticipantEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.dS);
            dest.writeString(this.ci);
            dest.writeString(this.df == null ? null : this.df.toString());
            dest.writeString(this.dg == null ? null : this.dg.toString());
            dest.writeInt(this.eI);
            dest.writeString(this.eJ);
            dest.writeInt(this.eK ? 1 : 0);
            dest.writeInt(this.eL == null ? 0 : 1);
            if (this.eL != null) {
                this.eL.writeToParcel(dest, flags);
            }
        }
    }

    static final class a
    extends ParticipantEntityCreator {
        a() {
        }

        public ParticipantEntity createFromParcel(Parcel in) {
            boolean bl2 = ParticipantEntity.c(ParticipantEntity.s());
            if (bl2 || ParticipantEntity.g(ParticipantEntity.class.getCanonicalName())) {
                return super.createFromParcel(in);
            }
            String string2 = in.readString();
            String string3 = in.readString();
            String string4 = in.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            String string5 = in.readString();
            Uri uri2 = string5 == null ? null : Uri.parse((String)string5);
            int n2 = in.readInt();
            String string6 = in.readString();
            boolean bl3 = in.readInt() > 0;
            boolean bl4 = in.readInt() > 0;
            int n3 = 7;
            PlayerEntity playerEntity = bl4 ? PlayerEntity.CREATOR.createFromParcel(in) : null;
            return new ParticipantEntity(1, string2, string3, uri, uri2, n2, string6, bl3, playerEntity, n3);
        }
    }
}

