/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.os.Bundle;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.internal.ac;
import java.util.ArrayList;
import java.util.Arrays;

public final class RoomConfig {
    private final RoomUpdateListener eR;
    private final RoomStatusUpdateListener eS;
    private final RealTimeMessageReceivedListener eT;
    private final String eA;
    private final int eF;
    private final String[] eU;
    private final Bundle eV;
    private final boolean eW;

    private RoomConfig(Builder builder) {
        this.eR = builder.eR;
        this.eS = builder.eS;
        this.eT = builder.eT;
        this.eA = builder.eX;
        this.eF = builder.eF;
        this.eV = builder.eV;
        this.eW = builder.eW;
        int n2 = builder.eY.size();
        this.eU = builder.eY.toArray(new String[n2]);
        if (this.eT == null) {
            ac.a(this.eW, (Object)"Must either enable sockets OR specify a message listener");
        }
    }

    public RoomUpdateListener getRoomUpdateListener() {
        return this.eR;
    }

    public String getInvitationId() {
        return this.eA;
    }

    public RoomStatusUpdateListener getRoomStatusUpdateListener() {
        return this.eS;
    }

    public RealTimeMessageReceivedListener getMessageReceivedListener() {
        return this.eT;
    }

    public int getVariant() {
        return this.eF;
    }

    public String[] getInvitedPlayerIds() {
        return this.eU;
    }

    public Bundle getAutoMatchCriteria() {
        return this.eV;
    }

    public boolean isSocketEnabled() {
        return this.eW;
    }

    public static Builder builder(RoomUpdateListener listener) {
        return new Builder(listener);
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        final RoomUpdateListener eR;
        RoomStatusUpdateListener eS;
        RealTimeMessageReceivedListener eT;
        String eX = null;
        int eF = -1;
        ArrayList<String> eY = new ArrayList();
        Bundle eV;
        boolean eW = false;

        private Builder(RoomUpdateListener updateListener) {
            this.eR = ac.a(updateListener, (Object)"Must provide a RoomUpdateListener");
        }

        public Builder setInvitationIdToAccept(String invitationId) {
            ac.d(invitationId);
            this.eX = invitationId;
            return this;
        }

        public Builder setRoomStatusUpdateListener(RoomStatusUpdateListener listener) {
            this.eS = listener;
            return this;
        }

        public Builder setMessageReceivedListener(RealTimeMessageReceivedListener listener) {
            this.eT = listener;
            return this;
        }

        public Builder addPlayersToInvite(String ... playerIds) {
            ac.d(playerIds);
            this.eY.addAll(Arrays.asList(playerIds));
            return this;
        }

        public Builder addPlayersToInvite(ArrayList<String> playerIds) {
            ac.d(playerIds);
            this.eY.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            this.eF = variant;
            return this;
        }

        public Builder setSocketCommunicationEnabled(boolean enableSockets) {
            this.eW = enableSockets;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.eV = autoMatchCriteria;
            return this;
        }

        public RoomConfig build() {
            return new RoomConfig(this);
        }
    }
}

