/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomEntityCreator;
import com.google.android.gms.internal.ab;
import com.google.android.gms.internal.bb;
import com.google.android.gms.internal.bq;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RoomEntity
extends bq
implements Room {
    public static final RoomEntityCreator CREATOR = new a();
    private final int W;
    private final String dQ;
    private final String eZ;
    private final long eB;
    private final int fa;
    private final String dd;
    private final int eF;
    private final Bundle eV;
    private final ArrayList<ParticipantEntity> eE;

    public RoomEntity(Room room) {
        this.W = 1;
        this.dQ = room.getRoomId();
        this.eZ = room.getCreatorId();
        this.eB = room.getCreationTimestamp();
        this.fa = room.getStatus();
        this.dd = room.getDescription();
        this.eF = room.getVariant();
        this.eV = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n2 = arrayList.size();
        this.eE = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.eE.add((ParticipantEntity)((Participant)arrayList.get(i2)).freeze());
        }
    }

    RoomEntity(int versionCode, String roomId, String creatorId, long creationTimestamp, int roomStatus, String description, int variant, Bundle autoMatchCriteria, ArrayList<ParticipantEntity> participants) {
        this.W = versionCode;
        this.dQ = roomId;
        this.eZ = creatorId;
        this.eB = creationTimestamp;
        this.fa = roomStatus;
        this.dd = description;
        this.eF = variant;
        this.eV = autoMatchCriteria;
        this.eE = participants;
    }

    public int F() {
        return this.W;
    }

    @Override
    public String getRoomId() {
        return this.dQ;
    }

    @Override
    public String getCreatorId() {
        return this.eZ;
    }

    @Override
    public long getCreationTimestamp() {
        return this.eB;
    }

    @Override
    public int getStatus() {
        return this.fa;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        int n2 = this.eE.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = this.eE.get(i2);
            if (!participant.getParticipantId().equals(participantId)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + participantId + " is not in room " + this.getRoomId());
    }

    @Override
    public String getDescription() {
        return this.dd;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        bb.b(this.dd, dataOut);
    }

    @Override
    public int getVariant() {
        return this.eF;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.eV;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.eE);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        int n2 = this.eE.size();
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(this.eE.get(i2).getParticipantId());
        }
        return arrayList;
    }

    @Override
    public String getParticipantId(String playerId) {
        String string2 = null;
        int n2 = this.eE.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = this.eE.get(i2);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(playerId)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    @Override
    public Room freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return RoomEntity.a(this);
    }

    public static int a(Room room) {
        return ab.hashCode(room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants());
    }

    public boolean equals(Object obj) {
        return RoomEntity.a(this, obj);
    }

    public static boolean a(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return ab.equal(room2.getRoomId(), room.getRoomId()) && ab.equal(room2.getCreatorId(), room.getCreatorId()) && ab.equal(room2.getCreationTimestamp(), room.getCreationTimestamp()) && ab.equal(room2.getStatus(), room.getStatus()) && ab.equal(room2.getDescription(), room.getDescription()) && ab.equal(room2.getVariant(), room.getVariant()) && ab.equal(room2.getAutoMatchCriteria(), room.getAutoMatchCriteria()) && ab.equal(room2.getParticipants(), room.getParticipants());
    }

    public String toString() {
        return RoomEntity.b(this);
    }

    public static String b(Room room) {
        return ab.c(room).a("RoomId", room.getRoomId()).a("CreatorId", room.getCreatorId()).a("CreationTimestamp", room.getCreationTimestamp()).a("RoomStatus", room.getStatus()).a("Description", room.getDescription()).a("Variant", room.getVariant()).a("AutoMatchCriteria", room.getAutoMatchCriteria()).a("Participants", room.getParticipants()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.t()) {
            RoomEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.dQ);
            dest.writeString(this.eZ);
            dest.writeLong(this.eB);
            dest.writeInt(this.fa);
            dest.writeString(this.dd);
            dest.writeInt(this.eF);
            dest.writeBundle(this.eV);
            int n2 = this.eE.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.eE.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    static final class a
    extends RoomEntityCreator {
        a() {
        }

        public RoomEntity createFromParcel(Parcel in) {
            boolean bl2 = RoomEntity.c(RoomEntity.s());
            if (bl2 || RoomEntity.g(RoomEntity.class.getCanonicalName())) {
                return super.createFromParcel(in);
            }
            String string2 = in.readString();
            String string3 = in.readString();
            long l2 = in.readLong();
            int n2 = in.readInt();
            String string4 = in.readString();
            int n3 = in.readInt();
            Bundle bundle = in.readBundle();
            int n4 = in.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n4);
            for (int i2 = 0; i2 < n4; ++i2) {
                arrayList.add(ParticipantEntity.CREATOR.createFromParcel(in));
            }
            return new RoomEntity(1, string2, string3, l2, n2, string4, n3, bundle, arrayList);
        }
    }
}

