/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.Intent;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.OnGamesLoadedListener;
import com.google.android.gms.games.OnPlayersLoadedListener;
import com.google.android.gms.games.OnSignOutCompleteListener;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.RealTimeSocket;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.OnAchievementUpdatedListener;
import com.google.android.gms.games.achievement.OnAchievementsLoadedListener;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.OnLeaderboardMetadataLoadedListener;
import com.google.android.gms.games.leaderboard.OnLeaderboardScoresLoadedListener;
import com.google.android.gms.games.leaderboard.OnScoreSubmittedListener;
import com.google.android.gms.games.leaderboard.SubmitScoreResult;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.OnInvitationsLoadedListener;
import com.google.android.gms.games.multiplayer.ParticipantUtils;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeReliableMessageSentListener;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.internal.bo;
import com.google.android.gms.internal.br;
import com.google.android.gms.internal.bs;
import com.google.android.gms.internal.bt;
import com.google.android.gms.internal.bu;
import com.google.android.gms.internal.bv;
import com.google.android.gms.internal.bw;
import com.google.android.gms.internal.cg;
import com.google.android.gms.internal.u;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class bp
extends com.google.android.gms.internal.u<bu> {
    private final String du;
    private final String g;
    private final Map<String, bw> dv;
    private PlayerEntity dw;
    private GameEntity dx;
    private final bv dy;
    private boolean dz = false;
    private final Binder dA;
    private final long dB;
    private final boolean dC;

    public bp(Context context, String string2, String string3, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String[] stringArray, int n2, View view, boolean bl2) {
        super(context, connectionCallbacks, onConnectionFailedListener, stringArray);
        this.du = string2;
        this.g = com.google.android.gms.internal.ac.d(string3);
        this.dA = new Binder();
        this.dv = new HashMap<String, bw>();
        this.dy = com.google.android.gms.internal.bv.a(this, n2);
        this.setViewForPopups(view);
        this.dB = this.hashCode();
        this.dC = bl2;
    }

    public void setGravityForPopups(int gravity) {
        this.dy.setGravity(gravity);
    }

    public void setViewForPopups(View gamesContentView) {
        this.dy.a(gamesContentView);
    }

    @Override
    protected void a(String ... stringArray) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if (string2.equals("https://www.googleapis.com/auth/games")) {
                bl2 = true;
                continue;
            }
            if (!string2.equals("https://www.googleapis.com/auth/games.firstparty")) continue;
            bl3 = true;
        }
        if (bl3) {
            com.google.android.gms.internal.ac.a(!bl2, (Object)String.format("Cannot have both %s and %s!", "https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"));
        } else {
            com.google.android.gms.internal.ac.a(bl2, (Object)String.format("GamesClient requires %s to function.", "https://www.googleapis.com/auth/games"));
        }
    }

    @Override
    public void connect() {
        this.at();
        super.connect();
    }

    @Override
    public void disconnect() {
        this.dz = false;
        if (this.isConnected()) {
            try {
                bu bu2 = (bu)this.z();
                bu2.av();
                bu2.b(this.dB);
                bu2.a(this.dB);
            }
            catch (RemoteException remoteException) {
                bs.b("GamesClient", "Failed to notify client disconnect.");
            }
        }
        this.au();
        super.disconnect();
    }

    @Override
    protected String b() {
        return "com.google.android.gms.games.service.START";
    }

    @Override
    protected String c() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected bu k(IBinder iBinder) {
        return bu.a.m(iBinder);
    }

    @Override
    protected Bundle w() {
        try {
            Bundle bundle = ((bu)this.z()).w();
            if (bundle != null) {
                bundle.setClassLoader(bp.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
            return null;
        }
    }

    private void at() {
        this.dw = null;
    }

    @Override
    protected void a(com.google.android.gms.internal.z z2, u.d d2) throws RemoteException {
        String string2 = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = new Bundle();
        bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.dC);
        z2.a(d2, 3225100, this.getContext().getPackageName(), this.g, this.u(), this.du, this.dy.aB(), string2, bundle);
    }

    @Override
    protected void v() {
        super.v();
        if (this.dz) {
            this.dy.az();
            this.dz = false;
        }
    }

    @Override
    protected void a(ConnectionResult connectionResult) {
        super.a(connectionResult);
        this.dz = false;
    }

    public String getCurrentAccountName() {
        try {
            return ((bu)this.z()).getCurrentAccountName();
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
            return null;
        }
    }

    public String getCurrentPlayerId() {
        try {
            return ((bu)this.z()).getCurrentPlayerId();
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player getCurrentPlayer() {
        this.y();
        bp bp2 = this;
        synchronized (bp2) {
            if (this.dw == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((bu)this.z()).aw());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.dw = (PlayerEntity)playerBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        playerBuffer.close();
                    }
                }
                catch (RemoteException remoteException) {
                    bs.b("GamesClient", "service died");
                }
            }
        }
        return this.dw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game getCurrentGame() {
        this.y();
        bp bp2 = this;
        synchronized (bp2) {
            if (this.dx == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((bu)this.z()).ay());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.dx = (GameEntity)gameBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        gameBuffer.close();
                    }
                }
                catch (RemoteException remoteException) {
                    bs.b("GamesClient", "service died");
                }
            }
        }
        return this.dx;
    }

    public void loadPlayer(OnPlayersLoadedListener listener, String playerId) {
        try {
            ((bu)this.z()).c(new ae(listener), playerId);
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public void a(OnPlayersLoadedListener onPlayersLoadedListener, int n2, boolean bl2, boolean bl3) {
        try {
            ((bu)this.z()).a((bt)new ae(onPlayersLoadedListener), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public Intent getAllLeaderboardsIntent() {
        this.y();
        Intent intent = new Intent("com.google.android.gms.games.VIEW_LEADERBOARDS");
        intent.putExtra("com.google.android.gms.games.GAME_PACKAGE_NAME", this.du);
        intent.addFlags(0x4000000);
        return br.b(intent);
    }

    public Intent getLeaderboardIntent(String leaderboardId) {
        this.y();
        Intent intent = new Intent("com.google.android.gms.games.VIEW_LEADERBOARD_SCORES");
        intent.putExtra("com.google.android.gms.games.LEADERBOARD_ID", leaderboardId);
        intent.addFlags(0x4000000);
        return br.b(intent);
    }

    public void loadLeaderboardMetadata(OnLeaderboardMetadataLoadedListener listener) {
        try {
            ((bu)this.z()).b(new s(listener));
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public void loadLeaderboardMetadata(OnLeaderboardMetadataLoadedListener listener, String leaderboardId) {
        try {
            ((bu)this.z()).d(new s(listener), leaderboardId);
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public void loadTopScores(OnLeaderboardScoresLoadedListener listener, String leaderboardId, int span, int leaderboardCollection, int maxResults, boolean forceReload) {
        try {
            ((bu)this.z()).a(new q(listener), leaderboardId, span, leaderboardCollection, maxResults, forceReload);
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public void loadPlayerCenteredScores(OnLeaderboardScoresLoadedListener listener, String leaderboardId, int span, int leaderboardCollection, int maxResults, boolean forceReload) {
        try {
            ((bu)this.z()).b(new q(listener), leaderboardId, span, leaderboardCollection, maxResults, forceReload);
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public void loadMoreScores(OnLeaderboardScoresLoadedListener listener, LeaderboardScoreBuffer buffer, int maxResults, int pageDirection) {
        try {
            ((bu)this.z()).a((bt)new q(listener), buffer.aD().aE(), maxResults, pageDirection);
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public void a(OnScoreSubmittedListener onScoreSubmittedListener, String string2, long l2) {
        try {
            ap ap2 = onScoreSubmittedListener == null ? null : new ap(onScoreSubmittedListener);
            ((bu)this.z()).a((bt)ap2, string2, l2);
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public Intent getAchievementsIntent() {
        this.y();
        Intent intent = new Intent("com.google.android.gms.games.VIEW_ACHIEVEMENTS");
        intent.addFlags(0x4000000);
        return br.b(intent);
    }

    public void loadAchievements(OnAchievementsLoadedListener listener, boolean forceReload) {
        try {
            ((bu)this.z()).b((bt)new f(listener), forceReload);
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public void a(OnAchievementUpdatedListener onAchievementUpdatedListener, String string2) {
        try {
            d d2 = onAchievementUpdatedListener == null ? null : new d(onAchievementUpdatedListener);
            ((bu)this.z()).a((bt)d2, string2, this.dy.aB(), this.dy.aA());
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public void b(OnAchievementUpdatedListener onAchievementUpdatedListener, String string2) {
        try {
            d d2 = onAchievementUpdatedListener == null ? null : new d(onAchievementUpdatedListener);
            ((bu)this.z()).b((bt)d2, string2, this.dy.aB(), this.dy.aA());
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public void a(OnAchievementUpdatedListener onAchievementUpdatedListener, String string2, int n2) {
        try {
            d d2 = onAchievementUpdatedListener == null ? null : new d(onAchievementUpdatedListener);
            ((bu)this.z()).a((bt)d2, string2, n2, this.dy.aB(), this.dy.aA());
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public Intent getInvitationInboxIntent() {
        this.y();
        Intent intent = new Intent("com.google.android.gms.games.SHOW_INVITATIONS");
        intent.putExtra("com.google.android.gms.games.GAME_PACKAGE_NAME", this.du);
        return br.b(intent);
    }

    public void registerInvitationListener(OnInvitationReceivedListener listener) {
        try {
            l l2 = new l(listener);
            ((bu)this.z()).a((bt)l2, this.dB);
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public void unregisterInvitationListener() {
        try {
            ((bu)this.z()).b(this.dB);
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public Intent getSelectPlayersIntent(int minPlayers, int maxPlayers) {
        this.y();
        Intent intent = new Intent("com.google.android.gms.games.SELECT_PLAYERS");
        intent.putExtra("com.google.android.gms.games.MIN_SELECTIONS", minPlayers);
        intent.putExtra("com.google.android.gms.games.MAX_SELECTIONS", maxPlayers);
        return br.b(intent);
    }

    public Intent getRealTimeWaitingRoomIntent(Room room, int minParticipantsToStart) {
        this.y();
        Intent intent = new Intent("com.google.android.gms.games.SHOW_REAL_TIME_WAITING_ROOM");
        com.google.android.gms.internal.ac.a(room, (Object)"Room parameter must not be null");
        intent.putExtra("room", (Parcelable)room.freeze());
        com.google.android.gms.internal.ac.a(minParticipantsToStart >= 0, (Object)"minParticipantsToStart must be >= 0");
        intent.putExtra("com.google.android.gms.games.MIN_PARTICIPANTS_TO_START", minParticipantsToStart);
        return br.b(intent);
    }

    public Intent getSettingsIntent() {
        this.y();
        Intent intent = new Intent("com.google.android.gms.games.SHOW_SETTINGS");
        intent.putExtra("com.google.android.gms.games.GAME_PACKAGE_NAME", this.du);
        intent.addFlags(0x4000000);
        return br.b(intent);
    }

    public void loadGame(OnGamesLoadedListener listener) {
        try {
            ((bu)this.z()).d(new j(listener));
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public void signOut(OnSignOutCompleteListener listener) {
        try {
            an an2 = listener == null ? null : new an(listener);
            ((bu)this.z()).a(an2);
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public String getAppId() {
        try {
            return ((bu)this.z()).getAppId();
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
            return null;
        }
    }

    public void loadInvitations(OnInvitationsLoadedListener listener) {
        try {
            ((bu)this.z()).e(new n(listener));
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public void h(String string2, int n2) {
        try {
            ((bu)this.z()).h(string2, n2);
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public void i(String string2, int n2) {
        try {
            ((bu)this.z()).i(string2, n2);
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public void createRoom(RoomConfig config) {
        try {
            aj aj2 = new aj(config.getRoomUpdateListener(), config.getRoomStatusUpdateListener(), config.getMessageReceivedListener());
            ((bu)this.z()).a((bt)aj2, (IBinder)this.dA, config.getVariant(), config.getInvitedPlayerIds(), config.getAutoMatchCriteria(), config.isSocketEnabled(), this.dB);
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public void joinRoom(RoomConfig config) {
        try {
            aj aj2 = new aj(config.getRoomUpdateListener(), config.getRoomStatusUpdateListener(), config.getMessageReceivedListener());
            ((bu)this.z()).a((bt)aj2, (IBinder)this.dA, config.getInvitationId(), config.isSocketEnabled(), this.dB);
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public void leaveRoom(RoomUpdateListener listener, String roomId) {
        try {
            ((bu)this.z()).e(new aj(listener), roomId);
            this.au();
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public int sendReliableRealTimeMessage(RealTimeReliableMessageSentListener listener, byte[] messageData, String roomId, String recipientParticipantId) {
        try {
            return ((bu)this.z()).a((bt)new ah(listener), messageData, roomId, recipientParticipantId);
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
            return -1;
        }
    }

    public int a(byte[] byArray, String string2, String[] stringArray) {
        com.google.android.gms.internal.ac.a(stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((bu)this.z()).b(byArray, string2, stringArray);
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
            return -1;
        }
    }

    public int sendUnreliableRealTimeMessageToAll(byte[] messageData, String roomId) {
        try {
            return ((bu)this.z()).b(messageData, roomId, null);
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
            return -1;
        }
    }

    public RealTimeSocket getRealTimeSocketForParticipant(String roomId, String participantId) {
        if (participantId == null || !ParticipantUtils.z(participantId)) {
            throw new IllegalArgumentException("Bad participant ID");
        }
        bw bw2 = this.dv.get(participantId);
        if (bw2 == null || bw2.isClosed()) {
            return this.t(participantId);
        }
        return bw2;
    }

    private bw t(String string2) {
        try {
            String string3 = ((bu)this.z()).v(string2);
            if (string3 == null) {
                return null;
            }
            bs.d("GamesClient", "Creating a socket to bind to:" + string3);
            LocalSocket localSocket = new LocalSocket();
            try {
                localSocket.connect(new LocalSocketAddress(string3));
            }
            catch (IOException iOException) {
                bs.c("GamesClient", "connect() call failed on socket: " + iOException.getMessage());
                return null;
            }
            bw bw2 = new bw(localSocket, string2);
            this.dv.put(string2, bw2);
            return bw2;
        }
        catch (RemoteException remoteException) {
            bs.c("GamesClient", "Unable to create socket. Service died.");
            return null;
        }
    }

    public void clearNotifications(int notificationTypes) {
        try {
            ((bu)this.z()).clearNotifications(notificationTypes);
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    public void setUseNewPlayerNotificationsFirstParty(boolean newPlayerStyle) {
        try {
            ((bu)this.z()).setUseNewPlayerNotificationsFirstParty(newPlayerStyle);
        }
        catch (RemoteException remoteException) {
            bs.b("GamesClient", "service died");
        }
    }

    private void au() {
        for (bw bw2 : this.dv.values()) {
            try {
                bw2.close();
            }
            catch (IOException iOException) {
                bs.a("GamesClient", "IOException:", iOException);
            }
        }
        this.dv.clear();
    }

    public void a(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((bu)this.z()).a(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                bs.b("GamesClient", "service died");
            }
        }
    }

    public void av() {
        if (this.isConnected()) {
            try {
                ((bu)this.z()).av();
            }
            catch (RemoteException remoteException) {
                bs.b("GamesClient", "service died");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Room x(com.google.android.gms.internal.l l2) {
        cg cg2 = new cg(l2);
        Room room = null;
        try {
            if (cg2.getCount() > 0) {
                room = (Room)((Room)cg2.get(0)).freeze();
            }
        }
        finally {
            cg2.close();
        }
        return room;
    }

    @Override
    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        if (n2 == 0 && bundle != null) {
            this.dz = bundle.getBoolean("show_welcome_popup");
        }
        super.a(n2, iBinder, bundle);
    }

    @Override
    protected /* synthetic */ IInterface c(IBinder iBinder) {
        return this.k(iBinder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ao
    extends u.b<OnSignOutCompleteListener> {
        public ao(OnSignOutCompleteListener onSignOutCompleteListener) {
            super(onSignOutCompleteListener);
        }

        @Override
        public void a(OnSignOutCompleteListener onSignOutCompleteListener) {
            onSignOutCompleteListener.onSignOutComplete();
        }

        @Override
        protected void d() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ag
    extends u.b<RealTimeReliableMessageSentListener> {
        private final int p;
        private final String dU;
        private final int dV;

        ag(RealTimeReliableMessageSentListener realTimeReliableMessageSentListener, int n2, int n3, String string2) {
            super(realTimeReliableMessageSentListener);
            this.p = n2;
            this.dV = n3;
            this.dU = string2;
        }

        @Override
        public void a(RealTimeReliableMessageSentListener realTimeReliableMessageSentListener) {
            if (realTimeReliableMessageSentListener != null) {
                realTimeReliableMessageSentListener.onRealTimeMessageSent(this.p, this.dV, this.dU);
            }
        }

        @Override
        protected void d() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class v
    extends u.b<RealTimeMessageReceivedListener> {
        private final RealTimeMessage dR;

        v(RealTimeMessageReceivedListener realTimeMessageReceivedListener, RealTimeMessage realTimeMessage) {
            super(realTimeMessageReceivedListener);
            this.dR = realTimeMessage;
        }

        @Override
        public void a(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            bs.a("GamesClient", "Deliver Message received callback");
            if (realTimeMessageReceivedListener != null) {
                realTimeMessageReceivedListener.onRealTimeMessageReceived(this.dR);
            }
        }

        @Override
        protected void d() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class x
    extends u.b<RoomStatusUpdateListener> {
        private final String dS;

        x(RoomStatusUpdateListener roomStatusUpdateListener, String string2) {
            super(roomStatusUpdateListener);
            this.dS = string2;
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PDisconnected(this.dS);
            }
        }

        @Override
        protected void d() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class w
    extends u.b<RoomStatusUpdateListener> {
        private final String dS;

        w(RoomStatusUpdateListener roomStatusUpdateListener, String string2) {
            super(roomStatusUpdateListener);
            this.dS = string2;
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PConnected(this.dS);
            }
        }

        @Override
        protected void d() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class aa
    extends a {
        aa(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.l l2, String[] stringArray) {
            super(roomStatusUpdateListener, l2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class y
    extends a {
        y(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.l l2, String[] stringArray) {
            super(roomStatusUpdateListener, l2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class z
    extends a {
        z(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.l l2, String[] stringArray) {
            super(roomStatusUpdateListener, l2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ad
    extends a {
        ad(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.l l2, String[] stringArray) {
            super(roomStatusUpdateListener, l2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ac
    extends a {
        ac(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.l l2, String[] stringArray) {
            super(roomStatusUpdateListener, l2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ab
    extends a {
        ab(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.l l2, String[] stringArray) {
            super(roomStatusUpdateListener, l2, stringArray);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    final class i
    extends c {
        i(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.l l2) {
            super(roomStatusUpdateListener, l2);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    final class h
    extends c {
        h(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.l l2) {
            super(roomStatusUpdateListener, l2);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    final class ai
    extends c {
        ai(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.l l2) {
            super(roomStatusUpdateListener, l2);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    final class al
    extends c {
        al(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.l l2) {
            super(roomStatusUpdateListener, l2);
        }

        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    final class ak
    extends b {
        ak(RoomUpdateListener roomUpdateListener, com.google.android.gms.internal.l l2) {
            super(roomUpdateListener, l2);
        }

        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomConnected(n2, room);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class u
    extends u.b<RoomUpdateListener> {
        private final int p;
        private final String dQ;

        u(RoomUpdateListener roomUpdateListener, int n2, String string2) {
            super(roomUpdateListener);
            this.p = n2;
            this.dQ = string2;
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.p, this.dQ);
        }

        @Override
        protected void d() {
        }
    }

    final class p
    extends b {
        public p(RoomUpdateListener roomUpdateListener, com.google.android.gms.internal.l l2) {
            super(roomUpdateListener, l2);
        }

        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onJoinedRoom(n2, room);
        }
    }

    final class am
    extends b {
        public am(RoomUpdateListener roomUpdateListener, com.google.android.gms.internal.l l2) {
            super(roomUpdateListener, l2);
        }

        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomCreated(n2, room);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class a
    extends c {
        private final ArrayList<String> dD;

        a(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.l l2, String[] stringArray) {
            super(roomStatusUpdateListener, l2);
            this.dD = new ArrayList();
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.dD.add(stringArray[i2]);
            }
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.a(roomStatusUpdateListener, room, this.dD);
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class c
    extends u.c<RoomStatusUpdateListener> {
        c(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.l l2) {
            super(roomStatusUpdateListener, l2);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, com.google.android.gms.internal.l l2) {
            this.a(roomStatusUpdateListener, bp.this.x(l2));
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class b
    extends u.c<RoomUpdateListener> {
        b(RoomUpdateListener roomUpdateListener, com.google.android.gms.internal.l l2) {
            super(roomUpdateListener, l2);
        }

        @Override
        protected void a(RoomUpdateListener roomUpdateListener, com.google.android.gms.internal.l l2) {
            this.a(roomUpdateListener, bp.this.x(l2), l2.getStatusCode());
        }

        protected abstract void a(RoomUpdateListener var1, Room var2, int var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class aq
    extends u.b<OnScoreSubmittedListener> {
        private final SubmitScoreResult ec;

        public aq(OnScoreSubmittedListener onScoreSubmittedListener, SubmitScoreResult submitScoreResult) {
            super(onScoreSubmittedListener);
            this.ec = submitScoreResult;
        }

        @Override
        public void a(OnScoreSubmittedListener onScoreSubmittedListener) {
            onScoreSubmittedListener.onScoreSubmitted(this.ec.getStatusCode(), this.ec);
        }

        @Override
        protected void d() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class af
    extends u.c<OnPlayersLoadedListener> {
        af(OnPlayersLoadedListener onPlayersLoadedListener, com.google.android.gms.internal.l l2) {
            super(onPlayersLoadedListener, l2);
        }

        @Override
        protected void a(OnPlayersLoadedListener onPlayersLoadedListener, com.google.android.gms.internal.l l2) {
            onPlayersLoadedListener.onPlayersLoaded(l2.getStatusCode(), new PlayerBuffer(l2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class m
    extends u.b<OnInvitationReceivedListener> {
        private final Invitation dK;

        m(OnInvitationReceivedListener onInvitationReceivedListener, Invitation invitation) {
            super(onInvitationReceivedListener);
            this.dK = invitation;
        }

        @Override
        protected void a(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.dK);
        }

        @Override
        protected void d() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class o
    extends u.c<OnInvitationsLoadedListener> {
        o(OnInvitationsLoadedListener onInvitationsLoadedListener, com.google.android.gms.internal.l l2) {
            super(onInvitationsLoadedListener, l2);
        }

        @Override
        protected void a(OnInvitationsLoadedListener onInvitationsLoadedListener, com.google.android.gms.internal.l l2) {
            onInvitationsLoadedListener.onInvitationsLoaded(l2.getStatusCode(), new InvitationBuffer(l2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class r
    extends u.b<OnLeaderboardScoresLoadedListener> {
        private final com.google.android.gms.internal.l dN;
        private final com.google.android.gms.internal.l dO;

        r(OnLeaderboardScoresLoadedListener onLeaderboardScoresLoadedListener, com.google.android.gms.internal.l l2, com.google.android.gms.internal.l l3) {
            super(onLeaderboardScoresLoadedListener);
            this.dN = l2;
            this.dO = l3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void a(OnLeaderboardScoresLoadedListener onLeaderboardScoresLoadedListener) {
            com.google.android.gms.internal.l l2 = this.dN;
            com.google.android.gms.internal.l l3 = this.dO;
            try {
                if (onLeaderboardScoresLoadedListener != null) {
                    LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(l2);
                    LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(l3);
                    onLeaderboardScoresLoadedListener.onLeaderboardScoresLoaded(l3.getStatusCode(), leaderboardBuffer, leaderboardScoreBuffer);
                    l2 = null;
                    l3 = null;
                }
            }
            finally {
                if (l2 != null) {
                    l2.close();
                }
                if (l3 != null) {
                    l3.close();
                }
            }
        }

        @Override
        protected void d() {
            if (this.dN != null) {
                this.dN.close();
            }
            if (this.dO != null) {
                this.dO.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class t
    extends u.c<OnLeaderboardMetadataLoadedListener> {
        t(OnLeaderboardMetadataLoadedListener onLeaderboardMetadataLoadedListener, com.google.android.gms.internal.l l2) {
            super(onLeaderboardMetadataLoadedListener, l2);
        }

        @Override
        protected void a(OnLeaderboardMetadataLoadedListener onLeaderboardMetadataLoadedListener, com.google.android.gms.internal.l l2) {
            onLeaderboardMetadataLoadedListener.onLeaderboardMetadataLoaded(l2.getStatusCode(), new LeaderboardBuffer(l2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class k
    extends u.c<OnGamesLoadedListener> {
        k(OnGamesLoadedListener onGamesLoadedListener, com.google.android.gms.internal.l l2) {
            super(onGamesLoadedListener, l2);
        }

        @Override
        protected void a(OnGamesLoadedListener onGamesLoadedListener, com.google.android.gms.internal.l l2) {
            onGamesLoadedListener.onGamesLoaded(l2.getStatusCode(), new GameBuffer(l2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class e
    extends u.b<OnAchievementUpdatedListener> {
        private final int p;
        private final String dG;

        e(OnAchievementUpdatedListener onAchievementUpdatedListener, int n2, String string2) {
            super(onAchievementUpdatedListener);
            this.p = n2;
            this.dG = string2;
        }

        @Override
        protected void a(OnAchievementUpdatedListener onAchievementUpdatedListener) {
            onAchievementUpdatedListener.onAchievementUpdated(this.p, this.dG);
        }

        @Override
        protected void d() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class g
    extends u.c<OnAchievementsLoadedListener> {
        g(OnAchievementsLoadedListener onAchievementsLoadedListener, com.google.android.gms.internal.l l2) {
            super(onAchievementsLoadedListener, l2);
        }

        @Override
        protected void a(OnAchievementsLoadedListener onAchievementsLoadedListener, com.google.android.gms.internal.l l2) {
            onAchievementsLoadedListener.onAchievementsLoaded(l2.getStatusCode(), new AchievementBuffer(l2));
        }
    }

    final class an
    extends bo {
        private final OnSignOutCompleteListener ea;

        public an(OnSignOutCompleteListener onSignOutCompleteListener) {
            this.ea = com.google.android.gms.internal.ac.a(onSignOutCompleteListener, (Object)"Listener must not be null");
        }

        public void onSignOutComplete() {
            bp.this.a(new ao(this.ea));
        }
    }

    final class ah
    extends bo {
        final RealTimeReliableMessageSentListener dW;

        public ah(RealTimeReliableMessageSentListener realTimeReliableMessageSentListener) {
            this.dW = realTimeReliableMessageSentListener;
        }

        public void a(int n2, int n3, String string2) {
            bp.this.a(new ag(this.dW, n2, n3, string2));
        }
    }

    final class aj
    extends bo {
        private final RoomUpdateListener dX;
        private final RoomStatusUpdateListener dY;
        private final RealTimeMessageReceivedListener dZ;

        public aj(RoomUpdateListener roomUpdateListener) {
            this.dX = com.google.android.gms.internal.ac.a(roomUpdateListener, (Object)"Callbacks must not be null");
            this.dY = null;
            this.dZ = null;
        }

        public aj(RoomUpdateListener roomUpdateListener, RoomStatusUpdateListener roomStatusUpdateListener, RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            this.dX = com.google.android.gms.internal.ac.a(roomUpdateListener, (Object)"Callbacks must not be null");
            this.dY = roomStatusUpdateListener;
            this.dZ = realTimeMessageReceivedListener;
        }

        public void n(com.google.android.gms.internal.l l2) {
            bp.this.a(new am(this.dX, l2));
        }

        public void o(com.google.android.gms.internal.l l2) {
            bp.this.a(new p(this.dX, l2));
        }

        public void onLeftRoom(int statusCode, String externalRoomId) {
            bp.this.a(new u(this.dX, statusCode, externalRoomId));
        }

        public void r(com.google.android.gms.internal.l l2) {
            bp.this.a(new ak(this.dX, l2));
        }

        public void p(com.google.android.gms.internal.l l2) {
            bp.this.a(new al(this.dY, l2));
        }

        public void q(com.google.android.gms.internal.l l2) {
            bp.this.a(new ai(this.dY, l2));
        }

        public void s(com.google.android.gms.internal.l l2) {
            bp.this.a(new h(this.dY, l2));
        }

        public void t(com.google.android.gms.internal.l l2) {
            bp.this.a(new i(this.dY, l2));
        }

        public void e(com.google.android.gms.internal.l l2, String[] stringArray) {
            bp.this.a(new y(this.dY, l2, stringArray));
        }

        public void f(com.google.android.gms.internal.l l2, String[] stringArray) {
            bp.this.a(new aa(this.dY, l2, stringArray));
        }

        public void a(com.google.android.gms.internal.l l2, String[] stringArray) {
            bp.this.a(new ab(this.dY, l2, stringArray));
        }

        public void b(com.google.android.gms.internal.l l2, String[] stringArray) {
            bp.this.a(new ac(this.dY, l2, stringArray));
        }

        public void c(com.google.android.gms.internal.l l2, String[] stringArray) {
            bp.this.a(new ad(this.dY, l2, stringArray));
        }

        public void d(com.google.android.gms.internal.l l2, String[] stringArray) {
            bp.this.a(new z(this.dY, l2, stringArray));
        }

        public void onP2PConnected(String participantId) {
            bp.this.a(new w(this.dY, participantId));
        }

        public void onP2PDisconnected(String participantId) {
            bp.this.a(new x(this.dY, participantId));
        }

        public void onRealTimeMessageReceived(RealTimeMessage message) {
            bs.a("GamesClient", "RoomBinderCallbacks: onRealTimeMessageReceived");
            bp.this.a(new v(this.dZ, message));
        }
    }

    final class ap
    extends bo {
        private final OnScoreSubmittedListener eb;

        public ap(OnScoreSubmittedListener onScoreSubmittedListener) {
            this.eb = com.google.android.gms.internal.ac.a(onScoreSubmittedListener, (Object)"Listener must not be null");
        }

        public void d(com.google.android.gms.internal.l l2) {
            SubmitScoreResult submitScoreResult = new SubmitScoreResult(l2);
            bp.this.a(new aq(this.eb, submitScoreResult));
        }
    }

    final class ae
    extends bo {
        private final OnPlayersLoadedListener dT;

        ae(OnPlayersLoadedListener onPlayersLoadedListener) {
            this.dT = com.google.android.gms.internal.ac.a(onPlayersLoadedListener, (Object)"Listener must not be null");
        }

        public void e(com.google.android.gms.internal.l l2) {
            bp.this.a(new af(this.dT, l2));
        }
    }

    final class l
    extends bo {
        private final OnInvitationReceivedListener dJ;

        l(OnInvitationReceivedListener onInvitationReceivedListener) {
            this.dJ = onInvitationReceivedListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void k(com.google.android.gms.internal.l l2) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(l2);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.close();
            }
            if (invitation != null) {
                bp.this.a(new m(this.dJ, invitation));
            }
        }
    }

    final class n
    extends bo {
        private final OnInvitationsLoadedListener dL;

        n(OnInvitationsLoadedListener onInvitationsLoadedListener) {
            this.dL = onInvitationsLoadedListener;
        }

        public void j(com.google.android.gms.internal.l l2) {
            bp.this.a(new o(this.dL, l2));
        }
    }

    final class q
    extends bo {
        private final OnLeaderboardScoresLoadedListener dM;

        q(OnLeaderboardScoresLoadedListener onLeaderboardScoresLoadedListener) {
            this.dM = com.google.android.gms.internal.ac.a(onLeaderboardScoresLoadedListener, (Object)"Listener must not be null");
        }

        public void a(com.google.android.gms.internal.l l2, com.google.android.gms.internal.l l3) {
            bp.this.a(new r(this.dM, l2, l3));
        }
    }

    final class s
    extends bo {
        private final OnLeaderboardMetadataLoadedListener dP;

        s(OnLeaderboardMetadataLoadedListener onLeaderboardMetadataLoadedListener) {
            this.dP = com.google.android.gms.internal.ac.a(onLeaderboardMetadataLoadedListener, (Object)"Listener must not be null");
        }

        public void c(com.google.android.gms.internal.l l2) {
            bp.this.a(new t(this.dP, l2));
        }
    }

    final class j
    extends bo {
        private final OnGamesLoadedListener dI;

        j(OnGamesLoadedListener onGamesLoadedListener) {
            this.dI = com.google.android.gms.internal.ac.a(onGamesLoadedListener, (Object)"Listener must not be null");
        }

        public void g(com.google.android.gms.internal.l l2) {
            bp.this.a(new k(this.dI, l2));
        }
    }

    final class d
    extends bo {
        private final OnAchievementUpdatedListener dF;

        d(OnAchievementUpdatedListener onAchievementUpdatedListener) {
            this.dF = com.google.android.gms.internal.ac.a(onAchievementUpdatedListener, (Object)"Listener must not be null");
        }

        public void onAchievementUpdated(int statusCode, String achievementId) {
            bp.this.a(new e(this.dF, statusCode, achievementId));
        }
    }

    final class f
    extends bo {
        private final OnAchievementsLoadedListener dH;

        f(OnAchievementsLoadedListener onAchievementsLoadedListener) {
            this.dH = com.google.android.gms.internal.ac.a(onAchievementsLoadedListener, (Object)"Listener must not be null");
        }

        public void b(com.google.android.gms.internal.l l2) {
            bp.this.a(new g(this.dH, l2));
        }
    }
}

