/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.internal.cn;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String fo = null;
        private int fp = 0;
        private long fq = Long.MIN_VALUE;
        private short fr = (short)-1;
        private double fs;
        private double ft;
        private float fu;

        public Builder setRequestId(String requestId) {
            this.fo = requestId;
            return this;
        }

        public Builder setTransitionTypes(int transitionTypes) {
            this.fp = transitionTypes;
            return this;
        }

        public Builder setExpirationDuration(long durationMillis) {
            this.fq = durationMillis < 0L ? -1L : SystemClock.elapsedRealtime() + durationMillis;
            return this;
        }

        public Builder setCircularRegion(double latitude, double longitude, float radius) {
            this.fr = 1;
            this.fs = latitude;
            this.ft = longitude;
            this.fu = radius;
            return this;
        }

        public Geofence build() {
            if (this.fo == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.fp == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if (this.fq == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.fr == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            return new cn(this.fo, this.fp, 1, this.fs, this.ft, this.fu, this.fq);
        }
    }
}

