/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.android.gms.internal.bi;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;

public interface ICameraUpdateFactoryDelegate
extends IInterface {
    public bi zoomIn() throws RemoteException;

    public bi zoomOut() throws RemoteException;

    public bi scrollBy(float var1, float var2) throws RemoteException;

    public bi zoomTo(float var1) throws RemoteException;

    public bi zoomBy(float var1) throws RemoteException;

    public bi zoomByWithFocus(float var1, int var2, int var3) throws RemoteException;

    public bi newCameraPosition(CameraPosition var1) throws RemoteException;

    public bi newLatLng(LatLng var1) throws RemoteException;

    public bi newLatLngZoom(LatLng var1, float var2) throws RemoteException;

    public bi newLatLngBounds(LatLngBounds var1, int var2) throws RemoteException;

    public bi newLatLngBoundsWithSize(LatLngBounds var1, int var2, int var3, int var4) throws RemoteException;

    public static abstract class com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate$a
    extends Binder
    implements ICameraUpdateFactoryDelegate {
        public static ICameraUpdateFactoryDelegate r(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
            if (iInterface != null && iInterface instanceof ICameraUpdateFactoryDelegate) {
                return (ICameraUpdateFactoryDelegate)iInterface;
            }
            return new a(iBinder);
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    return true;
                }
                case 1: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    bi bi2 = this.zoomIn();
                    reply.writeNoException();
                    reply.writeStrongBinder(bi2 != null ? bi2.asBinder() : null);
                    return true;
                }
                case 2: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    bi bi3 = this.zoomOut();
                    reply.writeNoException();
                    reply.writeStrongBinder(bi3 != null ? bi3.asBinder() : null);
                    return true;
                }
                case 3: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    float f2 = data.readFloat();
                    float f3 = data.readFloat();
                    bi bi4 = this.scrollBy(f2, f3);
                    reply.writeNoException();
                    reply.writeStrongBinder(bi4 != null ? bi4.asBinder() : null);
                    return true;
                }
                case 4: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    float f4 = data.readFloat();
                    bi bi5 = this.zoomTo(f4);
                    reply.writeNoException();
                    reply.writeStrongBinder(bi5 != null ? bi5.asBinder() : null);
                    return true;
                }
                case 5: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    float f5 = data.readFloat();
                    bi bi6 = this.zoomBy(f5);
                    reply.writeNoException();
                    reply.writeStrongBinder(bi6 != null ? bi6.asBinder() : null);
                    return true;
                }
                case 6: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    float f6 = data.readFloat();
                    int n2 = data.readInt();
                    int n3 = data.readInt();
                    bi bi7 = this.zoomByWithFocus(f6, n2, n3);
                    reply.writeNoException();
                    reply.writeStrongBinder(bi7 != null ? bi7.asBinder() : null);
                    return true;
                }
                case 7: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    CameraPosition cameraPosition = 0 != data.readInt() ? CameraPosition.CREATOR.createFromParcel(data) : null;
                    bi bi8 = this.newCameraPosition(cameraPosition);
                    reply.writeNoException();
                    reply.writeStrongBinder(bi8 != null ? bi8.asBinder() : null);
                    return true;
                }
                case 8: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    LatLng latLng = 0 != data.readInt() ? LatLng.CREATOR.createFromParcel(data) : null;
                    bi bi9 = this.newLatLng(latLng);
                    reply.writeNoException();
                    reply.writeStrongBinder(bi9 != null ? bi9.asBinder() : null);
                    return true;
                }
                case 9: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    LatLng latLng = 0 != data.readInt() ? LatLng.CREATOR.createFromParcel(data) : null;
                    float f7 = data.readFloat();
                    bi bi10 = this.newLatLngZoom(latLng, f7);
                    reply.writeNoException();
                    reply.writeStrongBinder(bi10 != null ? bi10.asBinder() : null);
                    return true;
                }
                case 10: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    LatLngBounds latLngBounds = 0 != data.readInt() ? LatLngBounds.CREATOR.createFromParcel(data) : null;
                    int n4 = data.readInt();
                    bi bi11 = this.newLatLngBounds(latLngBounds, n4);
                    reply.writeNoException();
                    reply.writeStrongBinder(bi11 != null ? bi11.asBinder() : null);
                    return true;
                }
                case 11: {
                    data.enforceInterface("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    LatLngBounds latLngBounds = 0 != data.readInt() ? LatLngBounds.CREATOR.createFromParcel(data) : null;
                    int n5 = data.readInt();
                    int n6 = data.readInt();
                    int n7 = data.readInt();
                    bi bi12 = this.newLatLngBoundsWithSize(latLngBounds, n5, n6, n7);
                    reply.writeNoException();
                    reply.writeStrongBinder(bi12 != null ? bi12.asBinder() : null);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        static class a
        implements ICameraUpdateFactoryDelegate {
            private IBinder a;

            a(IBinder iBinder) {
                this.a = iBinder;
            }

            public IBinder asBinder() {
                return this.a;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public bi zoomIn() throws RemoteException {
                bi bi2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    this.a.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    bi2 = bi.a.j(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bi2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public bi zoomOut() throws RemoteException {
                bi bi2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    this.a.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    bi2 = bi.a.j(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bi2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public bi scrollBy(float xPixel, float yPixel) throws RemoteException {
                bi bi2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    parcel.writeFloat(xPixel);
                    parcel.writeFloat(yPixel);
                    this.a.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    bi2 = bi.a.j(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bi2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public bi zoomTo(float zoom) throws RemoteException {
                bi bi2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    parcel.writeFloat(zoom);
                    this.a.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    bi2 = bi.a.j(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bi2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public bi zoomBy(float amount) throws RemoteException {
                bi bi2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    parcel.writeFloat(amount);
                    this.a.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    bi2 = bi.a.j(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bi2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public bi zoomByWithFocus(float amount, int screenFocusX, int screenFocusY) throws RemoteException {
                bi bi2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    parcel.writeFloat(amount);
                    parcel.writeInt(screenFocusX);
                    parcel.writeInt(screenFocusY);
                    this.a.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    bi2 = bi.a.j(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bi2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public bi newCameraPosition(CameraPosition cameraPosition) throws RemoteException {
                bi bi2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (cameraPosition != null) {
                        parcel.writeInt(1);
                        cameraPosition.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.a.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    bi2 = bi.a.j(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bi2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public bi newLatLng(LatLng latLng) throws RemoteException {
                bi bi2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (latLng != null) {
                        parcel.writeInt(1);
                        latLng.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.a.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    bi2 = bi.a.j(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bi2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public bi newLatLngZoom(LatLng latLng, float zoom) throws RemoteException {
                bi bi2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (latLng != null) {
                        parcel.writeInt(1);
                        latLng.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeFloat(zoom);
                    this.a.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    bi2 = bi.a.j(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bi2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public bi newLatLngBounds(LatLngBounds bounds, int padding) throws RemoteException {
                bi bi2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (bounds != null) {
                        parcel.writeInt(1);
                        bounds.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(padding);
                    this.a.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    bi2 = bi.a.j(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bi2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public bi newLatLngBoundsWithSize(LatLngBounds bounds, int width, int height, int padding) throws RemoteException {
                bi bi2;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken("com.google.android.gms.maps.internal.ICameraUpdateFactoryDelegate");
                    if (bounds != null) {
                        parcel.writeInt(1);
                        bounds.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(width);
                    parcel.writeInt(height);
                    parcel.writeInt(padding);
                    this.a.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    bi2 = bi.a.j(parcel2.readStrongBinder());
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bi2;
            }
        }
    }
}

