/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.ab;
import com.google.android.gms.internal.ac;
import com.google.android.gms.internal.dh;
import com.google.android.gms.internal.dl;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBoundsCreator;

public final class LatLngBounds
implements SafeParcelable {
    public static final LatLngBoundsCreator CREATOR = new LatLngBoundsCreator();
    private final int W;
    public final LatLng southwest;
    public final LatLng northeast;

    LatLngBounds(int versionCode, LatLng southwest, LatLng northeast) {
        ac.a(southwest, (Object)"null southwest");
        ac.a(northeast, (Object)"null northeast");
        ac.a(northeast.latitude >= southwest.latitude, "southern latitude exceeds northern latitude (%s > %s)", southwest.latitude, northeast.latitude);
        this.W = versionCode;
        this.southwest = southwest;
        this.northeast = northeast;
    }

    public LatLngBounds(LatLng southwest, LatLng northeast) {
        this(1, southwest, northeast);
    }

    public int F() {
        return this.W;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (dh.bm()) {
            dl.a(this, out, flags);
        } else {
            LatLngBoundsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean contains(LatLng point) {
        LatLng latLng = point;
        return this.a(latLng.latitude) && this.b(latLng.longitude);
    }

    public LatLngBounds including(LatLng point) {
        LatLng latLng = point;
        double d2 = Math.min(this.southwest.latitude, latLng.latitude);
        double d3 = Math.max(this.northeast.latitude, latLng.latitude);
        double d4 = this.northeast.longitude;
        double d5 = this.southwest.longitude;
        double d6 = latLng.longitude;
        if (!this.b(d6)) {
            if (LatLngBounds.b(d5, d6) < LatLngBounds.c(d4, d6)) {
                d5 = d6;
            } else {
                d4 = d6;
            }
        }
        return new LatLngBounds(new LatLng(d2, d5), new LatLng(d3, d4));
    }

    private static double b(double d2, double d3) {
        return (d2 - d3 + 360.0) % 360.0;
    }

    private static double c(double d2, double d3) {
        return (d3 - d2 + 360.0) % 360.0;
    }

    private boolean a(double d2) {
        return this.southwest.latitude <= d2 && d2 <= this.northeast.latitude;
    }

    private boolean b(double d2) {
        if (this.southwest.longitude <= this.northeast.longitude) {
            return this.southwest.longitude <= d2 && d2 <= this.northeast.longitude;
        }
        return this.southwest.longitude <= d2 || d2 <= this.northeast.longitude;
    }

    public int hashCode() {
        return ab.hashCode(this.southwest, this.northeast);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof LatLngBounds)) {
            return false;
        }
        LatLngBounds latLngBounds = (LatLngBounds)o2;
        return this.southwest.equals(latLngBounds.southwest) && this.northeast.equals(latLngBounds.northeast);
    }

    public String toString() {
        return ab.c(this).a("southwest", this.southwest).a("northeast", this.northeast).toString();
    }

    public static final class Builder {
        private double he = Double.POSITIVE_INFINITY;
        private double hf = Double.NEGATIVE_INFINITY;
        private double hg = Double.NaN;
        private double hh = Double.NaN;

        public Builder include(LatLng point) {
            this.he = Math.min(this.he, point.latitude);
            this.hf = Math.max(this.hf, point.latitude);
            double d2 = point.longitude;
            if (Double.isNaN(this.hg)) {
                this.hg = d2;
                this.hh = d2;
            } else if (!this.b(d2)) {
                if (LatLngBounds.b(this.hg, d2) < LatLngBounds.c(this.hh, d2)) {
                    this.hg = d2;
                } else {
                    this.hh = d2;
                }
            }
            return this;
        }

        private boolean b(double d2) {
            if (this.hg <= this.hh) {
                return this.hg <= d2 && d2 <= this.hh;
            }
            return this.hg <= d2 || d2 <= this.hh;
        }

        public LatLngBounds build() {
            ac.a(!Double.isNaN(this.hg), (Object)"no included points");
            return new LatLngBounds(new LatLng(this.he, this.hg), new LatLng(this.hf, this.hh));
        }
    }
}

