/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.dh;
import com.google.android.gms.internal.do;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PolygonOptionsCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolygonOptions
implements SafeParcelable {
    public static final PolygonOptionsCreator CREATOR = new PolygonOptionsCreator();
    private final int W;
    private final List<LatLng> hp;
    private final List<List<LatLng>> hq;
    private float gQ = 10.0f;
    private int gR = -16777216;
    private int gS = 0;
    private float gT = 0.0f;
    private boolean gU = true;
    private boolean hr = false;

    public PolygonOptions() {
        this.W = 1;
        this.hp = new ArrayList<LatLng>();
        this.hq = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int versionCode, List<LatLng> points, List holes, float strokeWidth, int strokeColor, int fillColor, float zIndex, boolean visible, boolean geodesic) {
        this.W = versionCode;
        this.hp = points;
        this.hq = holes;
        this.gQ = strokeWidth;
        this.gR = strokeColor;
        this.gS = fillColor;
        this.gT = zIndex;
        this.gU = visible;
        this.hr = geodesic;
    }

    public int F() {
        return this.W;
    }

    public List bq() {
        return this.hq;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (dh.bm()) {
            do.a(this, out, flags);
        } else {
            PolygonOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public PolygonOptions add(LatLng point) {
        this.hp.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        this.hp.addAll(Arrays.asList(points));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.hp.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : points) {
            arrayList.add(latLng);
        }
        this.hq.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        this.gQ = width;
        return this;
    }

    public PolygonOptions strokeColor(int color2) {
        this.gR = color2;
        return this;
    }

    public PolygonOptions fillColor(int color2) {
        this.gS = color2;
        return this;
    }

    public PolygonOptions zIndex(float zIndex) {
        this.gT = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.gU = visible;
        return this;
    }

    public PolygonOptions geodesic(boolean geodesic) {
        this.hr = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.hp;
    }

    public List<List<LatLng>> getHoles() {
        return this.hq;
    }

    public float getStrokeWidth() {
        return this.gQ;
    }

    public int getStrokeColor() {
        return this.gR;
    }

    public int getFillColor() {
        return this.gS;
    }

    public float getZIndex() {
        return this.gT;
    }

    public boolean isVisible() {
        return this.gU;
    }

    public boolean isGeodesic() {
        return this.hr;
    }
}

