/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.content.Context;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.internal.ed;
import com.google.android.gms.internal.eg;
import com.google.android.gms.internal.ek;
import com.google.android.gms.plus.model.moments.Moment;
import com.google.android.gms.plus.model.moments.MomentBuffer;
import com.google.android.gms.plus.model.people.Person;
import com.google.android.gms.plus.model.people.PersonBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlusClient
implements GooglePlayServicesClient {
    public static final String KEY_REQUEST_VISIBLE_ACTIVITIES = "request_visible_actions";
    final ek hI;

    PlusClient(ek plusClientImpl) {
        this.hI = plusClientImpl;
    }

    public String getAccountName() {
        return this.hI.getAccountName();
    }

    public void a(b b2, String string2) {
        this.hI.a(b2, string2);
    }

    public void writeMoment(Moment moment) {
        this.hI.writeMoment(moment);
    }

    public void loadMoments(OnMomentsLoadedListener listener) {
        this.hI.loadMoments(listener);
    }

    public void loadMoments(OnMomentsLoadedListener listener, int maxResults, String pageToken, Uri targetUrl, String type, String userId) {
        this.hI.loadMoments(listener, maxResults, pageToken, targetUrl, type, userId);
    }

    public void removeMoment(String momentId) {
        this.hI.removeMoment(momentId);
    }

    public void loadVisiblePeople(OnPeopleLoadedListener listener, int orderBy, String pageToken) {
        this.hI.loadVisiblePeople(listener, orderBy, pageToken);
    }

    public void loadVisiblePeople(OnPeopleLoadedListener listener, String pageToken) {
        this.hI.loadVisiblePeople(listener, pageToken);
    }

    public void loadPeople(OnPeopleLoadedListener listener, int collection) {
        this.hI.loadPeople(listener, collection);
    }

    public void loadPeople(OnPeopleLoadedListener listener, int collection, int orderBy, int maxResults, String pageToken) {
        this.hI.loadPeople(listener, collection, orderBy, maxResults, pageToken);
    }

    public void loadPerson(OnPersonLoadedListener listener, String userId) {
        this.hI.loadPerson(listener, userId);
    }

    public void loadPeople(OnPeopleLoadedListener listener, Collection<String> personIds) {
        this.hI.a(listener, personIds);
    }

    public void loadPeople(OnPeopleLoadedListener listener, String ... personIds) {
        this.hI.a(listener, personIds);
    }

    public Person getCurrentPerson() {
        return this.hI.getCurrentPerson();
    }

    public void clearDefaultAccount() {
        this.hI.clearDefaultAccount();
    }

    public void revokeAccessAndDisconnect(OnAccessRevokedListener listener) {
        this.hI.revokeAccessAndDisconnect(listener);
    }

    public void a(a a2, Uri uri, int n2) {
        this.hI.a(a2, uri, n2);
    }

    @Override
    public void connect() {
        this.hI.connect();
    }

    @Override
    public boolean isConnected() {
        return this.hI.isConnected();
    }

    @Override
    public boolean isConnecting() {
        return this.hI.isConnecting();
    }

    @Override
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.hI.registerConnectionCallbacks(listener);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        return this.hI.isConnectionCallbacksRegistered(listener);
    }

    @Override
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.hI.unregisterConnectionCallbacks(listener);
    }

    @Override
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.hI.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        return this.hI.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.hI.unregisterConnectionFailedListener(listener);
    }

    @Override
    public void disconnect() {
        this.hI.disconnect();
    }

    ek bt() {
        return this.hI;
    }

    public static class Builder {
        private Context mContext;
        private String g;
        private GooglePlayServicesClient.ConnectionCallbacks hJ;
        private GooglePlayServicesClient.OnConnectionFailedListener e;
        private ArrayList<String> hK;
        private String[] hL;
        private String[] hM;
        private String hN;
        private String hO;
        private String hP;

        public Builder(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener connectionFailedListener) {
            this.mContext = context;
            this.hJ = connectionCallbacks;
            this.e = connectionFailedListener;
            this.hK = new ArrayList();
            this.hO = this.mContext.getPackageName();
            this.hN = this.mContext.getPackageName();
            this.hK.add("https://www.googleapis.com/auth/plus.login");
        }

        public Builder setAccountName(String accountName) {
            this.g = accountName;
            return this;
        }

        public Builder setScopes(String ... scopes) {
            this.hK.clear();
            this.hK.addAll(Arrays.asList(scopes));
            return this;
        }

        public Builder clearScopes() {
            this.hK.clear();
            return this;
        }

        public Builder setVisibleActivities(String ... visibleActivities) {
            this.hL = visibleActivities;
            return this;
        }

        public PlusClient build() {
            if (this.g == null) {
                this.g = "<<default account>>";
            }
            String[] stringArray = this.hK.toArray(new String[this.hK.size()]);
            ed ed2 = new ed(this.g, stringArray, this.hL, this.hM, this.hN, this.hO, this.hP);
            return new PlusClient(new ek(this.mContext, ed2, this.hJ, this.e));
        }
    }

    public static interface a {
        public void a(ConnectionResult var1, ParcelFileDescriptor var2);
    }

    public static interface b {
        public void a(ConnectionResult var1, eg var2);
    }

    public static interface OnAccessRevokedListener {
        public void onAccessRevoked(ConnectionResult var1);
    }

    public static interface OnPeopleLoadedListener {
        public void onPeopleLoaded(ConnectionResult var1, PersonBuffer var2, String var3);
    }

    public static interface OrderBy {
        public static final int ALPHABETICAL = 0;
        public static final int BEST = 1;
    }

    public static interface OnPersonLoadedListener {
        public void onPersonLoaded(ConnectionResult var1, Person var2);
    }

    public static interface OnMomentsLoadedListener {
        public void onMomentsLoaded(ConnectionResult var1, MomentBuffer var2, String var3, String var4);
    }
}

