/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.internal.ac;
import com.google.android.gms.internal.eu;
import com.google.android.gms.plus.PlusClient;
import com.google.android.gms.plus.model.people.Person;
import java.util.ArrayList;
import java.util.List;

public final class PlusShare {
    public static final String EXTRA_CONTENT_URL = "com.google.android.apps.plus.CONTENT_URL";
    public static final String EXTRA_CONTENT_DEEP_LINK_ID = "com.google.android.apps.plus.CONTENT_DEEP_LINK_ID";
    public static final String EXTRA_CONTENT_DEEP_LINK_METADATA = "com.google.android.apps.plus.CONTENT_DEEP_LINK_METADATA";
    public static final String KEY_CONTENT_DEEP_LINK_METADATA_TITLE = "title";
    public static final String KEY_CONTENT_DEEP_LINK_METADATA_DESCRIPTION = "description";
    public static final String KEY_CONTENT_DEEP_LINK_METADATA_THUMBNAIL_URL = "thumbnailUrl";
    public static final String EXTRA_IS_INTERACTIVE_POST = "com.google.android.apps.plus.GOOGLE_INTERACTIVE_POST";
    public static final String EXTRA_CALL_TO_ACTION = "com.google.android.apps.plus.CALL_TO_ACTION";
    public static final String KEY_CALL_TO_ACTION_LABEL = "label";
    public static final String KEY_CALL_TO_ACTION_URL = "url";
    public static final String KEY_CALL_TO_ACTION_DEEP_LINK_ID = "deepLinkId";
    public static final String EXTRA_SENDER_ID = "com.google.android.apps.plus.SENDER_ID";
    public static final String PARAM_CONTENT_DEEP_LINK_ID = "deep_link_id";

    protected PlusShare() {
        throw new AssertionError();
    }

    public static String getDeepLinkId(Intent intent) {
        String string2 = null;
        if (intent != null && intent.getData() != null) {
            string2 = intent.getData().getQueryParameter(PARAM_CONTENT_DEEP_LINK_ID);
        }
        return string2;
    }

    public static Bundle a(String string2, String string3, Uri uri) {
        Bundle bundle = new Bundle();
        bundle.putString(KEY_CONTENT_DEEP_LINK_METADATA_TITLE, string2);
        bundle.putString(KEY_CONTENT_DEEP_LINK_METADATA_DESCRIPTION, string3);
        if (uri != null) {
            bundle.putString(KEY_CONTENT_DEEP_LINK_METADATA_THUMBNAIL_URL, uri.toString());
        }
        return bundle;
    }

    public static Person createPerson(String id, String displayName) {
        if (TextUtils.isEmpty((CharSequence)id)) {
            throw new IllegalArgumentException("MinimalPerson ID must not be empty.");
        }
        if (TextUtils.isEmpty((CharSequence)displayName)) {
            throw new IllegalArgumentException("Display name must not be empty.");
        }
        return new eu(displayName, id, null, 0, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final Context mContext;
        private final Intent mIntent;
        private boolean hT;
        private ArrayList<Uri> hU;
        protected boolean hV;

        public Builder(Context context) {
            this.mContext = context;
            this.mIntent = new Intent().setAction("android.intent.action.SEND");
        }

        public Builder(Activity launchingActivity) {
            this.mContext = launchingActivity;
            this.mIntent = new Intent().setAction("android.intent.action.SEND");
            this.mIntent.addFlags(524288);
            if (launchingActivity.getComponentName() != null) {
                this.hT = true;
            }
        }

        public Builder(Activity launchingActivity, PlusClient plusClient) {
            this(launchingActivity);
            ac.a(plusClient != null, (Object)"Must include the PlusClient object in PlusShare.Builder constructor to create an interactive post.");
            ac.a(plusClient.isConnected(), (Object)"PlusClient must be connected to create an interactive post.");
            ac.a(plusClient.bt().F("https://www.googleapis.com/auth/plus.login"), (Object)"Must request PLUS_LOGIN scope in PlusClient to create an interactive post.");
            Person person = plusClient.getCurrentPerson();
            String string2 = person != null ? person.getId() : "0";
            this.mIntent.putExtra(PlusShare.EXTRA_SENDER_ID, string2);
            this.hV = true;
        }

        public Builder setType(String mimeType) {
            this.mIntent.setType(mimeType);
            return this;
        }

        public Builder setRecipients(List<Person> recipientList) {
            int n2;
            int n3 = n2 = recipientList != null ? recipientList.size() : 0;
            if (n2 == 0) {
                this.mIntent.removeExtra("com.google.android.apps.plus.RECIPIENT_IDS");
                this.mIntent.removeExtra("com.google.android.apps.plus.RECIPIENT_DISPLAY_NAMES");
                return this;
            }
            ArrayList<String> arrayList = new ArrayList<String>(n2);
            ArrayList<String> arrayList2 = new ArrayList<String>(n2);
            for (Person person : recipientList) {
                arrayList.add(person.getId());
                arrayList2.add(person.getDisplayName());
            }
            this.mIntent.putStringArrayListExtra("com.google.android.apps.plus.RECIPIENT_IDS", arrayList);
            this.mIntent.putStringArrayListExtra("com.google.android.apps.plus.RECIPIENT_DISPLAY_NAMES", arrayList2);
            return this;
        }

        public Builder setText(CharSequence text) {
            this.mIntent.putExtra("android.intent.extra.TEXT", text);
            return this;
        }

        public Builder setStream(Uri streamUri) {
            this.hU = null;
            this.mIntent.putExtra("android.intent.extra.STREAM", (Parcelable)streamUri);
            return this;
        }

        public Builder addStream(Uri streamUri) {
            Uri uri = (Uri)this.mIntent.getParcelableExtra("android.intent.extra.STREAM");
            if (uri == null) {
                return this.setStream(streamUri);
            }
            if (this.hU == null) {
                this.hU = new ArrayList();
            }
            this.hU.add(uri);
            this.hU.add(streamUri);
            return this;
        }

        public Builder setContentUrl(Uri uri) {
            String string2 = null;
            if (uri != null) {
                string2 = uri.toString();
            }
            if (TextUtils.isEmpty(string2)) {
                this.mIntent.removeExtra(PlusShare.EXTRA_CONTENT_URL);
            } else {
                this.mIntent.putExtra(PlusShare.EXTRA_CONTENT_URL, string2);
            }
            return this;
        }

        public Builder setContentDeepLinkId(String deepLinkId) {
            return this.setContentDeepLinkId(deepLinkId, null, null, null);
        }

        public Builder setContentDeepLinkId(String deepLinkId, String title, String description, Uri thumbnailUri) {
            ac.b(this.hT, "Must include the launching activity with PlusShare.Builder constructor before setting deep links");
            ac.b(!TextUtils.isEmpty((CharSequence)deepLinkId), "The deepLinkId parameter is required.");
            Bundle bundle = PlusShare.a(title, description, thumbnailUri);
            this.mIntent.putExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_ID, deepLinkId);
            this.mIntent.putExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_METADATA, bundle);
            this.mIntent.setType("text/plain");
            return this;
        }

        public Builder addCallToAction(String label, Uri uri, String deepLinkId) {
            ac.a(this.hT, (Object)"Must include the launching activity with PlusShare.Builder constructor before setting call-to-action");
            ac.b(uri != null && !TextUtils.isEmpty((CharSequence)uri.toString()), "Must provide a call to action URL");
            ac.a(this.hV, (Object)"Must include PlusClient in PlusShare.Builder constructor to create an interactive post");
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)label)) {
                bundle.putString(PlusShare.KEY_CALL_TO_ACTION_LABEL, label);
            }
            bundle.putString(PlusShare.KEY_CALL_TO_ACTION_URL, uri.toString());
            if (!TextUtils.isEmpty((CharSequence)deepLinkId)) {
                bundle.putString(PlusShare.KEY_CALL_TO_ACTION_DEEP_LINK_ID, deepLinkId);
            }
            this.mIntent.putExtra(PlusShare.EXTRA_CALL_TO_ACTION, bundle);
            this.mIntent.putExtra(PlusShare.EXTRA_IS_INTERACTIVE_POST, true);
            this.mIntent.setType("text/plain");
            return this;
        }

        public Intent getIntent() {
            boolean bl2 = this.hU != null && this.hU.size() > 1;
            boolean bl3 = "android.intent.action.SEND_MULTIPLE".equals(this.mIntent.getAction());
            boolean bl4 = this.mIntent.getBooleanExtra(PlusShare.EXTRA_IS_INTERACTIVE_POST, false);
            ac.a(!bl2 || !bl4, (Object)"Call-to-action buttons are only available for URLs.");
            ac.a(!bl4 || this.mIntent.hasExtra(PlusShare.EXTRA_CONTENT_URL), (Object)"The content URL is required for interactive posts.");
            ac.a(!bl4 || this.mIntent.hasExtra(PlusShare.EXTRA_CONTENT_URL) || this.mIntent.hasExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_ID), (Object)"Must set content URL or content deep-link ID to use a call-to-action button.");
            if (!bl2 && bl3) {
                this.mIntent.setAction("android.intent.action.SEND");
                if (this.hU != null && !this.hU.isEmpty()) {
                    this.mIntent.putExtra("android.intent.extra.STREAM", (Parcelable)this.hU.get(0));
                } else {
                    this.mIntent.removeExtra("android.intent.extra.STREAM");
                }
                this.hU = null;
            }
            if (bl2 && !bl3) {
                this.mIntent.setAction("android.intent.action.SEND_MULTIPLE");
                if (this.hU != null && !this.hU.isEmpty()) {
                    this.mIntent.putParcelableArrayListExtra("android.intent.extra.STREAM", this.hU);
                } else {
                    this.mIntent.removeExtra("android.intent.extra.STREAM");
                }
            }
            if (!this.isGooglePlusAvailable() && !this.mIntent.hasExtra("android.intent.extra.STREAM")) {
                this.mIntent.setAction("com.google.android.gms.plus.action.SHARE_GOOGLE");
                this.mIntent.setPackage("com.google.android.gms");
                return this.mIntent;
            }
            this.mIntent.setPackage("com.google.android.apps.plus");
            return this.mIntent;
        }

        protected boolean isGooglePlusAvailable() {
            PackageManager packageManager = this.mContext.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            try {
                ApplicationInfo applicationInfo = packageManager.getApplicationInfo("com.google.android.apps.plus", 0);
                if (applicationInfo == null || !applicationInfo.enabled) {
                    return false;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return false;
            }
            return true;
        }
    }
}

