/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDCConverter
extends ClassicConverter {
    String key;
    private static final String EMPTY_STRING = "";

    @Override
    public void start() {
        this.key = this.getFirstOption();
        super.start();
    }

    @Override
    public void stop() {
        this.key = null;
        super.stop();
    }

    @Override
    public String convert(ILoggingEvent iLoggingEvent) {
        Map<String, String> map = iLoggingEvent.getMDCPropertyMap();
        if (map == null) {
            return EMPTY_STRING;
        }
        if (this.key == null) {
            return this.outputMDCForAllKeys(map);
        }
        String string = iLoggingEvent.getMDCPropertyMap().get(this.key);
        if (string != null) {
            return string;
        }
        return EMPTY_STRING;
    }

    private String outputMDCForAllKeys(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey()).append('=').append(entry.getValue());
        }
        return stringBuilder.toString();
    }
}

