/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.status.ErrorStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowableProxyConverter
extends ThrowableHandlingConverter {
    int lengthOption;
    List<EventEvaluator<ILoggingEvent>> evaluatorList = null;
    int errorCount = 0;

    @Override
    public void start() {
        String string = this.getFirstOption();
        if (string == null) {
            this.lengthOption = Integer.MAX_VALUE;
        } else if ("full".equals(string = string.toLowerCase())) {
            this.lengthOption = Integer.MAX_VALUE;
        } else if ("short".equals(string)) {
            this.lengthOption = 2;
        } else {
            try {
                this.lengthOption = Integer.parseInt(string) + 1;
            }
            catch (NumberFormatException numberFormatException) {
                this.addError("Could not parse [" + string + "] as an integer");
                this.lengthOption = Integer.MAX_VALUE;
            }
        }
        List<String> list = this.getOptionList();
        if (list != null && list.size() > 1) {
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                String string2 = list.get(i);
                Context context = this.getContext();
                Map map = (Map)context.getObject("EVALUATOR_MAP");
                EventEvaluator eventEvaluator = (EventEvaluator)map.get(string2);
                this.addEvaluator(eventEvaluator);
            }
        }
        super.start();
    }

    private void addEvaluator(EventEvaluator<ILoggingEvent> eventEvaluator) {
        if (this.evaluatorList == null) {
            this.evaluatorList = new ArrayList<EventEvaluator<ILoggingEvent>>();
        }
        this.evaluatorList.add(eventEvaluator);
    }

    @Override
    public void stop() {
        this.evaluatorList = null;
        super.stop();
    }

    protected void extraData(StringBuilder stringBuilder, StackTraceElementProxy stackTraceElementProxy) {
    }

    @Override
    public String convert(ILoggingEvent iLoggingEvent) {
        IThrowableProxy iThrowableProxy = iLoggingEvent.getThrowableProxy();
        if (iThrowableProxy == null) {
            return "";
        }
        if (this.evaluatorList != null) {
            boolean bl = true;
            for (int i = 0; i < this.evaluatorList.size(); ++i) {
                EventEvaluator<ILoggingEvent> eventEvaluator = this.evaluatorList.get(i);
                try {
                    if (!eventEvaluator.evaluate(iLoggingEvent)) continue;
                    bl = false;
                    break;
                }
                catch (EvaluationException evaluationException) {
                    ++this.errorCount;
                    if (this.errorCount < 4) {
                        this.addError("Exception thrown for evaluator named [" + eventEvaluator.getName() + "]", evaluationException);
                        continue;
                    }
                    if (this.errorCount != 4) continue;
                    ErrorStatus errorStatus = new ErrorStatus("Exception thrown for evaluator named [" + eventEvaluator.getName() + "].", this, evaluationException);
                    errorStatus.add(new ErrorStatus("This was the last warning about this evaluator's errors.We don't want the StatusManager to get flooded.", this));
                    this.addStatus(errorStatus);
                }
            }
            if (!bl) {
                return "";
            }
        }
        return this.throwableProxyToString(iThrowableProxy);
    }

    protected String throwableProxyToString(IThrowableProxy iThrowableProxy) {
        StringBuilder stringBuilder = new StringBuilder(32);
        for (IThrowableProxy iThrowableProxy2 = iThrowableProxy; iThrowableProxy2 != null; iThrowableProxy2 = iThrowableProxy2.getCause()) {
            this.subjoinThrowableProxy(stringBuilder, iThrowableProxy2);
        }
        return stringBuilder.toString();
    }

    void subjoinThrowableProxy(StringBuilder stringBuilder, IThrowableProxy iThrowableProxy) {
        int n;
        ThrowableProxyUtil.subjoinFirstLine(stringBuilder, iThrowableProxy);
        stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        StackTraceElementProxy[] stackTraceElementProxyArray = iThrowableProxy.getStackTraceElementProxyArray();
        int n2 = iThrowableProxy.getCommonFrames();
        boolean bl = this.lengthOption > stackTraceElementProxyArray.length;
        int n3 = n = bl ? stackTraceElementProxyArray.length : this.lengthOption;
        if (n2 > 0 && bl) {
            n -= n2;
        }
        for (int i = 0; i < n; ++i) {
            String string = stackTraceElementProxyArray[i].toString();
            stringBuilder.append('\t');
            stringBuilder.append(string);
            this.extraData(stringBuilder, stackTraceElementProxyArray[i]);
            stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        }
        if (n2 > 0 && bl) {
            stringBuilder.append("\t... ").append(iThrowableProxy.getCommonFrames()).append(" common frames omitted").append(CoreConstants.LINE_SEPARATOR);
        }
    }
}

